/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased;

import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.eventbased.automata.AutomatonHelper;
import org.eclipse.escet.cif.eventbased.automata.Edge;
import org.eclipse.escet.cif.eventbased.automata.Event;
import org.eclipse.escet.cif.eventbased.automata.Location;
import org.eclipse.escet.cif.eventbased.automata.origin.LocationSetOrigin;
import org.eclipse.escet.cif.eventbased.partitions.Partition;
import org.eclipse.escet.cif.eventbased.partitions.PartitionLocation;
import org.eclipse.escet.cif.eventbased.partitions.PartitionRefinement;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class AutomatonAbstraction
extends PartitionRefinement {
    private Map<Partition, Location> partitionMap = Maps.map();
    private final Automaton aut;
    private final Automaton newAut;

    private static Set<Set<Location>> makePartitions(Automaton aut) {
        Set markers = Sets.set();
        Set nonMarkers = Sets.set();
        Location loc = aut.locations;
        while (loc != null) {
            if (loc.marked) {
                markers.add(loc);
            } else {
                nonMarkers.add(loc);
            }
            loc = loc.nextLoc;
        }
        Set partitions = Sets.set();
        partitions.add(markers);
        partitions.add(nonMarkers);
        return partitions;
    }

    private static Set<Event> makeNonObservables(Automaton aut, Set<Event> observables) {
        int size = aut.alphabet.size() - observables.size();
        if (size <= 0) {
            size = 8;
        }
        Set nonObservables = Sets.setc((int)size);
        for (Event evt : aut.alphabet) {
            if (observables.contains(evt)) continue;
            nonObservables.add(evt);
        }
        return nonObservables;
    }

    private AutomatonAbstraction(Automaton aut, Set<Event> observables) {
        super(observables, AutomatonAbstraction.makeNonObservables(aut, observables), AutomatonAbstraction.makePartitions(aut));
        this.aut = aut;
        this.newAut = new Automaton(this.observableEvents);
        this.newAut.kind = this.aut.kind;
    }

    public static void automatonAbstractionPreCheck(Automaton aut, Set<Event> observables) {
        for (Event evt : observables) {
            if (aut.alphabet.contains(evt)) continue;
            String msg = Strings.fmt((String)"Event \"%s\" is in the observable event set, but is not in the alphabet of the automaton.", (Object[])new Object[]{evt.name});
            throw new InvalidInputException(msg);
        }
        boolean seenMarked = false;
        boolean seenUnmarked = false;
        for (Location loc : aut) {
            if (loc.marked) {
                seenMarked = true;
                if (!seenUnmarked) continue;
                return;
            }
            seenUnmarked = true;
            if (!seenMarked) continue;
            return;
        }
        String msg = seenMarked ? "unmarked" : "marked";
        msg = Strings.fmt((String)"Automaton \"%s\" cannot be partitioned because it has no %s locations.", (Object[])new Object[]{aut.name, msg});
        throw new InvalidInputException(msg);
    }

    public static Automaton automatonAbstraction(Automaton aut, Set<Event> observables) {
        AutomatonAbstraction aa = new AutomatonAbstraction(aut, observables);
        aa.refinePartitions();
        Automaton rslt = aa.createAbstractedAutomaton();
        if (OutputProvider.dodbg()) {
            OutputProvider.dbg((String)"Automaton abstraction finished (%s).", (Object[])new Object[]{AutomatonHelper.getAutStatistics(rslt)});
        }
        return rslt;
    }

    private Automaton createAbstractedAutomaton() {
        Set edgesDone = Sets.set();
        Location oldDst = this.aut.locations;
        while (oldDst != null) {
            Partition dstPart = ((PartitionLocation)this.locationMapping.get((Object)oldDst)).partition;
            Location dstLoc = this.getLocation(oldDst, dstPart);
            if (!edgesDone.contains(dstPart)) {
                Set<Location> oldDstLocs = this.f1(dstPart);
                Set oldSrcLocs = Sets.set();
                for (Event evt : this.observableEvents) {
                    Set srcParts = Sets.set();
                    for (Location oldSrc : this.f2(oldDstLocs, evt, oldSrcLocs)) {
                        Partition srcPart = ((PartitionLocation)this.locationMapping.get((Object)oldSrc)).partition;
                        if (!srcParts.add(srcPart)) continue;
                        Location srcLoc = this.getLocation(null, srcPart);
                        Edge.addEdge(evt, srcLoc, dstLoc);
                    }
                }
                edgesDone.add(dstPart);
            }
            oldDst = oldDst.nextLoc;
        }
        return this.newAut;
    }

    private Location getLocation(Location oldLoc, Partition p) {
        Location newLoc = this.partitionMap.get(p);
        if (newLoc == null) {
            LocationSetOrigin org = new LocationSetOrigin(p.getLocations());
            newLoc = new Location(this.newAut, org);
            this.partitionMap.put(p, newLoc);
        }
        if (oldLoc != null) {
            if (oldLoc.marked) {
                newLoc.marked = true;
            }
            if (this.aut.initial == oldLoc) {
                this.newAut.setInitial(newLoc);
            }
        }
        return newLoc;
    }
}

