/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.List;
import org.eclipse.escet.cif.eventbased.DfaMinimize;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.options.AddStateAnnosOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class DfaMinimizationApplication
extends Application<IOutputComponent> {
    private final String app = "DFA minimization";

    public static void main(String[] args) {
        DfaMinimizationApplication app = new DfaMinimizationApplication();
        app.run(args, true);
    }

    public DfaMinimizationApplication() {
    }

    public DfaMinimizationApplication(AppStreams streams) {
        super(streams);
    }

    protected OutputProvider<IOutputComponent> getProvider() {
        return new OutputProvider();
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        options.add(Options.getInstance(AddStateAnnosOption.class));
        return new OptionCategory(Strings.makeInitialUppercase((String)"DFA minimization"), "CIF event-based DFA minimizationoptions.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(DfaMinimizationApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based DFA minimization tool.";
        return new OptionCategory("Event-based DFA minimization options", optDesc, subPages, options);
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block12: {
            Automaton result;
            block11: {
                ConvertToEventBased cte;
                block10: {
                    block9: {
                        block8: {
                            try {
                                OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                                cifReader = (CifReader)new CifReader().init();
                                spec = (Specification)cifReader.read();
                                if (!this.isTerminationRequested()) break block8;
                                return 0;
                            }
                            catch (ApplicationException e) {
                                String msg = Strings.fmt((String)"Failed to apply %s for CIF file \"%s\".", (Object[])new Object[]{"DFA minimization", InputFileOption.getPath()});
                                throw new ApplicationException(msg, (Throwable)e);
                            }
                        }
                        OutputProvider.dbg((String)"Converting to internal representation...");
                        cte = new ConvertToEventBased();
                        cte.convertSpecification(spec, true);
                        if (!this.isTerminationRequested()) break block9;
                        return 0;
                    }
                    if (cte.automata.size() != 1) {
                        String msg = Strings.fmt((String)"DFA minimization can be applied to only one automaton, found %s automata.", (Object[])new Object[]{cte.automata.size()});
                        throw new InvalidInputException(msg);
                    }
                    OutputProvider.dbg((String)"Applying DFA minimization....");
                    DfaMinimize.preCheck(cte.automata.get(0));
                    if (!this.isTerminationRequested()) break block10;
                    return 0;
                }
                result = DfaMinimize.minimize(cte.automata.get(0));
                if (!this.isTerminationRequested()) break block11;
                return 0;
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "minimal";
            resultName = ResultNameOption.getRsltName(resultName);
            boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(result, resultName, doAddStateAnnos);
            if (!this.isTerminationRequested()) break block12;
            return 0;
        }
        Object outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        outPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (String)outPath, (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF DFA minimization tool";
    }

    public String getAppDescription() {
        return "Constructs a DFA with the equivalent language but with a minimal number of locations.";
    }
}

