/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifEnumLiteral;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.explorer.options.AddStateAnnosOption;
import org.eclipse.escet.cif.explorer.options.AutomatonNameOption;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.EventUsage;
import org.eclipse.escet.cif.explorer.runtime.Explorer;
import org.eclipse.escet.cif.explorer.runtime.ExplorerEdge;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.functions.Function;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.FuncType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifAutomatonBuilder {
    private Map<Event, Event> evtMap = null;

    public Specification createAutomaton(Explorer expl, Specification oldSpec) {
        this.evtMap = Maps.map();
        Specification newSpec = CifConstructors.newSpecification();
        this.makeEventGroups((Group)oldSpec, (Group)newSpec);
        this.addAutomaton(expl, newSpec);
        this.evtMap = null;
        return newSpec;
    }

    private boolean makeEventGroups(Group oldGrp, Group newGrp) {
        boolean nonEmpty = false;
        for (Component comp : oldGrp.getComponents()) {
            Group subGrp;
            if (comp instanceof Group) {
                Group oldComp = (Group)comp;
                subGrp = CifConstructors.newGroup();
                subGrp.setName(oldComp.getName());
                if (this.makeEventGroups(oldComp, subGrp)) {
                    newGrp.getComponents().add((Object)subGrp);
                    nonEmpty = true;
                }
            }
            if (!(comp instanceof Automaton)) continue;
            Automaton oldAut = (Automaton)comp;
            subGrp = CifConstructors.newGroup();
            subGrp.setName(oldAut.getName());
            if (!this.addEvents(subGrp, (List<Declaration>)oldAut.getDeclarations())) continue;
            newGrp.getComponents().add((Object)subGrp);
            nonEmpty = true;
        }
        return nonEmpty |= this.addEvents(newGrp, (List<Declaration>)oldGrp.getDeclarations());
    }

    private boolean addEvents(Group grp, List<Declaration> decls) {
        boolean nonEmpty = false;
        for (Declaration decl : decls) {
            if (!(decl instanceof Event)) continue;
            Event oldEvent = (Event)decl;
            Boolean ctl = oldEvent.getControllable();
            Event newEvent = CifConstructors.newEvent(null, (Boolean)ctl, (String)oldEvent.getName(), null, null);
            grp.getDeclarations().add((Object)newEvent);
            this.evtMap.put(oldEvent, newEvent);
            nonEmpty = true;
        }
        return nonEmpty;
    }

    private static Automaton createResultAutomaton(String sugName, Specification spec) {
        Automaton aut = CifConstructors.newAutomaton();
        String name = sugName;
        Set names = CifScopeUtils.getSymbolNamesForScope((PositionObject)spec, null);
        if (names.contains(name)) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)names, Collections.emptySet());
            OutputProvider.warn((String)"Resulting statespace automaton is named \"%s\" instead of \"%s\" to avoid a naming conflict.", (Object[])new Object[]{name, sugName});
        }
        aut.setName(name);
        spec.getComponents().add((Object)aut);
        return aut;
    }

    private void addAutomaton(Explorer expl, Specification newSpec) {
        String name = AutomatonNameOption.getAutomatonName("statespace");
        Automaton aut = CifAutomatonBuilder.createResultAutomaton(name, newSpec);
        Alphabet alphabet = CifConstructors.newAlphabet();
        aut.setAlphabet(alphabet);
        for (EventUsage evtUse : expl.eventUsages) {
            Event evt = this.evtMap.get(evtUse.event);
            EventExpression ee = CifConstructors.newEventExpression((Event)evt, null, (CifType)CifConstructors.newBoolType());
            alphabet.getEvents().add((Object)ee);
        }
        if (expl.states == null || expl.states.isEmpty()) {
            Location loc = CifConstructors.newLocation();
            aut.getLocations().add((Object)loc);
            return;
        }
        boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
        int idx = 0;
        for (BaseState state : expl.states.values()) {
            Assert.check((state.stateNumber == idx + 1 ? 1 : 0) != 0);
            Location loc = CifConstructors.newLocation();
            loc.setName(Strings.fmt((String)"loc%d", (Object[])new Object[]{idx + 1}));
            if (state.isInitial()) {
                loc.getInitials().add((Object)CifValueUtils.makeTrue());
            }
            if (state.isMarked()) {
                loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
            }
            aut.getLocations().add((Object)loc);
            ++idx;
            if (!doAddStateAnnos) continue;
            CifAutomatonBuilder.addStateAnno(expl, loc, state);
        }
        idx = 0;
        for (BaseState state : expl.states.values()) {
            Location srcLoc = (Location)aut.getLocations().get(idx++);
            for (ExplorerEdge explEdge : state.getOutgoingEdges()) {
                Location dstLoc = (Location)aut.getLocations().get(explEdge.next.stateNumber - 1);
                Edge edge = CifConstructors.newEdge();
                if (srcLoc != dstLoc) {
                    edge.setTarget(dstLoc);
                }
                srcLoc.getEdges().add((Object)edge);
                if (explEdge.event == null) continue;
                Event newEvent = this.evtMap.get(explEdge.event);
                EventExpression e = CifConstructors.newEventExpression((Event)newEvent, null, (CifType)CifConstructors.newBoolType());
                EdgeEvent ee = CifConstructors.newEdgeEvent();
                ee.setEvent((Expression)e);
                edge.getEvents().add((Object)ee);
            }
        }
    }

    private static void addStateAnno(Explorer explorer, Location loc, BaseState state) {
        Annotation anno = CifConstructors.newAnnotation();
        anno.setName("state");
        loc.getAnnotations().add((Object)anno);
        List args = Lists.listc((int)(explorer.automata.length + explorer.variables.length));
        int i = 0;
        while (i < explorer.automata.length) {
            args.add(CifAutomatonBuilder.createStateAnnoArg((PositionObject)explorer.automata[i], state.locations[i]));
            ++i;
        }
        i = 0;
        while (i < explorer.variables.length) {
            args.add(CifAutomatonBuilder.createStateAnnoArg(explorer.variables[i], state.values[i]));
            ++i;
        }
        Collections.sort(args, (a1, a2) -> Strings.SORTER.compare(a1.getName(), a2.getName()));
        anno.getArguments().addAll((Collection)args);
    }

    private static AnnotationArgument createStateAnnoArg(PositionObject object, Object value) {
        AnnotationArgument arg = CifConstructors.newAnnotationArgument();
        arg.setName(CifTextUtils.getAbsName((PositionObject)object, (boolean)false));
        if (object instanceof Automaton) {
            Location loc = (Location)value;
            arg.setValue((Expression)CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)(loc.getName() == null ? "*" : loc.getName())));
        } else {
            CifType varType = CifAutomatonBuilder.getVarType(object);
            arg.setValue(CifAutomatonBuilder.valueToExpr(value, varType));
        }
        return arg;
    }

    /*
     * WARNING - void declaration
     */
    private static CifType getVarType(PositionObject var) {
        PositionObject positionObject = var;
        if (positionObject instanceof ContVariable) {
            ContVariable contVariable = (ContVariable)positionObject;
            ContVariable cfr_ignored_0 = (ContVariable)positionObject;
            return CifConstructors.newRealType();
        }
        PositionObject positionObject2 = var;
        if (positionObject2 instanceof DiscVariable) {
            void dvar;
            DiscVariable discVariable = (DiscVariable)positionObject2;
            DiscVariable cfr_ignored_1 = (DiscVariable)positionObject2;
            return dvar.getType();
        }
        throw new AssertionError((Object)("Unexpected variable: " + String.valueOf(var)));
    }

    private static List<Expression> valuesToExpr(Collection<?> values, CifType type) {
        return values.stream().map(v -> CifAutomatonBuilder.valueToExpr(v, type)).toList();
    }

    /*
     * WARNING - void declaration
     */
    private static Expression valueToExpr(Object value, CifType type) {
        Object object = value;
        if (object instanceof Boolean) {
            void bvalue;
            Boolean bl = (Boolean)object;
            Boolean cfr_ignored_0 = (Boolean)object;
            return CifConstructors.newBoolExpression(null, (CifType)CifConstructors.newBoolType(), (Boolean)bvalue);
        }
        Object object2 = value;
        if (object2 instanceof Integer) {
            void ivalue;
            Integer n = (Integer)object2;
            Integer cfr_ignored_1 = (Integer)object2;
            return CifValueUtils.makeInt((int)ivalue.intValue());
        }
        Object object3 = value;
        if (object3 instanceof Double) {
            void dvalue;
            Double d = (Double)object3;
            Double cfr_ignored_2 = (Double)object3;
            return CifValueUtils.makeReal((double)dvalue.doubleValue());
        }
        Object object4 = value;
        if (object4 instanceof String) {
            void svalue;
            String string = (String)object4;
            String cfr_ignored_3 = (String)object4;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)svalue);
        }
        Object object5 = value;
        if (object5 instanceof CifEnumLiteral) {
            void lvalue;
            CifEnumLiteral cifEnumLiteral = (CifEnumLiteral)object5;
            CifEnumLiteral cfr_ignored_4 = (CifEnumLiteral)object5;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)lvalue.literal.getName());
        }
        Object object6 = value;
        if (object6 instanceof CifTuple) {
            void tvalue;
            CifTuple cifTuple = (CifTuple)object6;
            CifTuple cfr_ignored_5 = (CifTuple)object6;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof TupleType));
            List<String> fieldNames = ((TupleType)type).getFields().stream().map(f -> f.getName()).toList();
            List<CifType> fieldTypes = ((TupleType)type).getFields().stream().map(f -> f.getType()).toList();
            List fields = Lists.listc((int)tvalue.size());
            TupleType newTupleType = CifConstructors.newTupleType();
            int i = 0;
            while (i < tvalue.size()) {
                Expression field = CifAutomatonBuilder.valueToExpr(tvalue.get(i), fieldTypes.get(i));
                fields.add(field);
                newTupleType.getFields().add((Object)CifConstructors.newField((String)fieldNames.get(i), null, (CifType)((CifType)EMFHelper.deepclone((EObject)field.getType()))));
                ++i;
            }
            return CifConstructors.newTupleExpression((List)fields, null, (CifType)newTupleType);
        }
        Object object7 = value;
        if (object7 instanceof List) {
            void lvalue;
            List fieldNames = (List)object7;
            List cfr_ignored_6 = (List)object7;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof ListType));
            CifType elemType = ((ListType)type).getElementType();
            List<Expression> elems = CifAutomatonBuilder.valuesToExpr(lvalue, elemType);
            CifType newElemType = elems.stream().map(Expression::getType).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(elemType);
            ListType newListType = CifConstructors.newListType((CifType)CifAutomatonBuilder.makeAnnoArgType(newElemType), (Integer)lvalue.size(), null, (Integer)lvalue.size());
            return CifConstructors.newListExpression(elems, null, (CifType)newListType);
        }
        Object object8 = value;
        if (object8 instanceof Set) {
            void svalue;
            Set elemType = (Set)object8;
            Set cfr_ignored_7 = (Set)object8;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof SetType));
            CifType elemType2 = ((SetType)type).getElementType();
            List<Expression> elems = CifAutomatonBuilder.valuesToExpr(svalue, elemType2);
            CifType newElemType = elems.stream().map(Expression::getType).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(elemType2);
            SetType newSetType = CifConstructors.newSetType((CifType)CifAutomatonBuilder.makeAnnoArgType(newElemType), null);
            return CifConstructors.newSetExpression(elems, null, (CifType)newSetType);
        }
        Object object9 = value;
        if (object9 instanceof Map) {
            void mvalue;
            Map elemType2 = (Map)object9;
            Map cfr_ignored_8 = (Map)object9;
            type = CifTypeUtils.normalizeType((CifType)type);
            Assert.check((boolean)(type instanceof DictType));
            CifType keyType = ((DictType)type).getKeyType();
            CifType valueType = ((DictType)type).getValueType();
            List<DictPair> pairs = mvalue.entrySet().stream().map(e -> CifConstructors.newDictPair((Expression)CifAutomatonBuilder.valueToExpr(e.getKey(), keyType), null, (Expression)CifAutomatonBuilder.valueToExpr(e.getValue(), valueType))).toList();
            CifType newKeyType = pairs.stream().map(p -> p.getKey().getType()).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(keyType);
            CifType newValueType = pairs.stream().map(p -> p.getValue().getType()).reduce((t1, t2) -> CifTypeUtils.mergeTypes((CifType)t1, (CifType)t2, null)).orElse(valueType);
            DictType newDictType = CifConstructors.newDictType((CifType)CifAutomatonBuilder.makeAnnoArgType(newKeyType), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(newValueType));
            return CifConstructors.newDictExpression(pairs, null, (CifType)newDictType);
        }
        Object object10 = value;
        if (object10 instanceof Function) {
            void fvalue;
            Function keyType = (Function)object10;
            Function cfr_ignored_9 = (Function)object10;
            return CifConstructors.newStringExpression(null, (CifType)CifConstructors.newStringType(), (String)CifTextUtils.getAbsName((PositionObject)fvalue, (boolean)false));
        }
        throw new AssertionError((Object)("Unexpected value: " + String.valueOf(value)));
    }

    /*
     * WARNING - void declaration
     */
    private static CifType makeAnnoArgType(CifType type) {
        if ((type = CifTypeUtils.normalizeType((CifType)type)) instanceof BoolType) {
            return CifConstructors.newBoolType();
        }
        CifType cifType = type;
        if (cifType instanceof IntType) {
            void itype;
            IntType intType = (IntType)cifType;
            IntType cfr_ignored_0 = (IntType)cifType;
            return CifConstructors.newIntType((Integer)itype.getLower(), null, (Integer)itype.getUpper());
        }
        if (type instanceof RealType) {
            return CifConstructors.newRealType();
        }
        if (type instanceof StringType) {
            return CifConstructors.newStringType();
        }
        if (type instanceof EnumType) {
            return CifConstructors.newStringType();
        }
        CifType cifType2 = type;
        if (cifType2 instanceof TupleType) {
            void ttype;
            TupleType tupleType = (TupleType)cifType2;
            TupleType cfr_ignored_1 = (TupleType)cifType2;
            List<Field> fields = ttype.getFields().stream().map(f -> CifConstructors.newField((String)f.getName(), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(f.getType()))).toList();
            return CifConstructors.newTupleType(fields, null);
        }
        CifType cifType3 = type;
        if (cifType3 instanceof ListType) {
            void ltype;
            ListType fields = (ListType)cifType3;
            ListType cfr_ignored_2 = (ListType)cifType3;
            return CifConstructors.newListType((CifType)CifAutomatonBuilder.makeAnnoArgType(ltype.getElementType()), (Integer)ltype.getLower(), null, (Integer)ltype.getUpper());
        }
        CifType cifType4 = type;
        if (cifType4 instanceof SetType) {
            void stype;
            SetType setType = (SetType)cifType4;
            SetType cfr_ignored_3 = (SetType)cifType4;
            return CifConstructors.newSetType((CifType)CifAutomatonBuilder.makeAnnoArgType(stype.getElementType()), null);
        }
        CifType cifType5 = type;
        if (cifType5 instanceof DictType) {
            void dtype;
            DictType dictType = (DictType)cifType5;
            DictType cfr_ignored_4 = (DictType)cifType5;
            return CifConstructors.newDictType((CifType)CifAutomatonBuilder.makeAnnoArgType(dtype.getKeyType()), null, (CifType)CifAutomatonBuilder.makeAnnoArgType(dtype.getValueType()));
        }
        if (type instanceof FuncType) {
            return CifConstructors.newStringType();
        }
        throw new AssertionError((Object)("Unexpected type: " + String.valueOf(type)));
    }
}

