/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.explorer.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTuple;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.explorer.runtime.AbstractStateFactory;
import org.eclipse.escet.cif.explorer.runtime.BaseState;
import org.eclipse.escet.cif.explorer.runtime.ChosenEdge;
import org.eclipse.escet.cif.explorer.runtime.CollectedAlgVariable;
import org.eclipse.escet.cif.explorer.runtime.CollectedInvariants;
import org.eclipse.escet.cif.explorer.runtime.EventUsage;
import org.eclipse.escet.cif.explorer.runtime.ExplorerBuilder;
import org.eclipse.escet.cif.explorer.runtime.ExplorerEdge;
import org.eclipse.escet.cif.explorer.runtime.ExplorerState;
import org.eclipse.escet.cif.explorer.runtime.ExpressionEval;
import org.eclipse.escet.cif.explorer.runtime.InitialState;
import org.eclipse.escet.cif.explorer.runtime.NoInitialStateException;
import org.eclipse.escet.cif.explorer.runtime.NoInitialStateReason;
import org.eclipse.escet.cif.explorer.runtime.TransitionData;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.ListProductIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;
import org.eclipse.escet.common.java.exceptions.UnsupportedException;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class Explorer {
    public final Automaton[] automata;
    private List<Automaton> multiInitAuts;
    public final PositionObject[] variables;
    private List<DiscVariable> multiInitVars;
    private String[] variableNames = null;
    public final Map<PositionObject, Integer> indices;
    public final Map<AlgVariable, CollectedAlgVariable> algVariables;
    public final Map<Location, CollectedInvariants> stateInvs;
    public final List<Expression> markeds;
    public final Map<Location, List<Expression>> initialLocs;
    public Map<BaseState, BaseState> states = null;
    public final List<EventUsage> eventUsages;
    public final ExpressionEval evaluator = new ExpressionEval();
    private int freshStateNumber = 1;
    private List<BaseState> newStates;
    private final AbstractStateFactory stateFactory;

    public Explorer(Automaton[] automata, List<Automaton> multiInitAuts, PositionObject[] variables, List<DiscVariable> multiInitVars, Map<AlgVariable, CollectedAlgVariable> algVariables, Map<Location, CollectedInvariants> stateInvs, Map<Event, Map<Location, CollectedInvariants>> stateEvtExclInvs, List<Expression> markeds, Map<Location, List<Expression>> initialLocs, AbstractStateFactory stateFactory) {
        this.automata = automata;
        this.multiInitAuts = multiInitAuts;
        this.variables = variables;
        this.multiInitVars = multiInitVars;
        this.algVariables = algVariables;
        this.stateInvs = stateInvs;
        this.markeds = markeds;
        this.initialLocs = initialLocs;
        this.stateFactory = stateFactory;
        this.eventUsages = ExplorerBuilder.getSynchronizingEventMap(automata, stateEvtExclInvs);
        this.indices = Maps.map();
        int i = 0;
        while (i < automata.length) {
            this.indices.put((PositionObject)automata[i], i);
            for (Location loc : automata[i].getLocations()) {
                this.indices.put((PositionObject)loc, i);
            }
            ++i;
        }
        i = 0;
        while (i < variables.length) {
            this.indices.put(variables[i], i);
            ++i;
        }
    }

    public List<BaseState> getInitialStates(Application<?> app) {
        this.states = null;
        List statesValues = this.getPotentialInitialStates();
        if (statesValues == null) {
            statesValues = Lists.list(null);
        } else if (statesValues.isEmpty()) {
            statesValues.add(null);
        }
        this.states = Maps.map();
        int stateIdx = 0;
        while (stateIdx < statesValues.size()) {
            if (app.isTerminationRequested()) break;
            List stateValues = (List)statesValues.get(stateIdx);
            InitialState state = this.stateFactory.makeInitial(this);
            state.autLocs = Maps.mapc((int)this.multiInitAuts.size());
            state.varVals = Maps.mapc((int)this.multiInitVars.size());
            if (stateValues != null) {
                int i = 0;
                while (i < this.multiInitAuts.size()) {
                    state.autLocs.put(this.multiInitAuts.get(i), (Location)stateValues.get(i));
                    ++i;
                }
                int offset = this.multiInitAuts.size();
                int i2 = 0;
                while (i2 < this.multiInitVars.size()) {
                    state.varVals.put(this.multiInitVars.get(i2), (Expression)stateValues.get(offset + i2));
                    ++i2;
                }
            }
            NoInitialStateReason invalidReason = null;
            try {
                invalidReason = state.computeCompletely();
            }
            catch (NoInitialStateException ex) {
                invalidReason = ex.reason;
            }
            if (invalidReason != null) {
                if (stateValues == null) {
                    OutputProvider.warn((String)invalidReason.getMessage());
                }
            } else {
                this.addNewState(null, null, state);
            }
            ++stateIdx;
        }
        this.multiInitAuts = null;
        this.multiInitVars = null;
        if (this.states.isEmpty()) {
            this.states = null;
            return null;
        }
        return new ArrayList<BaseState>(this.states.keySet());
    }

    private List<List<Object>> getPotentialInitialStates() {
        List objValues;
        if (this.multiInitAuts.isEmpty() && this.multiInitVars.isEmpty()) {
            return null;
        }
        double stateCnt = 1.0;
        for (Automaton aut : this.multiInitAuts) {
            stateCnt *= this.getPotentialInitialLocCount(aut);
        }
        for (DiscVariable var : this.multiInitVars) {
            stateCnt *= CifValueUtils.getPossibleValueCount((CifType)var.getType());
        }
        if (stateCnt > 2.147483647E9) {
            String cntTxt = Double.isInfinite(stateCnt) ? "infinite" : CifMath.realToStr((double)stateCnt);
            String msg = Strings.fmt((String)"Too many potential initial states to store: %s.", (Object[])new Object[]{cntTxt});
            throw new UnsupportedException(msg);
        }
        int objCnt = this.multiInitAuts.size() + this.multiInitVars.size();
        List objsValues = Lists.listc((int)objCnt);
        for (Automaton aut : this.multiInitAuts) {
            objValues = Lists.cast(this.getPotentialInitialLocs(aut));
            objsValues.add(objValues);
        }
        for (DiscVariable var : this.multiInitVars) {
            objValues = Lists.cast(this.getPotentialInitialValues(var));
            objsValues.add(objValues);
        }
        List statesValues = Lists.listc((int)((int)stateCnt));
        ListProductIterator iter = new ListProductIterator(objsValues);
        while (iter.hasNext()) {
            List stateValues = iter.next();
            statesValues.add(stateValues);
        }
        return statesValues;
    }

    private double getPotentialInitialLocCount(Automaton aut) {
        double cnt = 0.0;
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty()) continue;
            cnt += 1.0;
        }
        return cnt;
    }

    private List<Location> getPotentialInitialLocs(Automaton aut) {
        List locs = Lists.list();
        for (Location loc : aut.getLocations()) {
            if (loc.getInitials().isEmpty()) continue;
            locs.add(loc);
        }
        return locs;
    }

    private List<Expression> getPotentialInitialValues(DiscVariable var) {
        VariableValue values = var.getValue();
        Assert.notNull((Object)values);
        if (values.getValues().isEmpty()) {
            return CifValueUtils.getPossibleValues((CifType)var.getType());
        }
        return values.getValues();
    }

    public List<BaseState> computeOutgoing(BaseState origState, boolean collectNewStates) {
        this.newStates = collectNewStates ? Lists.list() : null;
        List<Map<Event, List<ChosenEdge>>> autEdges = this.getAutomataEdges(origState);
        TransitionData transData = new TransitionData(origState, this.automata.length);
        transData.event = null;
        List<List<ChosenEdge>> syncSteps = Explorer.makeListSteps(this.automata.length);
        int i = 0;
        while (i < this.automata.length) {
            List<ChosenEdge> tauEdges = autEdges.get(i).get(null);
            if (tauEdges != null) {
                syncSteps.set(i, tauEdges);
                this.pickSyncEdge(transData, i, syncSteps);
                syncSteps.set(i, null);
            }
            ++i;
        }
        List<List<ChosenEdge>> sendSteps = Explorer.makeListSteps(this.automata.length);
        List<List<ChosenEdge>> recvSteps = Explorer.makeListSteps(this.automata.length);
        for (EventUsage usage : this.eventUsages) {
            int idx;
            int n;
            int n2;
            int[] nArray;
            if (!this.checkParticipation(autEdges, usage)) continue;
            transData.event = usage.event;
            if (!this.checkStateEventExclInvs(usage, transData)) continue;
            if (usage.isChannel) {
                nArray = usage.sendIndices;
                n2 = usage.sendIndices.length;
                n = 0;
                while (n < n2) {
                    idx = nArray[n];
                    sendSteps.set(idx, autEdges.get(idx).get(usage.event));
                    ++n;
                }
                nArray = usage.recvIndices;
                n2 = usage.recvIndices.length;
                n = 0;
                while (n < n2) {
                    idx = nArray[n];
                    recvSteps.set(idx, autEdges.get(idx).get(usage.event));
                    ++n;
                }
            }
            nArray = usage.alphabetIndices;
            n2 = usage.alphabetIndices.length;
            n = 0;
            while (n < n2) {
                idx = nArray[n];
                List<ChosenEdge> edges = autEdges.get(idx).get(usage.event);
                if (edges == null || edges.isEmpty()) {
                    Assert.check((boolean)usage.monitorAuts[idx]);
                } else {
                    syncSteps.set(idx, edges);
                }
                ++n;
            }
            if (usage.isChannel) {
                this.pickSendEdge(transData, sendSteps, recvSteps, syncSteps);
                nArray = usage.sendIndices;
                n2 = usage.sendIndices.length;
                n = 0;
                while (n < n2) {
                    idx = nArray[n];
                    sendSteps.set(idx, null);
                    ++n;
                }
                nArray = usage.recvIndices;
                n2 = usage.recvIndices.length;
                n = 0;
                while (n < n2) {
                    idx = nArray[n];
                    recvSteps.set(idx, null);
                    ++n;
                }
            } else {
                this.pickSyncEdge(transData, 0, syncSteps);
            }
            nArray = usage.alphabetIndices;
            n2 = usage.alphabetIndices.length;
            n = 0;
            while (n < n2) {
                idx = nArray[n];
                syncSteps.set(idx, null);
                ++n;
            }
        }
        if (this.newStates == null) {
            return null;
        }
        List<BaseState> result = this.newStates;
        this.newStates = null;
        return result;
    }

    private void pickSendEdge(TransitionData transData, List<List<ChosenEdge>> sendSteps, List<List<ChosenEdge>> recvSteps, List<List<ChosenEdge>> syncSteps) {
        int i = 0;
        while (i < this.automata.length) {
            List<ChosenEdge> chosenEdges = sendSteps.get(i);
            if (chosenEdges != null) {
                transData.sendIdx = i;
                Iterator<ChosenEdge> iterator = chosenEdges.iterator();
                while (iterator.hasNext()) {
                    ChosenEdge ce;
                    transData.sendEdge = ce = iterator.next();
                    this.pickRecvEdge(transData, recvSteps, syncSteps);
                }
                transData.sendEdge = null;
            }
            ++i;
        }
        transData.sendIdx = -1;
    }

    private void pickRecvEdge(TransitionData transData, List<List<ChosenEdge>> recvSteps, List<List<ChosenEdge>> syncSteps) {
        int i = 0;
        while (i < this.automata.length) {
            List<ChosenEdge> chosenEdges = recvSteps.get(i);
            if (chosenEdges != null) {
                Iterator<ChosenEdge> iterator = chosenEdges.iterator();
                while (iterator.hasNext()) {
                    ChosenEdge ce;
                    transData.edges[i] = ce = iterator.next();
                    this.pickSyncEdge(transData, 0, syncSteps);
                }
                transData.edges[i] = null;
            }
            ++i;
        }
    }

    private void pickSyncEdge(TransitionData transData, int idx, List<List<ChosenEdge>> syncSteps) {
        while (idx < this.automata.length && syncSteps.get(idx) == null) {
            ++idx;
        }
        if (idx < this.automata.length) {
            Iterator<ChosenEdge> iterator = syncSteps.get(idx).iterator();
            while (iterator.hasNext()) {
                ChosenEdge ce;
                transData.edges[idx] = ce = iterator.next();
                this.pickSyncEdge(transData, idx + 1, syncSteps);
            }
            transData.edges[idx] = null;
            return;
        }
        this.constructNewState(transData);
    }

    /*
     * WARNING - void declaration
     */
    private void constructNewState(TransitionData transData) {
        void var6_12;
        EdgeSend edgeSend;
        Location newLoc;
        ExplorerState newState = this.stateFactory.makeExplorerState(transData.event, transData.origState);
        BaseState origState = transData.origState;
        ChosenEdge sendEdge = transData.sendEdge;
        if (sendEdge != null && (newLoc = sendEdge.edge.getTarget()) != null) {
            newState.locations[transData.sendIdx] = newLoc;
        }
        int i = 0;
        while (i < this.automata.length) {
            Location location;
            if (transData.edges[i] != null && (location = transData.edges[i].edge.getTarget()) != null) {
                newState.locations[i] = location;
            }
            ++i;
        }
        Object sendValue = null;
        if (sendEdge != null && (edgeSend = (EdgeSend)sendEdge.edgeEvent).getValue() != null) {
            try {
                sendValue = origState.eval(edgeSend.getValue(), null);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value to send \"%s\" for event \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)edgeSend.getValue()), CifTextUtils.getAbsName((PositionObject)transData.event), origState.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        if (sendEdge != null) {
            this.performUpdates((List<Update>)sendEdge.edge.getUpdates(), sendValue, origState, newState);
        }
        boolean bl = false;
        while (var6_12 < this.automata.length) {
            if (transData.edges[var6_12] != null) {
                this.performUpdates((List<Update>)transData.edges[var6_12].edge.getUpdates(), sendValue, origState, newState);
            }
            ++var6_12;
        }
        if (this.stateFactory.unfoldExplorerState) {
            for (BaseState baseState : this.stateFactory.doUnfoldExplorerState(transData, newState)) {
                this.addNewState(transData, sendValue, baseState);
            }
        } else {
            this.addNewState(transData, sendValue, newState);
        }
    }

    private void addNewState(TransitionData transData, Object sendValue, BaseState newState) {
        BaseState authNewState = this.states.get(newState);
        if (authNewState == null) {
            if (transData != null) {
                if (!this.checkStateInvs(newState, this.stateInvs.get(null))) {
                    return;
                }
                Location[] locationArray = newState.locations;
                int n = newState.locations.length;
                int n2 = 0;
                while (n2 < n) {
                    Location loc = locationArray[n2];
                    if (!this.checkStateInvs(newState, this.stateInvs.get(loc))) {
                        return;
                    }
                    ++n2;
                }
            }
            newState.stateNumber = this.getFreshStateNumber();
            this.states.put(newState, newState);
            authNewState = newState;
            if (transData != null && this.newStates != null) {
                this.newStates.add(authNewState);
            }
        }
        if (transData != null) {
            new ExplorerEdge(transData.origState, authNewState, transData.event, sendValue);
        }
    }

    public void renumberStates() {
        int idx = 1;
        for (BaseState state : this.states.values()) {
            state.stateNumber = idx++;
        }
    }

    private List<Map<Event, List<ChosenEdge>>> getAutomataEdges(BaseState state) {
        List autEdges = Lists.listc((int)this.automata.length);
        Location[] locationArray = state.locations;
        int n = state.locations.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            Map edges = Maps.map();
            for (Edge edge : loc.getEdges()) {
                if (!Explorer.evalGuards((List<Expression>)edge.getGuards(), state, null)) continue;
                if (edge.getEvents().isEmpty()) {
                    Explorer.addEdge(edge, null, edges);
                    continue;
                }
                for (EdgeEvent eve : edge.getEvents()) {
                    Explorer.addEdge(edge, eve, edges);
                }
            }
            autEdges.add(edges);
            ++n2;
        }
        return autEdges;
    }

    private boolean checkParticipation(List<Map<Event, List<ChosenEdge>>> autEdges, EventUsage usage) {
        int n;
        if (usage.isChannel) {
            boolean sendFound = false;
            int[] nArray = usage.sendIndices;
            int n2 = usage.sendIndices.length;
            n = 0;
            while (n < n2) {
                int idx = nArray[n];
                if (autEdges.get(idx).containsKey(usage.event)) {
                    sendFound = true;
                    break;
                }
                ++n;
            }
            if (!sendFound) {
                return false;
            }
            boolean recvFound = false;
            int[] nArray2 = usage.recvIndices;
            int n3 = usage.recvIndices.length;
            n2 = 0;
            while (n2 < n3) {
                int idx = nArray2[n2];
                if (autEdges.get(idx).containsKey(usage.event)) {
                    recvFound = true;
                    break;
                }
                ++n2;
            }
            if (!recvFound) {
                return false;
            }
        }
        int[] nArray = usage.alphabetIndices;
        n = usage.alphabetIndices.length;
        int n4 = 0;
        while (n4 < n) {
            int idx = nArray[n4];
            if (!usage.monitorAuts[idx] && !autEdges.get(idx).containsKey(usage.event)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private static List<List<ChosenEdge>> makeListSteps(int length) {
        List steps = Lists.listc((int)length);
        int i = 0;
        while (i < length) {
            steps.add(null);
            ++i;
        }
        return steps;
    }

    private static void addEdge(Edge edge, EdgeEvent eve, Map<Event, List<ChosenEdge>> edges) {
        Expression evtExpr = eve == null ? null : eve.getEvent();
        Event event = evtExpr == null || evtExpr instanceof TauExpression ? null : ((EventExpression)evtExpr).getEvent();
        List chosens = edges.get(event);
        if (chosens == null) {
            chosens = Lists.list();
            edges.put(event, chosens);
        }
        chosens.add(new ChosenEdge(edge, eve));
    }

    private static boolean evalGuards(List<Expression> guards, BaseState state, Object sendValue) {
        for (Expression expr : guards) {
            try {
                Boolean val = (Boolean)state.eval(expr, sendValue);
                if (val.booleanValue()) continue;
                return false;
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value of guard \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr), state.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        return true;
    }

    private boolean checkStateInvs(BaseState state, CollectedInvariants cinvs) {
        if (cinvs == null) {
            return true;
        }
        return this.checkStateInvs(state, cinvs.getNoneInvariants()) && this.checkStateInvs(state, cinvs.getPlantInvariants()) && this.checkStateInvs(state, cinvs.getRequirementInvariants()) && this.checkStateInvs(state, cinvs.getSupervisorInvariants());
    }

    private boolean checkStateInvs(BaseState state, List<Invariant> invs) {
        for (Invariant inv : invs) {
            try {
                Object val = state.eval(inv.getPredicate(), null);
                boolean b = (Boolean)val;
                if (b) continue;
                return false;
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value of invariant \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false), state.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        return true;
    }

    private boolean checkStateEventExclInvs(EventUsage usage, TransitionData transData) {
        Assert.check((usage.event == transData.event ? 1 : 0) != 0);
        BaseState state = transData.origState;
        CollectedInvariants invs = usage.stateEvtExclInvs.get(null);
        if (!this.checkStateEventExclInvs(state, invs)) {
            return false;
        }
        Location[] locationArray = state.locations;
        int n = state.locations.length;
        int n2 = 0;
        while (n2 < n) {
            Location loc = locationArray[n2];
            CollectedInvariants locInvs = usage.stateEvtExclInvs.get(loc);
            if (!this.checkStateEventExclInvs(state, locInvs)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean checkStateEventExclInvs(BaseState state, CollectedInvariants cinvs) {
        if (cinvs == null) {
            return true;
        }
        return this.checkStateEventExclInvs(state, cinvs.getNoneInvariants()) && this.checkStateEventExclInvs(state, cinvs.getPlantInvariants()) && this.checkStateEventExclInvs(state, cinvs.getRequirementInvariants()) && this.checkStateEventExclInvs(state, cinvs.getSupervisorInvariants());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkStateEventExclInvs(BaseState state, List<Invariant> invs) {
        block6: for (Invariant inv : invs) {
            try {
                Object val = state.eval(inv.getPredicate(), null);
                boolean b = (Boolean)val;
                switch (inv.getInvKind()) {
                    case EVENT_DISABLES: {
                        if (!b) continue block6;
                        return false;
                    }
                    case EVENT_NEEDS: {
                        if (b) continue block6;
                        return false;
                    }
                    default: {
                        String msg = "Not a state/event excl inv: " + String.valueOf(inv);
                        throw new RuntimeException(msg);
                    }
                }
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value of invariant \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)false), state.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
        }
        return true;
    }

    private void performUpdates(List<Update> updates, Object sendValue, BaseState origState, BaseState newState) {
        for (Update upd : updates) {
            this.performUpdate(upd, sendValue, origState, newState);
        }
    }

    private void performUpdate(Update upd, Object sendValue, BaseState origState, BaseState newState) {
        if (upd instanceof IfUpdate) {
            IfUpdate iu = (IfUpdate)upd;
            boolean guard = Explorer.evalGuards((List<Expression>)iu.getGuards(), origState, sendValue);
            if (guard) {
                this.performUpdates((List<Update>)iu.getThens(), sendValue, origState, newState);
                return;
            }
            for (ElifUpdate eu : iu.getElifs()) {
                guard = Explorer.evalGuards((List<Expression>)eu.getGuards(), origState, sendValue);
                if (!guard) continue;
                this.performUpdates((List<Update>)eu.getThens(), sendValue, origState, newState);
                return;
            }
            this.performUpdates((List<Update>)iu.getElses(), sendValue, origState, newState);
            return;
        }
        if (upd instanceof Assignment) {
            Object rhs;
            Assignment asg = (Assignment)upd;
            try {
                rhs = origState.eval(asg.getValue(), sendValue);
            }
            catch (CifEvalException ex) {
                String msg = Strings.fmt((String)"Failed to compute value to assign for assignment \"%s := %s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)asg.getAddressable()), CifTextUtils.exprToStr((Expression)asg.getValue()), origState.toString()});
                throw new InvalidModelException(msg, (Throwable)ex);
            }
            this.checkTypeRangeBoundaries(asg.getAddressable().getType(), asg.getValue().getType(), true, rhs, asg.getAddressable(), asg.getValue(), origState);
            this.assignValue(rhs, asg.getAddressable(), sendValue, origState, newState);
        }
    }

    protected void checkTypeRangeBoundaries(CifType lhsType, CifType rhsType, boolean performTypecheck, Object rhsValue, Expression asgnLhs, Expression asgnRhs, BaseState state) {
        RangeCompat inRange = RangeCompat.CONTAINED;
        lhsType = CifTypeUtils.normalizeType((CifType)lhsType);
        rhsType = CifTypeUtils.normalizeType((CifType)rhsType);
        if (performTypecheck && CifTypeUtils.checkTypeCompat((CifType)lhsType, (CifType)rhsType, (RangeCompat)inRange)) {
            return;
        }
        if (lhsType instanceof IntType) {
            IntType lhsInt = (IntType)lhsType;
            int rhsVal = (Integer)rhsValue;
            if (lhsInt.getLower() != null && lhsInt.getLower() > rhsVal) {
                String msg = Strings.fmt((String)"Assigned value %d is too small in assignment \"%s := %s\" in state \"%s\".", (Object[])new Object[]{rhsVal, CifTextUtils.exprToStr((Expression)asgnLhs), CifTextUtils.exprToStr((Expression)asgnRhs), state.toString()});
                throw new InvalidModelException(msg);
            }
            if (lhsInt.getUpper() != null && lhsInt.getUpper() < rhsVal) {
                String msg = Strings.fmt((String)"Assigned value %d is too big in assignment \"%s := %s\" in state \"%s\".", (Object[])new Object[]{rhsVal, CifTextUtils.exprToStr((Expression)asgnLhs), CifTextUtils.exprToStr((Expression)asgnRhs), state.toString()});
                throw new InvalidModelException(msg);
            }
            return;
        }
        if (lhsType instanceof DictType) {
            Map rhsVal;
            DictType lhsDict = (DictType)lhsType;
            DictType rhsDict = (DictType)rhsType;
            if (!CifTypeUtils.checkTypeCompat((CifType)lhsDict.getKeyType(), (CifType)rhsDict.getKeyType(), (RangeCompat)inRange)) {
                rhsVal = (Map)rhsValue;
                for (Object val : rhsVal.keySet()) {
                    this.checkTypeRangeBoundaries(lhsDict.getKeyType(), rhsDict.getKeyType(), false, val, asgnLhs, asgnRhs, state);
                }
            }
            if (!CifTypeUtils.checkTypeCompat((CifType)lhsDict.getValueType(), (CifType)rhsDict.getValueType(), (RangeCompat)inRange)) {
                rhsVal = (Map)rhsValue;
                for (Object val : rhsVal.values()) {
                    this.checkTypeRangeBoundaries(lhsDict.getValueType(), rhsDict.getValueType(), false, val, asgnLhs, asgnRhs, state);
                }
            }
            return;
        }
        if (lhsType instanceof ListType) {
            ListType lhsList = (ListType)lhsType;
            ListType rhsList = (ListType)rhsType;
            List rhsVal = (List)rhsValue;
            int rhsSize = rhsVal.size();
            if (lhsList.getLower() != null && lhsList.getLower() > rhsSize) {
                String msg = Strings.fmt((String)"Assigned list \"%s\" has too few elements in assignment \"%s := %s\" in state \"%s\".", (Object[])new Object[]{CifEvalUtils.objToStr((Object)rhsVal), CifTextUtils.exprToStr((Expression)asgnLhs), CifTextUtils.exprToStr((Expression)asgnRhs), state.toString()});
                throw new InvalidModelException(msg);
            }
            if (lhsList.getUpper() != null && lhsList.getUpper() < rhsSize) {
                String msg = Strings.fmt((String)"Assigned list \"%s\" has too many elements in assignment \"%s := %s\" in state \"%s\".", (Object[])new Object[]{CifEvalUtils.objToStr((Object)rhsVal), CifTextUtils.exprToStr((Expression)asgnLhs), CifTextUtils.exprToStr((Expression)asgnRhs), state.toString()});
                throw new InvalidModelException(msg);
            }
            for (Object val : rhsVal) {
                this.checkTypeRangeBoundaries(lhsList.getElementType(), rhsList.getElementType(), true, val, asgnLhs, asgnRhs, state);
            }
            return;
        }
        if (lhsType instanceof SetType) {
            SetType lhsSet = (SetType)lhsType;
            SetType rhsSet = (SetType)rhsType;
            Set rhsVal = (Set)rhsValue;
            for (Object val : rhsVal) {
                this.checkTypeRangeBoundaries(lhsSet.getElementType(), rhsSet.getElementType(), true, val, asgnLhs, asgnRhs, state);
            }
            return;
        }
        if (lhsType instanceof TupleType) {
            TupleType lhsTuple = (TupleType)lhsType;
            TupleType rhsTuple = (TupleType)rhsType;
            CifTuple rhsVal = (CifTuple)rhsValue;
            int i = 0;
            while (i < rhsVal.size()) {
                this.checkTypeRangeBoundaries(((Field)lhsTuple.getFields().get(i)).getType(), ((Field)rhsTuple.getFields().get(i)).getType(), true, rhsVal.get(i), asgnLhs, asgnRhs, state);
                ++i;
            }
            return;
        }
        String msg = Strings.fmt((String)"Unexpected type %s encountered.", (Object[])new Object[]{lhsType});
        throw new RuntimeException(msg);
    }

    protected void assignValue(Object value, Expression addr, Object sendValue, BaseState origState, BaseState newState) {
        if (addr instanceof ProjectionExpression) {
            this.assignProjection(value, (ProjectionExpression)addr, sendValue, origState, newState);
            return;
        }
        if (addr instanceof TupleExpression) {
            TupleExpression a = (TupleExpression)addr;
            CifTuple ct = (CifTuple)value;
            Assert.check((ct.size() == a.getFields().size() ? 1 : 0) != 0);
            int i = 0;
            while (i < ct.size()) {
                this.assignValue(ct.get(i), (Expression)a.getFields().get(i), sendValue, origState, newState);
                ++i;
            }
            return;
        }
        if (addr instanceof DiscVariableExpression) {
            DiscVariableExpression a = (DiscVariableExpression)addr;
            DiscVariable dv = a.getVariable();
            newState.setVarValue((PositionObject)dv, value);
            return;
        }
        if (addr instanceof ContVariableExpression) {
            ContVariableExpression a = (ContVariableExpression)addr;
            ContVariable cv = a.getVariable();
            newState.setVarValue((PositionObject)cv, value);
            return;
        }
        String msg = Strings.fmt((String)"Found unexpected LHS %s in assignment.", (Object[])new Object[]{addr});
        throw new RuntimeException(msg);
    }

    private void assignProjection(Object value, ProjectionExpression addr, Object sendValue, BaseState origState, BaseState newState) {
        ProjectionExpression subAddr = addr;
        while (subAddr instanceof ProjectionExpression) {
            ProjectionExpression e = subAddr;
            subAddr = e.getChild();
        }
        Assert.check((boolean)(subAddr instanceof DiscVariableExpression));
        DiscVariableExpression a = (DiscVariableExpression)subAddr;
        DiscVariable dv = a.getVariable();
        Object val = newState.getVarValue((PositionObject)dv);
        val = this.modifyValue(val, (ProjectionExpression)subAddr.eContainer(), value, addr, origState, sendValue);
        newState.setVarValue((PositionObject)dv, val);
    }

    private Object modifyValue(Object value, ProjectionExpression expr, Object newValue, ProjectionExpression root, BaseState origState, Object sendValue) {
        Object index;
        try {
            index = origState.eval(expr.getIndex(), sendValue);
        }
        catch (CifEvalException ex) {
            String msg = Strings.fmt((String)"Failed to compute projection index \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)expr.getIndex()), origState.toString()});
            throw new InvalidModelException(msg, (Throwable)ex);
        }
        if (value instanceof CifTuple) {
            CifTuple value2 = (CifTuple)value;
            CifTuple val = new CifTuple(value2.size());
            val.addAll((Collection)value2);
            int idx = (Integer)index;
            Assert.check((idx >= 0 && idx < val.size() ? 1 : 0) != 0);
            if (expr != root) {
                newValue = this.modifyValue(val.get(idx), (ProjectionExpression)expr.eContainer(), newValue, root, origState, sendValue);
            }
            val.set(idx, newValue);
            return val;
        }
        if (value instanceof List) {
            List value2 = (List)value;
            List val = Lists.listc((int)value2.size());
            val.addAll(value2);
            if (val.isEmpty()) {
                String msg = Strings.fmt((String)"Cannot index into an empty list while assigning a value to projected variable \"%s\" in state \"%s\".", (Object[])new Object[]{CifTextUtils.exprToStr((Expression)root), origState.toString()});
                throw new InvalidModelException(msg);
            }
            int idx = (Integer)index;
            if (idx >= val.size()) {
                String msg = Strings.fmt((String)"List index \"%d\" is too large, biggest allowed index is \"%d\", while assigning a value to projected variable \"%s\" in state \"%s\".", (Object[])new Object[]{idx, val.size() - 1, CifTextUtils.exprToStr((Expression)root), origState.toString()});
                throw new InvalidModelException(msg);
            }
            if (idx < 0) {
                if (idx + val.size() < 0) {
                    String msg = Strings.fmt((String)"List index %d is too small, smallest allowed index is \"%d\", while assigning a value to projected variable \"%s\" in state \"%s\".", (Object[])new Object[]{index, -val.size(), CifTextUtils.exprToStr((Expression)root), origState.toString()});
                    throw new InvalidModelException(msg);
                }
                idx += val.size();
            }
            if (expr != root) {
                newValue = this.modifyValue(val.get(idx), (ProjectionExpression)expr.eContainer(), newValue, root, origState, sendValue);
            }
            val.set(idx, newValue);
            return val;
        }
        if (value instanceof Map) {
            Map value2 = (Map)value;
            Map val = Maps.mapc((int)value2.size());
            val.putAll(value2);
            if (expr != root) {
                if (!val.containsKey(index)) {
                    String msg = "Key error, value \"%s\" is not a key in the dictionary, while assigning a value to projected variable \"%s\" in state \"%s\".";
                    msg = Strings.fmt((String)msg, (Object[])new Object[]{index, CifTextUtils.exprToStr((Expression)root), origState.toString()});
                    throw new InvalidModelException(msg);
                }
                newValue = this.modifyValue(val.get(index), (ProjectionExpression)expr.eContainer(), newValue, root, origState, sendValue);
            }
            val.put(index, newValue);
            return val;
        }
        String msg = Strings.fmt((String)"Do not know how to modify value %s.", (Object[])new Object[]{value});
        throw new RuntimeException(msg);
    }

    public int getFreshStateNumber() {
        return this.freshStateNumber++;
    }

    public String[] getVariableNames() {
        if (this.variableNames != null) {
            return this.variableNames;
        }
        this.variableNames = new String[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            this.variableNames[i] = CifTextUtils.getAbsName((PositionObject)this.variables[i]);
            ++i;
        }
        return this.variableNames;
    }

    public void minimizeEdges() {
        if (this.states == null) {
            return;
        }
        for (BaseState state : this.states.keySet()) {
            List<ExplorerEdge> edges = state.getOutgoingEdges();
            Map eventMap = Maps.mapc((int)edges.size());
            Iterator<ExplorerEdge> edgesIter = edges.iterator();
            while (edgesIter.hasNext()) {
                ExplorerEdge edge = edgesIter.next();
                Set targetStates = (Set)eventMap.get(edge.event);
                if (targetStates == null) {
                    targetStates = Sets.set((Object)edge.next);
                    eventMap.put(edge.event, targetStates);
                    continue;
                }
                if (targetStates.contains(edge.next)) {
                    edgesIter.remove();
                    continue;
                }
                targetStates.add(edge.next);
            }
        }
    }
}

