/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.io;

import java.io.IOException;
import java.util.Locale;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.escet.cif.common.CifRelativePathUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.prettyprinter.CifPrettyPrinter;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.StreamCodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.emf.ecore.xmi.RealXMIResource;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;

public class CifWriter {
    private CifWriter() {
    }

    public static void writeCifSpec(Specification spec, String absFilePath, String specPath) {
        String absDirPath = Paths.getAbsFilePathDir((String)absFilePath);
        CifRelativePathUtils.adaptRelativePaths((ComplexComponent)spec, (String)specPath, (String)absDirPath);
        if (absFilePath.toLowerCase(Locale.US).endsWith(".cifx")) {
            URI resourceUri = Paths.createEmfURI((String)absFilePath);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            RealXMIResource resource = (RealXMIResource)resourceSet.createResource(resourceUri);
            resource.getContents().add((Object)spec);
            EMFHelper.normalizeXmiIds((XMLResource)resource);
            try {
                resource.save(null);
            }
            catch (IOException e) {
                throw new InvalidInputException(Strings.fmt((String)"Failed to load CIF file \"%s\".", (Object[])new Object[]{absFilePath}), (Throwable)e);
            }
            resource.getContents().remove((Object)spec);
            return;
        }
        FileAppStream stream = new FileAppStream(absFilePath);
        StreamCodeBox code = new StreamCodeBox((AppStream)stream, 2);
        CifPrettyPrinter.boxSpec((Specification)spec, (CodeBox)code);
        code.close();
    }
}

