/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion;

import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcCastFunctionDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFunctionBlockDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcSemanticFuncDescription;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;

public class PlcFunctionAppls {
    private final PlcTarget target;
    private static final PlcBasicFuncDescription.PlcParameterDescription[] ONE_INPUT_PARAMETER = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY)};

    public PlcFunctionAppls(PlcTarget target) {
        this.target = target;
    }

    public PlcFuncAppl negateFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.NEGATE_OP, (String)null, "-", PlcBasicFuncDescription.ExprBinding.UNARY_EXPR, in);
    }

    public PlcFuncAppl powerFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.POWER_OP, "EXPT", "**", PlcBasicFuncDescription.ExprBinding.POWER_EXPR, in1, in2);
    }

    public PlcFuncAppl multiplyFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.MULTIPLY_OP, "MUL", "*", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, inN);
    }

    public PlcFuncAppl divideFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.DIVIDE_OP, "DIV", "/", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, in1, in2);
    }

    public PlcFuncAppl moduloFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.MODULO_OP, "MOD", "MOD", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, in1, in2);
    }

    public PlcFuncAppl addFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.ADD_OP, "ADD", "+", PlcBasicFuncDescription.ExprBinding.ADD_EXPR, inN);
    }

    public PlcFuncAppl subtractFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.SUBTRACT_OP, "SUB", "-", PlcBasicFuncDescription.ExprBinding.MUL_EXPR, in1, in2);
    }

    public PlcFuncAppl lessThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_THAN_OP, "LT", "<", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, in1, in2);
    }

    public PlcFuncAppl lessEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.LESS_EQUAL_OP, "LE", "<=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, in1, in2);
    }

    public PlcFuncAppl greaterThanFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_THAN_OP, "GT", ">", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, in1, in2);
    }

    public PlcFuncAppl greaterEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.GREATER_EQUAL_OP, "GE", ">=", PlcBasicFuncDescription.ExprBinding.ORDER_EXPR, in1, in2);
    }

    public PlcFuncAppl equalFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.EQUAL_OP, "EQ", "=", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR, in1, in2);
    }

    public PlcFuncAppl unEqualFuncAppl(PlcExpression in1, PlcExpression in2) {
        return this.funcAppl(PlcFuncOperation.UNEQUAL_OP, "NE", "<>", PlcBasicFuncDescription.ExprBinding.EQUAL_EXPR, in1, in2);
    }

    public PlcFuncAppl complementFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.COMPLEMENT_OP, "NOT", "NOT ", PlcBasicFuncDescription.ExprBinding.UNARY_EXPR, in);
    }

    public PlcFuncAppl andFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.AND_OP, "AND", "AND", PlcBasicFuncDescription.ExprBinding.CONJUNCT_EXPR, inN);
    }

    public PlcFuncAppl xorFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.XOR_OP, "XOR", "XOR", PlcBasicFuncDescription.ExprBinding.EXCL_DISJUNCT_EXPR, inN);
    }

    public PlcFuncAppl orFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.OR_OP, "OR", "OR", PlcBasicFuncDescription.ExprBinding.DISJUNCT_EXPR, inN);
    }

    public PlcFuncAppl castFunctionAppl(PlcExpression in, PlcElementaryType inType, PlcElementaryType outType) {
        PlcFuncOperation operation = PlcFuncOperation.CAST_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcCastFunctionDescription func = new PlcCastFunctionDescription(inType, outType);
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    public PlcFuncAppl selFuncAppl(PlcExpression g, PlcExpression in0, PlcExpression in1) {
        PlcFuncOperation operation = PlcFuncOperation.SEL_OP;
        Assert.check((boolean)this.target.supportsOperation(operation, 3));
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("G", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("IN0", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("IN1", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY)};
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, "SEL", params, this.target.getSupportedFuncNotations(operation, 3));
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("G", g), new PlcNamedValue("IN0", in0), new PlcNamedValue("IN1", in1)));
    }

    public PlcFuncAppl normalizeArrayIndex(PlcExpression indexExpr, int arraySize) {
        PlcFuncAppl g = this.greaterEqualFuncAppl(indexExpr, new PlcIntLiteral(0));
        PlcFuncAppl in0 = this.addFuncAppl(indexExpr, new PlcIntLiteral(arraySize));
        PlcExpression in1 = indexExpr;
        return this.selFuncAppl(g, in0, in1);
    }

    public PlcFuncAppl absFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ABS, "ABS", in);
    }

    public PlcFuncAppl expFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_EXP, "EXP", in);
    }

    public PlcFuncAppl lnFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LN, "LN", in);
    }

    public PlcFuncAppl logFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_LOG, "LOG", in);
    }

    public PlcFuncAppl minFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MIN, "MIN", inN);
    }

    public PlcFuncAppl maxFuncAppl(PlcExpression ... inN) {
        return this.funcAppl(PlcFuncOperation.STDLIB_MAX, "MAX", inN);
    }

    public PlcFuncAppl sqrtFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SQRT, "SQRT", in);
    }

    public PlcFuncAppl acosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ACOS, "ACOS", in);
    }

    public PlcFuncAppl asinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ASIN, "ASIN", in);
    }

    public PlcFuncAppl atanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_ATAN, "ATAN", in);
    }

    public PlcFuncAppl cosFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_COS, "COS", in);
    }

    public PlcFuncAppl sinFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_SIN, "SIN", in);
    }

    public PlcFuncAppl tanFuncAppl(PlcExpression in) {
        return this.funcAppl(PlcFuncOperation.STDLIB_TAN, "TAN", in);
    }

    public PlcFunctionBlockDescription makeTonBlock(String prefixFuncName) {
        PlcBasicFuncDescription.PlcParameterDescription[] params = new PlcBasicFuncDescription.PlcParameterDescription[]{new PlcBasicFuncDescription.PlcParameterDescription("IN", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("PT", PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("Q", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY), new PlcBasicFuncDescription.PlcParameterDescription("ET", PlcBasicFuncDescription.PlcParamDirection.OUTPUT_ONLY)};
        return new PlcFunctionBlockDescription(prefixFuncName + this.target.getTonFuncBlockCallSuffix(), new PlcDerivedType("TON"), params);
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, ONE_INPUT_PARAMETER, this.target.getSupportedFuncNotations(operation, 1));
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcExpression in) {
        Assert.check((boolean)this.target.supportsOperation(operation, 1));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, ONE_INPUT_PARAMETER, infixText, exprBinding, this.target.getSupportedFuncNotations(operation, 1));
        return new PlcFuncAppl(func, List.of(new PlcNamedValue("IN", in)));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length), this.target.getSupportedFuncNotations(operation, inN.length));
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private PlcFuncAppl funcAppl(PlcFuncOperation operation, String prefixText, String infixText, PlcBasicFuncDescription.ExprBinding exprBinding, PlcExpression ... inN) {
        Assert.check((boolean)this.target.supportsOperation(operation, inN.length));
        PlcSemanticFuncDescription func = new PlcSemanticFuncDescription(operation, prefixText, PlcFunctionAppls.makeParamList(inN.length), infixText, exprBinding, this.target.getSupportedFuncNotations(operation, inN.length));
        return new PlcFuncAppl(func, PlcFunctionAppls.makeArgumentList(inN));
    }

    private static PlcBasicFuncDescription.PlcParameterDescription[] makeParamList(int length) {
        return (PlcBasicFuncDescription.PlcParameterDescription[])IntStream.range(0, length).mapToObj(i -> new PlcBasicFuncDescription.PlcParameterDescription("IN" + (i + 1), PlcBasicFuncDescription.PlcParamDirection.INPUT_ONLY)).toArray(PlcBasicFuncDescription.PlcParameterDescription[]::new);
    }

    private static List<PlcNamedValue> makeArgumentList(PlcExpression ... inN) {
        return (List)IntStream.range(0, inN.length).mapToObj(i -> new PlcNamedValue("IN" + (i + 1), inN[i])).collect(Lists.toList());
    }

    public PlcFuncAppl funcBlockAppl(PlcFunctionBlockDescription funcBlkDesc, List<PlcNamedValue> arguments) {
        return new PlcFuncAppl(funcBlkDesc, arguments);
    }
}

