/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.conversion.expressions;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunction;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TimeExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprAddressableResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenResult;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcSelectionStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class ExprGenerator {
    private static final CifType INT_TYPE = CifConstructors.newIntType();
    private static final CifType REAL_TYPE = CifConstructors.newRealType();
    private final Map<String, Integer> localNameGenMap = Maps.map();
    private final List<PlcBasicVariable> variables = Lists.list();
    private final Map<String, Integer> varNameToVarIndex = Maps.map();
    private final BitSet variableIsTemp = new BitSet();
    private final BitSet variableIsAvailable = new BitSet();
    private final PlcTarget target;
    private final CifDataProvider scopeCifDataProvider;
    private CifDataProvider currentCifDataProvider;
    private final PlcFunctionAppls funcAppls;
    private PlcBasicVariable channelValueVariable = null;

    public ExprGenerator(PlcTarget target, CifDataProvider cifDataProvider) {
        this.target = target;
        this.scopeCifDataProvider = cifDataProvider;
        this.currentCifDataProvider = cifDataProvider;
        this.funcAppls = new PlcFunctionAppls(target);
    }

    public PlcBasicVariable getTempVariable(String prefix, CifType cifType) {
        PlcType plcType = this.target.getTypeGenerator().convertType(cifType);
        return this.getTempVariable(prefix, plcType);
    }

    public PlcBasicVariable getTempVariable(String prefix, PlcType plcType) {
        Iterator iterator = new BitSetIterator(this.variableIsAvailable).iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            PlcBasicVariable var = this.variables.get(idx);
            if (!plcType.equals(var.type) || !var.varName.startsWith(prefix)) continue;
            this.variableIsAvailable.clear(idx);
            return var;
        }
        return this.createVariable(prefix, plcType, null, null, true);
    }

    public PlcBasicVariable makeLocalVariable(String prefix, PlcType plcType) {
        return this.createVariable(prefix, plcType, null, null, false);
    }

    public PlcBasicVariable makeLocalVariable(String prefix, PlcType plcType, String address, PlcExpression value) {
        return this.createVariable(prefix, plcType, address, value, false);
    }

    private PlcBasicVariable createVariable(String prefix, PlcType plcType, String address, PlcExpression value, boolean isTempVar) {
        String name = this.target.getNameGenerator().generateLocalName(prefix, this.localNameGenMap);
        PlcDataVariable newVar = new PlcDataVariable(name, plcType, address, value);
        int newVarIndex = this.variables.size();
        this.variables.add(newVar);
        this.varNameToVarIndex.put(newVar.varName, newVarIndex);
        if (isTempVar) {
            this.variableIsTemp.set(newVarIndex);
        }
        return newVar;
    }

    public void releaseTempVariables(Collection<PlcBasicVariable> variables) {
        for (PlcBasicVariable var : variables) {
            this.releaseTempVariable(var);
        }
    }

    public void releaseTempVariable(PlcBasicVariable variable) {
        Integer idx = this.varNameToVarIndex.get(variable.varName);
        if (idx == null || !this.variableIsTemp.get(idx)) {
            return;
        }
        this.variableIsAvailable.set(idx);
    }

    public List<PlcBasicVariable> getCreatedTempVariables() {
        List tempVars = Lists.listc((int)this.variableIsTemp.cardinality());
        Iterator iterator = new BitSetIterator(this.variableIsTemp).iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            tempVars.add(this.variables.get(idx));
        }
        Collections.sort(tempVars, (a, b) -> a.varName.compareTo(b.varName));
        return tempVars;
    }

    public CifDataProvider getScopeCifDataProvider() {
        return this.scopeCifDataProvider;
    }

    public void setCurrentCifDataProvider(CifDataProvider newCifDataProvider) {
        this.currentCifDataProvider = newCifDataProvider == null ? this.scopeCifDataProvider : newCifDataProvider;
    }

    public void setChannelValueVariable(PlcBasicVariable channelValueVariable) {
        this.channelValueVariable = channelValueVariable;
    }

    /*
     * WARNING - void declaration
     */
    public ExprAddressableResult convertVariableAddressable(Expression expr) {
        Expression expression = expr;
        if (expression instanceof DiscVariableExpression) {
            void de;
            DiscVariableExpression discVariableExpression = (DiscVariableExpression)expression;
            DiscVariableExpression cfr_ignored_0 = (DiscVariableExpression)expression;
            return (ExprAddressableResult)new ExprAddressableResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getAddressableForDiscVar(de.getVariable()));
        }
        Expression expression2 = expr;
        if (expression2 instanceof ContVariableExpression) {
            void ce;
            ContVariableExpression contVariableExpression = (ContVariableExpression)expression2;
            ContVariableExpression cfr_ignored_1 = (ContVariableExpression)expression2;
            return (ExprAddressableResult)new ExprAddressableResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getAddressableForContvar(ce.getVariable(), ce.isDerivative()));
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    /*
     * WARNING - void declaration
     */
    public ExprValueResult convertValue(Expression expr) {
        Expression expression = expr;
        if (expression instanceof BoolExpression) {
            void be;
            BoolExpression boolExpression = (BoolExpression)expression;
            BoolExpression cfr_ignored_0 = (BoolExpression)expression;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcBoolLiteral(be.isValue()));
        }
        Expression expression2 = expr;
        if (expression2 instanceof IntExpression) {
            void ie;
            IntExpression intExpression = (IntExpression)expression2;
            IntExpression cfr_ignored_1 = (IntExpression)expression2;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcIntLiteral(ie.getValue()));
        }
        Expression expression3 = expr;
        if (expression3 instanceof RealExpression) {
            void re;
            RealExpression realExpression = (RealExpression)expression3;
            RealExpression cfr_ignored_2 = (RealExpression)expression3;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcRealLiteral(re.getValue()));
        }
        if (expr instanceof StringExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        if (expr instanceof TimeExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression4 = expr;
        if (expression4 instanceof CastExpression) {
            void ce;
            CastExpression castExpression = (CastExpression)expression4;
            CastExpression cfr_ignored_3 = (CastExpression)expression4;
            return this.convertCastExpr((CastExpression)ce);
        }
        Expression expression5 = expr;
        if (expression5 instanceof UnaryExpression) {
            void ue;
            UnaryExpression unaryExpression = (UnaryExpression)expression5;
            UnaryExpression cfr_ignored_4 = (UnaryExpression)expression5;
            return this.convertUnaryExpr((UnaryExpression)ue);
        }
        Expression expression6 = expr;
        if (expression6 instanceof BinaryExpression) {
            void be;
            BinaryExpression binaryExpression = (BinaryExpression)expression6;
            BinaryExpression cfr_ignored_5 = (BinaryExpression)expression6;
            return this.convertBinaryExpr((BinaryExpression)be);
        }
        Expression expression7 = expr;
        if (expression7 instanceof IfExpression) {
            void ife;
            IfExpression ifExpression = (IfExpression)expression7;
            IfExpression cfr_ignored_6 = (IfExpression)expression7;
            return this.convertIfExpr((IfExpression)ife);
        }
        Expression expression8 = expr;
        if (expression8 instanceof ProjectionExpression) {
            void pe;
            ProjectionExpression projectionExpression = (ProjectionExpression)expression8;
            ProjectionExpression cfr_ignored_7 = (ProjectionExpression)expression8;
            return this.convertProjectionValue((Expression)pe);
        }
        if (expr instanceof SliceExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression9 = expr;
        if (expression9 instanceof FunctionCallExpression) {
            void fce;
            FunctionCallExpression functionCallExpression = (FunctionCallExpression)expression9;
            FunctionCallExpression cfr_ignored_8 = (FunctionCallExpression)expression9;
            return this.convertFuncCallExpr((FunctionCallExpression)fce);
        }
        Expression expression10 = expr;
        if (expression10 instanceof ListExpression) {
            void le;
            ListExpression listExpression = (ListExpression)expression10;
            ListExpression cfr_ignored_9 = (ListExpression)expression10;
            return this.convertArrayExpr((ListExpression)le);
        }
        if (expr instanceof SetExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression11 = expr;
        if (expression11 instanceof TupleExpression) {
            void te;
            TupleExpression tupleExpression = (TupleExpression)expression11;
            TupleExpression cfr_ignored_10 = (TupleExpression)expression11;
            return this.convertTupleExpr((TupleExpression)te);
        }
        if (expr instanceof DictExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression12 = expr;
        if (expression12 instanceof ConstantExpression) {
            void ce;
            ConstantExpression constantExpression = (ConstantExpression)expression12;
            ConstantExpression cfr_ignored_11 = (ConstantExpression)expression12;
            return this.convertValue(ce.getConstant().getValue());
        }
        Expression expression13 = expr;
        if (expression13 instanceof DiscVariableExpression) {
            void de;
            DiscVariableExpression discVariableExpression = (DiscVariableExpression)expression13;
            DiscVariableExpression cfr_ignored_12 = (DiscVariableExpression)expression13;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForDiscVar(de.getVariable()));
        }
        Expression expression14 = expr;
        if (expression14 instanceof AlgVariableExpression) {
            void ae;
            AlgVariableExpression algVariableExpression = (AlgVariableExpression)expression14;
            AlgVariableExpression cfr_ignored_13 = (AlgVariableExpression)expression14;
            return this.convertValue(ae.getVariable().getValue());
        }
        Expression expression15 = expr;
        if (expression15 instanceof ContVariableExpression) {
            void ce;
            ContVariableExpression contVariableExpression = (ContVariableExpression)expression15;
            ContVariableExpression cfr_ignored_14 = (ContVariableExpression)expression15;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForContvar(ce.getVariable(), ce.isDerivative()));
        }
        Expression expression16 = expr;
        if (expression16 instanceof LocationExpression) {
            LocationExpression locationExpression = (LocationExpression)expression16;
            LocationExpression cfr_ignored_15 = (LocationExpression)expression16;
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression17 = expr;
        if (expression17 instanceof EnumLiteralExpression) {
            void eLit;
            EnumLiteralExpression enumLiteralExpression = (EnumLiteralExpression)expression17;
            EnumLiteralExpression cfr_ignored_16 = (EnumLiteralExpression)expression17;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.target.getTypeGenerator().getPlcEnumLiteral(eLit.getLiteral()));
        }
        if (expr instanceof FunctionExpression) {
            throw new RuntimeException("Precondition violation.");
        }
        Expression expression18 = expr;
        if (expression18 instanceof InputVariableExpression) {
            void ie;
            InputVariableExpression inputVariableExpression = (InputVariableExpression)expression18;
            InputVariableExpression cfr_ignored_17 = (InputVariableExpression)expression18;
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(this.currentCifDataProvider.getValueForInputVar(ie.getVariable()));
        }
        if (expr instanceof ReceivedExpression) {
            Assert.notNull((Object)this.channelValueVariable);
            return (ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcVarExpression(this.channelValueVariable, new PlcVarExpression.PlcProjection[0]));
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }

    private ExprValueResult convertCastExpr(CastExpression castExpr) {
        ExprValueResult result = this.convertValue(castExpr.getChild());
        CifType ctype = CifTypeUtils.normalizeType((CifType)castExpr.getChild().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)castExpr.getType());
        if (ctype instanceof IntType && rtype instanceof RealType) {
            return (ExprValueResult)result.setValue(this.funcAppls.castFunctionAppl(result.value, this.target.getIntegerType(), this.target.getRealType()));
        }
        if (CifTypeUtils.checkTypeCompat((CifType)ctype, (CifType)rtype, (RangeCompat)RangeCompat.EQUAL)) {
            return result;
        }
        throw new RuntimeException("Precondition violation.");
    }

    private ExprValueResult convertUnaryExpr(UnaryExpression unaryExpr) {
        ExprValueResult result = this.convertValue(unaryExpr.getChild());
        switch (unaryExpr.getOperator()) {
            case INVERSE: {
                return (ExprValueResult)result.setValue(this.funcAppls.complementFuncAppl(result.value));
            }
            case NEGATE: {
                return (ExprValueResult)result.setValue(this.funcAppls.negateFuncAppl(result.value));
            }
            case PLUS: {
                return result;
            }
            case SAMPLE: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unknown unop: " + String.valueOf(unaryExpr.getOperator()));
    }

    private ExprValueResult convertBinaryExpr(BinaryExpression binExpr) {
        CifType ltype = CifTypeUtils.normalizeType((CifType)binExpr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)binExpr.getRight().getType());
        ExprValueResult leftResult = this.convertValue(binExpr.getLeft());
        ExprValueResult rightResult = this.convertValue(binExpr.getRight());
        ExprValueResult result = new ExprValueResult(this, leftResult, rightResult);
        switch (binExpr.getOperator()) {
            case IMPLICATION: {
                return (ExprValueResult)result.setValue(this.funcAppls.orFuncAppl(rightResult.value, this.funcAppls.complementFuncAppl(leftResult.value)));
            }
            case BI_CONDITIONAL: {
                return (ExprValueResult)result.setValue(this.funcAppls.equalFuncAppl(leftResult.value, rightResult.value));
            }
            case DISJUNCTION: 
            case CONJUNCTION: {
                if (ltype instanceof BoolType) {
                    return this.convertFlattenedExpr(binExpr);
                }
                throw new RuntimeException("Precondition violation.");
            }
            case LESS_THAN: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.lessThanFuncAppl(leftSide, rightSide));
            }
            case LESS_EQUAL: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.lessEqualFuncAppl(leftSide, rightSide));
            }
            case GREATER_THAN: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.greaterThanFuncAppl(leftSide, rightSide));
            }
            case GREATER_EQUAL: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                return (ExprValueResult)result.setValue(this.funcAppls.greaterEqualFuncAppl(leftSide, rightSide));
            }
            case EQUAL: {
                if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                    return (ExprValueResult)result.setValue(this.funcAppls.equalFuncAppl(leftResult.value, rightResult.value));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case UNEQUAL: {
                if (ltype instanceof BoolType || ltype instanceof IntType || ltype instanceof RealType || ltype instanceof EnumType) {
                    return (ExprValueResult)result.setValue(this.funcAppls.unEqualFuncAppl(leftResult.value, rightResult.value));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case ADDITION: {
                if (ltype instanceof IntType || ltype instanceof RealType) {
                    return this.convertFlattenedExpr(binExpr);
                }
                throw new RuntimeException("Precondition violation.");
            }
            case SUBTRACTION: {
                if (ltype instanceof IntType || ltype instanceof RealType) {
                    PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, rtype);
                    PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, ltype);
                    return (ExprValueResult)result.setValue(this.funcAppls.subtractFuncAppl(leftSide, rightSide));
                }
                throw new RuntimeException("Precondition violation.");
            }
            case MULTIPLICATION: {
                return this.convertFlattenedExpr(binExpr);
            }
            case DIVISION: {
                PlcExpression leftSide = this.unifyTypeOfExpr(leftResult.value, ltype, REAL_TYPE);
                PlcExpression rightSide = this.unifyTypeOfExpr(rightResult.value, rtype, REAL_TYPE);
                return (ExprValueResult)result.setValue(this.funcAppls.divideFuncAppl(leftSide, rightSide));
            }
            case INTEGER_DIVISION: {
                return (ExprValueResult)result.setValue(this.funcAppls.divideFuncAppl(leftResult.value, rightResult.value));
            }
            case MODULUS: {
                return (ExprValueResult)result.setValue(this.funcAppls.moduloFuncAppl(leftResult.value, rightResult.value));
            }
            case ELEMENT_OF: {
                throw new RuntimeException("Precondition violation.");
            }
            case SUBSET: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unknown binary expression operator: " + String.valueOf(binExpr.getOperator()));
    }

    private ExprValueResult convertFlattenedExpr(BinaryExpression binExpr) {
        CifType unifiedType;
        Function<PlcExpression[], PlcExpression> applFunc;
        boolean unifyTypes = switch (binExpr.getOperator()) {
            case BinaryOperator.DISJUNCTION -> {
                applFunc = values -> this.funcAppls.orFuncAppl((PlcExpression)values);
                yield false;
            }
            case BinaryOperator.CONJUNCTION -> {
                applFunc = values -> this.funcAppls.andFuncAppl((PlcExpression)values);
                yield false;
            }
            case BinaryOperator.ADDITION -> {
                applFunc = values -> this.funcAppls.addFuncAppl((PlcExpression)values);
                yield true;
            }
            case BinaryOperator.MULTIPLICATION -> {
                applFunc = values -> this.funcAppls.multiplyFuncAppl((PlcExpression)values);
                yield true;
            }
            default -> throw new RuntimeException("Unexpected flattened binary expression operator: " + String.valueOf(binExpr.getOperator()));
        };
        List exprs = CifValueUtils.flattenBinExpr(List.of(binExpr), (BinaryOperator)binExpr.getOperator());
        if (unifyTypes) {
            unifiedType = INT_TYPE;
            for (Expression expr : exprs) {
                if (!(CifTypeUtils.normalizeType((CifType)expr.getType()) instanceof RealType)) continue;
                unifiedType = REAL_TYPE;
                break;
            }
        } else {
            unifiedType = null;
        }
        ExprGenResult[] exprValueResults = new ExprGenResult[exprs.size()];
        PlcExpression[] values2 = new PlcExpression[exprs.size()];
        int i = 0;
        for (Expression expr : exprs) {
            ExprValueResult exprValueResult = this.convertValue(expr);
            exprValueResults[i] = exprValueResult;
            values2[i] = unifyTypes ? this.unifyTypeOfExpr(exprValueResult.value, CifTypeUtils.normalizeType((CifType)expr.getType()), unifiedType) : exprValueResult.value;
            ++i;
        }
        ExprValueResult exprValueResult = new ExprValueResult(this, exprValueResults);
        return (ExprValueResult)exprValueResult.setValue(applFunc.apply(values2));
    }

    private ExprValueResult convertIfExpr(IfExpression ifExpr) {
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        PlcType resultValueType = this.target.getTypeGenerator().convertType(ifExpr.getType());
        PlcBasicVariable resultVar = this.getTempVariable("ifResult", resultValueType);
        result.valueVariables.add(resultVar);
        result.setValue(new PlcVarExpression(resultVar, new PlcVarExpression.PlcProjection[0]));
        PlcSelectionStatement selStat = null;
        selStat = this.addBranch((List<Expression>)ifExpr.getGuards(), this.generateThenStatement(resultVar, ifExpr.getThen()), selStat, result.code);
        for (ElifExpression elif : ifExpr.getElifs()) {
            selStat = this.addBranch((List<Expression>)elif.getGuards(), this.generateThenStatement(resultVar, elif.getThen()), selStat, result.code);
        }
        this.addBranch(null, this.generateThenStatement(resultVar, ifExpr.getElse()), selStat, result.code);
        return result;
    }

    private Supplier<List<PlcStatement>> generateThenStatement(PlcBasicVariable resultVar, Expression resultValue) {
        return () -> {
            List statements = Lists.list();
            ExprValueResult retValueResult = this.convertValue(resultValue);
            statements.addAll(retValueResult.code);
            statements.add(new PlcAssignmentStatement(new PlcVarExpression(resultVar, new PlcVarExpression.PlcProjection[0]), retValueResult.value));
            this.releaseTempVariables(retValueResult.codeVariables);
            this.releaseTempVariables(retValueResult.valueVariables);
            return statements;
        };
    }

    public PlcSelectionStatement addBranch(List<Expression> guards, Supplier<List<PlcStatement>> genThenStats, PlcSelectionStatement selStat, List<PlcStatement> rootCode) {
        List<ExprValueResult> convertedGuards;
        if (guards == null) {
            convertedGuards = null;
        } else if (guards.isEmpty()) {
            convertedGuards = List.of((ExprValueResult)new ExprValueResult(this, new ExprGenResult[0]).setValue(new PlcBoolLiteral(true)));
        } else {
            convertedGuards = Lists.listc((int)guards.size());
            for (Expression guard : guards) {
                convertedGuards.add(this.convertValue(guard));
            }
        }
        return this.addPlcBranch(convertedGuards, genThenStats, selStat, rootCode);
    }

    public PlcSelectionStatement addPlcBranch(List<ExprValueResult> plcGuards, Supplier<List<PlcStatement>> genThenStats, PlcSelectionStatement selStat, List<PlcStatement> rootCode) {
        List<PlcStatement> codeStorage;
        List<PlcStatement> list = codeStorage = selStat != null ? selStat.elseStats : rootCode;
        if (plcGuards != null) {
            PlcExpression[] grdValues = new PlcExpression[plcGuards.size()];
            boolean seenGuardCode = false;
            Set grdVariables = Sets.set();
            int grdNum = 0;
            for (ExprValueResult grdResult : plcGuards) {
                if (grdResult.hasCode()) {
                    seenGuardCode = true;
                    codeStorage.addAll(grdResult.code);
                    grdVariables.addAll(grdResult.codeVariables);
                }
                grdVariables.addAll(grdResult.valueVariables);
                grdValues[grdNum] = grdResult.value;
                ++grdNum;
            }
            if (selStat == null || seenGuardCode) {
                selStat = new PlcSelectionStatement();
                codeStorage.add(selStat);
            }
            PlcSelectionStatement.PlcSelectChoice choice = grdNum == 1 ? new PlcSelectionStatement.PlcSelectChoice(grdValues[0], Lists.list()) : new PlcSelectionStatement.PlcSelectChoice((PlcExpression)this.funcAppls.andFuncAppl(grdValues), Lists.list());
            selStat.condChoices.add(choice);
            this.releaseTempVariables(grdVariables);
            codeStorage = choice.thenStats;
        }
        codeStorage.addAll((Collection<PlcStatement>)genThenStats.get());
        return selStat;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public ExprAddressableResult convertProjectedAddressable(Expression expr) {
        Expression expression;
        List projections = Lists.list();
        while ((expression = expr) instanceof ProjectionExpression) {
            void proj;
            ProjectionExpression cfr_ignored_0 = (ProjectionExpression)expression;
            ProjectionExpression cfr_ignored_1 = (ProjectionExpression)expression;
            projections.add(proj);
            expr = proj.getChild();
        }
        Assert.check((!projections.isEmpty() ? 1 : 0) != 0);
        ExprAddressableResult exprResult = this.convertVariableAddressable(expr);
        PlcVarExpression varExpr = new PlcVarExpression(((PlcVarExpression)exprResult.value).variable, this.convertAddProjections(projections, Lists.copy(((PlcVarExpression)exprResult.value).projections), exprResult));
        exprResult.setValue(varExpr);
        return exprResult;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private ExprValueResult convertProjectionValue(Expression expr) {
        Expression expression;
        List projections = Lists.list();
        while ((expression = expr) instanceof ProjectionExpression) {
            void proj;
            ProjectionExpression cfr_ignored_0 = (ProjectionExpression)expression;
            ProjectionExpression cfr_ignored_1 = (ProjectionExpression)expression;
            projections.add(proj);
            expr = proj.getChild();
        }
        Assert.check((!projections.isEmpty() ? 1 : 0) != 0);
        ExprValueResult exprResult = this.convertValue(expr);
        PlcExpression plcExpression = exprResult.value;
        if (plcExpression instanceof PlcVarExpression) {
            void parentVarExpr;
            PlcVarExpression plcVarExpression = (PlcVarExpression)plcExpression;
            PlcVarExpression cfr_ignored_2 = (PlcVarExpression)plcExpression;
            PlcVarExpression varExpr = new PlcVarExpression(parentVarExpr.variable, this.convertAddProjections(projections, Lists.copy(parentVarExpr.projections), exprResult));
            exprResult.setValue(varExpr);
            return exprResult;
        }
        PlcType plcType = this.target.getTypeGenerator().convertType(expr.getType());
        PlcBasicVariable projectVar = this.getTempVariable("project", plcType);
        ExprValueResult convertResult = new ExprValueResult(this, exprResult);
        PlcVarExpression varExpr = new PlcVarExpression(projectVar, new PlcVarExpression.PlcProjection[0]);
        convertResult.code.add(new PlcAssignmentStatement(varExpr, convertResult.value));
        convertResult.codeVariables.addAll(exprResult.valueVariables);
        convertResult.setValue(new PlcVarExpression(projectVar, this.convertAddProjections(projections, Lists.list(), convertResult)));
        convertResult.valueVariables.add(projectVar);
        return convertResult;
    }

    /*
     * WARNING - void declaration
     */
    private List<PlcVarExpression.PlcProjection> convertAddProjections(List<ProjectionExpression> cifProjections, List<PlcVarExpression.PlcProjection> plcProjections, ExprGenResult<?, ?> convertResult) {
        int i = cifProjections.size() - 1;
        while (i >= 0) {
            ProjectionExpression cifProjection = cifProjections.get(i);
            CifType unProjectedType = CifTypeUtils.normalizeType((CifType)cifProjection.getChild().getType());
            Expression cifIndexExpr = cifProjection.getIndex();
            CifType cifType = unProjectedType;
            if (cifType instanceof ListType) {
                void lt;
                ListType cfr_ignored_0 = (ListType)cifType;
                ListType cfr_ignored_1 = (ListType)cifType;
                Object indexResult = this.convertValue(cifIndexExpr);
                convertResult.mergeCodeAndVariables((ExprGenResult<?, ?>)indexResult);
                PlcFuncAppl normalizedIndex = this.funcAppls.normalizeArrayIndex(indexResult.value, lt.getUpper());
                plcProjections.add(new PlcVarExpression.PlcArrayProjection(normalizedIndex));
            } else {
                CifType cifType2 = unProjectedType;
                if (cifType2 instanceof TupleType) {
                    TupleType cfr_ignored_2 = (TupleType)cifType2;
                    TupleType cfr_ignored_3 = (TupleType)cifType2;
                    int fieldIndex = CifValueUtils.getTupleProjIndex((ProjectionExpression)cifProjection);
                    PlcType structTypeName = this.target.getTypeGenerator().convertType(unProjectedType);
                    PlcStructType structType = this.target.getTypeGenerator().getStructureType(structTypeName);
                    plcProjections.add(new PlcVarExpression.PlcStructProjection(structType.fields.get((int)fieldIndex).fieldName));
                } else {
                    throw new AssertionError((Object)("Unexpected unprojected type \"" + String.valueOf(unProjectedType) + "\" found."));
                }
            }
            --i;
        }
        return plcProjections;
    }

    private ExprValueResult convertFuncCallExpr(FunctionCallExpression funcCallExpr) {
        List argumentResults = Lists.listc((int)funcCallExpr.getArguments().size());
        for (Expression arg : funcCallExpr.getArguments()) {
            argumentResults.add(this.convertValue(arg));
        }
        Expression fexpr = funcCallExpr.getFunction();
        Expression expression = fexpr;
        if (expression instanceof StdLibFunctionExpression) {
            Iterator iterator = (StdLibFunctionExpression)expression;
            StdLibFunctionExpression cfr_ignored_0 = (StdLibFunctionExpression)expression;
            return this.convertStdlibExpr(funcCallExpr, argumentResults);
        }
        throw new RuntimeException("Calls to internal user-defined functions are not implemented yet.");
    }

    private ExprValueResult convertStdlibExpr(FunctionCallExpression stdlibCallExpr, List<ExprValueResult> argumentResults) {
        EList arguments = stdlibCallExpr.getArguments();
        StdLibFunction stdlib = ((StdLibFunctionExpression)stdlibCallExpr.getFunction()).getFunction();
        switch (stdlib) {
            case ABS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.absFuncAppl(arg1.value));
            }
            case CBRT: {
                PlcFuncAppl expValue = this.funcAppls.divideFuncAppl(new PlcRealLiteral("1.0"), new PlcRealLiteral("3.0"));
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.powerFuncAppl(arg1.value, expValue));
            }
            case CEIL: {
                throw new RuntimeException("Precondition violation.");
            }
            case DELETE: {
                throw new RuntimeException("Precondition violation.");
            }
            case EMPTY: {
                throw new RuntimeException("Precondition violation.");
            }
            case EXP: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.expFuncAppl(arg1.value));
            }
            case FLOOR: {
                throw new RuntimeException("Precondition violation.");
            }
            case FORMAT: {
                throw new RuntimeException("Precondition violation.");
            }
            case LN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.lnFuncAppl(arg1.value));
            }
            case LOG: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                if (!this.target.supportsOperation(PlcFuncOperation.STDLIB_LOG, argumentResults.size())) {
                    PlcFuncAppl lnX = this.funcAppls.lnFuncAppl(arg1.value);
                    PlcFuncAppl ln10 = this.funcAppls.lnFuncAppl(new PlcRealLiteral("10.0"));
                    return (ExprValueResult)arg1.setValue(this.funcAppls.divideFuncAppl(lnX, ln10));
                }
                return (ExprValueResult)arg1.setValue(this.funcAppls.logFuncAppl(arg1.value));
            }
            case MINIMUM: 
            case MAXIMUM: {
                Assert.check((argumentResults.size() == 2 ? 1 : 0) != 0);
                CifType ltype = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(0)).getType());
                CifType rtype = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(1)).getType());
                PlcExpression leftSide = this.unifyTypeOfExpr(argumentResults.get((int)0).value, ltype, rtype);
                PlcExpression rightSide = this.unifyTypeOfExpr(argumentResults.get((int)1).value, rtype, ltype);
                ExprValueResult result = new ExprValueResult(this, argumentResults.get(0), argumentResults.get(1));
                if (stdlib == StdLibFunction.MAXIMUM) {
                    return (ExprValueResult)result.setValue(this.funcAppls.maxFuncAppl(leftSide, rightSide));
                }
                return (ExprValueResult)result.setValue(this.funcAppls.minFuncAppl(leftSide, rightSide));
            }
            case POP: {
                throw new RuntimeException("Precondition violation.");
            }
            case POWER: {
                Assert.check((argumentResults.size() == 2 ? 1 : 0) != 0);
                CifType baseType = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(0)).getType());
                CifType exponentType = CifTypeUtils.normalizeType((CifType)((Expression)arguments.get(1)).getType());
                boolean baseIsInt = baseType instanceof IntType;
                boolean exponentIsInt = exponentType instanceof IntType;
                boolean baseAllowsInt = baseIsInt && !CifTypeUtils.isRangeless((IntType)((IntType)baseType));
                boolean exponentAllowsInt = exponentIsInt && !CifTypeUtils.isRangeless((IntType)((IntType)exponentType)) && ((IntType)exponentType).getLower() >= 0;
                boolean cifIntResult = baseAllowsInt & exponentAllowsInt;
                boolean plcBaseIsInt = baseIsInt;
                boolean plcExponentIsInt = exponentIsInt;
                if (!this.target.supportsPower(plcBaseIsInt, plcExponentIsInt) && plcBaseIsInt) {
                    plcBaseIsInt = false;
                }
                if (!this.target.supportsPower(plcBaseIsInt, plcExponentIsInt) && plcExponentIsInt) {
                    plcExponentIsInt = false;
                }
                PlcExpression baseSide = argumentResults.get((int)0).value;
                if (baseIsInt && !plcBaseIsInt) {
                    baseSide = this.funcAppls.castFunctionAppl(baseSide, this.target.getIntegerType(), this.target.getRealType());
                }
                PlcExpression exponentSide = argumentResults.get((int)1).value;
                if (exponentIsInt && !plcExponentIsInt) {
                    exponentSide = this.funcAppls.castFunctionAppl(exponentSide, this.target.getIntegerType(), this.target.getRealType());
                }
                PlcFuncAppl powCall = this.funcAppls.powerFuncAppl(baseSide, exponentSide);
                boolean plcIntResult = plcBaseIsInt & plcExponentIsInt;
                if (cifIntResult && !plcIntResult) {
                    powCall = this.funcAppls.castFunctionAppl(powCall, this.target.getRealType(), this.target.getIntegerType());
                }
                ExprValueResult result = new ExprValueResult(this, argumentResults.get(0), argumentResults.get(1));
                return (ExprValueResult)result.setValue(powCall);
            }
            case ROUND: {
                throw new RuntimeException("Precondition violation.");
            }
            case SCALE: {
                throw new RuntimeException("Precondition violation.");
            }
            case SIGN: {
                throw new RuntimeException("Precondition violation.");
            }
            case SIZE: {
                throw new RuntimeException("Precondition violation.");
            }
            case SQRT: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.sqrtFuncAppl(arg1.value));
            }
            case ACOS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.acosFuncAppl(arg1.value));
            }
            case ASIN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.asinFuncAppl(arg1.value));
            }
            case ATAN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.atanFuncAppl(arg1.value));
            }
            case COS: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.cosFuncAppl(arg1.value));
            }
            case SIN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.sinFuncAppl(arg1.value));
            }
            case TAN: {
                Assert.check((argumentResults.size() == 1 ? 1 : 0) != 0);
                ExprValueResult arg1 = argumentResults.get(0);
                return (ExprValueResult)arg1.setValue(this.funcAppls.tanFuncAppl(arg1.value));
            }
            case ACOSH: 
            case ASINH: 
            case ATANH: 
            case COSH: 
            case SINH: 
            case TANH: {
                throw new RuntimeException("Precondition violation.");
            }
            case BERNOULLI: 
            case BETA: 
            case BINOMIAL: 
            case CONSTANT: 
            case ERLANG: 
            case EXPONENTIAL: 
            case GAMMA: 
            case GEOMETRIC: 
            case LOG_NORMAL: 
            case NORMAL: 
            case POISSON: 
            case RANDOM: 
            case TRIANGLE: 
            case UNIFORM: 
            case WEIBULL: {
                throw new RuntimeException("Precondition violation.");
            }
        }
        throw new RuntimeException("Unexpected standard library function: " + String.valueOf(stdlib));
    }

    private ExprValueResult convertArrayExpr(ListExpression listExpr) {
        PlcType listType = this.target.getTypeGenerator().convertType(listExpr.getType());
        PlcBasicVariable arrayVar = this.getTempVariable("litArray", listType);
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        int idx = 0;
        for (Expression e : listExpr.getElements()) {
            ExprValueResult childResult = this.convertValue(e);
            result.mergeCode(childResult);
            this.releaseTempVariables(childResult.codeVariables);
            PlcVarExpression.PlcArrayProjection arrayProj = new PlcVarExpression.PlcArrayProjection(List.of(new PlcIntLiteral(idx)));
            PlcVarExpression lhs = new PlcVarExpression(arrayVar, List.of(arrayProj));
            PlcAssignmentStatement assignment = new PlcAssignmentStatement(lhs, childResult.value);
            ++idx;
            result.code.add(assignment);
            this.releaseTempVariables(childResult.valueVariables);
        }
        result.valueVariables.add(arrayVar);
        return (ExprValueResult)result.setValue(new PlcVarExpression(arrayVar, new PlcVarExpression.PlcProjection[0]));
    }

    private ExprValueResult convertTupleExpr(TupleExpression tupleExpr) {
        PlcType varType = this.target.getTypeGenerator().convertType(tupleExpr.getType());
        PlcBasicVariable structVar = this.getTempVariable("litStruct", varType);
        PlcStructType structType = this.target.getTypeGenerator().getStructureType(varType);
        ExprValueResult result = new ExprValueResult(this, new ExprGenResult[0]);
        int idx = 0;
        for (Expression e : tupleExpr.getFields()) {
            ExprValueResult childResult = this.convertValue(e);
            result.mergeCode(childResult);
            this.releaseTempVariables(childResult.codeVariables);
            PlcVarExpression.PlcStructProjection structProj = new PlcVarExpression.PlcStructProjection(structType.fields.get((int)idx).fieldName);
            PlcVarExpression lhs = new PlcVarExpression(structVar, List.of(structProj));
            PlcAssignmentStatement assignment = new PlcAssignmentStatement(lhs, childResult.value);
            ++idx;
            result.code.add(assignment);
            this.releaseTempVariables(childResult.valueVariables);
        }
        result.valueVariables.add(structVar);
        return (ExprValueResult)result.setValue(new PlcVarExpression(structVar, new PlcVarExpression.PlcProjection[0]));
    }

    private PlcExpression unifyTypeOfExpr(PlcExpression expr, CifType myType, CifType otherType) {
        if (myType instanceof IntType && otherType instanceof RealType) {
            return this.funcAppls.castFunctionAppl(expr, this.target.getIntegerType(), this.target.getRealType());
        }
        return expr;
    }
}

