/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.StateInitVarOrderer;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprValueResult;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcRealLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class DefaultVariableStorage
implements VariableStorage {
    private final PlcTarget target;
    private final PlcFunctionAppls funcAppls;
    private final Map<Declaration, PlcBasicVariable> variables = Maps.map();

    public DefaultVariableStorage(PlcTarget target) {
        this.target = target;
        this.funcAppls = new PlcFunctionAppls(target);
    }

    @Override
    public void addStateVariable(Declaration decl, CifType type) {
        PlcType varType = this.target.getTypeGenerator().convertType(type);
        String varName = this.target.getNameGenerator().generateGlobalName((PositionObject)decl);
        PlcBasicVariable plcVar = this.target.getCodeStorage().addStateVariable(varName, varType);
        this.variables.put(decl, plcVar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process() {
        ExprGenerator exprGen = this.target.getCodeStorage().getExprGenerator();
        StateInitVarOrderer varOrderer = new StateInitVarOrderer();
        for (Declaration decl : this.variables.keySet()) {
            if (!(decl instanceof DiscVariable) && !(decl instanceof ContVariable)) continue;
            varOrderer.addObject((Object)decl);
        }
        List statements = Lists.list();
        statements.add(new PlcCommentLine("Initialize the state variables."));
        for (Declaration decl : varOrderer.computeOrder(true)) {
            ContVariable assignedContVar;
            ExprValueResult exprResult;
            Declaration declaration = decl;
            if (declaration instanceof DiscVariable) {
                void discVar;
                DiscVariable cfr_ignored_0 = (DiscVariable)declaration;
                DiscVariable cfr_ignored_1 = (DiscVariable)declaration;
                exprResult = exprGen.convertValue((Expression)Lists.first((List)discVar.getValue().getValues()));
                assignedContVar = null;
            } else {
                Declaration declaration2 = decl;
                if (declaration2 instanceof ContVariable) {
                    void contVar;
                    ContVariable cfr_ignored_2 = (ContVariable)declaration2;
                    ContVariable cfr_ignored_3 = (ContVariable)declaration2;
                    exprResult = exprGen.convertValue(contVar.getValue());
                    assignedContVar = contVar;
                } else {
                    throw new AssertionError((Object)("Unexpected kind of variable " + String.valueOf(decl)));
                }
            }
            statements.addAll(exprResult.code);
            exprGen.releaseTempVariables(exprResult.codeVariables);
            PlcVarExpression lhs = new PlcVarExpression(this.variables.get(decl), new PlcVarExpression.PlcProjection[0]);
            statements.add(new PlcAssignmentStatement(lhs, exprResult.value));
            exprGen.releaseTempVariables(exprResult.valueVariables);
            if (assignedContVar == null) continue;
            statements.addAll(this.target.getContinuousVariablesGenerator().getPlcTimerCodeGen(assignedContVar).generateAssignPreset());
        }
        this.target.getCodeStorage().addStateInitialization(statements);
    }

    @Override
    public CifDataProvider getCifDataProvider() {
        return new CifDataProvider(){

            @Override
            public PlcExpression getValueForConstant(Constant constant) {
                return new PlcVarExpression((PlcBasicVariable)new PlcDataVariable("someConstantvariable", PlcElementaryType.LREAL_TYPE), new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForDiscVar(DiscVariable variable) {
                PlcBasicVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForDiscVar(DiscVariable variable) {
                PlcBasicVariable plcDiscvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcDiscvar);
                return new PlcVarExpression(plcDiscvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForContvar(ContVariable variable, boolean getDerivative) {
                if (getDerivative) {
                    return DefaultVariableStorage.this.funcAppls.negateFuncAppl(new PlcRealLiteral("1.0"));
                }
                PlcBasicVariable plcContVar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcContVar);
                return new PlcVarExpression(plcContVar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForContvar(ContVariable variable, boolean writeDerivative) {
                Assert.check((!writeDerivative ? 1 : 0) != 0);
                PlcBasicVariable plcContVar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcContVar);
                return new PlcVarExpression(plcContVar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcExpression getValueForInputVar(InputVariable variable) {
                PlcBasicVariable plcInpvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcInpvar);
                return new PlcVarExpression(plcInpvar, new PlcVarExpression.PlcProjection[0]);
            }

            @Override
            public PlcVarExpression getAddressableForInputVar(InputVariable variable) {
                PlcBasicVariable plcInpvar = DefaultVariableStorage.this.variables.get(variable);
                Assert.notNull((Object)plcInpvar);
                return new PlcVarExpression(plcInpvar, new PlcVarExpression.PlcProjection[0]);
            }
        };
    }
}

