/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.expressions.CifDataProvider;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.io.IoAddress;
import org.eclipse.escet.cif.plcgen.generators.io.IoDirection;
import org.eclipse.escet.cif.plcgen.generators.io.IoEntry;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.CsvParser;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class InputOutputGenerator {
    private static final Set<PlcElementaryType> FEASIBLE_IO_VAR_TYPES = Sets.set((Object[])new PlcElementaryType[]{PlcElementaryType.BOOL_TYPE, PlcElementaryType.INT_TYPE, PlcElementaryType.DINT_TYPE, PlcElementaryType.LINT_TYPE, PlcElementaryType.REAL_TYPE, PlcElementaryType.LREAL_TYPE});
    private final PlcTarget target;
    private final String ioTablePath;
    private final String absIoTablePath;
    private final WarnOutput warnOutput;

    public InputOutputGenerator(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.ioTablePath = settings.ioTablePath;
        this.absIoTablePath = settings.absIoTablePath;
        this.warnOutput = settings.warnOutput;
    }

    public void process() {
        List<IoEntry> entries = this.convertIoTableEntries();
        this.generateIoCode(entries);
    }

    private List<IoEntry> convertIoTableEntries() {
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (BufferedReader ioTableText = new BufferedReader(new FileReader(this.absIoTablePath));){
                Set connectedInputCifObjects = Sets.set();
                Set connectedPlcAddresses = Sets.set();
                List entries = Lists.list();
                CsvParser parser = new CsvParser((Reader)ioTableText);
                int lineNumber = 0;
                while (true) {
                    String message;
                    PositionObject cifObj;
                    ++lineNumber;
                    List line = parser.getLine();
                    if (line == null) break;
                    String tableLinePositionText = Strings.fmt((String)"at line %d of I/O table file \"%s\"", (Object[])new Object[]{lineNumber, this.ioTablePath});
                    if (line.size() != 3) {
                        String message2 = Strings.fmt((String)"Incorrect number of fields (expected 3 fields, found %d) %s.", (Object[])new Object[]{line.size(), tableLinePositionText});
                        throw new InvalidInputException(message2);
                    }
                    String plcTableTypeText = ((String)line.get(1)).trim();
                    PlcType plcTableType = this.checkIoType(plcTableTypeText, tableLinePositionText);
                    String absCifName = ((String)line.get(2)).trim();
                    try {
                        cifObj = this.target.getCifProcessor().findCifObjectByAbsName(absCifName);
                    }
                    catch (IllegalArgumentException ex) {
                        String message3 = Strings.fmt((String)"The 'CIF name' field containing \"%s\" does not refer to an object in the CIF specification (third field %s).", (Object[])new Object[]{absCifName, tableLinePositionText});
                        throw new InvalidInputException(message3, (Throwable)ex);
                    }
                    PlcType plcTypeFromCif = this.decideTypeFromCif(absCifName, cifObj, tableLinePositionText);
                    IoDirection directionFromCif = this.decideIoDirectionFromCif(cifObj);
                    if (directionFromCif == IoDirection.IO_READ) {
                        if (connectedInputCifObjects.contains(cifObj)) {
                            String message4 = Strings.fmt((String)"The CIF variable for entry %s is already in use for receiving a value from an input, as specified by an earlier I/O table entry.", (Object[])new Object[]{tableLinePositionText});
                            throw new InvalidInputException(message4);
                        }
                        connectedInputCifObjects.add(cifObj);
                    }
                    plcTableType = this.decidePlcType(plcTableType, absCifName, plcTypeFromCif, tableLinePositionText);
                    String plcAddressText = ((String)line.get(0)).trim();
                    if (plcAddressText.isEmpty()) {
                        String message5 = Strings.fmt((String)"The 'address' field is empty (first field %s).", (Object[])new Object[]{tableLinePositionText});
                        throw new InvalidInputException(message5);
                    }
                    IoAddress plcAddress = this.target.parseIoAddress(plcAddressText);
                    if (plcAddress == null) {
                        message = Strings.fmt((String)"The 'address' field does not have a correct form (first field %s).", (Object[])new Object[]{tableLinePositionText});
                        throw new InvalidInputException(message);
                    }
                    if (directionFromCif == IoDirection.IO_WRITE) {
                        if (connectedPlcAddresses.contains(plcAddress)) {
                            message = Strings.fmt((String)"The PLC address for the entry %s is already in use for outputting a value, as specified by an earlier I/O table entry.", (Object[])new Object[]{tableLinePositionText});
                            throw new InvalidInputException(message);
                        }
                        connectedPlcAddresses.add(plcAddress);
                    }
                    this.target.verifyIoTableEntry(plcAddress, plcTableType, directionFromCif, tableLinePositionText);
                    IoEntry entry = new IoEntry(plcAddress, plcTableType, cifObj, directionFromCif);
                    entries.add(entry);
                }
                return entries;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            this.warnOutput.line("I/O table file \"%s\" not found. The PLC code will not perform any I/O with the environment.", new Object[]{this.ioTablePath});
            return List.of();
        }
        catch (IOException ex) {
            throw new InputOutputException("Failed to read I/O table file \"" + this.ioTablePath + "\".", (Throwable)ex);
        }
    }

    private PlcType checkIoType(String plcTableTypeText, String tableLinePositionText) {
        PlcType plcTableType;
        if (!plcTableTypeText.isEmpty()) {
            plcTableType = this.getIoVarType(plcTableTypeText);
            if (plcTableType == null) {
                String message = Strings.fmt((String)"Type \"%s\" contained in the 'PLC type' field is not a usable type for input/output (second field %s).", (Object[])new Object[]{plcTableTypeText, tableLinePositionText});
                throw new InvalidInputException(message);
            }
        } else {
            plcTableType = null;
        }
        return plcTableType;
    }

    /*
     * WARNING - void declaration
     */
    private PlcType decideTypeFromCif(String absName, PositionObject cifObj, String tableLinePositionText) {
        PositionObject positionObject = cifObj;
        if (positionObject instanceof DiscVariable) {
            void dv;
            DiscVariable discVariable = (DiscVariable)positionObject;
            DiscVariable cfr_ignored_0 = (DiscVariable)positionObject;
            return this.target.getTypeGenerator().convertType(dv.getType());
        }
        PositionObject positionObject2 = cifObj;
        if (positionObject2 instanceof InputVariable) {
            void iv;
            InputVariable inputVariable = (InputVariable)positionObject2;
            InputVariable cfr_ignored_1 = (InputVariable)positionObject2;
            return this.target.getTypeGenerator().convertType(iv.getType());
        }
        String message = Strings.fmt((String)"The 'CIF name' field containing \"%s\" does not indicate an input or discrete variable (third field %s).", (Object[])new Object[]{absName, tableLinePositionText});
        throw new InvalidInputException(message);
    }

    private IoDirection decideIoDirectionFromCif(PositionObject posObject) {
        if (posObject instanceof DiscVariable) {
            return IoDirection.IO_WRITE;
        }
        if (posObject instanceof InputVariable) {
            return IoDirection.IO_READ;
        }
        throw new AssertionError((Object)("Unexpected CIF object \"" + String.valueOf(posObject) + "\"."));
    }

    private PlcType decidePlcType(PlcType plcTableType, String absCifName, PlcType plcTypeFromCif, String tableLinePositionText) {
        Assert.notNull((Object)plcTypeFromCif);
        if (plcTableType != null) {
            if (!plcTableType.equals(plcTypeFromCif)) {
                String message = Strings.fmt((String)"The type stated in the 'PLC type' field does not correspond with the type of the connected CIF variable from the 'CIF name' field containing \"%s\", for the entry %s.", (Object[])new Object[]{absCifName, tableLinePositionText});
                throw new InvalidInputException(message);
            }
        } else {
            if (!FEASIBLE_IO_VAR_TYPES.contains(plcTypeFromCif)) {
                String message = Strings.fmt((String)"The type of CIF variable \"%s\" is not a usable type for input/output (third field %s).", (Object[])new Object[]{absCifName, tableLinePositionText});
                throw new InvalidInputException(message);
            }
            plcTableType = plcTypeFromCif;
        }
        return plcTableType;
    }

    private PlcType getIoVarType(String typeName) {
        for (PlcElementaryType varType : FEASIBLE_IO_VAR_TYPES) {
            if (!typeName.equalsIgnoreCase(varType.name)) continue;
            return varType;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void generateIoCode(List<IoEntry> entries) {
        List inputStats = Lists.list();
        List outputStats = Lists.list();
        NameGenerator nameGenerator = this.target.getNameGenerator();
        PlcCodeStorage codeStorage = this.target.getCodeStorage();
        CifDataProvider cifDataProvider = codeStorage.getExprGenerator().getScopeCifDataProvider();
        for (IoEntry entry : entries) {
            PlcExpression rightSide;
            PlcVarExpression leftSide;
            Assert.check((boolean)EnumSet.of(IoDirection.IO_READ, IoDirection.IO_WRITE).contains((Object)entry.ioDirection));
            boolean isInput = entry.ioDirection == IoDirection.IO_READ;
            List stats = isInput ? inputStats : outputStats;
            String varPrefix = isInput ? "in_" : "out_";
            Object ioVarName = varPrefix + CifTextUtils.getAbsName((PositionObject)entry.cifObject, (boolean)false);
            ioVarName = nameGenerator.generateGlobalName((String)ioVarName, false);
            PlcDataVariable ioVar = new PlcDataVariable((String)ioVarName, entry.varType, entry.plcAddress.getAddress(), null);
            if (isInput) {
                codeStorage.addInputVariable(ioVar);
            } else {
                codeStorage.addOutputVariable(ioVar);
            }
            if (isInput) {
                PositionObject positionObject = entry.cifObject;
                if (positionObject instanceof DiscVariable) {
                    void discVar;
                    DiscVariable cfr_ignored_0 = (DiscVariable)positionObject;
                    DiscVariable cfr_ignored_1 = (DiscVariable)positionObject;
                    leftSide = cifDataProvider.getAddressableForDiscVar((DiscVariable)discVar);
                } else {
                    PositionObject positionObject2 = entry.cifObject;
                    if (positionObject2 instanceof InputVariable) {
                        void inpVar;
                        InputVariable cfr_ignored_2 = (InputVariable)positionObject2;
                        InputVariable cfr_ignored_3 = (InputVariable)positionObject2;
                        leftSide = cifDataProvider.getAddressableForInputVar((InputVariable)inpVar);
                    } else {
                        throw new AssertionError((Object)("Unexpected state variable found: " + String.valueOf(entry.cifObject)));
                    }
                }
                PlcVarExpression rightSide2 = new PlcVarExpression((PlcBasicVariable)ioVar, new PlcVarExpression.PlcProjection[0]);
                stats.add(new PlcAssignmentStatement(leftSide, (PlcExpression)rightSide2));
                continue;
            }
            leftSide = new PlcVarExpression((PlcBasicVariable)ioVar, new PlcVarExpression.PlcProjection[0]);
            PositionObject positionObject = entry.cifObject;
            if (positionObject instanceof DiscVariable) {
                void discVar;
                DiscVariable cfr_ignored_4 = (DiscVariable)positionObject;
                DiscVariable cfr_ignored_5 = (DiscVariable)positionObject;
                rightSide = cifDataProvider.getValueForDiscVar((DiscVariable)discVar);
            } else {
                PositionObject positionObject3 = entry.cifObject;
                if (positionObject3 instanceof InputVariable) {
                    void inpVar;
                    InputVariable cfr_ignored_6 = (InputVariable)positionObject3;
                    InputVariable cfr_ignored_7 = (InputVariable)positionObject3;
                    rightSide = cifDataProvider.getValueForInputVar((InputVariable)inpVar);
                } else {
                    throw new AssertionError((Object)("Unexpected state variable found: " + String.valueOf(entry.cifObject)));
                }
            }
            stats.add(new PlcAssignmentStatement(leftSide, rightSide));
        }
        if (!inputStats.isEmpty()) {
            codeStorage.addInputFuncCode(inputStats);
        }
        if (!outputStats.isEmpty()) {
            codeStorage.addOutputFuncCode(outputStats);
        }
    }
}

