/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Arrays;
import java.util.List;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.PlcInstantiatedFunctionBlockData;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.model.PlcModelUtils;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcFuncBlockInstanceVar;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFunctionBlockDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;

public class PlcCodeStorage {
    private static final int MAX_LOOPS_KILLED = 9999;
    private final PlcTarget target;
    private final PlcFunctionAppls plcFuncAppls;
    private final PlcProject project;
    private final PlcResource resource;
    private final PlcTask task;
    private final PlcPou mainProgram;
    private PlcGlobalVarList globalConstants = null;
    private PlcGlobalVarList globalInputs = null;
    private PlcGlobalVarList globalOutputs = null;
    private PlcGlobalVarList globalTimerVars = null;
    private ExprGenerator exprGenerator = null;
    private PlcBasicVariable isProgressVariable = null;
    private List<PlcStatement> stateInitializationCode = null;
    private List<PlcStatement> updateContVarsRemainingTimeCode = null;
    private List<PlcStatement> eventTransitionsIterationCode = null;
    private Integer maxIter;
    private List<PlcStatement> inputFuncCode = null;
    private List<PlcStatement> outputFuncCode = null;

    public PlcCodeStorage(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.plcFuncAppls = new PlcFunctionAppls(target);
        this.maxIter = settings.maxIter;
        this.project = new PlcProject(settings.projectName);
        PlcConfiguration config = new PlcConfiguration(settings.configurationName);
        this.project.configurations.add(config);
        this.resource = new PlcResource(settings.resourceName);
        config.resources.add(this.resource);
        this.task = new PlcTask(settings.taskName, settings.taskCycleTime, settings.taskPriority);
        this.resource.tasks.add(this.task);
        this.mainProgram = new PlcPou("MAIN", PlcPouType.PROGRAM, null);
        this.project.pous.add(this.mainProgram);
        this.task.pouInstances.add(new PlcPouInstance("MAIN", this.mainProgram));
    }

    public ExprGenerator getExprGenerator() {
        if (this.exprGenerator == null) {
            this.exprGenerator = new ExprGenerator(this.target, this.target.getVarStorage().getCifDataProvider());
        }
        return this.exprGenerator;
    }

    public PlcBasicVariable getIsProgressVariable() {
        if (this.isProgressVariable == null) {
            this.isProgressVariable = this.getExprGenerator().getTempVariable("isProgress", PlcElementaryType.BOOL_TYPE);
        }
        return this.isProgressVariable;
    }

    public void addConstant(PlcBasicVariable plcVar) {
        Assert.check((boolean)this.target.supportsConstants());
        if (this.globalConstants == null) {
            this.globalConstants = new PlcGlobalVarList("CONSTANTS", PlcGlobalVarList.PlcVarListKind.CONSTANTS);
        }
        this.globalConstants.variables.add(plcVar);
    }

    public void addInputVariable(PlcBasicVariable variable) {
        if (this.globalInputs == null) {
            this.globalInputs = new PlcGlobalVarList("INPUTS", PlcGlobalVarList.PlcVarListKind.INPUT_OUTPUT);
        }
        this.globalInputs.variables.add(variable);
    }

    public void addOutputVariable(PlcBasicVariable variable) {
        if (this.globalOutputs == null) {
            this.globalOutputs = new PlcGlobalVarList("OUTPUTS", PlcGlobalVarList.PlcVarListKind.INPUT_OUTPUT);
        }
        this.globalOutputs.variables.add(variable);
    }

    public PlcBasicVariable addStateVariable(String name, PlcType type) {
        return this.addStateVariable(name, type, null, null);
    }

    public PlcBasicVariable addStateVariable(String name, PlcType type, String address, PlcExpression initValue) {
        PlcDataVariable plcVar = new PlcDataVariable(this.target.getStateVariablePrefix(), name, type, address, initValue);
        this.mainProgram.localVars.add(plcVar);
        return plcVar;
    }

    public void addTempVariable(PlcBasicVariable variable) {
        this.mainProgram.tempVars.add(variable);
    }

    public PlcInstantiatedFunctionBlockData addTimerVariable(String varName) {
        if (this.globalTimerVars == null) {
            this.globalTimerVars = new PlcGlobalVarList("TIMERS", PlcGlobalVarList.PlcVarListKind.TIMERS);
        }
        PlcFunctionBlockDescription tonFuncDescr = this.plcFuncAppls.makeTonBlock(varName);
        PlcFuncBlockInstanceVar timerVar = new PlcFuncBlockInstanceVar(varName, tonFuncDescr);
        this.globalTimerVars.variables.add(timerVar);
        return new PlcInstantiatedFunctionBlockData(tonFuncDescr, timerVar);
    }

    public void addTypeDecl(PlcTypeDecl decl) {
        this.project.typeDecls.add(decl);
    }

    public void addStateInitialization(List<PlcStatement> stateInitializationCode) {
        Assert.check((this.stateInitializationCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(stateInitializationCode)) {
            this.stateInitializationCode = stateInitializationCode;
        }
    }

    public void storeUpdateContvarsRemainingTimeCode(List<PlcStatement> updateContVarsRemainingTimeCode) {
        this.updateContVarsRemainingTimeCode = updateContVarsRemainingTimeCode;
    }

    public void addEventTransitions(List<PlcStatement> eventTransitionsIterationCode) {
        Assert.check((this.eventTransitionsIterationCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(eventTransitionsIterationCode)) {
            this.eventTransitionsIterationCode = eventTransitionsIterationCode;
        }
    }

    public void addInputFuncCode(List<PlcStatement> inputFuncCode) {
        Assert.check((this.inputFuncCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(inputFuncCode)) {
            this.inputFuncCode = inputFuncCode;
        }
    }

    public void addOutputFuncCode(List<PlcStatement> outputFuncCode) {
        Assert.check((this.outputFuncCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(outputFuncCode)) {
            this.outputFuncCode = outputFuncCode;
        }
    }

    public void finishPlcProgram() {
        Assert.implies((this.updateContVarsRemainingTimeCode != null ? 1 : 0) != 0, (this.stateInitializationCode != null ? 1 : 0) != 0);
        PlcFunctionAppls funcAppls = new PlcFunctionAppls(this.target);
        ExprGenerator exprGen = this.getExprGenerator();
        ModelTextGenerator textGenerator = this.target.getModelTextGenerator();
        NameGenerator nameGen = this.target.getNameGenerator();
        PlcBasicVariable firstRun = null;
        if (this.stateInitializationCode != null) {
            String name = nameGen.generateGlobalName("firstRun", false);
            firstRun = this.addStateVariable(name, PlcElementaryType.BOOL_TYPE, null, new PlcBoolLiteral(true));
        }
        PlcBasicVariable loopCount = null;
        PlcBasicVariable loopsKilled = null;
        if (this.maxIter != null) {
            String name = nameGen.generateGlobalName("loopsKilled", false);
            loopsKilled = this.addStateVariable(name, PlcElementaryType.INT_TYPE);
            Assert.check((boolean)true);
            PlcElementaryType loopCountType = this.target.getIntegerType();
            loopCount = exprGen.makeLocalVariable("loopCount", loopCountType);
            int bitSize = PlcElementaryType.getSizeOfIntType(loopCountType);
            this.maxIter = switch (bitSize) {
                case 32, 64 -> this.maxIter;
                case 16 -> Math.min(this.maxIter, Short.MAX_VALUE);
                case 8 -> Math.min(this.maxIter, 127);
                default -> throw new AssertionError((Object)("Unexpected loopCount bit-size " + bitSize + " found."));
            };
            this.addTempVariable(loopCount);
        }
        this.addGlobalVariableTable(this.globalConstants);
        this.addGlobalVariableTable(this.globalInputs);
        this.addGlobalVariableTable(this.globalOutputs);
        this.addGlobalVariableTable(this.globalTimerVars);
        CodeBox box = this.mainProgram.body;
        boolean boxNeedsEmptyLine = false;
        int commentLength = 79;
        if (this.inputFuncCode != null) {
            this.generateCommentHeader("Read input from sensors.", '-', commentLength, boxNeedsEmptyLine, box);
            boxNeedsEmptyLine = true;
            textGenerator.toText(this.inputFuncCode, box, this.mainProgram.name, false);
        }
        if (this.stateInitializationCode != null) {
            String headerText = this.updateContVarsRemainingTimeCode == null ? "Initialize state." : "Initialize state or update continuous variables.";
            this.generateCommentHeader(headerText, '-', commentLength, boxNeedsEmptyLine, box);
            boxNeedsEmptyLine = true;
            box.add("IF %s THEN", new Object[]{firstRun.varRefText});
            box.indent();
            box.add("%s := FALSE;", new Object[]{firstRun.varRefText});
            if (loopsKilled != null) {
                box.add("%s := 0;", new Object[]{loopsKilled.varRefText});
            }
            box.add();
            textGenerator.toText(this.stateInitializationCode, box, this.mainProgram.name, false);
            box.dedent();
            if (this.updateContVarsRemainingTimeCode != null) {
                box.add("ELSE");
                box.indent();
                textGenerator.toText(this.updateContVarsRemainingTimeCode, box, this.mainProgram.name, false);
                box.dedent();
            }
            box.add("END_IF;");
        }
        if (this.eventTransitionsIterationCode != null) {
            this.generateCommentHeader("Process all events.", '-', commentLength, boxNeedsEmptyLine, box);
            PlcBasicVariable progressVar = this.getIsProgressVariable();
            box.add("%s := TRUE;", new Object[]{progressVar.varRefText});
            if (loopCount == null) {
                box.add("(* Perform events until none can be done anymore. *)");
                box.add("WHILE %s DO", new Object[]{progressVar.varRefText});
                box.indent();
            } else {
                PlcVarExpression progressCond = new PlcVarExpression(progressVar, new PlcVarExpression.PlcProjection[0]);
                PlcFuncAppl maxIterCond = funcAppls.lessThanFuncAppl(new PlcVarExpression(loopCount, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(this.maxIter));
                PlcFuncAppl whileCond = funcAppls.andFuncAppl(progressCond, maxIterCond);
                box.add("(* Perform events until none can be done anymore. *)");
                box.add("(* Track the number of iterations and abort if there are too many. *)");
                box.add("%s := 0;", new Object[]{loopCount.varRefText});
                box.add("WHILE %s DO", new Object[]{textGenerator.toString(whileCond)});
                box.indent();
                box.add("%s := %s + 1;", new Object[]{loopCount.varRefText, loopCount.varRefText});
            }
            box.add("%s := FALSE;", new Object[]{progressVar.varRefText});
            box.add();
            textGenerator.toText(this.eventTransitionsIterationCode, box, this.mainProgram.name, false);
            box.dedent();
            box.add("END_WHILE;");
            if (loopsKilled != null) {
                PlcFuncAppl reachedMaxLoopCond = funcAppls.greaterEqualFuncAppl(new PlcVarExpression(loopCount, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(this.maxIter));
                PlcFuncAppl incKilled = funcAppls.addFuncAppl(new PlcVarExpression(loopsKilled, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(1));
                PlcFuncAppl limitedIncrementKilled = funcAppls.minFuncAppl(incKilled, new PlcIntLiteral(9999));
                box.add("(* Register the first %d aborted loops. *)", new Object[]{9999});
                box.add("IF %s THEN", new Object[]{textGenerator.toString(reachedMaxLoopCond)});
                box.indent();
                box.add("%s := %s;", new Object[]{loopsKilled.varRefText, textGenerator.toString(limitedIncrementKilled)});
                box.dedent();
                box.add("END_IF;");
            }
        }
        boxNeedsEmptyLine = true;
        if (this.outputFuncCode != null) {
            this.generateCommentHeader("Write output to actuators.", '-', commentLength, boxNeedsEmptyLine, box);
            boxNeedsEmptyLine = true;
            textGenerator.toText(this.outputFuncCode, box, this.mainProgram.name, false);
        }
        exprGen.releaseTempVariable(this.isProgressVariable);
        this.mainProgram.tempVars = exprGen.getCreatedTempVariables();
    }

    private void generateCommentHeader(String text, char dashChar, int length, boolean addEmptyLine, CodeBox box) {
        char[] pre = new char[]{'(', '*', ' ', dashChar, dashChar, dashChar, ' '};
        char[] post = new char[]{dashChar, dashChar, dashChar, ' ', '*', ')'};
        char[] afterText = new char[]{' '};
        int layoutLength = pre.length + afterText.length + post.length;
        length = Math.max(length, layoutLength + text.length());
        char[] line = new char[length];
        Arrays.fill(line, dashChar);
        System.arraycopy(pre, 0, line, 0, pre.length);
        System.arraycopy(text.toCharArray(), 0, line, pre.length, text.length());
        System.arraycopy(afterText, 0, line, pre.length + text.length(), afterText.length);
        System.arraycopy(post, 0, line, line.length - post.length, post.length);
        if (addEmptyLine) {
            box.add();
        }
        box.add(new String(line));
    }

    private void addGlobalVariableTable(PlcGlobalVarList varTable) {
        if (varTable != null) {
            this.resource.globalVarLists.add(varTable);
        }
    }

    public void writeOutput() {
        this.target.writeOutput(this.project);
    }
}

