/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.expressions;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.common.java.Assert;

public class PlcVarExpression
extends PlcExpression {
    public final PlcBasicVariable variable;
    public final List<PlcProjection> projections;

    public PlcVarExpression(PlcBasicVariable variable, PlcProjection ... projections) {
        this(variable, Arrays.asList(projections));
    }

    public PlcVarExpression(PlcBasicVariable variable, List<PlcProjection> projections) {
        this.variable = variable;
        this.projections = Collections.unmodifiableList(projections);
    }

    public static class PlcArrayProjection
    extends PlcProjection {
        public final List<PlcExpression> indexExpressions;

        public PlcArrayProjection(PlcExpression indexExpression) {
            this(List.of(indexExpression));
        }

        public PlcArrayProjection(List<PlcExpression> indexExpressions) {
            Assert.check((!indexExpressions.isEmpty() ? 1 : 0) != 0);
            this.indexExpressions = Collections.unmodifiableList(indexExpressions);
        }
    }

    public static abstract class PlcProjection {
    }

    public static class PlcStructProjection
    extends PlcProjection {
        public final String fieldName;

        public PlcStructProjection(String fieldName) {
            this.fieldName = fieldName;
        }
    }
}

