/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.functions;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.escet.common.java.Assert;

public abstract class PlcBasicFuncDescription {
    public final String prefixFuncName;
    public final PlcParameterDescription[] parameters;
    public final EnumSet<PlcFuncNotation> notations;

    public PlcBasicFuncDescription(String prefixFuncName, PlcParameterDescription[] parameters, EnumSet<PlcFuncNotation> notations) {
        Assert.check((!notations.isEmpty() ? 1 : 0) != 0);
        long numUnique = Arrays.stream(parameters).map(param -> param.name).distinct().count();
        Assert.areEqual((Object)Math.toIntExact(numUnique), (Object)parameters.length);
        this.prefixFuncName = prefixFuncName;
        this.parameters = parameters;
        this.notations = notations;
    }

    public static enum ExprAssociativity {
        LEFT,
        RIGHT,
        NONE,
        ALWAYS;


        boolean needsParentheses(boolean atLeft, boolean atRight) {
            return this == ALWAYS || this == LEFT && !atLeft || this == RIGHT && !atRight;
        }
    }

    public static enum ExprBinding {
        UNARY_EXPR(1, ExprAssociativity.RIGHT),
        POWER_EXPR(2, ExprAssociativity.ALWAYS),
        MUL_EXPR(3, ExprAssociativity.LEFT),
        ADD_EXPR(4, ExprAssociativity.LEFT),
        ORDER_EXPR(5, ExprAssociativity.ALWAYS),
        EQUAL_EXPR(6, ExprAssociativity.ALWAYS),
        CONJUNCT_EXPR(7, ExprAssociativity.LEFT),
        EXCL_DISJUNCT_EXPR(8, ExprAssociativity.LEFT),
        DISJUNCT_EXPR(9, ExprAssociativity.LEFT),
        NO_PRIORITY(Integer.MAX_VALUE, ExprAssociativity.NONE);

        public final int priority;
        public final ExprAssociativity associativity;

        private ExprBinding(int priority, ExprAssociativity associativity) {
            this.priority = priority;
            this.associativity = associativity;
        }

        public boolean needsParentheses(ExprBinding parentBinding, boolean atLeft, boolean atRight) {
            if (parentBinding.priority != this.priority) {
                return parentBinding.priority < this.priority;
            }
            return parentBinding.associativity.needsParentheses(atLeft, atRight);
        }

        public boolean needsParentheses(ExprBinding parentBinding) {
            return this.needsParentheses(parentBinding, false, false);
        }
    }

    public static enum PlcFuncNotation {
        INFIX,
        INFORMAL,
        FORMAL;

        public static final EnumSet<PlcFuncNotation> UNSUPPORTED;
        public static final EnumSet<PlcFuncNotation> INFIX_ONLY;
        public static final EnumSet<PlcFuncNotation> INFORMAL_ONLY;
        public static final EnumSet<PlcFuncNotation> FORMAL_ONLY;
        public static final EnumSet<PlcFuncNotation> NOT_INFIX;
        public static final EnumSet<PlcFuncNotation> NOT_INFORMAL;
        public static final EnumSet<PlcFuncNotation> NOT_FORMAL;
        public static final EnumSet<PlcFuncNotation> ALL;

        static {
            UNSUPPORTED = EnumSet.noneOf(PlcFuncNotation.class);
            INFIX_ONLY = EnumSet.of(INFIX);
            INFORMAL_ONLY = EnumSet.of(INFORMAL);
            FORMAL_ONLY = EnumSet.of(FORMAL);
            NOT_INFIX = EnumSet.of(INFORMAL, FORMAL);
            NOT_INFORMAL = EnumSet.of(INFIX, FORMAL);
            NOT_FORMAL = EnumSet.of(INFIX, INFORMAL);
            ALL = EnumSet.allOf(PlcFuncNotation.class);
        }
    }

    public static enum PlcParamDirection {
        OUTPUT_ONLY,
        INPUT_OUTPUT,
        INPUT_ONLY;

    }

    public static class PlcParameterDescription {
        public final String name;
        public final PlcParamDirection direction;

        public PlcParameterDescription(String name, PlcParamDirection direction) {
            this.name = name;
            this.direction = direction;
        }
    }
}

