/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.statements;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.common.java.Lists;

public class PlcSelectionStatement
extends PlcStatement {
    public List<PlcSelectChoice> condChoices;
    public List<PlcStatement> elseStats;

    public PlcSelectionStatement() {
        this(Lists.list(), Lists.list());
    }

    public PlcSelectionStatement(PlcSelectChoice condChoice) {
        this(Lists.list((Object)condChoice));
    }

    public PlcSelectionStatement(List<PlcSelectChoice> condChoices) {
        this(condChoices, Lists.list());
    }

    public PlcSelectionStatement(List<PlcSelectChoice> condChoices, List<PlcStatement> elseStats) {
        this.condChoices = condChoices;
        this.elseStats = elseStats;
    }

    @Override
    public PlcStatement copy() {
        List choices = Lists.listc((int)this.condChoices.size());
        this.condChoices.stream().map(PlcSelectChoice::copy).collect(Collectors.toCollection(() -> choices));
        return new PlcSelectionStatement(choices, PlcStatement.copy(this.elseStats));
    }

    @Override
    public boolean isProperPlcStatement() {
        return true;
    }

    public static class PlcSelectChoice {
        public PlcExpression guard;
        public List<PlcStatement> thenStats;

        public PlcSelectChoice(PlcExpression guard, PlcStatement thenStat) {
            this(guard, Lists.list((Object)thenStat));
        }

        public PlcSelectChoice(PlcExpression guard, List<PlcStatement> thenStats) {
            this.guard = guard;
            this.thenStats = thenStats;
        }

        public PlcSelectChoice copy() {
            return new PlcSelectChoice(this.guard, PlcStatement.copy(this.thenStats));
        }
    }
}

