/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.EnumSet;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.generators.CifProcessor;
import org.eclipse.escet.cif.plcgen.generators.ContinuousVariablesGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultContinuousVariablesGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultNameGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultVariableStorage;
import org.eclipse.escet.cif.plcgen.generators.InputOutputGenerator;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.TransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.generators.io.IoAddress;
import org.eclipse.escet.cif.plcgen.generators.io.IoDirection;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.output.WarnOutput;

public abstract class PlcBaseTarget
extends PlcTarget {
    public static final int CIF_INTEGER_SIZE = 32;
    public static final int CIF_REAL_SIZE = 64;
    public final PlcTargetType targetType;
    protected final String stateVariablePrefix;
    protected final String tonFuncBlockCallSuffix;
    private PlcNumberBits intTypeSize;
    private PlcNumberBits realTypeSize;
    private final ConvertEnums autoEnumConversion;
    private ConvertEnums selectedEnumConversion;
    private String absOutputPath;
    private WarnOutput warnOutput;
    private final ModelTextGenerator modelTextGenerator = new ModelTextGenerator();
    protected CifProcessor cifProcessor;
    protected TransitionGenerator transitionGenerator;
    private ContinuousVariablesGenerator continuousVariablesGenerator;
    protected InputOutputGenerator ioGenerator;
    protected VariableStorage varStorage;
    protected TypeGenerator typeGenerator;
    protected PlcCodeStorage codeStorage;
    protected NameGenerator nameGenerator;

    public PlcBaseTarget(PlcTargetType targetType, ConvertEnums autoEnumConversion) {
        this(targetType, autoEnumConversion, "", "");
    }

    public PlcBaseTarget(PlcTargetType targetType, ConvertEnums autoEnumConversion, String stateVariablePrefix, String tonFuncBlockCallSuffix) {
        this.targetType = targetType;
        this.autoEnumConversion = autoEnumConversion;
        this.stateVariablePrefix = stateVariablePrefix;
        this.tonFuncBlockCallSuffix = tonFuncBlockCallSuffix;
        Assert.check((autoEnumConversion != ConvertEnums.AUTO ? 1 : 0) != 0);
    }

    public void setup(PlcGenSettings settings) {
        this.intTypeSize = settings.intTypeSize;
        this.realTypeSize = settings.realTypeSize;
        this.absOutputPath = settings.absOutputPath;
        this.warnOutput = settings.warnOutput;
        ConvertEnums convertEnums = this.selectedEnumConversion = settings.enumConversion == ConvertEnums.AUTO ? this.autoEnumConversion : settings.enumConversion;
        if (settings.intTypeSize.getTypeSize(32) < 32) {
            this.warnOutput.line("Configured integer type size is less than the CIF integer type size. Some values in the program may be truncated.");
        } else if (this.getMaxIntegerTypeSize() < 32) {
            this.warnOutput.line("Maximum integer type size supported by the PLC is less than the CIF integer type size. Some values in the program may be truncated.");
        }
        if (settings.realTypeSize.getTypeSize(64) < 64) {
            this.warnOutput.line("Configured real type size is less than the CIF real type size. Some values in the program may be truncated.");
        } else if (this.getMaxRealTypeSize() < 64) {
            this.warnOutput.line("Maximum real type size supported by the PLC is less than the CIF real type size. Some values in the program may be truncated.");
        }
    }

    public void generate(PlcGenSettings settings) {
        this.setup(settings);
        this.nameGenerator = new DefaultNameGenerator(settings);
        this.codeStorage = new PlcCodeStorage(this, settings);
        this.typeGenerator = new DefaultTypeGenerator(this, settings);
        this.varStorage = new DefaultVariableStorage(this);
        this.cifProcessor = new CifProcessor(this, settings);
        this.transitionGenerator = new DefaultTransitionGenerator(this);
        this.ioGenerator = new InputOutputGenerator(this, settings);
        this.continuousVariablesGenerator = new DefaultContinuousVariablesGenerator(this);
        this.cifProcessor.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.continuousVariablesGenerator.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.ioGenerator.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.varStorage.process();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.transitionGenerator.generate();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.codeStorage.finishPlcProgram();
        if (settings.shouldTerminate.get().booleanValue()) {
            return;
        }
        this.codeStorage.writeOutput();
    }

    protected abstract Writer getPlcCodeWriter();

    @Override
    public PlcTargetType getTargetType() {
        return this.targetType;
    }

    @Override
    public ModelTextGenerator getModelTextGenerator() {
        return this.modelTextGenerator;
    }

    @Override
    public CifProcessor getCifProcessor() {
        return this.cifProcessor;
    }

    @Override
    public TransitionGenerator getTransitionGenerator() {
        return this.transitionGenerator;
    }

    @Override
    public ContinuousVariablesGenerator getContinuousVariablesGenerator() {
        return this.continuousVariablesGenerator;
    }

    @Override
    public VariableStorage getVarStorage() {
        return this.varStorage;
    }

    @Override
    public TypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    @Override
    public PlcCodeStorage getCodeStorage() {
        return this.codeStorage;
    }

    @Override
    public NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    @Override
    public ConvertEnums getActualEnumerationsConversion() {
        return this.selectedEnumConversion;
    }

    @Override
    public String getStateVariablePrefix() {
        return this.stateVariablePrefix;
    }

    @Override
    public String getTonFuncBlockCallSuffix() {
        return this.tonFuncBlockCallSuffix;
    }

    @Override
    public EnumSet<PlcBasicFuncDescription.PlcFuncNotation> getSupportedFuncNotations(PlcFuncOperation funcOper, int numArgs) {
        return PlcBasicFuncDescription.PlcFuncNotation.ALL;
    }

    @Override
    public boolean supportsPower(boolean baseIsInt, boolean exponentIsInt) {
        return !baseIsInt;
    }

    protected abstract int getMaxIntegerTypeSize();

    @Override
    public PlcElementaryType getIntegerType() {
        int generatorBestIntSize = Math.min(32, this.getMaxIntegerTypeSize());
        int userSpecifiedIntSize = this.intTypeSize.getTypeSize(generatorBestIntSize);
        return PlcElementaryType.getIntTypeBySize(userSpecifiedIntSize);
    }

    protected abstract int getMaxRealTypeSize();

    @Override
    public PlcElementaryType getRealType() {
        int generatorBestRealSize = Math.min(64, this.getMaxRealTypeSize());
        int userSpecifiedRealSize = this.realTypeSize.getTypeSize(generatorBestRealSize);
        return PlcElementaryType.getRealTypeBySize(userSpecifiedRealSize);
    }

    @Override
    public void verifyIoTableEntry(IoAddress parsedAddress, PlcType plcTableType, IoDirection directionFromCif, String tableLinePositionText) {
        if (parsedAddress.size() > this.getMaxIntegerTypeSize()) {
            this.warnOutput.line("Size of I/O address \"%s\" (of %d bits) exceeds the size of the largest supported integer type (of %d bits).", new Object[]{parsedAddress.getAddress(), parsedAddress.size(), this.getMaxIntegerTypeSize()});
        }
    }

    @Override
    public void writeOutput(PlcProject project) {
        Writer writer = this.getPlcCodeWriter();
        writer.write(project, this.absOutputPath);
    }
}

