/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.S7Writer;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.java.Assert;

public class SiemensS7Target
extends PlcBaseTarget {
    private static final EnumSet<PlcTargetType> S7_300_400 = EnumSet.of(PlcTargetType.S7_300, PlcTargetType.S7_400);
    private static final Map<PlcTargetType, String> OUT_SUFFIX_REPLACEMENTS = Map.of(PlcTargetType.S7_300, "_s7_300", PlcTargetType.S7_400, "_s7_400", PlcTargetType.S7_1200, "_s7_1200", PlcTargetType.S7_1500, "_s7_1500");
    private static final Map<PlcTargetType, Integer> MAX_INTEGER_SIZES = Map.of(PlcTargetType.S7_300, 32, PlcTargetType.S7_400, 32, PlcTargetType.S7_1200, 32, PlcTargetType.S7_1500, 64);
    private static final Map<PlcTargetType, Integer> MAX_REAL_SIZES = Map.of(PlcTargetType.S7_300, 32, PlcTargetType.S7_400, 32, PlcTargetType.S7_1200, 64, PlcTargetType.S7_1500, 64);

    public SiemensS7Target(PlcTargetType targetType) {
        super(targetType, ConvertEnums.CONSTS, "\"DB\".", ".TON");
        Assert.check((boolean)OUT_SUFFIX_REPLACEMENTS.containsKey((Object)targetType));
    }

    @Override
    public Writer getPlcCodeWriter() {
        return new S7Writer(this);
    }

    @Override
    public boolean supportsArrays() {
        return false;
    }

    @Override
    public boolean supportsConstants() {
        return true;
    }

    @Override
    public boolean supportsPower(boolean baseIsInt, boolean exponentIsInt) {
        if (S7_300_400.contains((Object)this.targetType)) {
            return !baseIsInt && !exponentIsInt;
        }
        return super.supportsPower(baseIsInt, exponentIsInt);
    }

    @Override
    public EnumSet<PlcBasicFuncDescription.PlcFuncNotation> getSupportedFuncNotations(PlcFuncOperation funcOper, int numArgs) {
        if (funcOper == PlcFuncOperation.STDLIB_LOG) {
            return PlcBasicFuncDescription.PlcFuncNotation.UNSUPPORTED;
        }
        EnumSet<PlcBasicFuncDescription.PlcFuncNotation> funcSupport = super.getSupportedFuncNotations(funcOper, numArgs);
        if (S7_300_400.contains((Object)this.targetType) && funcOper == PlcFuncOperation.POWER_OP) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.remove((Object)PlcBasicFuncDescription.PlcFuncNotation.INFIX);
            return funcSupport;
        }
        EnumSet<PlcFuncOperation[]> notFormalFuncs = EnumSet.of(PlcFuncOperation.COMPLEMENT_OP, new PlcFuncOperation[]{PlcFuncOperation.STDLIB_ABS, PlcFuncOperation.STDLIB_EXP, PlcFuncOperation.STDLIB_SQRT, PlcFuncOperation.STDLIB_LN, PlcFuncOperation.STDLIB_LOG, PlcFuncOperation.STDLIB_ACOS, PlcFuncOperation.STDLIB_ASIN, PlcFuncOperation.STDLIB_ATAN, PlcFuncOperation.STDLIB_COS, PlcFuncOperation.STDLIB_SIN, PlcFuncOperation.STDLIB_TAN});
        if (notFormalFuncs.contains((Object)funcOper) || numArgs >= 2) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.remove((Object)PlcBasicFuncDescription.PlcFuncNotation.FORMAL);
            return funcSupport;
        }
        EnumSet<PlcFuncOperation> formalFuncs = EnumSet.of(PlcFuncOperation.STDLIB_MIN, PlcFuncOperation.STDLIB_MAX);
        if (formalFuncs.contains((Object)funcOper)) {
            funcSupport = EnumSet.copyOf(funcSupport);
            funcSupport.retainAll(PlcBasicFuncDescription.PlcFuncNotation.FORMAL_ONLY);
            return funcSupport;
        }
        return funcSupport;
    }

    @Override
    public int getMaxIntegerTypeSize() {
        return MAX_INTEGER_SIZES.get((Object)this.targetType);
    }

    @Override
    public int getMaxRealTypeSize() {
        return MAX_REAL_SIZES.get((Object)this.targetType);
    }

    @Override
    public String getPathSuffixReplacement() {
        return OUT_SUFFIX_REPLACEMENTS.get((Object)this.targetType);
    }
}

