/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.model.types.PlcDerivedType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class S7Writer
extends Writer {
    public S7Writer(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String outPath) {
        this.ensureDirectory(outPath);
        Assert.areEqual((Object)project.configurations.size(), (Object)1);
        PlcConfiguration config = project.configurations.get(0);
        Assert.areEqual((Object)config.resources.size(), (Object)1);
        PlcResource resource = config.resources.get(0);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            if (globalVarList.listKind == PlcGlobalVarList.PlcVarListKind.TIMERS) {
                this.writeTimers(globalVarList.variables, outPath);
                continue;
            }
            this.writeGlobalVarList(globalVarList, outPath);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outPath);
        }
        int programCount = 0;
        for (PlcPou pou : project.pous) {
            if (pou.pouType != PlcPouType.PROGRAM) continue;
            ++programCount;
            if (pou.localVars.isEmpty()) continue;
            this.writeDatabase(pou.localVars, outPath);
        }
        Assert.areEqual((Object)programCount, (Object)1);
        for (PlcTypeDecl typeDecl : project.typeDecls) {
            this.write(typeDecl, outPath);
        }
    }

    private void write(PlcPou pou, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, pou.name + ".scl"});
        Box code = this.toBox(pou);
        code.writeToFile(path);
    }

    /*
     * Unable to fully structure code
     */
    private void writeTimers(List<PlcBasicVariable> timerVariables, String outPath) {
        c = new MemoryCodeBox(4);
        hasIecTimers = this.hasIecTimers();
        for (PlcBasicVariable timerVar : timerVariables) {
            var8_8 = timerVar.type;
            if (!(var8_8 instanceof PlcDerivedType)) ** GOTO lbl-1000
            (PlcDerivedType)var8_8;
            (PlcDerivedType)var8_8;
            if (der.name.equals("TON")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            Assert.check((boolean)v0);
            c.add("DATA_BLOCK \"%s\"", new Object[]{timerVar.varName});
            c.add("{InstructionName := '%s';", new Object[]{hasIecTimers != false ? "IEC_TIMER" : "TON"});
            c.add("LibVersion := '1.0';");
            c.add("S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
            c.add("AUTHOR : Simatic");
            c.add("FAMILY : %s", new Object[]{hasIecTimers != false ? "IEC" : "IEC_TC"});
            c.add("NAME : %s", new Object[]{hasIecTimers != false ? "IEC_TMR" : "TON"});
            c.add("VERSION : 1.0");
            c.add("NON_RETAIN");
            c.add("%s", new Object[]{hasIecTimers != false ? "IEC_TIMER" : "TON"});
            c.add();
            c.add("BEGIN");
            c.add();
            c.add("END_DATA_BLOCK");
            c.add();
        }
        path = Paths.join((String[])new String[]{outPath, "timers.db"});
        c.writeToFile(path);
    }

    private boolean hasIecTimers() {
        return EnumSet.of(PlcTargetType.S7_1200, PlcTargetType.S7_1500).contains((Object)this.target.getTargetType());
    }

    private void write(PlcTypeDecl typeDecl, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, typeDecl.name + ".udt"});
        Box code = this.toBox(typeDecl);
        code.writeToFile(path);
    }

    private void writeGlobalVarList(PlcGlobalVarList gvl, String outPath) {
        String path = Paths.join((String[])new String[]{outPath, gvl.name + ".xml"});
        Box code = this.makeTagTable(gvl);
        code.writeToFile(path);
    }

    /*
     * WARNING - void declaration
     */
    private void writeDatabase(List<PlcBasicVariable> variables, String outPath) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("DATA_BLOCK \"DB\"");
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
        c.indent();
        c.add("VAR");
        c.indent();
        for (PlcBasicVariable var : variables) {
            c.add("%s: %s;", new Object[]{var.varName, this.toBox(var.type)});
        }
        c.dedent();
        c.add("END_VAR");
        c.dedent();
        c.add("BEGIN");
        c.indent();
        ModelTextGenerator modelTextGenerator = this.target.getModelTextGenerator();
        for (PlcBasicVariable var : variables) {
            void dataVar;
            PlcBasicVariable plcBasicVariable = var;
            if (!(plcBasicVariable instanceof PlcDataVariable)) continue;
            PlcDataVariable cfr_ignored_0 = (PlcDataVariable)plcBasicVariable;
            PlcDataVariable cfr_ignored_1 = (PlcDataVariable)plcBasicVariable;
            if (dataVar.value == null) continue;
            c.add("%s := %s;", new Object[]{var.varName, modelTextGenerator.toString(dataVar.value)});
        }
        c.dedent();
        c.add("END_DATA_BLOCK");
        String path = Paths.join((String[])new String[]{outPath, "DB.db"});
        c.writeToFile(path);
    }

    private boolean hasOptimizedBlockAccess() {
        return EnumSet.of(PlcTargetType.S7_1200, PlcTargetType.S7_1500).contains((Object)this.target.getTargetType());
    }

    @Override
    protected Box toBox(PlcGlobalVarList globVarList) {
        throw new UnsupportedOperationException("Should not be used.");
    }

    private Box makeTagTable(PlcGlobalVarList globVarList) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("<?xml version='1.0' encoding='utf-8'?>");
        c.add("<Tagtable name='%s'>", new Object[]{globVarList.name});
        c.indent();
        if (globVarList.listKind == PlcGlobalVarList.PlcVarListKind.CONSTANTS) {
            ModelTextGenerator modelTextGenerator = this.target.getModelTextGenerator();
            for (PlcBasicVariable constant : globVarList.variables) {
                PlcDataVariable dataConstant = (PlcDataVariable)constant;
                c.add("<Constant type='%s' remark='' value='%s'>%s</Constant>", new Object[]{this.toBox(dataConstant.type), modelTextGenerator.toString(dataConstant.value), dataConstant.varName});
            }
        } else {
            for (PlcBasicVariable var : globVarList.variables) {
                PlcDataVariable dataVar = (PlcDataVariable)var;
                c.add("<Tag type='%s' hmiVisible='True' hmiWriteable='False' hmiAccessible='True' retain='False' remark='' addr='%s'>%s</Tag>", new Object[]{this.toBox(dataVar.type), dataVar.address, dataVar.varName});
            }
        }
        c.dedent();
        c.add("</Tagtable>");
        return c;
    }

    @Override
    protected Box toBox(PlcPou pou) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String pouTypeText = switch (pou.pouType) {
            case PlcPouType.FUNCTION -> "FUNCTION";
            case PlcPouType.PROGRAM -> "ORGANIZATION_BLOCK";
            default -> throw new RuntimeException("Unknown pou type: " + String.valueOf((Object)pou.pouType));
        };
        String retTypeTxt = pou.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.toBox(pou.retType)});
        c.add("%s %s%s", new Object[]{pouTypeText, pou.name, retTypeTxt});
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
        c.indent();
        if (!pou.inputVars.isEmpty()) {
            c.add("VAR_INPUT");
            c.indent();
            for (PlcBasicVariable var : pou.inputVars) {
                c.add("%s: %s;", new Object[]{var.varName, this.toBox(var.type)});
            }
            c.dedent();
            c.add("END_VAR");
        }
        if (!pou.outputVars.isEmpty()) {
            Assert.areEqual((Object)((Object)pou.pouType), (Object)((Object)PlcPouType.FUNCTION));
            c.add("VAR_OUTPUT");
            c.indent();
            for (PlcBasicVariable var : pou.outputVars) {
                c.add("%s: %s;", new Object[]{var.varName, this.toBox(var.type)});
            }
            c.dedent();
            c.add("END_VAR");
        }
        Assert.check((pou.pouType != PlcPouType.FUNCTION || pou.localVars.isEmpty() ? 1 : 0) != 0);
        if (!pou.tempVars.isEmpty()) {
            c.add("VAR_TEMP");
            c.indent();
            for (PlcBasicVariable var : pou.tempVars) {
                c.add("%s: %s;", new Object[]{var.varName, this.toBox(var.type)});
            }
            c.dedent();
            c.add("END_VAR");
        }
        c.dedent();
        c.add();
        c.add("BEGIN");
        c.indent();
        if (!pou.body.isEmpty()) {
            c.add((Box)pou.body);
        }
        c.dedent();
        c.add("END_%s", new Object[]{pouTypeText});
        return c;
    }

    @Override
    protected Box toBox(PlcTypeDecl typeDecl) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{typeDecl.name});
        c.indent();
        c.add((Box)new HBox(new Object[]{this.toBox(typeDecl.type), ";"}));
        c.dedent();
        c.add("END_TYPE");
        return c;
    }

    @Override
    protected Box toBox(PlcStructType structType) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("STRUCT");
        c.indent();
        for (PlcStructField field : structType.fields) {
            c.add("%s: %s;", new Object[]{field.fieldName, this.toBox(field.type)});
        }
        c.dedent();
        c.add("END_STRUCT");
        return c;
    }
}

