/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTypeDecl;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.HBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TwinCatWriter
extends Writer {
    private PlcProject project;
    private PlcConfiguration configuration;
    private PlcResource resource;
    private PlcTask task;
    private File xaeProjFile;
    private File plcProjFile;
    private File plcProjDirFile;
    private Map<String, Document> files = Maps.map();
    private List<File> oldCodeFiles = Lists.list();

    public TwinCatWriter(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, String slnDirPath) {
        slnDirPath = Paths.resolve((String)slnDirPath);
        this.project = project;
        Assert.check((project.configurations.size() == 1 ? 1 : 0) != 0);
        this.configuration = (PlcConfiguration)Lists.first(project.configurations);
        Assert.check((this.configuration.resources.size() == 1 ? 1 : 0) != 0);
        this.resource = (PlcResource)Lists.first(this.configuration.resources);
        Assert.check((this.resource.tasks.size() == 1 ? 1 : 0) != 0);
        this.task = (PlcTask)Lists.first(this.resource.tasks);
        if (this.task.cycleTime == 0) {
            String msg = "TwinCAT output with periodic task scheduling disabled, is currently not supported.";
            throw new InvalidOptionException(msg);
        }
        this.findTwinCatProjects(slnDirPath);
        Assert.check((boolean)this.resource.pouInstances.isEmpty());
        this.updateXaeProj();
        this.genCodeFiles();
        this.updatePlcProj();
        this.updateTask();
        this.updateCodeFiles();
    }

    private void findTwinCatProjects(String slnDirPath) {
        File slnDirFile = new File(slnDirPath);
        if (!slnDirFile.isDirectory()) {
            String msg = Strings.fmt((String)"TwinCAT solution directory \"%s\" does not exist, or is not a directory.", (Object[])new Object[]{slnDirFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        String slnDirName = slnDirFile.getName();
        File slnFile = new File(slnDirFile, slnDirName + ".sln");
        if (!slnFile.isFile()) {
            String msg = Strings.fmt((String)"TwinCAT solution file \"%s\" does not exist, or is not a file.", (Object[])new Object[]{slnFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        File xaeDirFile = new File(slnDirFile, slnDirName);
        if (!xaeDirFile.isDirectory()) {
            String msg = Strings.fmt((String)"TwinCAT XAE project directory \"%s\" does not exist, or is not a directory.", (Object[])new Object[]{xaeDirFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        this.xaeProjFile = new File(xaeDirFile, slnDirName + ".tsproj");
        if (!this.xaeProjFile.isFile()) {
            String msg = Strings.fmt((String)"TwinCAT XAE project file \"%s\" does not exist, or is not a file.", (Object[])new Object[]{this.xaeProjFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        this.plcProjDirFile = new File(xaeDirFile, this.project.name);
        if (!this.plcProjDirFile.isDirectory()) {
            String msg = Strings.fmt((String)"TwinCAT PLC project directory \"%s\" does not exist, or is not a directory.", (Object[])new Object[]{this.plcProjDirFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        this.plcProjFile = new File(this.plcProjDirFile, this.project.name + ".plcproj");
        if (!this.plcProjFile.isFile()) {
            String msg = Strings.fmt((String)"TwinCAT PLC project file \"%s\" does not exist, or is not a file.", (Object[])new Object[]{this.plcProjFile.getPath()});
            throw new InvalidOptionException(msg);
        }
    }

    private void updateXaeProj() {
        Document doc = this.readXmlFile(this.xaeProjFile);
        String query = Strings.fmt((String)"//Task/Name[text()='%s']/..", (Object[])new Object[]{this.task.name});
        List<Node> tasks = this.execXPath(doc, query);
        if (tasks.size() != 1) {
            String msg = Strings.fmt((String)"Found %d tasks with name \"%s\" in \"%s\".", (Object[])new Object[]{tasks.size(), this.task.name, this.xaeProjFile.getPath()});
            throw new InvalidOptionException(msg);
        }
        Element taskElem = (Element)Lists.first(tasks);
        taskElem.setAttribute("Priority", Strings.str((Object)this.task.priority));
        taskElem.setAttribute("CycleTime", Strings.str((Object)(this.task.cycleTime * 10000)));
        this.writeXmlFile(doc, this.xaeProjFile);
    }

    private void updatePlcProj() {
        Element compileGroup;
        Document doc = this.readXmlFile(this.plcProjFile);
        List<Node> compileGroups = this.execXPath(doc, "//ItemGroup/Compile/..");
        if (compileGroups.isEmpty()) {
            compileGroup = doc.createElement("ItemGroup");
            doc.getDocumentElement().appendChild(compileGroup);
        } else {
            compileGroup = (Element)Lists.first(compileGroups);
        }
        String query = "//ItemGroup/Compile/@Include/..";
        List<Node> compileNodes = this.execXPath(doc, query);
        for (Node compileNode : compileNodes) {
            Element compileElem = (Element)compileNode;
            String path = compileElem.getAttribute("Include");
            if (!path.endsWith("TcPOU") && !path.endsWith("TcGVL") && !path.endsWith("TcDUT")) continue;
            compileNode.getParentNode().removeChild(compileNode);
            boolean remove = !this.files.containsKey(path);
            path = Paths.join((String[])new String[]{this.plcProjDirFile.getPath(), path});
            File codeFile = new File(path);
            if (!remove || !codeFile.exists()) continue;
            this.oldCodeFiles.add(codeFile);
        }
        for (String path : this.files.keySet()) {
            query = Strings.fmt((String)"//ItemGroup/Compile[@Include='%s']", (Object[])new Object[]{path});
            List<Node> compiles = this.execXPath(doc, query);
            if (!compiles.isEmpty()) continue;
            Element compileElem = doc.createElement("Compile");
            compileGroup.appendChild(compileElem);
            compileElem.setAttribute("Include", path);
            Element subTypeElem = doc.createElement("SubType");
            compileElem.appendChild(subTypeElem);
            subTypeElem.setTextContent("Code");
        }
        for (String folder : Lists.list((Object[])new String[]{"DUTs", "GVLs", "POUs"})) {
            query = Strings.fmt((String)"//ItemGroup/Folder[@Include='%s']", (Object[])new Object[]{folder});
            List<Node> tasks = this.execXPath(doc, query);
            if (!tasks.isEmpty()) continue;
            Element folderElem = doc.createElement("Folder");
            compileGroup.appendChild(folderElem);
            folderElem.setAttribute("Include", folder);
        }
        this.writeXmlFile(doc, this.plcProjFile);
    }

    private void updateTask() {
        File taskFile = new File(this.plcProjDirFile, Strings.fmt((String)"%s.TcTTO", (Object[])new Object[]{this.task.name}));
        Document doc = this.readXmlFile(taskFile);
        List<Node> cycleNodes = this.execXPath(doc, "//Task/CycleTime");
        for (Node cycleNode : cycleNodes) {
            cycleNode.setTextContent(Strings.str((Object)(this.task.cycleTime * 1000)));
        }
        List<Node> prioNodes = this.execXPath(doc, "//Task/Priority");
        for (Node prioNode : prioNodes) {
            prioNode.setTextContent(Strings.str((Object)this.task.priority));
        }
        Node taskElem = null;
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("Task")) {
                taskElem = (Element)node;
                break;
            }
            ++i;
        }
        if (taskElem == null) {
            throw new RuntimeException("Task not found.");
        }
        Element callElem = null;
        nodes = taskElem.getChildNodes();
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Node node = nodes.item(i2);
            if (node.getNodeName().equals("PouCall")) {
                callElem = (Element)node;
                break;
            }
            ++i2;
        }
        for (PlcPouInstance pouInst : this.task.pouInstances) {
            Assert.check((boolean)pouInst.name.equals(pouInst.pou.name));
            String query = Strings.fmt((String)"//Task/PouCall/Name[text()='%s']", (Object[])new Object[]{pouInst.name});
            List<Node> callNodes = this.execXPath(doc, query);
            if (!callNodes.isEmpty()) continue;
            if (callElem == null) {
                callElem = doc.createElement("PouCall");
                taskElem.appendChild(callElem);
            }
            Element nameElem = doc.createElement("Name");
            callElem.appendChild(nameElem);
            nameElem.setTextContent(pouInst.name);
        }
        this.writeXmlFile(doc, taskFile);
    }

    private Document readXmlFile(File file) {
        DocumentBuilder builder;
        Assert.check((boolean)file.isAbsolute());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            return builder.parse(file);
        }
        catch (SAXException e) {
            String msg = Strings.fmt((String)"TwinCAT file \"%s\" could not be read.", (Object[])new Object[]{file.getPath()});
            throw new InvalidOptionException(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"TwinCAT file \"%s\" could not be read.", (Object[])new Object[]{file.getPath()});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    private void writeXmlFile(Document doc, File file) {
        Transformer transformer;
        Assert.check((boolean)file.isAbsolute());
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("indent", "yes");
        String indentAmountKey = "{http://xml.apache.org/xslt}indent-amount";
        transformer.setOutputProperty(indentAmountKey, "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(file);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            String msg = Strings.fmt((String)"Failed to write TwinCAT file \"%s\".", (Object[])new Object[]{file.getPath()});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }

    private List<Node> execXPath(Node node, String query) {
        NodeList nodes;
        XPathExpression expr;
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        try {
            expr = xpath.compile(query);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        try {
            nodes = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        List rslt = Lists.listc((int)nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            rslt.add(nodes.item(i));
            ++i;
        }
        return rslt;
    }

    private void genCodeFiles() {
        for (PlcPou pou : this.project.pous) {
            this.genCodeFile(pou);
        }
        for (PlcTypeDecl tdecl : this.project.typeDecls) {
            this.genCodeFile(tdecl);
        }
        for (PlcGlobalVarList varList : this.configuration.globalVarLists) {
            this.genCodeFile(varList);
        }
        for (PlcGlobalVarList varList : this.resource.globalVarLists) {
            this.genCodeFile(varList);
        }
    }

    private void genCodeFile(PlcPou pou) {
        Document doc = this.createXmlDoc();
        Element rootElem = doc.createElement("TcPlcObject");
        doc.appendChild(rootElem);
        rootElem.setAttribute("Version", "1.1.0.1");
        rootElem.setAttribute("ProductVersion", "3.1.0.18");
        Element pouElem = doc.createElement("POU");
        rootElem.appendChild(pouElem);
        pouElem.setAttribute("Name", pou.name);
        Element declElem = doc.createElement("Declaration");
        pouElem.appendChild(declElem);
        String headerTxt = this.headerToBox(pou).toString();
        declElem.appendChild(doc.createCDATASection(headerTxt));
        Element implElem = doc.createElement("Implementation");
        pouElem.appendChild(implElem);
        Element stElem = doc.createElement("ST");
        implElem.appendChild(stElem);
        stElem.appendChild(doc.createCDATASection(pou.body.toString()));
        Element opElem = doc.createElement("ObjectProperties");
        pouElem.appendChild(opElem);
        String fileName = Strings.fmt((String)"POUs\\%s.TcPOU", (Object[])new Object[]{pou.name});
        Document prevDoc = this.files.put(fileName, doc);
        Assert.check((prevDoc == null ? 1 : 0) != 0);
    }

    private void genCodeFile(PlcTypeDecl typeDecl) {
        Document doc = this.createXmlDoc();
        Element rootElem = doc.createElement("TcPlcObject");
        doc.appendChild(rootElem);
        rootElem.setAttribute("Version", "1.1.0.1");
        rootElem.setAttribute("ProductVersion", "3.1.0.18");
        Element pouElem = doc.createElement("DUT");
        rootElem.appendChild(pouElem);
        pouElem.setAttribute("Name", typeDecl.name);
        Element declElem = doc.createElement("Declaration");
        pouElem.appendChild(declElem);
        String txt = this.toBox(typeDecl).toString();
        declElem.appendChild(doc.createCDATASection(txt));
        Element opElem = doc.createElement("ObjectProperties");
        pouElem.appendChild(opElem);
        String fileName = Strings.fmt((String)"DUTs\\%s.TcDUT", (Object[])new Object[]{typeDecl.name});
        Document prevDoc = this.files.put(fileName, doc);
        Assert.check((prevDoc == null ? 1 : 0) != 0);
    }

    private void genCodeFile(PlcGlobalVarList varList) {
        if (varList.variables.isEmpty()) {
            return;
        }
        Document doc = this.createXmlDoc();
        Element rootElem = doc.createElement("TcPlcObject");
        doc.appendChild(rootElem);
        rootElem.setAttribute("Version", "1.1.0.1");
        rootElem.setAttribute("ProductVersion", "3.1.0.18");
        Element pouElem = doc.createElement("GVL");
        rootElem.appendChild(pouElem);
        pouElem.setAttribute("Name", varList.name);
        Element declElem = doc.createElement("Declaration");
        pouElem.appendChild(declElem);
        declElem.appendChild(doc.createCDATASection(this.toBox(varList).toString()));
        Element opElem = doc.createElement("ObjectProperties");
        pouElem.appendChild(opElem);
        String fileName = Strings.fmt((String)"GVLs\\%s.TcGVL", (Object[])new Object[]{varList.name});
        Document prevDoc = this.files.put(fileName, doc);
        Assert.check((prevDoc == null ? 1 : 0) != 0, (Object)Strings.fmt((String)"Duplicate generated file \"%s\".", (Object[])new Object[]{fileName}));
    }

    private void updateCodeFiles() {
        for (File file : this.oldCodeFiles) {
            boolean success = file.delete();
            if (success) continue;
            String msg = Strings.fmt((String)"Could not remove TwinCAT code file \"%s\".", (Object[])new Object[]{file.getPath()});
            throw new InputOutputException(msg);
        }
        for (Map.Entry entry : this.files.entrySet()) {
            String path = Paths.join((String[])new String[]{this.plcProjDirFile.getPath(), (String)entry.getKey()});
            File entryFile = new File(path);
            this.writeXmlFile((Document)entry.getValue(), entryFile);
        }
    }

    private Document createXmlDoc() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return builder.newDocument();
    }

    @Override
    protected Box toBox(PlcTypeDecl typeDecl) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("TYPE %s:", new Object[]{typeDecl.name});
        c.indent();
        if (typeDecl.type instanceof PlcStructType) {
            c.add(this.toBox(typeDecl.type));
        } else {
            c.add((Box)new HBox(new Object[]{this.toBox(typeDecl.type), ";"}));
        }
        c.dedent();
        c.add("END_TYPE");
        return c;
    }
}

