/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.appsview.ui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuFactory;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.AppStatusLegendCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.AutoExpandCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.AutoRemoveCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.AutoTerminateCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.CommandUtils;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.RemoveAllCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.RemoveCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.TerminateAllCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.TerminateCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.ToolItemCheckCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.commands.ToolItemCommand;
import org.eclipse.escet.common.app.framework.appsview.ui.icons.AppStatusIcons;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.escet.common.app.framework.management.AppManagerData;
import org.eclipse.escet.common.app.framework.management.AppStatus;
import org.eclipse.escet.common.app.framework.management.AppStatusListener;
import org.eclipse.escet.common.eclipse.ui.SelectionListenerBase;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

public class AppsView
implements AppStatusListener {
    private MPart part = null;
    private final AppStatusIcons icons = new AppStatusIcons();
    private Tree tree;
    private Map<Application<?>, TreeItem> treeItems = Maps.map();
    private Set<TreeItem> itemsToRemove = Sets.set();
    private MDirectToolItem[] toolbarItems;
    private MDirectMenuItem[] popupItems;
    private Set<String> alwaysEnabledContributions = Sets.set();
    public AtomicBoolean autoTerminate;
    public AtomicBoolean autoRemove;
    public AtomicBoolean autoExpand;

    @Inject
    public AppsView(Composite parent, MPart part) {
        this.part = part;
        parent.setLayout((Layout)new FillLayout());
        this.tree = new Tree(parent, 2);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AppManager.removeStatusListener((AppStatusListener)AppsView.this);
                AppsView.this.icons.dispose();
                AppsView.this.treeItems.clear();
                AppsView.this.treeItems = null;
                AppsView.this.tree = null;
                AppsView.this.toolbarItems = new MDirectToolItem[0];
                AppsView.this.popupItems = new MDirectMenuItem[0];
                AppsView.this.alwaysEnabledContributions.clear();
                AppsView.this.part = null;
            }
        });
        this.loadPreferences();
        this.setupToolbar();
        this.tree.addSelectionListener((SelectionListener)new SelectionListenerBase(){

            public void widgetSelected(SelectionEvent e) {
                AppsView.this.updateEnabled();
            }
        });
        Display.getDefault().asyncExec(() -> this.updateEnabled());
        AppManager.addStatusListener((AppStatusListener)this, (boolean)true);
    }

    private void loadPreferences() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        String autoTerminatePref = store.getString("org.eclipse.escet.common.app.framework.appsview.ui.autoTerminate");
        String autoRemovePref = store.getString("org.eclipse.escet.common.app.framework.appsview.ui.autoRemove");
        String autoExpandPref = store.getString("org.eclipse.escet.common.app.framework.appsview.ui.autoExpand");
        if (autoTerminatePref.isEmpty()) {
            autoTerminatePref = "true";
        }
        if (autoRemovePref.isEmpty()) {
            autoRemovePref = "true";
        }
        if (autoExpandPref.isEmpty()) {
            autoExpandPref = "true";
        }
        this.autoTerminate = new AtomicBoolean(autoTerminatePref.equals("true"));
        this.autoRemove = new AtomicBoolean(autoRemovePref.equals("true"));
        this.autoExpand = new AtomicBoolean(autoExpandPref.equals("true"));
    }

    private void setupToolbar() {
        MToolBar toolbar = MMenuFactory.INSTANCE.createToolBar();
        this.part.setToolbar(toolbar);
        ToolItemCommand[] toolbarCommands = new ToolItemCommand[]{new TerminateAllCommand(), new AutoTerminateCommand(), new AutoRemoveCommand(), new AutoExpandCommand()};
        ToolItemCommand[] popupCommands = new ToolItemCommand[]{new TerminateCommand(), new RemoveCommand(), new RemoveAllCommand(), new AppStatusLegendCommand()};
        this.toolbarItems = new MDirectToolItem[toolbarCommands.length];
        int i = 0;
        while (i < toolbarCommands.length) {
            this.toolbarItems[i] = MMenuFactory.INSTANCE.createDirectToolItem();
            this.toolbarItems[i].setEnabled(false);
            this.toolbarItems[i].setIconURI(toolbarCommands[i].getIconUri());
            this.toolbarItems[i].setLabel(toolbarCommands[i].getItemLabel());
            this.toolbarItems[i].setTooltip(toolbarCommands[i].getTooltip());
            this.toolbarItems[i].setContributionURI(toolbarCommands[i].getContributionUri());
            this.toolbarItems[i].setType(toolbarCommands[i].getItemType());
            if (this.toolbarItems[i].getType() == ItemType.CHECK) {
                ToolItemCheckCommand checkCommand = (ToolItemCheckCommand)toolbarCommands[i];
                this.toolbarItems[i].setSelected(checkCommand.isSelected(this));
            }
            toolbar.getChildren().add(this.toolbarItems[i]);
            ++i;
        }
        this.popupItems = new MDirectMenuItem[popupCommands.length];
        if (popupCommands.length > 0) {
            MPopupMenu popupMenu = MMenuFactory.INSTANCE.createPopupMenu();
            popupMenu.getTags().add("ViewMenu");
            this.part.getMenus().add(popupMenu);
            int i2 = 0;
            while (i2 < popupCommands.length) {
                this.popupItems[i2] = MMenuFactory.INSTANCE.createDirectMenuItem();
                this.popupItems[i2].setEnabled(false);
                this.popupItems[i2].setIconURI(popupCommands[i2].getIconUri());
                this.popupItems[i2].setLabel(popupCommands[i2].getItemLabel());
                this.popupItems[i2].setTooltip(popupCommands[i2].getTooltip());
                this.popupItems[i2].setContributionURI(popupCommands[i2].getContributionUri());
                this.popupItems[i2].setType(popupCommands[i2].getItemType());
                if (this.popupItems[i2].getType() == ItemType.CHECK) {
                    ToolItemCheckCommand checkCommand = (ToolItemCheckCommand)popupCommands[i2];
                    this.popupItems[i2].setSelected(checkCommand.isSelected(this));
                }
                popupMenu.getChildren().add(this.popupItems[i2]);
                ++i2;
            }
        }
    }

    public AppStatusIcons getIcons() {
        return this.icons;
    }

    public Tree getTree() {
        return this.tree;
    }

    public Map<Application<?>, TreeItem> getTreeItems() {
        return this.treeItems;
    }

    public void appStatusChanged(final AppManagerData data, final boolean newApp) {
        final Display display = Display.getDefault();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                if (AppsView.this.part == null) {
                    return;
                }
                AppsView.this.appStatusChangedInternal(data, newApp);
            }
        });
    }

    private void appStatusChangedInternal(AppManagerData data, boolean newApp) {
        if (this.treeItems == null) {
            return;
        }
        TreeItem item = this.treeItems.get(data.application);
        if (item == null) {
            if (!newApp) {
                return;
            }
            TreeItem parentItem = null;
            if (data.parent != null) {
                parentItem = this.treeItems.get(data.parent);
            }
            if (parentItem != null) {
                if (parentItem.isDisposed()) {
                    return;
                }
                item = new TreeItem(parentItem, 0);
                if (this.autoExpand.get()) {
                    parentItem.setExpanded(true);
                }
            } else {
                TreeItem[] roots;
                boolean doTerminate = this.autoTerminate.get();
                boolean doRemove = this.autoRemove.get();
                if (doTerminate && !this.tree.isDisposed()) {
                    roots = this.tree.getItems();
                    Set items = Sets.setc((int)roots.length);
                    TreeItem[] treeItemArray = roots;
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem root = treeItemArray[n2];
                        items.add(root);
                        ++n2;
                    }
                    for (Map.Entry<Application<?>, TreeItem> entry : this.treeItems.entrySet()) {
                        if (!items.contains(entry.getValue())) continue;
                        AppManager.terminate(entry.getKey());
                    }
                }
                if (doRemove && !this.tree.isDisposed()) {
                    TreeItem[] treeItemArray = roots = this.tree.getItems();
                    int n = roots.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TreeItem root = treeItemArray[n3];
                        Image icon = root.getImage();
                        AppStatus status = this.icons.getStatus(icon);
                        if (status.isDone()) {
                            root.dispose();
                        } else if (doTerminate) {
                            this.itemsToRemove.add(root);
                        }
                        ++n3;
                    }
                }
                if (this.tree.isDisposed()) {
                    return;
                }
                item = new TreeItem(this.tree, 0);
            }
            this.treeItems.put(data.application, item);
            item.setText(data.application.getAppName());
        }
        if (!item.isDisposed()) {
            if (data.status.isDone() && this.itemsToRemove.contains(item)) {
                this.removeRootItem(item);
            } else {
                Image icon = this.icons.getIcon(data.status);
                if (icon != null && !icon.isDisposed()) {
                    item.setImage(icon);
                }
            }
        }
        if (this.part != null) {
            this.updateEnabled();
        }
    }

    @Focus
    public void setFocus() {
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        this.tree.setFocus();
    }

    private void updateEnabled() {
        boolean enabled;
        String contributionUri;
        if (this.part == null || this.part.getObject() == null) {
            return;
        }
        if (this.tree == null || this.tree.isDisposed()) {
            return;
        }
        int i = 0;
        while (i < this.toolbarItems.length) {
            contributionUri = this.toolbarItems[i].getContributionURI();
            enabled = this.isEnabled(contributionUri);
            if (this.toolbarItems[i].isEnabled() != enabled) {
                this.toolbarItems[i].setEnabled(enabled);
            }
            ++i;
        }
        i = 0;
        while (i < this.popupItems.length) {
            contributionUri = this.popupItems[i].getContributionURI();
            enabled = this.isEnabled(contributionUri);
            if (this.popupItems[i].isEnabled() != enabled) {
                this.popupItems[i].setEnabled(enabled);
            }
            ++i;
        }
    }

    private boolean isEnabled(String contributionUri) {
        Object rslt;
        Object obj;
        Method method;
        Class cls;
        Bundle bundle;
        if (this.alwaysEnabledContributions.contains(contributionUri)) {
            return true;
        }
        URI uri = null;
        try {
            uri = new URI(contributionUri);
        }
        catch (URISyntaxException ex) {
            this.logError("Invalid contribution URI.", ex);
            return false;
        }
        try {
            bundle = Platform.getBundle((String)uri.getHost());
        }
        catch (IllegalArgumentException ex) {
            String msg = Strings.fmt((String)"Can't obtain OSGi bundle \"%s\".", (Object[])new Object[]{uri.getHost()});
            this.logError(msg, ex);
            return false;
        }
        if (bundle == null) {
            String msg = Strings.fmt((String)"OSGi bundle \"%s\" not found.", (Object[])new Object[]{uri.getHost()});
            this.logError(msg, null);
            return false;
        }
        String clsName = uri.getPath();
        while (clsName.startsWith("/")) {
            clsName = clsName.substring(1);
        }
        if (clsName.isEmpty()) {
            String msg = Strings.fmt((String)"Class name missing in URI \"%s\".", (Object[])new Object[]{uri});
            this.logError(msg, null);
            return false;
        }
        try {
            cls = bundle.loadClass(clsName);
        }
        catch (ClassNotFoundException ex) {
            String msg = Strings.fmt((String)"Class \"%s\" not found.", (Object[])new Object[]{clsName});
            this.logError(msg, ex);
            return false;
        }
        try {
            method = cls.getMethod("isEnabled", MPart.class);
        }
        catch (NoSuchMethodException ex) {
            this.alwaysEnabledContributions.add(contributionUri);
            return true;
        }
        catch (SecurityException ex) {
            String msg = Strings.fmt((String)"Can't obtain \"isEnabled\" method for class \"%s\".", (Object[])new Object[]{clsName});
            this.logError(msg, ex);
            return false;
        }
        try {
            obj = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            String msg = Strings.fmt((String)"Can't instantiate class \"%s\".", (Object[])new Object[]{clsName});
            this.logError(msg, ex);
            return false;
        }
        try {
            rslt = method.invoke(obj, this.part);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            String msg = Strings.fmt((String)"Failed to invoke \"isEnabled\" method of class \"%s\".", (Object[])new Object[]{clsName});
            this.logError(msg, ex);
            return false;
        }
        if (!(rslt instanceof Boolean)) {
            String msg = Strings.fmt((String)"Unexpected result for \"isEnabled\" method of class \"%s\".", (Object[])new Object[]{clsName});
            this.logError(msg, null);
            return false;
        }
        return (Boolean)rslt;
    }

    public void removeRootItem(TreeItem root) {
        Set removed = Sets.set();
        Assert.check((root.getParentItem() == null ? 1 : 0) != 0);
        CommandUtils.collectItems(root, removed);
        root.dispose();
        Iterator<Map.Entry<Application<?>, TreeItem>> iter = this.treeItems.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Application<?>, TreeItem> entry = iter.next();
            TreeItem item = entry.getValue();
            if (!removed.contains(item)) continue;
            iter.remove();
            this.itemsToRemove.remove(item);
        }
    }

    public void removeRootItems(Set<TreeItem> roots) {
        Set removed = Sets.set();
        for (TreeItem root : roots) {
            Assert.check((root.getParentItem() == null ? 1 : 0) != 0);
            CommandUtils.collectItems(root, removed);
            root.dispose();
        }
        Iterator<Map.Entry<Application<?>, TreeItem>> iter = this.treeItems.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Application<?>, TreeItem> entry = iter.next();
            TreeItem item = entry.getValue();
            if (!removed.contains(item)) continue;
            iter.remove();
            this.itemsToRemove.remove(item);
        }
    }

    private void logError(String msg, Exception ex) {
        msg = (String)msg + " Please report this to the Eclipse ESCET development team.";
        String pluginName = this.getClass().getName();
        Status status = new Status(4, pluginName, 0, (String)msg, (Throwable)ex);
        StatusManager.getManager().handle((IStatus)status, 1);
    }
}

