/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.input.NullInputStream;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.AppEnvData;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.console.Console;
import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.io.NullAppStream;
import org.eclipse.escet.common.app.framework.management.AppManager;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class ChildAppStarter {
    private ChildAppStarter() {
    }

    public static <T extends Application<?>> int exec(Class<T> appClass, String[] args) {
        return ChildAppStarter.exec(appClass, args, "-", "-", "-", false, false, false, false);
    }

    public static <T extends Application<?>> int exec(Class<T> appClass, String[] args, String stdoutPath, String stderrPath, boolean ignoreExitCode) {
        if (stdoutPath == null) {
            stdoutPath = "-";
        }
        if (stderrPath == null) {
            stderrPath = "-";
        }
        return ChildAppStarter.exec(appClass, args, "-", stdoutPath, stderrPath, false, false, false, ignoreExitCode);
    }

    public static <T extends Application<?>> int exec(Class<T> appClass, final String[] args, String stdinPath, String stdoutPath, String stderrPath, boolean appendOut, boolean appendErr, boolean errToOut, boolean ignoreExitCode) {
        AppStream warnStream;
        AppStream errStream;
        Object inStream;
        Constructor<T> appConstructor;
        try {
            appConstructor = appClass.getConstructor(AppStreams.class);
        }
        catch (SecurityException ex) {
            String msg = Strings.fmt((String)"Application framework application execution failed, due to security settings prohibiting obtaining of a constructor for the \"%s\" class.", (Object[])new Object[]{appClass.getName()});
            throw new RuntimeException(msg, ex);
        }
        catch (NoSuchMethodException ex) {
            String msg = Strings.fmt((String)"Application framework application execution failed, due the \"%s\" class missing a proper constructor.", (Object[])new Object[]{appClass.getName()});
            throw new RuntimeException(msg, ex);
        }
        final AppEnvData parentAppEnvData = AppEnv.getData();
        final String parentWorkDir = Paths.getCurWorkingDir();
        final Console console = parentAppEnvData.getConsole();
        AppStreams parentStreams = parentAppEnvData.getStreams();
        if (stdinPath.isEmpty()) {
            inStream = new NullInputStream(0L);
        } else if (stdinPath.equals("-")) {
            inStream = parentStreams.inStream;
        } else {
            String absStdinPath = Paths.resolve(stdinPath);
            try {
                inStream = new FileInputStream(absStdinPath);
            }
            catch (FileNotFoundException ex) {
                String msg = Strings.fmt((String)"Failed to open file \"%s\" for reading, as it can not be found, is a directory rather than a file, or for some other reason can not be opened for reading.", (Object[])new Object[]{stdinPath});
                throw new InputOutputException(msg, (Throwable)ex);
            }
            inStream = new BufferedInputStream((InputStream)inStream);
        }
        AppStream outStream = stdoutPath.isEmpty() ? new NullAppStream() : (stdoutPath.equals("-") ? parentStreams.out : new FileAppStream(stdoutPath, appendOut));
        if (errToOut) {
            errStream = outStream;
            warnStream = outStream;
        } else if (stderrPath.isEmpty()) {
            errStream = new NullAppStream();
            warnStream = new NullAppStream();
        } else if (stderrPath.equals("-")) {
            errStream = parentStreams.err;
            warnStream = parentStreams.warn;
        } else {
            errStream = new FileAppStream(stderrPath, appendErr);
            warnStream = errStream;
        }
        final AppStreams childStreams = new AppStreams((InputStream)inStream, outStream, warnStream, errStream);
        final AtomicReference app = new AtomicReference();
        final AtomicReference<String> msg = new AtomicReference<String>();
        final AtomicReference<InterruptedException> ex = new AtomicReference<InterruptedException>();
        final AtomicReference exitCode = new AtomicReference();
        final AtomicReference terminated = new AtomicReference();
        Runnable childRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    app.set((Application)appConstructor.newInstance(childStreams));
                }
                catch (IllegalArgumentException e) {
                    msg.set("Application framework application execution failed, due to invalid constructor parameters.");
                    ex.set(e);
                }
                catch (InstantiationException e) {
                    msg.set("Application framework application execution failed, due to a failure to instantiate the application class. Is the class abstract?");
                    ex.set(e);
                }
                catch (IllegalAccessException e) {
                    msg.set("Application framework application execution failed, due to the constructor being inaccessible.");
                    ex.set(e);
                }
                catch (InvocationTargetException e) {
                    msg.set("Application framework application execution failed, due to an uncaught exception of the application class constructor.");
                    ex.set(e);
                }
                if (app.get() == null) {
                    return;
                }
                Paths.setCurWorkingDir(parentWorkDir);
                AppEnvData childAppEnvData = AppEnv.getData();
                if (console != null) {
                    console.setApplication((Application)app.get());
                }
                AppManager.add((Application)app.get(), parentAppEnvData.getApplication());
                if (parentAppEnvData.isTerminationRequested()) {
                    ((Application)app.get()).terminate();
                }
                int appExitCode = ((Application)app.get()).runApplication(args, false);
                AppManager.remove((Application)app.get());
                app.set(null);
                exitCode.set(appExitCode);
                terminated.set(childAppEnvData.isTerminationRequested());
            }
        };
        Thread t = new Thread(childRunnable, appClass.getName());
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            msg.set("Application framework application execution failed, due to its thread being interrupted.");
            ex.set(e);
        }
        if (app.get() != null) {
            AppManager.remove((Application)app.get());
            app.set(null);
        }
        if (exitCode.get() == null) {
            throw new RuntimeException("Application framework application crashed. Crash not properly handled by crash handling of the application framework application.");
        }
        if (console != null) {
            console.setApplication(parentAppEnvData.getApplication());
        }
        if (!stdinPath.isEmpty() && !stdinPath.equals("-")) {
            try {
                ((InputStream)inStream).close();
            }
            catch (IOException ex2) {
                String msg2 = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{stdinPath});
                throw new InputOutputException(msg2, (Throwable)ex2);
            }
        }
        if (!stdoutPath.isEmpty() && !stdoutPath.equals("-")) {
            outStream.flush();
            outStream.close();
        }
        if (!(errToOut || stderrPath.isEmpty() || stderrPath.equals("-"))) {
            errStream.flush();
            errStream.close();
        }
        if (terminated.get() != null && ((Boolean)terminated.get()).booleanValue()) {
            AppEnv.terminate();
        }
        if (ex.get() != null) {
            throw new RuntimeException((String)msg.get(), (Throwable)ex.get());
        }
        Assert.notNull(exitCode.get());
        if (!ignoreExitCode && (Integer)exitCode.get() != 0) {
            parentAppEnvData.terminate();
        }
        return (Integer)exitCode.get();
    }
}

