/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.escet.common.app.framework.javacompiler.InMemoryJarClassLoaderUrlStreamHandler;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class InMemoryJarClassLoader
extends URLClassLoader {
    protected final String jarPath;
    protected final InMemoryJarClassLoaderUrlStreamHandler handler;

    public InMemoryJarClassLoader(String jarPath) {
        this(jarPath, null);
    }

    public InMemoryJarClassLoader(String jarPath, ClassLoader parent) {
        this(jarPath, parent, new InMemoryJarClassLoaderUrlStreamHandler(jarPath));
    }

    public InMemoryJarClassLoader(String jarPath, ClassLoader parent, InMemoryJarClassLoaderUrlStreamHandler handler) {
        super(new URL[]{InMemoryJarClassLoader.createUrl(handler)}, parent);
        this.jarPath = jarPath;
        this.handler = handler;
    }

    private static URL createUrl(InMemoryJarClassLoaderUrlStreamHandler handler) {
        try {
            return new URL("jar-in-memory", null, -1, "/", handler);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMainClassName() {
        Manifest manifest = this.handler.getManifest();
        if (manifest == null) {
            String msg = Strings.fmt((String)"Could not retrieve manifest for JAR file \"%s\".", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg);
        }
        Attributes attrs = manifest.getMainAttributes();
        if (attrs == null) {
            String msg = Strings.fmt((String)"Could not retrieve main attributes for manifest of JAR file \"%s\".", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg);
        }
        String mainClass = attrs.getValue(Attributes.Name.MAIN_CLASS);
        if (mainClass == null || mainClass.isEmpty()) {
            String msg = Strings.fmt((String)"The main class name in the manifest of JAR file \"%s\" is not valid.", (Object[])new Object[]{this.jarPath});
            throw new InputOutputException(msg);
        }
        return mainClass;
    }

    public <T> Class<? extends T> loadClassByName(String absClassName) {
        try {
            Class<?> rslt = this.loadClass(absClassName, true);
            return rslt;
        }
        catch (ClassNotFoundException e) {
            String msg = Strings.fmt((String)"Could not find class \"%s\" in JAR file \"%s\".", (Object[])new Object[]{absClassName, this.jarPath});
            throw new InputOutputException(msg, (Throwable)e);
        }
    }
}

