/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.runtime.builtins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.escet.common.app.framework.AppEnv;
import org.eclipse.escet.common.app.framework.ChildAppStarter;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.PlatformUtils;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.CommandLineUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.UncachedUrlClassLoader;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.tooldef.common.ClassLoaderObtainer;
import org.eclipse.escet.tooldef.runtime.ExitException;
import org.eclipse.escet.tooldef.runtime.ToolDefException;
import org.osgi.framework.Bundle;

public class BuiltInGenericTools {
    private BuiltInGenericTools() {
    }

    public static int app(String plugin, String classname, List<String> args, String stdin, String stdout, String stderr, boolean appendOut, boolean appendErr, boolean errToOut, boolean ignoreNonZeroExitCode) {
        int exitCode;
        Class<?> appClass;
        Class<?> cls;
        ClassLoader loader = BuiltInGenericTools.getClassLoader(plugin);
        try {
            cls = loader.loadClass(classname);
        }
        catch (ClassNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to load/find class \"%s\".", (Object[])new Object[]{classname});
            throw new ToolDefException(msg, ex);
        }
        try {
            Class<?> tmpClass;
            appClass = tmpClass = cls;
        }
        catch (ClassCastException ex) {
            String msg = Strings.fmt((String)"Class \"%s\" is not an application framework application class.", (Object[])new Object[]{classname});
            throw new ToolDefException(msg, ex);
        }
        List processedArgs = Lists.list();
        for (String arg : args) {
            String[] parsedArgs;
            try {
                parsedArgs = CommandLineUtils.parseArgs((String)arg);
            }
            catch (IllegalArgumentException ex) {
                String msg = Strings.fmt((String)"Failed to parse command line argument: \"%s\".", (Object[])new Object[]{arg});
                throw new ToolDefException(msg, ex);
            }
            String[] stringArray = parsedArgs;
            int n = parsedArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String parsedArg = stringArray[n2];
                processedArgs.add(parsedArg);
                ++n2;
            }
        }
        String[] argsArray = processedArgs.toArray(new String[0]);
        try {
            exitCode = ChildAppStarter.exec(appClass, (String[])argsArray, (String)stdin, (String)stdout, (String)stderr, (boolean)appendOut, (boolean)appendErr, (boolean)errToOut, (boolean)true);
        }
        catch (RuntimeException ex) {
            String msg = "Application framework application execution failed.";
            throw new ToolDefException(msg, ex);
        }
        if (exitCode != 0 && !ignoreNonZeroExitCode) {
            throw new ExitException(exitCode);
        }
        return exitCode;
    }

    private static ClassLoader getClassLoader(String name) {
        return new ClassLoaderObtainer(){

            protected void errNotPluginProj(String name) {
                String msg = Strings.fmt((String)"Cannot load application from plug-in (Eclipse project) \"%s\", as the project is not a plug-in project, or it contains a manifest file that is malformed or missing vital information.", (Object[])new Object[]{name});
                throw new ToolDefException(msg);
            }

            protected void errPluginClassicFormat(String name) {
                String msg = Strings.fmt((String)"Cannot load application from plug-in (Eclipse project) \"%s\", as the plug-in project is in a classic format (does not use the new OSGi bundle layout).", (Object[])new Object[]{name});
                throw new ToolDefException(msg);
            }

            protected void errComputeClassPath(String name, CoreException ex) {
                String exMsg = ex.getMessage();
                if (exMsg == null) {
                    exMsg = "no additional details available.";
                }
                String msg = Strings.fmt((String)"Cannot load application from plug-in (Eclipse project) \"%s\", as the class path of the project could not be computed. The plug-in may not have a Java nature. Cause: %s", (Object[])new Object[]{name, exMsg});
                throw new ToolDefException(msg);
            }

            protected void errMalformedUrl(String name, MalformedURLException ex) {
                String exMsg = ex.getMessage();
                if (exMsg == null) {
                    exMsg = "no additional details available.";
                }
                String msg = Strings.fmt((String)"Cannot load application from plug-in (Eclipse project) \"%s\", as an URL from the project's class path is malformed. Cause: %s", (Object[])new Object[]{name, exMsg});
                throw new ToolDefException(msg);
            }

            protected void errOpenUrl(String name, UncachedUrlClassLoader.OpenUrlException ex) {
                String exMsg = ex.getMessage();
                if (exMsg == null) {
                    exMsg = "no additional details available.";
                }
                String msg = Strings.fmt((String)"Cannot load application from plug-in (Eclipse project) \"%s\", as URL \"%s\" from the project's class path could not be opened. Cause: %s", (Object[])new Object[]{name, ex.url.toString(), exMsg});
                throw new ToolDefException(msg);
            }

            protected void errNotFound(String name) {
                String msg = Strings.fmt((String)"Cannot find a plug-in (OSGi bundle or Eclipse project) with name \"%s\".", (Object[])new Object[]{name});
                throw new ToolDefException(msg);
            }

            protected void errWrongState(String name, Bundle bundle, int state) {
                String msg = Strings.fmt((String)"Cannot load application from plug-in (OSGi bundle) \"%s\", as the plug-in is in a wrong state (%s), as it should be in state RESOLVED, STARTING, or ACTIVE.", (Object[])new Object[]{name, PlatformUtils.getStateName((Bundle)bundle)});
                throw new ToolDefException(msg);
            }

            protected void errNoClassLoader(String name, Bundle bundle) {
                String msg = Strings.fmt((String)"Cannot load application from plug-in (OSGi bundle) \"%s\", as a class loader could not be obtained for the plug-in.", (Object[])new Object[]{name});
                throw new ToolDefException(msg);
            }
        }.getClassLoader(name);
    }

    public static int exec(String cmd, List<String> args, String stdin, String stdout, String stderr, boolean appendOut, boolean appendErr, boolean errToOut, boolean ignoreNonZeroExitCode) {
        Integer exitCode;
        Throwable execErr;
        InputOutputException ioErr;
        block52: {
            String msg;
            Object errStream;
            block51: {
                Object outStream;
                block50: {
                    Object inStream;
                    block49: {
                        block48: {
                            AppStreams tooldefStreams = AppEnv.getStreams();
                            ioErr = null;
                            inStream = null;
                            if (ioErr == null) {
                                if (stdin.equals("")) {
                                    inStream = new NullInputStream(0L);
                                } else if (stdin.equals("-")) {
                                    inStream = tooldefStreams.inStream;
                                } else {
                                    String absStdin = Paths.resolve((String)stdin);
                                    try {
                                        inStream = new FileInputStream(absStdin);
                                        inStream = new BufferedInputStream((InputStream)inStream);
                                    }
                                    catch (FileNotFoundException ex) {
                                        String msg2 = Strings.fmt((String)"Failed to open file \"%s\" for reading, as it can not be found, is a directory rather than a file, or for some other reason can not be opened for reading.", (Object[])new Object[]{stdin});
                                        ioErr = new InputOutputException(msg2, (Throwable)ex);
                                    }
                                }
                            }
                            outStream = null;
                            if (ioErr == null) {
                                if (stdout.equals("")) {
                                    outStream = NullOutputStream.NULL_OUTPUT_STREAM;
                                } else if (stdout.equals("-")) {
                                    outStream = tooldefStreams.out.asOutputStream();
                                } else {
                                    String absStdout = Paths.resolve((String)stdout);
                                    try {
                                        outStream = new FileOutputStream(absStdout);
                                        outStream = new BufferedOutputStream((OutputStream)outStream);
                                    }
                                    catch (FileNotFoundException ex) {
                                        String msg3 = Strings.fmt((String)"Failed to open file \"%s\" for writing, as it already exists as a directory, does not exist but cannot be created, or for some other reason cannot be opened for opened for writing.", (Object[])new Object[]{stdout});
                                        ioErr = new InputOutputException(msg3, (Throwable)ex);
                                    }
                                }
                            }
                            errStream = null;
                            if (ioErr == null) {
                                if (errToOut) {
                                    errStream = outStream;
                                } else if (stderr.equals("")) {
                                    errStream = NullOutputStream.NULL_OUTPUT_STREAM;
                                } else if (stderr.equals("-")) {
                                    errStream = tooldefStreams.err.asOutputStream();
                                } else {
                                    String absStderr = Paths.resolve((String)stderr);
                                    try {
                                        errStream = new FileOutputStream(absStderr);
                                        errStream = new BufferedOutputStream((OutputStream)errStream);
                                    }
                                    catch (FileNotFoundException ex) {
                                        String msg4 = Strings.fmt((String)"Failed to open file \"%s\" for writing, as it already exists as a directory, does not exist but cannot be created, or for some other reason cannot be opened for opened for writing.", (Object[])new Object[]{stderr});
                                        ioErr = new InputOutputException(msg4, (Throwable)ex);
                                    }
                                }
                            }
                            execErr = null;
                            exitCode = null;
                            if (ioErr == null) {
                                try {
                                    exitCode = BuiltInGenericTools.execInternal(cmd, args, (InputStream)inStream, (OutputStream)outStream, (OutputStream)errStream, ignoreNonZeroExitCode);
                                }
                                catch (ApplicationException | ExitException ex) {
                                    execErr = ex;
                                }
                            }
                            try {
                                if (outStream != null) {
                                    ((OutputStream)outStream).flush();
                                }
                            }
                            catch (IOException ex) {
                                msg = "Failed to flush stdout stream.";
                                if (ioErr == null) break block48;
                                ioErr = new InputOutputException(msg, (Throwable)ex);
                            }
                        }
                        try {
                            if (errStream != null) {
                                ((OutputStream)errStream).flush();
                            }
                        }
                        catch (IOException ex) {
                            msg = "Failed to flush stderr stream.";
                            if (ioErr == null) break block49;
                            ioErr = new InputOutputException(msg, (Throwable)ex);
                        }
                    }
                    if (!stdin.equals("") && !stdin.equals("-")) {
                        try {
                            if (inStream != null) {
                                ((InputStream)inStream).close();
                            }
                        }
                        catch (IOException ex) {
                            msg = Strings.fmt((String)"Failed to close file \"%s\".", (Object[])new Object[]{stdin});
                            if (ioErr == null) break block50;
                            ioErr = new InputOutputException(msg, (Throwable)ex);
                        }
                    }
                }
                if (!stdout.equals("") && !stdout.equals("-")) {
                    try {
                        if (outStream != null) {
                            ((OutputStream)outStream).close();
                        }
                    }
                    catch (IOException ex) {
                        msg = "Failed to close stdout stream.";
                        if (ioErr == null) break block51;
                        ioErr = new InputOutputException(msg, (Throwable)ex);
                    }
                }
            }
            if (!(errToOut || stderr.equals("") || stderr.equals("-"))) {
                try {
                    if (errStream != null) {
                        ((OutputStream)errStream).close();
                    }
                }
                catch (IOException ex) {
                    msg = "Failed to close stderr stream.";
                    if (ioErr == null) break block52;
                    ioErr = new InputOutputException(msg, (Throwable)ex);
                }
            }
        }
        if (execErr != null) {
            if (execErr instanceof ApplicationException) {
                throw (ApplicationException)execErr;
            }
            if (execErr instanceof ExitException) {
                throw (ExitException)execErr;
            }
            throw new RuntimeException("Unknown execErr: " + String.valueOf(execErr));
        }
        if (ioErr != null) {
            throw ioErr;
        }
        Assert.notNull((Object)exitCode);
        return exitCode;
    }

    private static int execInternal(String cmd, List<String> args, InputStream stdin, OutputStream stdout, OutputStream stderr, boolean ignoreNonZeroExitCode) {
        CommandLine commandLine = new CommandLine(cmd);
        for (String arg : args) {
            String[] parsedArgs;
            try {
                parsedArgs = CommandLineUtils.parseArgs((String)arg);
            }
            catch (IllegalArgumentException ex) {
                String msg = Strings.fmt((String)"Failed to parse command line argument: \"%s\".", (Object[])new Object[]{arg});
                throw new ToolDefException(msg, ex);
            }
            String[] stringArray = parsedArgs;
            int n = parsedArgs.length;
            int msg = 0;
            while (msg < n) {
                String parsedArg = stringArray[msg];
                commandLine.addArgument(parsedArg, false);
                ++msg;
            }
        }
        DefaultExecutor executor = new DefaultExecutor();
        DefaultExecuteResultHandler rslt = new DefaultExecuteResultHandler();
        PumpStreamHandler streams = new PumpStreamHandler(stdout, stderr, stdin);
        executor.setStreamHandler((ExecuteStreamHandler)streams);
        File workingDir = new File(Paths.getCurWorkingDir());
        executor.setWorkingDirectory(workingDir);
        try {
            executor.execute(commandLine, (ExecuteResultHandler)rslt);
        }
        catch (ExecuteException ex) {
            String msg = "Failed to execute system command or external application.";
            throw new ToolDefException(msg, ex);
        }
        catch (IOException ex) {
            String msg = "Failed to execute system command or external application, due to I/O failure.";
            throw new ToolDefException(msg, ex);
        }
        try {
            rslt.waitFor();
        }
        catch (InterruptedException ex) {
            String msg = "Failed to execute system command or external application: the application was interrupted.";
            throw new ToolDefException(msg, ex);
        }
        if (rslt.getException() != null) {
            String msg = Strings.fmt((String)"Execution of system command or external application failed (exit code = %d).", (Object[])new Object[]{rslt.getExitValue()});
            throw new ToolDefException(msg, rslt.getException());
        }
        int exitCode = rslt.getExitValue();
        if (exitCode != 0 && !ignoreNonZeroExitCode) {
            throw new ExitException(exitCode);
        }
        return exitCode;
    }

    public static int tooldef(List<String> args, String stdin, String stdout, String stderr, boolean appendOut, boolean appendErr, boolean errToOut, boolean ignoreNonZeroExitCode) {
        return BuiltInGenericTools.app("org.eclipse.escet.tooldef.interpreter", "org.eclipse.escet.tooldef.interpreter.ToolDefInterpreterApp", args, stdin, stdout, stderr, appendOut, appendErr, errToOut, ignoreNonZeroExitCode);
    }
}

