/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.controllercheck;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerPreChecker;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerResult;
import org.eclipse.escet.cif.controllercheck.ControllerCheckerSettings;
import org.eclipse.escet.cif.controllercheck.checks.CheckConclusion;
import org.eclipse.escet.cif.controllercheck.checks.ControllerCheckerCheck;
import org.eclipse.escet.cif.controllercheck.checks.boundedresponse.BoundedResponseCheck;
import org.eclipse.escet.cif.controllercheck.checks.confluence.ConfluenceCheck;
import org.eclipse.escet.cif.controllercheck.checks.finiteresponse.FiniteResponseCheck;
import org.eclipse.escet.cif.controllercheck.checks.nonblockingundercontrol.NonBlockingUnderControlCheck;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.DebugNormalOutput;
import org.eclipse.escet.common.java.output.WarnOutput;

public class ControllerChecker {
    private ControllerChecker() {
    }

    public static ControllerCheckerResult performChecks(Specification spec, String specAbsPath, ControllerCheckerSettings settings) {
        settings.check();
        Termination termination = settings.getTermination();
        DebugNormalOutput normalOutput = settings.getNormalOutput();
        DebugNormalOutput debugOutput = settings.getDebugOutput();
        WarnOutput warnOutput = settings.getWarnOutput();
        spec = ControllerChecker.preprocessAndCheck(spec, specAbsPath, termination, warnOutput);
        List checksToPerform = Lists.listc((int)4);
        if (settings.getCheckBoundedResponse()) {
            checksToPerform.add(new BoundedResponseCheck());
        }
        if (settings.getCheckNonBlockingUnderControl()) {
            checksToPerform.add(new NonBlockingUnderControlCheck());
        }
        if (settings.getCheckFiniteResponse()) {
            checksToPerform.add(new FiniteResponseCheck(settings.getPrintFiniteResponseControlLoops()));
        }
        if (settings.getCheckConfluence()) {
            checksToPerform.add(new ConfluenceCheck());
        }
        int checksPerformed = 0;
        List conclusions = Lists.listc((int)checksToPerform.size());
        int i = 0;
        while (i < checksToPerform.size()) {
            ControllerCheckerCheck check = (ControllerCheckerCheck)checksToPerform.get(i);
            if (checksPerformed > 0) {
                normalOutput.line();
            }
            normalOutput.line("Checking for %s:", new Object[]{check.getPropertyName()});
            debugOutput.inc();
            Object conclusion = check.performCheck(spec, specAbsPath, settings);
            debugOutput.dec();
            if (conclusion == null || termination.isRequested()) {
                return null;
            }
            ++checksPerformed;
            conclusions.add(conclusion);
            ++i;
        }
        ControllerCheckerResult result = new ControllerCheckerResult(conclusions);
        normalOutput.line();
        normalOutput.line("CONCLUSION:");
        List namedConclusions = Lists.list();
        namedConclusions.add(Pair.pair((Object)"bounded response", (Object)result.boundedResponseConclusion));
        namedConclusions.add(Pair.pair((Object)"non-blocking under control", (Object)result.nonBlockingUnderControlConclusion));
        namedConclusions.add(Pair.pair((Object)"finite response", (Object)result.finiteResponseConclusion));
        namedConclusions.add(Pair.pair((Object)"confluence", (Object)result.confluenceConclusion));
        int i2 = 0;
        while (i2 < namedConclusions.size()) {
            boolean previousConclusionHasDetails;
            boolean isFirst = i2 == 0;
            Pair current = (Pair)namedConclusions.get(i2);
            Pair previous = isFirst ? null : (Pair)namedConclusions.get(i2 - 1);
            String name = (String)current.left;
            CheckConclusion conclusion = (CheckConclusion)current.right;
            CheckConclusion previousConclusion = previous == null ? null : (CheckConclusion)previous.right;
            boolean conclusionHasDetails = conclusion != null && conclusion.hasDetails();
            boolean bl = previousConclusionHasDetails = previousConclusion != null && previousConclusion.hasDetails();
            if (!isFirst && (previousConclusionHasDetails || conclusionHasDetails)) {
                normalOutput.line();
            }
            normalOutput.inc();
            if (conclusion != null) {
                conclusion.printResult(normalOutput, warnOutput);
            } else {
                normalOutput.line("[UNKNOWN] %s checking was disabled, %s property is unknown.", new Object[]{Strings.makeInitialUppercase((String)name), name});
            }
            normalOutput.dec();
            ++i2;
        }
        return result;
    }

    private static Specification preprocessAndCheck(Specification spec, String specAbsPath, Termination termination, WarnOutput warnOutput) {
        new ElimComponentDefInst().transform(spec);
        spec = (Specification)EMFHelper.deepclone((EObject)spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            warnOutput.line("The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        ControllerCheckerPreChecker checker = new ControllerCheckerPreChecker(termination);
        checker.reportPreconditionViolations(spec, specAbsPath, "CIF controller properties checker");
        if (termination.isRequested()) {
            return null;
        }
        Set specAlphabet = CifEventUtils.getAlphabet((Specification)spec);
        if (specAlphabet.stream().allMatch(e -> e.getControllable() == false)) {
            warnOutput.line("The alphabet of the specification contains no controllable events.");
        }
        if (specAlphabet.stream().allMatch(e -> e.getControllable())) {
            warnOutput.line("The alphabet of the specification contains no uncontrollable events.");
        }
        if (((List)CifCollectUtils.collectInputVariables((ComplexComponent)spec, (Collection)Lists.list())).isEmpty()) {
            warnOutput.line("The specification contains no input variables.");
        }
        return spec;
    }
}

