/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.c99;

import java.util.List;
import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.ExprCodeGen;
import org.eclipse.escet.cif.codegen.IfElseGenerator;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.c99.C99DataValue;
import org.eclipse.escet.cif.codegen.c99.typeinfos.C99TypeInfoHelper;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.codegen.updates.VariableWrapper;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class C99ExprCodeGen
extends ExprCodeGen {
    @Override
    protected ExprCode predTextsToTarget(List<ExprCode> predCodes, CodeContext ctxt) {
        if (predCodes.isEmpty()) {
            ExprCode result = new ExprCode();
            result.setDataValue(C99DataValue.makeLiteral("true"));
            return result;
        }
        if (predCodes.size() == 1) {
            return (ExprCode)Lists.first(predCodes);
        }
        ExprCode result = new ExprCode();
        CharSequence[] preds = new String[predCodes.size()];
        int i = 0;
        while (i < predCodes.size()) {
            if (i == 0) {
                result.add(predCodes.get(i));
            } else {
                Assert.check((!predCodes.get(i).hasCode() ? 1 : 0) != 0);
            }
            preds[i] = Strings.fmt((String)"(%s)", (Object[])new Object[]{predCodes.get(i).getData()});
            ++i;
        }
        result.setDataValue(C99DataValue.makeValue(String.join((CharSequence)" && ", preds)));
        return result;
    }

    private String getCastTypeName(CifType type) {
        if (type instanceof BoolType) {
            return "Bool";
        }
        if (type instanceof IntType) {
            return "Int";
        }
        if (type instanceof RealType) {
            return "Real";
        }
        throw new RuntimeException("Unexpected type in cast name conversion: " + Strings.str((Object)type));
    }

    @Override
    protected ExprCode convertCastExpression(CifType exprType, CifType childType, Expression child, Destination dest, CodeContext ctxt) {
        ExprCode childCode = ctxt.exprToTarget(child, null);
        ExprCode result = new ExprCode();
        result.add(childCode);
        if (exprType instanceof StringType) {
            Object targetVar;
            if (dest == null) {
                VariableInformation tempVarInfo = ctxt.makeTempVariable(exprType, "str_dest");
                String destVarname = tempVarInfo.targetRef;
                result.setDataValue(C99DataValue.makeComputed(destVarname));
                targetVar = "&" + tempVarInfo.targetRef;
            } else {
                String destVarname = dest.getData();
                targetVar = dest.getReference();
            }
            String resultText = Strings.fmt((String)"%sToString(%s, %s);", (Object[])new Object[]{this.getCastTypeName(childType), childCode.getData(), targetVar});
            result.add(resultText);
            return result;
        }
        if (childType instanceof StringType) {
            TypeInfo childTi = ctxt.typeToTarget(childType);
            String childRef = C99DataValue.constructReference(childCode.getRawDataValue(), childTi, ctxt, result);
            String resultText = Strings.fmt((String)"StringTo%s(%s)", (Object[])new Object[]{this.getCastTypeName(exprType), childRef});
            result.setDestination(dest);
            result.setDataValue(C99DataValue.makeComputed(resultText));
            return result;
        }
        Assert.check((boolean)(exprType instanceof RealType));
        Assert.check((boolean)(childType instanceof IntType));
        String resultText = Strings.fmt((String)"(RealType)(%s)", (Object[])new Object[]{childCode.getData()});
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeComputed(resultText));
        return result;
    }

    @Override
    protected ExprCode convertIfExpression(IfExpression expr, Destination dest, CodeContext ctxt) {
        VariableInformation tempVarInfo = ctxt.makeTempVariable(expr.getType(), "if_dest");
        MemoryCodeBox code = ctxt.makeCodeBox();
        code.add(Strings.fmt((String)"%s %s;", (Object[])new Object[]{tempVarInfo.typeInfo.getTargetType(), tempVarInfo.targetRef}));
        IfElseGenerator ifElse = ctxt.getIfElseUpdateGenerator();
        ExprCode guards = this.predsToTarget((List<Expression>)expr.getGuards(), ctxt);
        ifElse.generateIf(guards, (CodeBox)code);
        ExprCode branchCode = ctxt.exprToTarget(expr.getThen(), ctxt.makeDestination(tempVarInfo));
        code.add((Box)branchCode.getCode());
        for (ElifExpression elif : expr.getElifs()) {
            guards = this.predsToTarget((List<Expression>)elif.getGuards(), ctxt);
            ifElse.generateElseIf(guards, (CodeBox)code);
            branchCode = ctxt.exprToTarget(elif.getThen(), ctxt.makeDestination(tempVarInfo));
            code.add((Box)branchCode.getCode());
        }
        ifElse.generateElse((CodeBox)code);
        branchCode = ctxt.exprToTarget(expr.getElse(), ctxt.makeDestination(tempVarInfo));
        code.add((Box)branchCode.getCode());
        ifElse.generateEndIf((CodeBox)code);
        ExprCode ifCode = new ExprCode();
        ifCode.add((CodeBox)code);
        ifCode.setDestination(dest);
        ifCode.setDataValue(C99DataValue.makeComputed(tempVarInfo.targetRef));
        return ifCode;
    }

    @Override
    protected ExprCode convertInternalFunctionCall(InternalFunction func, List<ExprCode> argsCode, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        for (ExprCode argCode : argsCode) {
            result.add(argCode);
        }
        StringBuilder callText = new StringBuilder();
        callText.append(ctxt.getFunctionName(func));
        callText.append('(');
        Assert.check((func.getParameters().size() == argsCode.size() ? 1 : 0) != 0);
        int arg = 0;
        while (arg < func.getParameters().size()) {
            DiscVariable param = ((FunctionParameter)func.getParameters().get(arg)).getParameter();
            TypeInfo paramTi = ctxt.typeToTarget(param.getType());
            ExprCode argCode = argsCode.get(arg);
            if (arg != 0) {
                callText.append(", ");
            }
            if (C99TypeInfoHelper.typeUsesValues(paramTi)) {
                callText.append(argCode.getData());
            } else {
                String refText = C99DataValue.constructReference(argCode.getRawDataValue(), paramTi, ctxt, result);
                callText.append(refText);
            }
            ++arg;
        }
        callText.append(')');
        CifType retType = CifTypeUtils.makeTupleType((List)func.getReturnTypes(), null);
        TypeInfo retTi = ctxt.typeToTarget(retType);
        boolean needsTemporary = dest == null ? !C99TypeInfoHelper.typeUsesValues(retTi) : false;
        if (needsTemporary) {
            VariableInformation tempVarInfo = ctxt.makeTempVariable(retType, "ret_val");
            result.add(Strings.fmt((String)"%s %s = %s;", (Object[])new Object[]{tempVarInfo.typeInfo.getTargetType(), tempVarInfo.targetRef, callText.toString()}));
            result.setDestination(dest);
            result.setDataValue(C99DataValue.makeValue(tempVarInfo.targetRef));
            return result;
        }
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeComputed(callText.toString()));
        return result;
    }

    @Override
    protected ExprCode convertConstantExpression(ConstantExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)expr.getConstant(), false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeValue(varInfo.targetRef));
        return result;
    }

    @Override
    public ExprCode convertDiscVariableExpression(DiscVariable discVar, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)discVar, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeValue(varInfo.targetRef));
        return result;
    }

    @Override
    protected ExprCode convertAlgVariableExpression(AlgVariable algVar, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)algVar, false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        if (varInfo.isTempVar) {
            String resultText = varInfo.targetRef;
            result.setDataValue(C99DataValue.makeValue(resultText));
        } else {
            String resultText = Strings.fmt((String)"%s()", (Object[])new Object[]{varInfo.targetRef});
            result.setDataValue(C99DataValue.makeComputed(resultText));
        }
        result.setDestination(dest);
        return result;
    }

    @Override
    protected ExprCode convertContVariableExpression(ContVariable contVar, boolean isDerivative, Destination dest, CodeContext ctxt) {
        VariableWrapper var = new VariableWrapper((Declaration)contVar, isDerivative);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        String varName = varInfo.targetRef;
        ExprCode result = new ExprCode();
        result.setDestination(dest);
        if (!varInfo.isTempVar && isDerivative) {
            String resultText = Strings.fmt((String)"%sderiv()", (Object[])new Object[]{varName});
            result.setDataValue(C99DataValue.makeComputed(resultText));
        } else {
            result.setDataValue(C99DataValue.makeValue(varName));
        }
        return result;
    }

    @Override
    protected ExprCode convertInputVariableExpression(InputVariableExpression expr, Destination dest, CodeContext ctxt) {
        ExprCode result = new ExprCode();
        VariableWrapper var = new VariableWrapper((Declaration)expr.getVariable(), false);
        VariableInformation varInfo = ctxt.getReadVarInfo(var);
        result.setDestination(dest);
        result.setDataValue(C99DataValue.makeValue(varInfo.targetRef));
        return result;
    }
}

