/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class TriangleDistribution
extends DoubleDistribution {
    private RandomGenerator randGen;
    private double a;
    private double b;
    private double c;

    public TriangleDistribution(ChiCoordinator chiCoordinator, double a, double b, double c) {
        super(chiCoordinator);
        if (a >= b) {
            String msg = Strings.fmt((String)"The Triangle distribution expects the left bound to be less than the top, found %s for left and %s for top instead.", (Object[])new Object[]{a, b});
            throw new ChiSimulatorException(msg);
        }
        if (b >= c) {
            String msg = Strings.fmt((String)"The Triangle distribution expects the top to be less than the right bound, found %s for top and %s for right instead.", (Object[])new Object[]{b, c});
            throw new ChiSimulatorException(msg);
        }
        this.a = a;
        this.b = b;
        this.c = c;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return TriangleDistribution.drawTriangle(this.randGen, this.a, this.b, this.c);
    }

    public static double drawTriangle(RandomGenerator randGen, double a, double b, double c) {
        double beta = (b - a) / (c - a);
        double u = randGen.draw();
        double t = u < beta ? Math.sqrt(beta * u) : 1.0 - Math.sqrt((1.0 - beta) * (1.0 - u));
        return a + (c - a) * t;
    }
}

