/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.scopes;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.AlgParameter;
import org.eclipse.escet.cif.metamodel.cif.ComponentDef;
import org.eclipse.escet.cif.metamodel.cif.ComponentInst;
import org.eclipse.escet.cif.metamodel.cif.ComponentParameter;
import org.eclipse.escet.cif.metamodel.cif.EventParameter;
import org.eclipse.escet.cif.metamodel.cif.LocationParameter;
import org.eclipse.escet.cif.metamodel.cif.Parameter;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.ComponentDefType;
import org.eclipse.escet.cif.parser.ast.ACompInstDecl;
import org.eclipse.escet.cif.parser.ast.expressions.AExpression;
import org.eclipse.escet.cif.parser.ast.tokens.AName;
import org.eclipse.escet.cif.typechecker.CheckStatus;
import org.eclipse.escet.cif.typechecker.CifAnnotationsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.ExprContext;
import org.eclipse.escet.cif.typechecker.SymbolTableEntry;
import org.eclipse.escet.cif.typechecker.scopes.AutDefScope;
import org.eclipse.escet.cif.typechecker.scopes.GroupDefScope;
import org.eclipse.escet.cif.typechecker.scopes.ParentScope;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.TextBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Numbers;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CompInstScope
extends SymbolScope<ComponentInst> {
    private static final ExprContext EVT_REF_CTXT = ExprContext.DEFAULT_CTXT.add(ExprContext.Condition.ALLOW_EVENT);
    private final ACompInstDecl compInstDecl;
    private ParentScope<?> compDefScope;

    public CompInstScope(ComponentInst obj, ACompInstDecl compInstDecl, ParentScope<?> parent, CifTypeChecker tchecker) {
        super(obj, parent, tchecker);
        this.compInstDecl = compInstDecl;
    }

    public ParentScope<?> getCompDefScope() {
        Assert.notNull(this.compDefScope);
        return this.compDefScope;
    }

    @Override
    protected boolean isSubScope() {
        return true;
    }

    @Override
    protected boolean isRootScope() {
        return false;
    }

    @Override
    public String getName() {
        return ((ComponentInst)this.obj).getName();
    }

    @Override
    public String getAbsName() {
        return CifTextUtils.getAbsName((PositionObject)this.obj);
    }

    @Override
    public String getAbsText() {
        this.tcheckForUse();
        if (this.compDefScope instanceof AutDefScope) {
            return Strings.fmt((String)"automaton \"%s\"", (Object[])new Object[]{this.getAbsName()});
        }
        if (this.compDefScope instanceof GroupDefScope) {
            return Strings.fmt((String)"group \"%s\"", (Object[])new Object[]{this.getAbsName()});
        }
        throw new RuntimeException("Unknown comp def: " + String.valueOf(this.compDefScope));
    }

    public Box toBox() {
        return new TextBox(Strings.fmt((String)"[ compinst scope \"%s\" for: %s ]", (Object[])new Object[]{this.getName(), this.obj}));
    }

    @Override
    public void tcheckForUseImpl() {
        this.checkName();
        this.tchecker.addToCycle(this);
        try {
            AName compDefRef = this.compInstDecl.defName;
            SymbolTableEntry entry = this.parent.resolve(compDefRef.position, compDefRef.name, this.tchecker, this.parent);
            if (!(entry instanceof AutDefScope) && !(entry instanceof GroupDefScope)) {
                this.tchecker.addProblem(ErrMsg.RESOLVE_NOT_COMP_DEF, compDefRef.position, entry.getAbsName());
                throw new SemanticException();
            }
            this.compDefScope = (ParentScope)entry;
            CifType compdef = this.parent.resolveAsType(compDefRef.name, compDefRef.position, "", this.tchecker);
            ((ComponentInst)this.obj).setDefinition(compdef);
            if (!(compdef instanceof ComponentDefType)) {
                this.tchecker.addProblem(ErrMsg.COMP_INST_DEF_NOT_IN_SCOPE, compDefRef.position, this.compDefScope.getAbsName());
                throw new SemanticException();
            }
        }
        finally {
            this.tchecker.removeFromCycle(this);
        }
        this.status = CheckStatus.USE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tcheckFull() {
        this.tcheckForUse();
        if (this.isCheckedFull()) {
            return;
        }
        if (this.compDefScope instanceof AutDefScope) {
            ((AutDefScope)this.compDefScope).tcheckFullParams();
        } else if (this.compDefScope instanceof GroupDefScope) {
            ((GroupDefScope)this.compDefScope).tcheckFullParams();
        } else {
            String msg = "Unknown component def scope: " + String.valueOf(this.compDefScope);
            throw new RuntimeException(msg);
        }
        ComponentDef compDef = (ComponentDef)this.compDefScope.obj;
        int argCountInst = this.compInstDecl.arguments.size();
        int paramCountDef = compDef.getParameters().size();
        if (argCountInst != paramCountDef) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_COUNT, this.compInstDecl.defName.position, String.valueOf(argCountInst), this.getAbsName(), String.valueOf(paramCountDef), CifTextUtils.getAbsName((PositionObject)compDef));
            throw new SemanticException();
        }
        EList args = ((ComponentInst)this.obj).getArguments();
        int i = 0;
        while (i < argCountInst) {
            CifType argHint;
            String paramIdxTxt = Numbers.toOrdinal((int)(i + 1));
            Parameter param = (Parameter)compDef.getParameters().get(i);
            if (param instanceof AlgParameter) {
                argHint = ((AlgParameter)param).getVariable().getType();
            } else if (param instanceof EventParameter) {
                argHint = CifExprsTypeChecker.BOOL_TYPE_HINT;
            } else if (param instanceof LocationParameter) {
                argHint = CifExprsTypeChecker.BOOL_TYPE_HINT;
            } else if (param instanceof ComponentParameter) {
                argHint = ((ComponentParameter)param).getType();
            } else {
                throw new RuntimeException("Unknown param: " + String.valueOf(param));
            }
            ExprContext context = param instanceof EventParameter ? EVT_REF_CTXT : ExprContext.DEFAULT_CTXT;
            AExpression astArg = (AExpression)this.compInstDecl.arguments.get(i);
            Expression arg = CifExprsTypeChecker.transExpression(astArg, argHint, this.parent, context, this.tchecker);
            args.add(arg);
            Parameter parameter = param;
            if (parameter instanceof AlgParameter) {
                void algParam;
                AlgParameter cfr_ignored_0 = (AlgParameter)parameter;
                AlgParameter cfr_ignored_1 = (AlgParameter)parameter;
                EventParameter paramType = algParam.getVariable().getType();
                CifType argType = arg.getType();
                if (!CifTypeUtils.checkTypeCompat((CifType)paramType, (CifType)argType, (RangeCompat)RangeCompat.CONTAINED)) {
                    this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_ALG_TYPES, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)algParam.getVariable().getName()), CifTextUtils.getAbsName((PositionObject)compDef), CifTextUtils.typeToStr((CifType)paramType), CifTextUtils.getAbsName((PositionObject)this.obj), CifTextUtils.typeToStr((CifType)argType));
                }
            } else {
                Parameter parameter2 = param;
                if (parameter2 instanceof EventParameter) {
                    EventParameter cfr_ignored_2 = (EventParameter)parameter2;
                    EventParameter cfr_ignored_3 = (EventParameter)parameter2;
                    LocationParameter unwrap = CifTypeUtils.unwrapExpression((Expression)arg);
                    if (!(unwrap instanceof EventExpression)) {
                        void evtParam;
                        String requiredTxt = "an event";
                        this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_TYPE, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)evtParam.getEvent().getName()), CifTextUtils.getAbsName((PositionObject)compDef), requiredTxt, CifTextUtils.getAbsName((PositionObject)this.obj), requiredTxt);
                        throw new SemanticException();
                    }
                    Event paramEvent = ((EventParameter)param).getEvent();
                    Event argEvent = ((EventExpression)unwrap).getEvent();
                    Boolean paramContr = paramEvent.getControllable();
                    Boolean argContr = argEvent.getControllable();
                    if (paramContr != null && !paramContr.equals(argContr)) {
                        String paramContrText = paramContr != false ? "a \"controllable\"" : "an \"uncontrollable\"";
                        this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_CONTR_MISMATCH, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)paramEvent.getName()), CifTextUtils.getAbsName((PositionObject)compDef), paramContrText, CifTextUtils.getAbsName((PositionObject)this.obj), CompInstScope.controllableToStr(argContr));
                    }
                    CifType paramType = paramEvent.getType();
                    CifType argType = argEvent.getType();
                    if (paramType != null && argType == null) {
                        String paramTxt = Strings.fmt((String)"of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)paramType)});
                        String argTxt = "has no type";
                        this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_EVENT_TYPES, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)paramEvent.getName()), CifTextUtils.getAbsName((PositionObject)compDef), paramTxt, CifTextUtils.getAbsName((PositionObject)this.obj), argTxt);
                    }
                    if (paramType != null && argType != null && !CifTypeUtils.checkTypeCompat((CifType)paramEvent.getType(), (CifType)argEvent.getType(), (RangeCompat)RangeCompat.EQUAL)) {
                        this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_EVENT_TYPES, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)paramEvent.getName()), CifTextUtils.getAbsName((PositionObject)compDef), Strings.fmt((String)"of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)paramType)}), CifTextUtils.getAbsName((PositionObject)this.obj), Strings.fmt((String)"is of type \"%s\"", (Object[])new Object[]{CifTextUtils.typeToStr((CifType)argType)}));
                    }
                    EventParameter paramParam = (EventParameter)param;
                    EventParameter argParam = null;
                    if (argEvent.eContainer() instanceof EventParameter) {
                        argParam = (EventParameter)argEvent.eContainer();
                    }
                    if (argParam != null) {
                        this.checkEventUsage(paramParam, argParam, astArg.position, paramIdxTxt, compDef);
                    }
                } else {
                    Parameter parameter3 = param;
                    if (parameter3 instanceof LocationParameter) {
                        LocationParameter cfr_ignored_4 = (LocationParameter)parameter3;
                        LocationParameter cfr_ignored_5 = (LocationParameter)parameter3;
                        Expression unwrap = CifTypeUtils.unwrapExpression((Expression)arg);
                        if (!(unwrap instanceof LocationExpression)) {
                            void locParam;
                            String requiredTxt = "a location";
                            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_TYPE, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)locParam.getLocation().getName()), CifTextUtils.getAbsName((PositionObject)compDef), requiredTxt, CifTextUtils.getAbsName((PositionObject)this.obj), requiredTxt);
                        }
                    } else if (param instanceof ComponentParameter) {
                        CifType argType;
                        CifType paramType = ((ComponentParameter)param).getType();
                        if (!CifTypeUtils.checkTypeCompat((CifType)paramType, (CifType)(argType = arg.getType()), null)) {
                            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_COMP_TYPES, arg.getPosition(), paramIdxTxt, CifTextUtils.escapeIdentifier((String)((ComponentParameter)param).getName()), CifTextUtils.getAbsName((PositionObject)compDef), CifTextUtils.typeToStr((CifType)paramType), CifTextUtils.getAbsName((PositionObject)this.obj), CifTextUtils.typeToStr((CifType)argType));
                        }
                    } else {
                        throw new RuntimeException("Unknown param: " + String.valueOf(param));
                    }
                }
            }
            ++i;
        }
        List<Annotation> annos = CifAnnotationsTypeChecker.transAnnotations(this.compInstDecl.annotations, this.getParent(), this.tchecker);
        ((ComponentInst)this.obj).getAnnotations().addAll(annos);
        this.status = CheckStatus.FULL;
    }

    private void checkEventUsage(EventParameter param, EventParameter arg, TextPosition position, String paramIdxTxt, ComponentDef compDef) {
        boolean paramSend = CifEventUtils.eventParamSupportsSend((EventParameter)param);
        boolean paramRecv = CifEventUtils.eventParamSupportsRecv((EventParameter)param);
        boolean paramSync = CifEventUtils.eventParamSupportsSync((EventParameter)param);
        boolean argSend = CifEventUtils.eventParamSupportsSend((EventParameter)arg);
        boolean argRecv = CifEventUtils.eventParamSupportsRecv((EventParameter)arg);
        boolean argSync = CifEventUtils.eventParamSupportsSync((EventParameter)arg);
        if (paramSend && !argSend) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.escapeIdentifier((String)param.getEvent().getName()), CifTextUtils.getAbsName((PositionObject)compDef), "send (!)", CifTextUtils.getAbsName((PositionObject)this.obj));
        }
        if (paramRecv && !argRecv) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.escapeIdentifier((String)param.getEvent().getName()), CifTextUtils.getAbsName((PositionObject)compDef), "receive (?)", CifTextUtils.getAbsName((PositionObject)this.obj));
        }
        if (paramSync && !argSync) {
            this.tchecker.addProblem(ErrMsg.COMP_INST_ARG_EVENT_FLAG, position, paramIdxTxt, CifTextUtils.escapeIdentifier((String)param.getEvent().getName()), CifTextUtils.getAbsName((PositionObject)compDef), "synchronization (~)", CifTextUtils.getAbsName((PositionObject)this.obj));
        }
    }

    public static String controllableToStr(Boolean controllable) {
        return controllable == null ? "(unspecified)" : (controllable != false ? "controllable" : "uncontrollable");
    }

    @Override
    protected SymbolTableEntry resolve1(TextPosition position, String id, String done, CifTypeChecker tchecker, SymbolScope<?> origScope) {
        this.tcheckForUse();
        if (done.isEmpty()) {
            throw new IllegalArgumentException("done");
        }
        if (origScope != null) {
            throw new IllegalArgumentException("origScope");
        }
        return this.compDefScope.resolve1(position, id, done, tchecker, origScope);
    }

    @Override
    public void detectCompDefInstCycles(List<ParentScope<?>> cycle) {
        this.compDefScope.detectCompDefInstCycles(cycle);
    }
}

