/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.model.functions;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.types.PlcAbstractType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcGenericType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public abstract class PlcBasicFuncDescription {
    public final PlcFuncOperation operation;
    public final String prefixFuncName;
    public final PlcParameterDescription[] parameters;
    public final EnumSet<PlcFuncNotation> notations;
    public final PlcAbstractType resultType;
    public final PlcFuncTypeExtension typeExtension;

    public PlcBasicFuncDescription(PlcFuncOperation operation, String prefixFuncName, PlcParameterDescription[] parameters, EnumSet<PlcFuncNotation> notations, PlcAbstractType resultType, PlcFuncTypeExtension typeExtension) {
        Assert.check((!notations.isEmpty() ? 1 : 0) != 0);
        long numUnique = Arrays.stream(parameters).map(param -> param.name).distinct().count();
        Assert.areEqual((Object)Math.toIntExact(numUnique), (Object)parameters.length);
        this.operation = operation;
        this.prefixFuncName = prefixFuncName;
        this.parameters = parameters;
        this.notations = notations;
        this.resultType = resultType;
        this.typeExtension = typeExtension;
    }

    public String getFuncName() {
        if (this.prefixFuncName == null) {
            return "prefix-N/A";
        }
        if (this.prefixFuncName.isEmpty()) {
            return "prefix-dont_use";
        }
        return "prefix-\"" + this.prefixFuncName + "\"";
    }

    /*
     * WARNING - void declaration
     */
    public PlcType deriveResultType(List<PlcNamedValue> argumentList) {
        PlcType concreteResultType;
        Map arguments = Maps.mapc((int)argumentList.size());
        for (PlcNamedValue arg2 : argumentList) {
            arguments.put(arg2.name, arg2);
        }
        Assert.check((!argumentList.isEmpty() ? 1 : 0) != 0);
        Assert.areEqual((Object)arguments.size(), (Object)argumentList.size());
        long paramMatches = Arrays.stream(this.parameters).filter(arg -> arguments.containsKey(arg.name)).count();
        Assert.areEqual((Object)Math.toIntExact(paramMatches), (Object)argumentList.size());
        Map genericTypeMap = Maps.map();
        PlcParameterDescription[] plcParameterDescriptionArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            PlcParameterDescription paramDesc = plcParameterDescriptionArray[n2];
            PlcNamedValue argument = (PlcNamedValue)arguments.get(paramDesc.name);
            if (argument != null) {
                if (paramDesc.type instanceof PlcType) {
                    Assert.areEqual((Object)paramDesc.type, (Object)argument.value.type, (Object)Strings.fmt((String)"Parameter type %s does not match argument type %s for argument \"%s\".", (Object[])new Object[]{paramDesc.type, argument.value.type, paramDesc.name}));
                } else {
                    PlcAbstractType plcAbstractType = paramDesc.type;
                    if (plcAbstractType instanceof PlcGenericType) {
                        void genericType;
                        PlcGenericType cfr_ignored_0 = (PlcGenericType)plcAbstractType;
                        PlcGenericType cfr_ignored_1 = (PlcGenericType)plcAbstractType;
                        Assert.check((boolean)genericType.checkMatch(argument.value.type), (Object)Strings.fmt((String)"Concrete type %s does not fit in generic type %s.", (Object[])new Object[]{argument.value.type, genericType}));
                        PlcType mappedType = genericTypeMap.computeIfAbsent(genericType, t -> plcNamedValue.value.type);
                        Assert.areEqual((Object)mappedType, (Object)argument.value.type);
                    } else {
                        throw new AssertionError((Object)("Unexpected parameter type found: " + String.valueOf(paramDesc.type)));
                    }
                }
            }
            ++n2;
        }
        PlcAbstractType plcAbstractType = this.resultType;
        if (plcAbstractType instanceof PlcGenericType) {
            void genericType;
            PlcGenericType plcGenericType = (PlcGenericType)plcAbstractType;
            PlcGenericType cfr_ignored_2 = (PlcGenericType)plcAbstractType;
            concreteResultType = (PlcType)genericTypeMap.get(genericType);
        } else {
            concreteResultType = (PlcType)this.resultType;
        }
        Assert.notNull((Object)concreteResultType);
        return concreteResultType;
    }

    public static enum ExprAssociativity {
        LEFT,
        RIGHT,
        NONE,
        ALWAYS;


        boolean needsParentheses(boolean atLeft, boolean atRight) {
            return this == ALWAYS || this == LEFT && !atLeft || this == RIGHT && !atRight;
        }
    }

    public static enum ExprBinding {
        UNARY_NEGATE,
        UNARY_NOT,
        BINARY_MUL,
        BINARY_DIV,
        BINARY_MOD,
        BINARY_SUB,
        BINARY_ADD,
        BINARY_LESS_THAN,
        BINARY_LESS_EQUAL,
        BINARY_GREATER_THAN,
        BINARY_GREATER_EQUAL,
        BINARY_EQUAL,
        BINARY_UNEQUAL,
        BINARY_AND,
        BINARY_XOR,
        BINARY_OR,
        NO_PRIORITY;


        public boolean needsParentheses(ExprBinding parentBinding, boolean atLeft, boolean atRight, PlcTarget target) {
            int thisPrio;
            int parentPrio = target.getExprPriority(parentBinding);
            if (parentPrio != (thisPrio = target.getExprPriority(this))) {
                return parentPrio < thisPrio;
            }
            return target.getExprAssociativity(parentBinding).needsParentheses(atLeft, atRight);
        }

        public boolean needsParentheses(ExprBinding parentBinding, PlcTarget target) {
            return this.needsParentheses(parentBinding, false, false, target);
        }
    }

    public static enum PlcFuncNotation {
        INFIX,
        INFORMAL,
        FORMAL;

        public static final EnumSet<PlcFuncNotation> UNSUPPORTED;
        public static final EnumSet<PlcFuncNotation> INFIX_ONLY;
        public static final EnumSet<PlcFuncNotation> INFORMAL_ONLY;
        public static final EnumSet<PlcFuncNotation> FORMAL_ONLY;
        public static final EnumSet<PlcFuncNotation> NOT_INFIX;
        public static final EnumSet<PlcFuncNotation> NOT_INFORMAL;
        public static final EnumSet<PlcFuncNotation> NOT_FORMAL;
        public static final EnumSet<PlcFuncNotation> ALL;

        static {
            UNSUPPORTED = EnumSet.noneOf(PlcFuncNotation.class);
            INFIX_ONLY = EnumSet.of(INFIX);
            INFORMAL_ONLY = EnumSet.of(INFORMAL);
            FORMAL_ONLY = EnumSet.of(FORMAL);
            NOT_INFIX = EnumSet.of(INFORMAL, FORMAL);
            NOT_INFORMAL = EnumSet.of(INFIX, FORMAL);
            NOT_FORMAL = EnumSet.of(INFIX, INFORMAL);
            ALL = EnumSet.allOf(PlcFuncNotation.class);
        }
    }

    public static enum PlcFuncTypeExtension {
        NEVER(t -> false),
        ELEMENTARY_NOT_BOOL(t -> t instanceof PlcElementaryType && t != PlcElementaryType.BOOL_TYPE);

        public final Predicate<PlcType> testFunction;

        private PlcFuncTypeExtension(Predicate<PlcType> testFunction) {
            this.testFunction = testFunction;
        }
    }

    public static enum PlcParamDirection {
        OUTPUT_ONLY,
        INPUT_OUTPUT,
        INPUT_ONLY;

    }

    public static class PlcParameterDescription {
        public final String name;
        public final PlcParamDirection direction;
        public final PlcAbstractType type;

        public PlcParameterDescription(String name, PlcParamDirection direction, PlcAbstractType type) {
            this.name = name;
            this.direction = direction;
            this.type = type;
        }

        public String toString() {
            return Strings.fmt((String)"PlcParameterDescription(\"%s\", %s)", (Object[])new Object[]{this.name, this.type});
        }
    }
}

