/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.types.PlcArrayType;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcEnumType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructField;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;

public class S7Writer
extends Writer {
    public S7Writer(PlcTarget target) {
        super(target);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(PlcProject project, PathPair outPaths) {
        this.ensureDirectory(outPaths);
        Assert.areEqual((Object)project.configurations.size(), (Object)1);
        PlcConfiguration config = project.configurations.get(0);
        Assert.areEqual((Object)config.resources.size(), (Object)1);
        PlcResource resource = config.resources.get(0);
        for (PlcGlobalVarList globalVarList : resource.globalVarLists) {
            if (globalVarList.variables.isEmpty()) continue;
            if (globalVarList.listKind == PlcGlobalVarList.PlcVarListKind.TIMERS) {
                this.writeTimers(globalVarList.variables, outPaths);
                continue;
            }
            this.writeGlobalVarList(globalVarList, outPaths);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outPaths);
        }
        int programCount = 0;
        for (PlcPou pou : project.pous) {
            if (pou.pouType != PlcPouType.PROGRAM) continue;
            ++programCount;
            if (pou.localVars.isEmpty()) continue;
            this.writeDatabase(pou.localVars, outPaths);
        }
        Assert.areEqual((Object)programCount, (Object)1);
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            PlcDeclaredType plcDeclaredType = declaredType;
            if (plcDeclaredType instanceof PlcStructType) {
                void structType;
                PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
                PlcStructType cfr_ignored_1 = (PlcStructType)plcDeclaredType;
                this.writeDeclaredType((PlcStructType)structType, outPaths);
                continue;
            }
            PlcDeclaredType plcDeclaredType2 = declaredType;
            if (plcDeclaredType2 instanceof PlcEnumType) {
                void enumType;
                PlcEnumType cfr_ignored_2 = (PlcEnumType)plcDeclaredType2;
                PlcEnumType cfr_ignored_3 = (PlcEnumType)plcDeclaredType2;
                this.writeDeclaredType((PlcEnumType)enumType, outPaths);
                continue;
            }
            throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
        }
    }

    private void write(PlcPou pou, PathPair outPaths) {
        String fileName = pou.name + ".scl";
        Box code = this.toBox(pou);
        this.writeFile(code, outPaths, fileName);
    }

    /*
     * Unable to fully structure code
     */
    private void writeTimers(List<PlcDataVariable> timerVariables, PathPair outPaths) {
        c = new MemoryCodeBox(4);
        hasIecTimers = this.hasIecTimers();
        for (PlcDataVariable timerVar : timerVariables) {
            var8_8 = timerVar.type;
            if (!(var8_8 instanceof PlcFuncBlockType)) ** GOTO lbl-1000
            (PlcFuncBlockType)var8_8;
            (PlcFuncBlockType)var8_8;
            if (blockType.funcBlockDescription.typeName.equals("TON")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            Assert.check((boolean)v0);
            c.add("DATA_BLOCK \"%s\"", new Object[]{timerVar.varName});
            c.add("{InstructionName := '%s';", new Object[]{hasIecTimers != false ? "IEC_TIMER" : "TON"});
            c.add("LibVersion := '1.0';");
            c.add("S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
            c.add("AUTHOR : Simatic");
            c.add("FAMILY : %s", new Object[]{hasIecTimers != false ? "IEC" : "IEC_TC"});
            c.add("NAME : %s", new Object[]{hasIecTimers != false ? "IEC_TMR" : "TON"});
            c.add("VERSION : 1.0");
            c.add("NON_RETAIN");
            c.add("%s", new Object[]{hasIecTimers != false ? "IEC_TIMER" : "TON"});
            c.add();
            c.add("BEGIN");
            c.add();
            c.add("END_DATA_BLOCK");
            c.add();
        }
        this.writeFile((Box)c, outPaths, "timers.db");
    }

    private boolean hasIecTimers() {
        return EnumSet.of(PlcTargetType.S7_1200, PlcTargetType.S7_1500).contains((Object)this.target.getTargetType());
    }

    private void writeDeclaredType(PlcStructType structType, PathPair outPaths) {
        String fileName = structType.typeName + ".udt";
        Box code = this.toTypeDeclBox(structType);
        this.writeFile(code, outPaths, fileName);
    }

    private void writeDeclaredType(PlcEnumType enumType, PathPair outPaths) {
        String fileName = enumType.typeName + ".udt";
        Box code = this.toTypeDeclBox(enumType);
        this.writeFile(code, outPaths, fileName);
    }

    private void writeGlobalVarList(PlcGlobalVarList gvl, PathPair outPaths) {
        String fileName = gvl.name + ".xml";
        Box code = this.makeTagTable(gvl);
        this.writeFile(code, outPaths, fileName);
    }

    private void writeDatabase(List<PlcDataVariable> variables, PathPair outPaths) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("DATA_BLOCK \"DB\"");
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
        c.indent();
        this.writeVarTable((CodeBox)c, "VAR", variables, 0);
        c.dedent();
        c.add("BEGIN");
        c.indent();
        ModelTextGenerator modelTextGenerator = this.target.getModelTextGenerator();
        for (PlcDataVariable var : variables) {
            if (var.value == null) continue;
            c.add("%s := %s;", new Object[]{var.varName, modelTextGenerator.toString(var.value)});
        }
        c.dedent();
        c.add("END_DATA_BLOCK");
        this.writeFile((Box)c, outPaths, "DB.db");
    }

    private boolean hasOptimizedBlockAccess() {
        return EnumSet.of(PlcTargetType.S7_1200, PlcTargetType.S7_1500).contains((Object)this.target.getTargetType());
    }

    @Override
    protected Box toVarDeclBox(PlcGlobalVarList globVarList) {
        throw new UnsupportedOperationException("Should not be used.");
    }

    private Box makeTagTable(PlcGlobalVarList globVarList) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        c.add("<?xml version='1.0' encoding='utf-8'?>");
        c.add("<Tagtable name='%s'>", new Object[]{globVarList.name});
        c.indent();
        if (globVarList.listKind == PlcGlobalVarList.PlcVarListKind.CONSTANTS) {
            ModelTextGenerator modelTextGenerator = this.target.getModelTextGenerator();
            for (PlcDataVariable constant : globVarList.variables) {
                c.add("<Constant type='%s' remark='' value='%s'>%s</Constant>", new Object[]{this.toTypeRefBox(constant.type), modelTextGenerator.literalToString(constant.value), constant.varName});
            }
        } else {
            for (PlcDataVariable var : globVarList.variables) {
                c.add("<Tag type='%s' hmiVisible='True' hmiWriteable='False' hmiAccessible='True' retain='False' remark='' addr='%s'>%s</Tag>", new Object[]{this.toTypeRefBox(var.type), var.address, var.varName});
            }
        }
        c.dedent();
        c.add("</Tagtable>");
        return c;
    }

    @Override
    protected Box toBox(PlcPou pou) {
        MemoryCodeBox c = new MemoryCodeBox(4);
        String pouTypeText = switch (pou.pouType) {
            case PlcPouType.FUNCTION -> "FUNCTION";
            case PlcPouType.PROGRAM -> "ORGANIZATION_BLOCK";
            default -> throw new RuntimeException("Unknown pou type: " + String.valueOf((Object)pou.pouType));
        };
        String retTypeTxt = pou.retType == null ? "" : Strings.fmt((String)": %s", (Object[])new Object[]{this.toTypeRefBox(pou.retType)});
        c.add("%s %s%s", new Object[]{pouTypeText, pou.name, retTypeTxt});
        c.add("{ S7_Optimized_Access := '%b' }", new Object[]{this.hasOptimizedBlockAccess()});
        c.indent();
        if (!pou.inputVars.isEmpty()) {
            this.writeVarTable((CodeBox)c, "VAR_INPUT", pou.inputVars, 0);
        }
        if (!pou.inOutVars.isEmpty()) {
            this.writeVarTable((CodeBox)c, "VAR_IN_OUT", pou.inOutVars, 0);
        }
        if (!pou.outputVars.isEmpty()) {
            Assert.areEqual((Object)((Object)pou.pouType), (Object)((Object)PlcPouType.FUNCTION));
            this.writeVarTable((CodeBox)c, "VAR_OUTPUT", pou.outputVars, 0);
        }
        Assert.check((pou.pouType != PlcPouType.FUNCTION || pou.localVars.isEmpty() ? 1 : 0) != 0);
        if (!pou.tempVars.isEmpty()) {
            this.writeVarTable((CodeBox)c, "VAR_TEMP", pou.tempVars, 20);
        }
        c.dedent();
        c.add();
        c.add("BEGIN");
        c.indent();
        if (!pou.body.isEmpty()) {
            c.add((Box)pou.body);
        }
        c.dedent();
        c.add("END_%s", new Object[]{pouTypeText});
        return c;
    }

    private void writeVarTable(CodeBox c, String headerText, List<PlcDataVariable> variables, int minByteSize) {
        PlcElementaryType typeOfDummies = PlcElementaryType.DINT_TYPE;
        Assert.check((typeOfDummies.bitSize > 0 ? 1 : 0) != 0);
        Assert.check((minByteSize == 0 || headerText.equals("VAR_TEMP") ? 1 : 0) != 0);
        Assert.check((minByteSize <= 20 ? 1 : 0) != 0);
        int remainingBitSize = minByteSize * 8;
        c.add(headerText);
        c.indent();
        for (PlcDataVariable var : variables) {
            c.add("%s: %s;", new Object[]{var.varName, this.toTypeRefBox(var.type)});
            remainingBitSize -= S7Writer.guessTypeSize(var.type);
        }
        int dummyNum = 1;
        while (remainingBitSize > 0 && dummyNum < 6) {
            String dummyName = "dummyVar" + dummyNum;
            c.add("%s: %s;", new Object[]{dummyName, this.toTypeRefBox(typeOfDummies)});
            remainingBitSize -= typeOfDummies.bitSize;
            ++dummyNum;
        }
        c.dedent();
        c.add("END_VAR");
    }

    /*
     * WARNING - void declaration
     */
    private static int guessTypeSize(PlcType type) {
        PlcType plcType = type;
        if (plcType instanceof PlcElementaryType) {
            void elemType;
            PlcElementaryType plcElementaryType = (PlcElementaryType)plcType;
            PlcElementaryType cfr_ignored_0 = (PlcElementaryType)plcType;
            return elemType.bitSize;
        }
        PlcType plcType2 = type;
        if (plcType2 instanceof PlcStructType) {
            void strType;
            PlcStructType plcStructType = (PlcStructType)plcType2;
            PlcStructType cfr_ignored_1 = (PlcStructType)plcType2;
            int totalSize = 0;
            for (PlcStructField field : strType.fields) {
                totalSize += S7Writer.guessTypeSize(field.type);
            }
            return totalSize;
        }
        PlcType plcType3 = type;
        if (plcType3 instanceof PlcArrayType) {
            void arrType;
            PlcArrayType totalSize = (PlcArrayType)plcType3;
            PlcArrayType cfr_ignored_2 = (PlcArrayType)plcType3;
            int elementSize = S7Writer.guessTypeSize(arrType.elemType);
            return elementSize * (arrType.upper - arrType.lower + 1);
        }
        return 0;
    }
}

