/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifAnnotationUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.StringType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ExprNoSpecificBinaryExprsCheck
extends CifCheck {
    private final EnumSet<NoSpecificBinaryOp> disalloweds;
    private boolean ignoreAnnotations;

    public ExprNoSpecificBinaryExprsCheck(NoSpecificBinaryOp ... disalloweds) {
        this(EnumSet.copyOf(Arrays.asList(disalloweds)));
    }

    public ExprNoSpecificBinaryExprsCheck(EnumSet<NoSpecificBinaryOp> disalloweds) {
        this.disalloweds = disalloweds;
    }

    public ExprNoSpecificBinaryExprsCheck ignoreAnnotations() {
        return this.ignoreAnnotations(true);
    }

    public ExprNoSpecificBinaryExprsCheck ignoreAnnotations(boolean ignore) {
        this.ignoreAnnotations = ignore;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    protected void preprocessBinaryExpression(BinaryExpression binExpr, CifCheckViolations violations) {
        if (this.ignoreAnnotations && CifAnnotationUtils.isObjInAnnotation((EObject)binExpr)) {
            return;
        }
        BinaryOperator op = binExpr.getOperator();
        CifType ltype = CifTypeUtils.normalizeType((CifType)binExpr.getLeft().getType());
        CifType rtype = CifTypeUtils.normalizeType((CifType)binExpr.getRight().getType());
        switch (op) {
            case ADDITION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_REALS) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, "a real typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, "a list typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_STRINGS) && (ltype instanceof StringType || rtype instanceof StringType)) {
                    this.addExprViolationOperand(binExpr, "a string typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.ADDITION_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, "a dictionary typed", violations);
                break;
            }
            case BI_CONDITIONAL: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.BI_CONDITIONAL)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case CONJUNCTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.CONJUNCTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.CONJUNCTION_SETS) || !(ltype instanceof SetType) && !(rtype instanceof SetType)) break;
                this.addExprViolationOperand(binExpr, "a set typed", violations);
                break;
            }
            case DISJUNCTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.DISJUNCTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.DISJUNCTION_SETS) || !(ltype instanceof SetType) && !(rtype instanceof SetType)) break;
                this.addExprViolationOperand(binExpr, "a set typed", violations);
                break;
            }
            case DIVISION: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.DIVISION)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case ELEMENT_OF: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, "a list typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_SETS) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, "a set typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.ELEMENT_OF_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, "a dictionary typed", violations);
                break;
            }
            case EQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_BOOL) && (ltype instanceof BoolType || rtype instanceof BoolType)) {
                    this.addExprViolationOperand(binExpr, "a boolean typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_DICT) && (ltype instanceof DictType || rtype instanceof DictType)) {
                    this.addExprViolationOperand(binExpr, "a dictionary typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_ENUM) && (ltype instanceof EnumType || rtype instanceof EnumType)) {
                    this.addExprViolationOperand(binExpr, "an enumeration typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_INT)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_INT_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_INT_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_LIST)) {
                    if (ltype instanceof ListType || rtype instanceof ListType) {
                        this.addExprViolationOperand(binExpr, "a list typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_LIST_ARRAY) && (ltype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)ltype)) || rtype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "an array list typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_LIST_NON_ARRAY) && (ltype instanceof ListType && !CifTypeUtils.isArrayType((ListType)((ListType)ltype)) || rtype instanceof ListType && !CifTypeUtils.isArrayType((ListType)((ListType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a non-array list typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_REAL) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, "a real typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_SET) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, "a set typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_STRING) && (ltype instanceof StringType || rtype instanceof StringType)) {
                    this.addExprViolationOperand(binExpr, "a string typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.EQUAL_TUPLE) || !(ltype instanceof TupleType) && !(rtype instanceof TupleType)) break;
                this.addExprViolationOperand(binExpr, "a tuple typed", violations);
                break;
            }
            case GREATER_EQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_EQUAL_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, "a real typed", violations);
                break;
            }
            case GREATER_THAN: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.GREATER_THAN_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, "a real typed", violations);
                break;
            }
            case IMPLICATION: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.IMPLICATION)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case INTEGER_DIVISION: {
                void intType;
                CifType cifType;
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                    this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                    this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.INTEGER_DIVISION_NON_POSITIVE_DIVISOR) || !((cifType = rtype) instanceof IntType)) break;
                IntType intType2 = (IntType)cifType;
                IntType cfr_ignored_0 = (IntType)cifType;
                if (CifTypeUtils.getLowerBound((IntType)intType) >= 1) break;
                boolean alwaysNonPositive = CifTypeUtils.getUpperBound((IntType)intType) < 1;
                String operandTxt = Strings.fmt((String)"a %snon-positive divisor", (Object[])new Object[]{alwaysNonPositive ? "" : "possibly "});
                this.addExprViolationOperand(binExpr, operandTxt, violations);
                break;
            }
            case LESS_EQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_EQUAL_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, "a real typed", violations);
                break;
            }
            case LESS_THAN: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.LESS_THAN_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, "a real typed", violations);
                break;
            }
            case MODULUS: {
                CifType cifType;
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                    this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                    this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.MODULUS_NON_POSITIVE_DIVISOR) || !((cifType = rtype) instanceof IntType)) break;
                IntType intType = (IntType)cifType;
                IntType cfr_ignored_1 = (IntType)cifType;
                if (CifTypeUtils.getLowerBound((IntType)intType) >= 1) break;
                boolean alwaysNonPositive = CifTypeUtils.getUpperBound((IntType)intType) < 1;
                String operandTxt = Strings.fmt((String)"a %snon-positive divisor", (Object[])new Object[]{alwaysNonPositive ? "" : "possibly "});
                this.addExprViolationOperand(binExpr, operandTxt, violations);
                break;
            }
            case MULTIPLICATION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.MULTIPLICATION_REALS) || !(ltype instanceof RealType) && !(rtype instanceof RealType)) break;
                this.addExprViolationOperand(binExpr, "a real typed", violations);
                break;
            }
            case SUBSET: {
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBSET)) break;
                this.addExprViolationOperator(binExpr, violations);
                break;
            }
            case SUBTRACTION: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_INTS_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_REALS) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, "a real typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_LISTS) && (ltype instanceof ListType || rtype instanceof ListType)) {
                    this.addExprViolationOperand(binExpr, "a list typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_SETS) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, "a set typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.SUBTRACTION_DICTS) || !(ltype instanceof DictType) && !(rtype instanceof DictType)) break;
                this.addExprViolationOperand(binExpr, "a dictionary typed", violations);
                break;
            }
            case UNEQUAL: {
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL)) {
                    this.addExprViolationOperator(binExpr, violations);
                    break;
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_BOOL) && (ltype instanceof BoolType || rtype instanceof BoolType)) {
                    this.addExprViolationOperand(binExpr, "a boolean typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_DICT) && (ltype instanceof DictType || rtype instanceof DictType)) {
                    this.addExprViolationOperand(binExpr, "a dictionary typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_ENUM) && (ltype instanceof EnumType || rtype instanceof EnumType)) {
                    this.addExprViolationOperand(binExpr, "an enumeration typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_INT)) {
                    if (ltype instanceof IntType || rtype instanceof IntType) {
                        this.addExprViolationOperand(binExpr, "an integer typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_INT_RANGELESS) && (ltype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a rangeless integer typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_INT_RANGED) && (ltype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)ltype)) || rtype instanceof IntType && !CifTypeUtils.isRangeless((IntType)((IntType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a ranged integer typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_LIST)) {
                    if (ltype instanceof ListType || rtype instanceof ListType) {
                        this.addExprViolationOperand(binExpr, "a list typed", violations);
                    }
                } else {
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_LIST_ARRAY) && (ltype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)ltype)) || rtype instanceof ListType && CifTypeUtils.isArrayType((ListType)((ListType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "an array list typed", violations);
                    }
                    if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_LIST_NON_ARRAY) && (ltype instanceof ListType && !CifTypeUtils.isArrayType((ListType)((ListType)ltype)) || rtype instanceof ListType && !CifTypeUtils.isArrayType((ListType)((ListType)rtype)))) {
                        this.addExprViolationOperand(binExpr, "a non-array list typed", violations);
                    }
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_REAL) && (ltype instanceof RealType || rtype instanceof RealType)) {
                    this.addExprViolationOperand(binExpr, "a real typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_SET) && (ltype instanceof SetType || rtype instanceof SetType)) {
                    this.addExprViolationOperand(binExpr, "a set typed", violations);
                }
                if (this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_STRING) && (ltype instanceof StringType || rtype instanceof StringType)) {
                    this.addExprViolationOperand(binExpr, "a string typed", violations);
                }
                if (!this.disalloweds.contains((Object)NoSpecificBinaryOp.UNEQUAL_TUPLE) || !(ltype instanceof TupleType) && !(rtype instanceof TupleType)) break;
                this.addExprViolationOperand(binExpr, "a tuple typed", violations);
                break;
            }
            default: {
                throw new RuntimeException("Unknown binary operator: " + String.valueOf(op));
            }
        }
    }

    private void addExprViolationOperator(BinaryExpression binExpr, CifCheckViolations violations) {
        violations.add((PositionObject)binExpr, "Binary operator \"%s\" is used", CifTextUtils.operatorToStr((BinaryOperator)binExpr.getOperator()));
    }

    private void addExprViolationOperand(BinaryExpression binExpr, String operandTxt, CifCheckViolations violations) {
        violations.add((PositionObject)binExpr, "Binary operator \"%s\" is used on %s operand", CifTextUtils.operatorToStr((BinaryOperator)binExpr.getOperator()), operandTxt);
    }

    public static enum NoSpecificBinaryOp {
        ADDITION,
        ADDITION_INTS,
        ADDITION_INTS_RANGED,
        ADDITION_INTS_RANGELESS,
        ADDITION_REALS,
        ADDITION_LISTS,
        ADDITION_STRINGS,
        ADDITION_DICTS,
        BI_CONDITIONAL,
        CONJUNCTION,
        CONJUNCTION_SETS,
        DISJUNCTION,
        DISJUNCTION_SETS,
        DIVISION,
        ELEMENT_OF,
        ELEMENT_OF_LISTS,
        ELEMENT_OF_SETS,
        ELEMENT_OF_DICTS,
        EQUAL,
        EQUAL_BOOL,
        EQUAL_DICT,
        EQUAL_ENUM,
        EQUAL_INT,
        EQUAL_INT_RANGED,
        EQUAL_INT_RANGELESS,
        EQUAL_LIST,
        EQUAL_LIST_ARRAY,
        EQUAL_LIST_NON_ARRAY,
        EQUAL_REAL,
        EQUAL_SET,
        EQUAL_STRING,
        EQUAL_TUPLE,
        GREATER_EQUAL,
        GREATER_EQUAL_INTS,
        GREATER_EQUAL_INTS_RANGED,
        GREATER_EQUAL_INTS_RANGELESS,
        GREATER_EQUAL_REALS,
        GREATER_THAN,
        GREATER_THAN_INTS,
        GREATER_THAN_INTS_RANGED,
        GREATER_THAN_INTS_RANGELESS,
        GREATER_THAN_REALS,
        IMPLICATION,
        INTEGER_DIVISION,
        INTEGER_DIVISION_INTS_RANGED,
        INTEGER_DIVISION_INTS_RANGELESS,
        INTEGER_DIVISION_NON_POSITIVE_DIVISOR,
        LESS_EQUAL,
        LESS_EQUAL_INTS,
        LESS_EQUAL_INTS_RANGED,
        LESS_EQUAL_INTS_RANGELESS,
        LESS_EQUAL_REALS,
        LESS_THAN,
        LESS_THAN_INTS,
        LESS_THAN_INTS_RANGED,
        LESS_THAN_INTS_RANGELESS,
        LESS_THAN_REALS,
        MODULUS,
        MODULUS_INTS_RANGED,
        MODULUS_INTS_RANGELESS,
        MODULUS_NON_POSITIVE_DIVISOR,
        MULTIPLICATION,
        MULTIPLICATION_INTS,
        MULTIPLICATION_INTS_RANGED,
        MULTIPLICATION_INTS_RANGELESS,
        MULTIPLICATION_REALS,
        SUBSET,
        SUBTRACTION,
        SUBTRACTION_INTS,
        SUBTRACTION_INTS_RANGED,
        SUBTRACTION_INTS_RANGELESS,
        SUBTRACTION_REALS,
        SUBTRACTION_LISTS,
        SUBTRACTION_SETS,
        SUBTRACTION_DICTS,
        UNEQUAL,
        UNEQUAL_BOOL,
        UNEQUAL_DICT,
        UNEQUAL_ENUM,
        UNEQUAL_INT,
        UNEQUAL_INT_RANGED,
        UNEQUAL_INT_RANGELESS,
        UNEQUAL_LIST,
        UNEQUAL_LIST_ARRAY,
        UNEQUAL_LIST_NON_ARRAY,
        UNEQUAL_REAL,
        UNEQUAL_SET,
        UNEQUAL_STRING,
        UNEQUAL_TUPLE;

    }
}

