/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifMath;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class SpecNoTooManyPossibleInitialStatesCheck
extends CifCheckNoCompDefInst {
    private double count = 1.0;
    private boolean isPrecise = true;

    protected void preprocessDiscVariable(DiscVariable discVar, CifCheckViolations violations) {
        CifValueUtils.Count varCount = CifValueUtils.getPossibleInitialValuesCount((DiscVariable)discVar);
        this.count *= varCount.value();
        this.isPrecise &= varCount.isPrecise();
    }

    protected void preprocessInputVariable(InputVariable inputVar, CifCheckViolations violations) {
        this.count *= CifValueUtils.getPossibleInitialValuesCount((InputVariable)inputVar);
    }

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        CifValueUtils.Count autCount = CifValueUtils.getPossibleInitialLocationsCount((Automaton)aut);
        this.count *= autCount.value();
        this.isPrecise &= autCount.isPrecise();
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        if (this.count > 2.147483647E9) {
            if (Double.isInfinite(this.count)) {
                violations.add((PositionObject)spec, "The specification has practically infinitely many possible initial states", new Object[0]);
            } else {
                Object countTxt = CifMath.realToStr((double)this.count);
                if (!this.isPrecise) {
                    countTxt = "approximately " + (String)countTxt;
                }
                violations.add((PositionObject)spec, "The specification has %s possible initial states, more than the maximum of 2,147,483,647", countTxt);
            }
        }
    }
}

