/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimAlgVariables;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimIfUpdates;
import org.eclipse.escet.cif.cif2cif.ElimTypeDecls;
import org.eclipse.escet.cif.cif2cif.LinearizeProduct;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2cif.SwitchesToIfs;
import org.eclipse.escet.cif.cif2mcrl2.CifToMcrl2PreChecker;
import org.eclipse.escet.cif.cif2mcrl2.ProcessValueActions;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEnumUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifMarkedUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumLiteral;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.VariableValue;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryOperator;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifToMcrl2Transformer {
    private final Termination termination;
    private final WarnOutput warnOutput;
    private Map<EnumDecl, EnumDecl> enums;
    private Map<DiscVariable, String> origVarNames;
    private Map<DiscVariable, String> origAutNames;

    public CifToMcrl2Transformer(Termination termination, WarnOutput warnOutput) {
        this.termination = termination;
        this.warnOutput = warnOutput;
    }

    public CodeBox transform(Specification spec, String absSpecPath, String valueActionPatterns, boolean addMarked) {
        this.preprocess1(spec);
        CifToMcrl2PreChecker checker = new CifToMcrl2PreChecker(this.termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF to mCRL2 transformation");
        List origVars = (List)CifCollectUtils.collectDiscVariables((ComplexComponent)spec, (Collection)Lists.list());
        this.origVarNames = origVars.stream().collect(Collectors.toMap(v -> v, v -> CifTextUtils.getAbsName((PositionObject)v, (boolean)false)));
        this.origAutNames = this.preprocess2(spec);
        this.enums = CifEnumUtils.getEnumDeclReprs((List)((List)CifCollectUtils.collectEnumDecls((ComplexComponent)spec, (Collection)Lists.list())));
        List vars = (List)CifCollectUtils.collectDiscVariables((ComplexComponent)spec, (Collection)Lists.list());
        List events = (List)CifCollectUtils.collectEvents((ComplexComponent)spec, (Collection)Lists.list());
        List linearizedAuts = (List)CifCollectUtils.collectAutomata((ComplexComponent)spec, (Collection)Lists.list());
        Assert.areEqual((Object)linearizedAuts.size(), (Object)1);
        Automaton aut = (Automaton)Lists.first((List)linearizedAuts);
        Assert.areEqual((Object)aut.getLocations().size(), (Object)1);
        Location loc = (Location)Lists.first((List)aut.getLocations());
        EList edges = loc.getEdges();
        Set<DiscVariable> valueActionVars = this.determineValueActionVars(vars, valueActionPatterns);
        Expression marked = addMarked ? this.getMarked(spec) : null;
        MemoryCodeBox code = new MemoryCodeBox();
        code.add("% Generated by CIF to mCRL2.");
        code.add();
        this.addSortsForEnums(code);
        this.addActionsForEvents(events, code);
        this.addVarValueActions(valueActionVars, code);
        if (addMarked) {
            this.addMarkedAction(code);
        }
        this.addProcess(vars, valueActionVars, (List<Edge>)edges, marked, code);
        this.addInstantiationForInit(vars, code);
        return code;
    }

    private void preprocess1(Specification spec) {
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        if (removeIoDecls.haveAnySvgInputDeclarationsBeenRemoved()) {
            this.warnOutput.line("The specification contains CIF/SVG input declarations. These will be ignored.");
        }
        new RemoveAnnotations().transform(spec);
        new ElimComponentDefInst().transform(spec);
        new SimplifyValues().transform(spec);
    }

    private Map<DiscVariable, String> preprocess2(Specification spec) {
        new ElimTypeDecls().transform(spec);
        new ElimConsts().transform(spec);
        new ElimAlgVariables().transform(spec);
        new AddDefaultInitialValues().transform(spec);
        LinearizeProduct linearize = new LinearizeProduct(true);
        linearize.transform(spec);
        new SwitchesToIfs().transform(spec);
        new ElimIfUpdates().transform(spec);
        return linearize.getLpVarToAbsAutNameMap();
    }

    private Set<DiscVariable> determineValueActionVars(List<DiscVariable> vars, String valueActionPatterns) {
        DiscVariable prev;
        Map namesMap = Maps.mapc((int)(this.origVarNames.size() + this.origAutNames.size()));
        for (Map.Entry<DiscVariable, String> entry : this.origVarNames.entrySet()) {
            prev = namesMap.put(entry.getValue(), entry.getKey());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        for (Map.Entry<DiscVariable, String> entry : this.origAutNames.entrySet()) {
            prev = namesMap.put(entry.getValue(), entry.getKey());
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        Set names = Sets.set();
        names.addAll(this.origVarNames.values());
        names.addAll(this.origAutNames.values());
        names = Sets.list2set((List)Sets.sortedstrings((Set)names));
        Set<String> includeNames = ProcessValueActions.matchNames(valueActionPatterns, names, this.warnOutput);
        Set result = (Set)includeNames.stream().map(n -> (DiscVariable)namesMap.get(n)).collect(Sets.toSet());
        Assert.check((boolean)vars.containsAll(result));
        return result;
    }

    private Expression getMarked(Specification spec) {
        Expression marked = CifMarkedUtils.getMarked((Specification)spec);
        spec.getMarkeds().add((Object)marked);
        new SimplifyValues().transform(marked);
        marked = (Expression)Lists.last((List)spec.getMarkeds());
        spec.getMarkeds().remove((Object)marked);
        return marked;
    }

    private void addSortsForEnums(MemoryCodeBox code) {
        if (this.enums.isEmpty()) {
            return;
        }
        code.add("% Sorts for CIF enumerations.");
        for (EnumDecl enumDecl : (Set)this.enums.values().stream().collect(Sets.toSet())) {
            String litNames = enumDecl.getLiterals().stream().map(l -> this.getName((PositionObject)l)).collect(Collectors.joining(" | "));
            code.add("sort %s = struct %s;", new Object[]{this.getName((PositionObject)enumDecl), litNames});
        }
        code.add();
    }

    private void addActionsForEvents(List<Event> events, MemoryCodeBox code) {
        if (events.isEmpty()) {
            return;
        }
        code.add("% Actions for CIF events.");
        for (Event event : events) {
            code.add("act %s;", new Object[]{this.getName((PositionObject)event)});
        }
        code.add();
    }

    private void addVarValueActions(Set<DiscVariable> vars, MemoryCodeBox code) {
        if (vars.isEmpty()) {
            return;
        }
        code.add("% Actions for CIF variables having certain values.");
        for (DiscVariable var : vars) {
            code.add("act %s'varvalue: %s;", new Object[]{this.getName((PositionObject)var), this.generateSortExprForType(var.getType())});
        }
        code.add();
    }

    private void addMarkedAction(MemoryCodeBox code) {
        code.add("% Action for CIF marker predicate.");
        code.add("act marked;");
        code.add();
    }

    private void addProcess(List<DiscVariable> vars, Set<DiscVariable> valueActVars, List<Edge> edges, Expression marked, MemoryCodeBox code) {
        code.add("% Process for behavior of the CIF specification.");
        if (vars.isEmpty()) {
            code.add("proc P =");
        } else {
            code.add("proc P(");
            code.indent();
            int i = 0;
            while (i < vars.size()) {
                DiscVariable var = vars.get(i);
                boolean isLast = i == vars.size() - 1;
                code.add("%s: %s%s", new Object[]{this.getName((PositionObject)var), this.generateSortExprForType(var.getType()), isLast ? "" : ","});
                ++i;
            }
            code.dedent();
            code.add(") =");
        }
        code.indent();
        boolean first = true;
        boolean firstEdge = true;
        for (Edge edge : edges) {
            if (!first) {
                code.add("+");
            }
            first = false;
            if (firstEdge) {
                code.add("% CIF linearized edges.");
                firstEdge = false;
            }
            this.addProcessExprForEdge(edge, vars, code);
        }
        boolean firstValueAct = true;
        for (DiscVariable valueActVar : valueActVars) {
            if (!first) {
                code.add("+");
            }
            first = false;
            if (firstValueAct) {
                code.add("% CIF variable value actions.");
                firstValueAct = false;
            }
            this.addProcessExprForValueActVar(valueActVar, code);
        }
        if (marked != null) {
            if (!first) {
                code.add("+");
            }
            first = false;
            code.add("% CIF 'marked' action.");
            this.addProcessExprForMarked(marked, code);
        }
        if (first) {
            code.add("delta");
        }
        code.dedent();
        code.add(";");
    }

    /*
     * WARNING - void declaration
     */
    private String generateSortExprForType(CifType type) {
        if (type instanceof BoolType) {
            return "Bool";
        }
        if (type instanceof IntType) {
            return "Int";
        }
        CifType cifType = type;
        if (cifType instanceof EnumType) {
            void enumType;
            EnumType enumType2 = (EnumType)cifType;
            EnumType cfr_ignored_0 = (EnumType)cifType;
            EnumDecl representative = this.enums.get(enumType.getEnum());
            return this.getName((PositionObject)representative);
        }
        throw new RuntimeException("Unexpected type: " + String.valueOf(type));
    }

    /*
     * WARNING - void declaration
     */
    private void addProcessExprForEdge(Edge edge, List<DiscVariable> vars, MemoryCodeBox code) {
        String event;
        Expression eventRef;
        List guards = Lists.list();
        guards.addAll(EMFHelper.deepclone((List)edge.getGuards()));
        Map<DiscVariable, Expression> assignments = this.getAssignments((List<Update>)edge.getUpdates());
        List<DiscVariable> intVars = vars.stream().filter(v -> v.getType() instanceof IntType).toList();
        for (DiscVariable var : intVars) {
            Expression newValue = assignments.get(var);
            if (newValue == null) continue;
            int lower = CifTypeUtils.getLowerBound((IntType)((IntType)var.getType()));
            int upper = CifTypeUtils.getUpperBound((IntType)((IntType)var.getType()));
            guards.addAll(this.createRangeGuards(newValue, lower, upper));
        }
        Expression guardExpr = CifValueUtils.createConjunction((List)guards, (boolean)true);
        edge.getGuards().add((Object)guardExpr);
        new SimplifyValues().transform(guardExpr);
        guardExpr = (Expression)Lists.last((List)edge.getGuards());
        edge.getGuards().remove((Object)guardExpr);
        String guard = this.generateExpr(guardExpr);
        Assert.areEqual((Object)edge.getEvents().size(), (Object)1);
        EdgeEvent edgeEvent = (EdgeEvent)Lists.first((List)edge.getEvents());
        Expression expression = eventRef = edgeEvent.getEvent();
        if (expression instanceof EventExpression) {
            void eventExpr;
            EventExpression eventExpression = (EventExpression)expression;
            EventExpression cfr_ignored_0 = (EventExpression)expression;
            event = this.getName((PositionObject)eventExpr.getEvent());
        } else if (eventRef instanceof TauExpression) {
            event = "tau";
        } else {
            throw new RuntimeException("Unexpected event reference: " + String.valueOf(eventRef));
        }
        String updates = assignments.entrySet().stream().map(e -> Strings.fmt((String)"%s = %s", (Object[])new Object[]{this.getName((PositionObject)e.getKey()), this.generateExpr((Expression)e.getValue())})).collect(Collectors.joining(", "));
        code.add("(%s) -> %s . P(%s)", new Object[]{guard, event, updates});
    }

    private List<Expression> createRangeGuards(Expression value, int lower, int upper) {
        Expression left1 = CifValueUtils.makeInt((int)lower);
        Expression right1 = (Expression)EMFHelper.deepclone((EObject)value);
        BinaryExpression bexpr1 = CifConstructors.newBinaryExpression();
        bexpr1.setLeft(left1);
        bexpr1.setOperator(BinaryOperator.LESS_EQUAL);
        bexpr1.setRight(right1);
        bexpr1.setType((CifType)CifConstructors.newBoolType());
        Expression left2 = (Expression)EMFHelper.deepclone((EObject)value);
        Expression right2 = CifValueUtils.makeInt((int)upper);
        BinaryExpression bexpr2 = CifConstructors.newBinaryExpression();
        bexpr2.setLeft(left2);
        bexpr2.setOperator(BinaryOperator.LESS_EQUAL);
        bexpr2.setRight(right2);
        bexpr2.setType((CifType)CifConstructors.newBoolType());
        return List.of(bexpr1, bexpr2);
    }

    private Map<DiscVariable, Expression> getAssignments(List<Update> updates) {
        Map result = Maps.mapc((int)updates.size());
        for (Update update : updates) {
            Assert.check((boolean)(update instanceof Assignment));
            Assignment asgn = (Assignment)update;
            Assert.check((boolean)(asgn.getAddressable() instanceof DiscVariableExpression));
            DiscVariable var = ((DiscVariableExpression)asgn.getAddressable()).getVariable();
            Expression value = asgn.getValue();
            Expression prev = result.put(var, value);
            Assert.check((prev == null ? 1 : 0) != 0);
        }
        return result;
    }

    private void addProcessExprForValueActVar(DiscVariable var, MemoryCodeBox code) {
        code.add("%s'varvalue(%s) . P()", new Object[]{this.getName((PositionObject)var), this.getName((PositionObject)var)});
    }

    private void addProcessExprForMarked(Expression marked, MemoryCodeBox code) {
        code.add("(%s) -> marked . P()", new Object[]{this.generateExpr(marked)});
    }

    private String generatePreds(List<Expression> preds) {
        if (preds.isEmpty()) {
            return "true";
        }
        if (preds.size() == 1) {
            return this.generateExpr((Expression)Lists.first(preds));
        }
        return preds.stream().map(p -> this.generateExpr((Expression)p)).collect(Collectors.joining(" && ", "(", ")"));
    }

    /*
     * WARNING - void declaration
     */
    private String generateExpr(Expression expr) {
        Integer intValue = CifValueUtils.tryGetIntLiteralValue((Expression)expr);
        if (intValue != null) {
            return intValue.toString();
        }
        Expression expression = expr;
        if (expression instanceof BoolExpression) {
            void boolExpr;
            BoolExpression boolExpression = (BoolExpression)expression;
            BoolExpression cfr_ignored_0 = (BoolExpression)expression;
            return boolExpr.isValue() ? "true" : "false";
        }
        Expression expression2 = expr;
        if (expression2 instanceof BinaryExpression) {
            void binExpr;
            BinaryExpression binaryExpression = (BinaryExpression)expression2;
            BinaryExpression cfr_ignored_1 = (BinaryExpression)expression2;
            String left = this.generateExpr(binExpr.getLeft());
            String right = this.generateExpr(binExpr.getRight());
            String op = switch (binExpr.getOperator()) {
                case BinaryOperator.ADDITION -> "+";
                case BinaryOperator.BI_CONDITIONAL -> "==";
                case BinaryOperator.CONJUNCTION -> "&&";
                case BinaryOperator.DISJUNCTION -> "||";
                case BinaryOperator.EQUAL -> "==";
                case BinaryOperator.GREATER_EQUAL -> ">=";
                case BinaryOperator.GREATER_THAN -> ">";
                case BinaryOperator.IMPLICATION -> "=>";
                case BinaryOperator.INTEGER_DIVISION -> "div";
                case BinaryOperator.LESS_EQUAL -> "<=";
                case BinaryOperator.LESS_THAN -> "<";
                case BinaryOperator.MODULUS -> "mod";
                case BinaryOperator.MULTIPLICATION -> "*";
                case BinaryOperator.SUBTRACTION -> "-";
                case BinaryOperator.UNEQUAL -> "!=";
                default -> throw new RuntimeException("Unexpected operator: " + String.valueOf(binExpr.getOperator()));
            };
            return Strings.fmt((String)"(%s %s %s)", (Object[])new Object[]{left, op, right});
        }
        Expression expression3 = expr;
        if (expression3 instanceof UnaryExpression) {
            void unExpr;
            UnaryExpression left = (UnaryExpression)expression3;
            UnaryExpression cfr_ignored_2 = (UnaryExpression)expression3;
            String child = this.generateExpr(unExpr.getChild());
            String op = switch (unExpr.getOperator()) {
                case UnaryOperator.INVERSE -> "!";
                case UnaryOperator.NEGATE -> "-";
                case UnaryOperator.PLUS -> "";
                default -> throw new RuntimeException("Unexpected operator: " + String.valueOf(unExpr.getOperator()));
            };
            return Strings.fmt((String)"%s%s", (Object[])new Object[]{op, child});
        }
        Expression expression4 = expr;
        if (expression4 instanceof DiscVariableExpression) {
            void discRefExpr;
            DiscVariableExpression child = (DiscVariableExpression)expression4;
            DiscVariableExpression cfr_ignored_3 = (DiscVariableExpression)expression4;
            return this.getName((PositionObject)discRefExpr.getVariable());
        }
        Expression expression5 = expr;
        if (expression5 instanceof IntExpression) {
            void intLitExpr;
            IntExpression intExpression = (IntExpression)expression5;
            IntExpression cfr_ignored_4 = (IntExpression)expression5;
            return Integer.toString(intLitExpr.getValue());
        }
        Expression expression6 = expr;
        if (expression6 instanceof EnumLiteralExpression) {
            void enumLitRefExpr;
            EnumLiteralExpression enumLiteralExpression = (EnumLiteralExpression)expression6;
            EnumLiteralExpression cfr_ignored_5 = (EnumLiteralExpression)expression6;
            EnumLiteral refEnumLit = enumLitRefExpr.getLiteral();
            EnumDecl refEnumDecl = (EnumDecl)refEnumLit.eContainer();
            int litIdx = refEnumDecl.getLiterals().indexOf((Object)refEnumLit);
            EnumDecl representativeEnumDecl = this.enums.get(refEnumDecl);
            EnumLiteral representativeEnumLit = (EnumLiteral)representativeEnumDecl.getLiterals().get(litIdx);
            return this.getName((PositionObject)representativeEnumLit);
        }
        Expression expression7 = expr;
        if (expression7 instanceof IfExpression) {
            void ifExpr;
            IfExpression refEnumLit = (IfExpression)expression7;
            IfExpression cfr_ignored_6 = (IfExpression)expression7;
            String result = this.generateExpr(ifExpr.getElse());
            for (ElifExpression elifExpr : Lists.reverse((List)ifExpr.getElifs())) {
                String elifGuard = this.generatePreds((List<Expression>)elifExpr.getGuards());
                String elifThen = this.generateExpr(elifExpr.getThen());
                result = Strings.fmt((String)"if(%s, %s, %s)", (Object[])new Object[]{elifGuard, elifThen, result});
            }
            String ifGuard = this.generatePreds((List<Expression>)ifExpr.getGuards());
            String ifThen = this.generateExpr(ifExpr.getThen());
            result = Strings.fmt((String)"if(%s, %s, %s)", (Object[])new Object[]{ifGuard, ifThen, result});
            return result;
        }
        Expression expression8 = expr;
        if (expression8 instanceof CastExpression) {
            void castExpr;
            CastExpression result = (CastExpression)expression8;
            CastExpression cfr_ignored_7 = (CastExpression)expression8;
            return this.generateExpr(castExpr.getChild());
        }
        throw new RuntimeException("Unexpected expression: " + String.valueOf(expr));
    }

    private void addInstantiationForInit(List<DiscVariable> vars, MemoryCodeBox code) {
        List initExprs = Lists.listc((int)vars.size());
        for (DiscVariable var : vars) {
            VariableValue varValue = var.getValue();
            Assert.areEqual((Object)varValue.getValues().size(), (Object)1);
            Expression value = (Expression)Lists.first((List)varValue.getValues());
            try {
                value = CifEvalUtils.evalAsExpr((Expression)value, (boolean)true);
            }
            catch (CifEvalException e) {
                throw new RuntimeException("Precondition violation.", e);
            }
            initExprs.add(this.generateExpr(value));
        }
        code.add();
        code.add("% Initialization.");
        code.add("init P(%s);", new Object[]{String.join((CharSequence)", ", initExprs)});
    }

    /*
     * Unable to fully structure code
     */
    private String getName(PositionObject cifObject) {
        block3: {
            block2: {
                var4_2 = cifObject;
                if (!(var4_2 instanceof DiscVariable)) break block2;
                var3_3 = (DiscVariable)var4_2;
                (DiscVariable)var4_2;
                if (!this.origVarNames.containsKey(dvar)) break block2;
                name = this.origVarNames.get(dvar);
                break block3;
            }
            if (!((var6_5 = cifObject) instanceof DiscVariable)) ** GOTO lbl-1000
            var5_6 = (DiscVariable)var6_5;
            (DiscVariable)var6_5;
            if (this.origAutNames.containsKey(dvar)) {
                name = this.origAutNames.get(dvar);
            } else lbl-1000:
            // 2 sources

            {
                name = CifTextUtils.getAbsName((PositionObject)cifObject, (boolean)false);
            }
        }
        name = name.replace('.', '\'');
        name = (String)name + "'";
        return name;
    }
}

