/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import java.util.function.Supplier;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.common.java.Strings;

public class CifBddApplyPlantInvariants {
    private CifBddApplyPlantInvariants() {
    }

    public static void applyStateEvtExclPlantsInvs(CifBddSpec cifBddSpec, String behaviorName, Supplier<String> sysBehTextSupplier, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting %s behavior using state/event exclusion plant invariants:", new Object[]{behaviorName});
            cifBddSpec.settings.getDebugOutput().inc();
        }
        boolean guardChanged = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD plant = cifBddSpec.stateEvtExclPlants.get(edge.event);
            if (plant == null || plant.isOne() || edge.guard.isZero()) continue;
            BDD newGuard = edge.guard.and(plant);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s [plant: %s].", new Object[]{edge.toString(""), BddUtils.bddToStr(edge.guard, cifBddSpec), BddUtils.bddToStr(newGuard, cifBddSpec), BddUtils.bddToStr(plant, cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardChanged = true;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            if (guardChanged) {
                String sysBehText = sysBehTextSupplier.get();
                if (sysBehText != null || !cifBddSpec.edges.isEmpty()) {
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("%s:", new Object[]{Strings.makeInitialUppercase((String)behaviorName)});
                    if (sysBehText != null) {
                        cifBddSpec.settings.getDebugOutput().inc();
                        cifBddSpec.settings.getDebugOutput().line(sysBehText);
                    }
                    if (!cifBddSpec.edges.isEmpty()) {
                        cifBddSpec.settings.getDebugOutput().inc();
                        for (String line : cifBddSpec.getEdgesText()) {
                            cifBddSpec.settings.getDebugOutput().line(line);
                        }
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    if (sysBehText != null) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                }
            } else {
                cifBddSpec.settings.getDebugOutput().line("No guards changed.");
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }

    public static void applyStatePlantInvs(CifBddSpec cifBddSpec, String behaviorName, Supplier<String> sysBehTextSupplier, boolean dbgEnabled) {
        if (dbgEnabled) {
            cifBddSpec.settings.getDebugOutput().line();
            cifBddSpec.settings.getDebugOutput().line("Restricting %s behavior using state plant invariants:", new Object[]{behaviorName});
            cifBddSpec.settings.getDebugOutput().inc();
        }
        if (cifBddSpec.plantInv.isOne()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("No restrictions needed.");
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        boolean guardChanged = false;
        for (CifBddEdge edge : cifBddSpec.edges) {
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD updPred = cifBddSpec.plantInv.id();
            updPred = edge.apply(updPred, CifBddEdgeApplyDirection.BACKWARD, null);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD guardAndPlantInv = edge.guard.and(cifBddSpec.plantInv);
            BDD implication = guardAndPlantInv.imp(updPred);
            boolean skip = implication.isOne();
            guardAndPlantInv.free();
            implication.free();
            if (skip) {
                updPred.free();
                updPred = cifBddSpec.factory.one();
            }
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            BDD newGuard = edge.guard.id().andWith(updPred);
            if (cifBddSpec.settings.getTermination().isRequested()) {
                if (dbgEnabled) {
                    cifBddSpec.settings.getDebugOutput().dec();
                }
                return;
            }
            if (edge.guard.equals((Object)newGuard)) {
                newGuard.free();
                continue;
            }
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().line("Edge %s: guard: %s -> %s.", new Object[]{edge.toString(""), BddUtils.bddToStr(edge.guard, cifBddSpec), BddUtils.bddToStr(newGuard, cifBddSpec)});
            }
            edge.guard.free();
            edge.guard = newGuard;
            guardChanged = true;
        }
        if (cifBddSpec.settings.getTermination().isRequested()) {
            if (dbgEnabled) {
                cifBddSpec.settings.getDebugOutput().dec();
            }
            return;
        }
        if (dbgEnabled) {
            if (guardChanged) {
                String sysBehText = sysBehTextSupplier.get();
                if (sysBehText != null || !cifBddSpec.edges.isEmpty()) {
                    cifBddSpec.settings.getDebugOutput().line();
                    cifBddSpec.settings.getDebugOutput().line("%s:", new Object[]{Strings.makeInitialUppercase((String)behaviorName)});
                    if (sysBehText != null) {
                        cifBddSpec.settings.getDebugOutput().inc();
                        cifBddSpec.settings.getDebugOutput().line(sysBehText);
                    }
                    if (!cifBddSpec.edges.isEmpty()) {
                        cifBddSpec.settings.getDebugOutput().inc();
                        for (String line : cifBddSpec.getEdgesText()) {
                            cifBddSpec.settings.getDebugOutput().line(line);
                        }
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                    if (sysBehText != null) {
                        cifBddSpec.settings.getDebugOutput().dec();
                    }
                }
            } else {
                cifBddSpec.settings.getDebugOutput().line("No guards changed.");
            }
            cifBddSpec.settings.getDebugOutput().dec();
        }
    }
}

