/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.utils;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDVarSet;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.escet.cif.bdd.settings.ExplorationStrategy;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeKind;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.bdd.workset.pruners.MaxCardinalityEdgePruner;
import org.eclipse.escet.cif.bdd.workset.pruners.RewardBasedEdgePruner;
import org.eclipse.escet.cif.bdd.workset.pruners.SequentialEdgePruner;
import org.eclipse.escet.cif.bdd.workset.selectors.EdgeSelector;
import org.eclipse.escet.cif.bdd.workset.selectors.FirstEdgeSelector;
import org.eclipse.escet.cif.bdd.workset.selectors.PruningEdgeSelector;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.TerminationException;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class CifBddReachability {
    private final CifBddSpec cifBddSpec;
    private final String predName;
    private final String initName;
    private final String restrictionName;
    private final BDD restriction;
    private final CifBddEdgeApplyDirection direction;
    private final Set<CifBddEdgeKind> edgeKinds;
    private final boolean dbgEnabled;
    private Integer saturationInstance;

    public CifBddReachability(CifBddSpec cifBddSpec, String predName, String initName, String restrictionName, BDD restriction, CifBddEdgeApplyDirection direction, Set<CifBddEdgeKind> edgeKinds, boolean dbgEnabled) {
        Assert.areEqual((Object)(restrictionName == null ? 1 : 0), (Object)(restriction == null ? 1 : 0));
        this.cifBddSpec = cifBddSpec;
        this.predName = predName;
        this.initName = initName;
        this.restrictionName = restrictionName;
        this.restriction = restriction;
        this.direction = direction;
        this.edgeKinds = edgeKinds;
        this.dbgEnabled = dbgEnabled;
        this.saturationInstance = null;
    }

    public void setSaturationInstance(int instance) {
        this.saturationInstance = instance;
    }

    public BDD performReachability(BDD pred) {
        if (this.dbgEnabled) {
            this.cifBddSpec.settings.getDebugOutput().line("%s: %s [%s predicate]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), this.initName});
        }
        boolean changed = false;
        if (this.restriction != null) {
            BDD restrictedPred = pred.and(this.restriction);
            if (this.cifBddSpec.settings.getTermination().isRequested()) {
                return null;
            }
            if (pred.equals((Object)restrictedPred)) {
                restrictedPred.free();
            } else {
                if (this.dbgEnabled) {
                    Assert.notNull((Object)this.restrictionName);
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [restricted to %s predicate: %s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(restrictedPred, this.cifBddSpec), this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                }
                pred.free();
                pred = restrictedPred;
                changed = true;
            }
        }
        List<CifBddEdge> orderedEdges = this.direction == CifBddEdgeApplyDirection.FORWARD ? this.cifBddSpec.orderedEdgesForward : this.cifBddSpec.orderedEdgesBackward;
        Predicate<CifBddEdge> edgeShouldBeApplied = e -> this.edgeKinds.contains((Object)e.getEdgeKind());
        List<CifBddEdge> edgesToApply = orderedEdges.stream().filter(edgeShouldBeApplied).toList();
        if (this.cifBddSpec.settings.getTermination().isRequested()) {
            return null;
        }
        ExplorationStrategy strategy = this.cifBddSpec.settings.getExplorationStrategy();
        Pair<BDD, Boolean> reachabilityResult = switch (strategy) {
            case ExplorationStrategy.CHAINING_FIXED -> this.performReachabilityFixedOrder(pred, edgesToApply);
            case ExplorationStrategy.CHAINING_WORKSET -> {
                BitSet edgesToApplyMask = (BitSet)IntStream.range(0, orderedEdges.size()).filter(i -> edgeShouldBeApplied.test((CifBddEdge)orderedEdges.get(i))).boxed().collect(BitSets.toBitSet());
                yield this.performReachabilityWorkset(pred, orderedEdges, edgesToApplyMask);
            }
            case ExplorationStrategy.SATURATION -> this.performReachabilitySaturation(pred, edgesToApply);
            default -> throw new RuntimeException("Unknown exploration strategy: " + String.valueOf((Object)strategy));
        };
        if (reachabilityResult == null || this.cifBddSpec.settings.getTermination().isRequested()) {
            return null;
        }
        pred = (BDD)reachabilityResult.left;
        changed |= ((Boolean)reachabilityResult.right).booleanValue();
        if (this.cifBddSpec.settings.getTermination().isRequested()) {
            return null;
        }
        if (this.dbgEnabled && changed) {
            this.cifBddSpec.settings.getDebugOutput().line();
            this.cifBddSpec.settings.getDebugOutput().line("%s: %s [fixed point].", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec)});
        }
        return pred;
    }

    private Pair<BDD, Boolean> performReachabilityWorkset(BDD pred, List<CifBddEdge> edges, BitSet edgesMask) {
        boolean changed = false;
        List<BitSet> dependencies = this.direction == CifBddEdgeApplyDirection.FORWARD ? this.cifBddSpec.worksetDependenciesForward : this.cifBddSpec.worksetDependenciesBackward;
        PruningEdgeSelector edgeSelector = new PruningEdgeSelector(new SequentialEdgePruner(new MaxCardinalityEdgePruner(dependencies), new RewardBasedEdgePruner(edges.size(), 1, -1)), new FirstEdgeSelector());
        BitSet workset = BitSets.copy((BitSet)edgesMask);
        while (!workset.isEmpty()) {
            BDD newPred;
            int edgeIdx = edgeSelector.select(workset);
            CifBddEdge edge = edges.get(edgeIdx);
            boolean changedByEdge = false;
            while (true) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.direction, this.restriction);
                if (this.cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                newPred = pred.id().orWith(updPred);
                if (this.cifBddSpec.settings.getTermination().isRequested()) {
                    return null;
                }
                if (pred.equals((Object)newPred)) break;
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (!changed) {
                        this.cifBddSpec.settings.getDebugOutput().line();
                    }
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                    }
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [%s reach with edge: %s%s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(newPred, this.cifBddSpec), this.direction.description, edge.toString(""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                changedByEdge = true;
            }
            newPred.free();
            if (changedByEdge) {
                BitSet dependents = BitSets.copy((BitSet)dependencies.get(edgeIdx));
                dependents.and(edgesMask);
                workset.or(dependents);
            }
            workset.clear(edgeIdx);
            ((EdgeSelector)edgeSelector).update(edgeIdx, changedByEdge);
        }
        return Pair.pair((Object)pred, (Object)changed);
    }

    private Pair<BDD, Boolean> performReachabilityFixedOrder(BDD pred, List<CifBddEdge> edges) {
        boolean changed = false;
        int iter = 0;
        int remainingEdges = edges.size();
        while (remainingEdges > 0) {
            ++iter;
            if (this.dbgEnabled) {
                this.cifBddSpec.settings.getDebugOutput().line();
                this.cifBddSpec.settings.getDebugOutput().line("%s reachability iteration %d:", new Object[]{Strings.makeInitialUppercase((String)this.direction.description), iter});
                this.cifBddSpec.settings.getDebugOutput().inc();
            }
            boolean iterChanged = false;
            for (CifBddEdge edge : edges) {
                BDD updPred = pred.id();
                updPred = edge.apply(updPred, this.direction, this.restriction);
                if (this.cifBddSpec.settings.getTermination().isRequested()) {
                    if (this.dbgEnabled) {
                        this.cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return null;
                }
                BDD newPred = pred.id().orWith(updPred);
                if (this.cifBddSpec.settings.getTermination().isRequested()) {
                    if (this.dbgEnabled) {
                        this.cifBddSpec.settings.getDebugOutput().dec();
                    }
                    return null;
                }
                if (pred.equals((Object)newPred)) {
                    newPred.free();
                    if (--remainingEdges != 0) continue;
                    break;
                }
                if (this.dbgEnabled) {
                    String restrTxt;
                    if (this.restriction == null) {
                        restrTxt = "";
                    } else {
                        Assert.notNull((Object)this.restrictionName);
                        restrTxt = Strings.fmt((String)", restricted to %s predicate: %s", (Object[])new Object[]{this.restrictionName, BddUtils.bddToStr(this.restriction, this.cifBddSpec)});
                    }
                    this.cifBddSpec.settings.getDebugOutput().line("%s: %s -> %s [%s reach with edge: %s%s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(pred, this.cifBddSpec), BddUtils.bddToStr(newPred, this.cifBddSpec), this.direction.description, edge.toString(""), restrTxt});
                }
                pred.free();
                pred = newPred;
                changed = true;
                iterChanged = true;
                remainingEdges = edges.size();
            }
            if (!this.dbgEnabled) continue;
            if (!iterChanged) {
                this.cifBddSpec.settings.getDebugOutput().line("No change this iteration.");
            }
            this.cifBddSpec.settings.getDebugOutput().dec();
        }
        return Pair.pair((Object)pred, (Object)changed);
    }

    private Pair<BDD, Boolean> performReachabilitySaturation(BDD pred, List<CifBddEdge> edges) {
        BDD result;
        Assert.notNull((Object)this.saturationInstance, (Object)"Expected a saturation instance number to have been configured.");
        Termination termination = this.cifBddSpec.settings.getTermination();
        DebugNormalOutput dbg = this.cifBddSpec.settings.getDebugOutput();
        Map<CifBddEdge, BDD> edgeSupport = edges.stream().distinct().collect(Collectors.toMap(edge -> edge, edge -> edge.updateGuardSupport.toBDD()));
        List<CifBddEdge> sortedEdges = edges.stream().sorted(Comparator.comparing(edge -> ((BDD)edgeSupport.get(edge)).level())).toList();
        edgeSupport.values().forEach(BDD::free);
        if (termination.isRequested()) {
            return null;
        }
        List sortedRelations = (List)sortedEdges.stream().map(edge -> edge.updateGuard).collect(Lists.toList());
        List sortedVars = (List)sortedEdges.stream().map(edge -> edge.updateGuardSupport).collect(Lists.toList());
        if (termination.isRequested()) {
            return null;
        }
        if (this.dbgEnabled) {
            this.cifBddSpec.factory.setSaturationCallback((transition, before, after) -> {
                if (termination.isRequested()) {
                    throw new TerminationException();
                }
                if (!before.equalsBDD(after)) {
                    CifBddEdge edge = (CifBddEdge)sortedEdges.get(transition);
                    BDD support = ((BDDVarSet)sortedVars.get(transition)).toBDD();
                    String boundedText = this.restriction != null ? "bounded " : "";
                    dbg.line("%s: %s -> %s [%s reach using %ssaturation (transition: %d of %d) (level: %d of %d) with edge: %s]", new Object[]{Strings.makeInitialUppercase((String)this.predName), BddUtils.bddToStr(before, this.cifBddSpec), BddUtils.bddToStr(after, this.cifBddSpec), this.direction.description, boundedText, transition + 1, sortedEdges.size(), support.level() + 1, this.cifBddSpec.factory.varNum(), edge.toString("")});
                    support.free();
                }
            });
        } else {
            this.cifBddSpec.factory.setSaturationCallback(transition -> {
                if (termination.isRequested()) {
                    throw new TerminationException();
                }
            });
        }
        try {
            result = this.direction == CifBddEdgeApplyDirection.FORWARD ? (this.restriction == null ? pred.saturationForward(sortedRelations, sortedVars, this.saturationInstance.intValue()) : pred.boundedSaturationForward(this.restriction, sortedRelations, sortedVars, this.saturationInstance.intValue())) : (this.restriction == null ? pred.saturationBackward(sortedRelations, sortedVars, this.saturationInstance.intValue()) : pred.boundedSaturationBackward(this.restriction, sortedRelations, sortedVars, this.saturationInstance.intValue()));
        }
        catch (TerminationException ex) {
            return null;
        }
        this.cifBddSpec.factory.unsetSaturationCallback();
        boolean changed = !pred.equals((Object)result);
        pred.free();
        return Pair.pair((Object)result, (Object)changed);
    }
}

