/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.partialspecs;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Alphabet;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class PartialSpecManager {
    private final Specification partialSpec;
    private Map<EObject, EObject> copiedObjects = Maps.map();
    private Deque<Map<EObject, Collection<EStructuralFeature.Setting>>> danglingQueue = new ArrayDeque<Map<EObject, Collection<EStructuralFeature.Setting>>>();

    public PartialSpecManager(Specification origSpec) {
        this.partialSpec = CifConstructors.newSpecification();
        this.addCopiedObject((EObject)origSpec, (EObject)this.partialSpec);
    }

    public Specification getPartialSpec() {
        return this.partialSpec;
    }

    public EObject getCopiedPartialObject(EObject origObject) {
        return this.copiedObjects.get(origObject);
    }

    public Map<EObject, Collection<EStructuralFeature.Setting>> getNextDanglingObjects() {
        return this.danglingQueue.poll();
    }

    public void copyAutomatonSkeleton(Automaton origAut) {
        Assert.check((boolean)origAut.getEquations().isEmpty());
        Assert.check((boolean)origAut.getIoDecls().isEmpty());
        Alphabet alphabet = this.deepcloneAndAdd(origAut.getAlphabet());
        List initials = this.deepcloneAndAdd((Collection)origAut.getInitials());
        List markeds = this.deepcloneAndAdd((Collection)origAut.getMarkeds());
        Monitors monitors = this.deepcloneAndAdd(origAut.getMonitors());
        Automaton partialAut = CifConstructors.newAutomaton((Alphabet)alphabet, null, null, null, initials, null, null, (SupKind)origAut.getKind(), null, markeds, (Monitors)monitors, (String)origAut.getName(), null);
        this.addCopiedObject((EObject)origAut, (EObject)partialAut);
        this.directlyAttachAddedToComponent((EObject)origAut, (EObject)partialAut);
        for (Location origLoc : origAut.getLocations()) {
            Assert.check((boolean)origLoc.getEquations().isEmpty());
            List edges = this.deepcloneAndAdd((Collection)origLoc.getEdges());
            initials = this.deepcloneAndAdd((Collection)origLoc.getInitials());
            markeds = this.deepcloneAndAdd((Collection)origLoc.getMarkeds());
            Location partialLoc = CifConstructors.newLocation(null, edges, null, initials, null, markeds, (String)origLoc.getName(), null, (Boolean)origLoc.isUrgent());
            this.addCopiedObject((EObject)origLoc, (EObject)partialLoc);
            this.directlyAttachAddedToComponent((EObject)origLoc, (EObject)partialLoc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void directlyAttachAddedToComponent(EObject origObj, EObject partialObj) {
        Assert.check((boolean)this.copiedObjects.containsKey(origObj));
        Assert.check((this.copiedObjects.get(origObj) == partialObj ? 1 : 0) != 0);
        this.scanPartialObject(partialObj);
        ComplexComponent origParent = (ComplexComponent)origObj.eContainer();
        Assert.notNull((Object)origParent, (Object)("Element " + String.valueOf(origObj) + " has no parent."));
        ComplexComponent partialParent = this.ensureComponent(origParent);
        EObject eObject = partialObj;
        if (eObject instanceof Group) {
            void group;
            Group group2 = (Group)eObject;
            Group cfr_ignored_0 = (Group)eObject;
            this.insertEObject(((Group)origParent).getComponents(), ((Group)partialParent).getComponents(), group);
        } else {
            EObject eObject2 = partialObj;
            if (eObject2 instanceof Automaton) {
                void aut;
                Automaton automaton = (Automaton)eObject2;
                Automaton cfr_ignored_1 = (Automaton)eObject2;
                this.insertEObject(((Group)origParent).getComponents(), ((Group)partialParent).getComponents(), aut);
            } else {
                EObject eObject3 = partialObj;
                if (eObject3 instanceof Declaration) {
                    void decl;
                    Declaration declaration = (Declaration)eObject3;
                    Declaration cfr_ignored_2 = (Declaration)eObject3;
                    this.insertEObject(origParent.getDeclarations(), partialParent.getDeclarations(), decl);
                } else {
                    EObject eObject4 = partialObj;
                    if (eObject4 instanceof Invariant) {
                        void inv;
                        Invariant invariant = (Invariant)eObject4;
                        Invariant cfr_ignored_3 = (Invariant)eObject4;
                        this.insertEObject(origParent.getInvariants(), partialParent.getInvariants(), inv);
                    } else {
                        EObject eObject5 = partialObj;
                        if (eObject5 instanceof Location) {
                            void loc;
                            Location location = (Location)eObject5;
                            Location cfr_ignored_4 = (Location)eObject5;
                            this.insertEObject(((Automaton)origParent).getLocations(), ((Automaton)partialParent).getLocations(), loc);
                        } else {
                            throw new AssertionError((Object)("Unexpected partial object \"" + String.valueOf(partialObj) + "\" found for component attachment."));
                        }
                    }
                }
            }
        }
    }

    private ComplexComponent ensureComponent(ComplexComponent origComponent) {
        ComplexComponent availablePartialComponent = (ComplexComponent)this.copiedObjects.get(origComponent);
        if (availablePartialComponent != null) {
            return availablePartialComponent;
        }
        Group origParent = (Group)origComponent.eContainer();
        Group partialParent = (Group)this.ensureComponent((ComplexComponent)origParent);
        Group partialComponent = CifConstructors.newGroup();
        partialComponent.setName(origComponent.getName());
        this.addCopiedObject((EObject)origComponent, (EObject)partialComponent);
        this.insertEObject(origParent.getComponents(), partialParent.getComponents(), partialComponent);
        return partialComponent;
    }

    <T extends EObject, U extends T> void insertEObject(EList<T> origList, EList<T> partialList, U newPartialObject) {
        Assert.notNull(newPartialObject);
        if (partialList.isEmpty()) {
            partialList.add(newPartialObject);
            return;
        }
        int partialIndex = 0;
        for (EObject origObj : origList) {
            EObject expectedPartialObject = this.copiedObjects.get(origObj);
            if (expectedPartialObject == null) continue;
            if (expectedPartialObject != newPartialObject) {
                if (partialList.get(partialIndex) != expectedPartialObject || ++partialIndex < partialList.size()) continue;
                partialList.add(newPartialObject);
                return;
            }
            Assert.check((newPartialObject != partialList.get(partialIndex) ? 1 : 0) != 0);
            partialList.add(partialIndex, newPartialObject);
            return;
        }
    }

    private void scanPartialObject(EObject partialObject) {
        Map danglingElements = EcoreUtil.ExternalCrossReferencer.find((EObject)partialObject);
        if (!danglingElements.isEmpty()) {
            this.danglingQueue.add(danglingElements);
        }
    }

    public void addCopiedObject(EObject originalObj, EObject partialObj) {
        EObject prevObj = this.copiedObjects.put(originalObj, partialObj);
        Assert.check((prevObj == null ? 1 : 0) != 0, (Object)("Duplicate copy of " + String.valueOf(originalObj)));
    }

    public <T extends EObject> T deepcloneAndAdd(T origObject) {
        if (origObject == null) {
            return null;
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        EObject partialObject = copier.copy(origObject);
        copier.copyReferences();
        for (Map.Entry entry : copier.entrySet()) {
            this.addCopiedObject((EObject)entry.getKey(), (EObject)entry.getValue());
        }
        return (T)partialObject;
    }

    public <T extends EObject> List<T> deepcloneAndAdd(Collection<T> origObjects) {
        if (origObjects.isEmpty()) {
            return Lists.list();
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        List partialObject = (List)copier.copyAll(origObjects);
        copier.copyReferences();
        for (Map.Entry entry : copier.entrySet()) {
            this.addCopiedObject((EObject)entry.getKey(), (EObject)entry.getValue());
        }
        return partialObject;
    }
}

