/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifAddressableUtils;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.common.RangeCompat;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.FunctionParameter;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGenerator;
import org.eclipse.escet.cif.simulator.compiler.ExprCodeGeneratorResult;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Strings;

public class AssignmentCodeGenerator {
    private AssignmentCodeGenerator() {
    }

    public static List<ExprCodeGeneratorResult> gencodeAssignment(Expression addr, Expression value, Automaton aut, CodeBox c, CifCompilerContext ctxt, String state) {
        Assert.check((aut == null == (state == null) ? 1 : 0) != 0);
        List cores = Lists.list();
        AtomicInteger counter = new AtomicInteger();
        AssignmentCodeGenerator.getCoreAssignments(addr, value, aut, c, ctxt, state, cores, counter);
        int count = counter.get();
        Assert.check((count >= 1 ? 1 : 0) != 0);
        if (count > 1) {
            c.add("{");
            c.indent();
        }
        for (CoreAssignment core : cores) {
            core.count = count;
            core.genPreCode();
        }
        List exprResults = Lists.list();
        for (CoreAssignment core : cores) {
            exprResults.addAll(core.genCode());
        }
        for (CoreAssignment core : cores) {
            core.genPostCode();
        }
        if (count > 1) {
            c.dedent();
            c.add("}");
        }
        return exprResults;
    }

    private static void getCoreAssignments(Expression addr, Expression value, Automaton aut, CodeBox c, CifCompilerContext ctxt, String state, List<CoreAssignment> cores, AtomicInteger counter) {
        if (addr instanceof TupleExpression && value instanceof TupleExpression) {
            TupleExpression taddr = (TupleExpression)addr;
            TupleExpression tvalue = (TupleExpression)value;
            int size = taddr.getFields().size();
            int i = 0;
            while (i < size) {
                AssignmentCodeGenerator.getCoreAssignments((Expression)taddr.getFields().get(i), (Expression)tvalue.getFields().get(i), aut, c, ctxt, state, cores, counter);
                ++i;
            }
            return;
        }
        CoreAssignment asgn = new CoreAssignment(addr, value, aut, c, ctxt, state, counter);
        cores.add(asgn);
    }

    private static class CoreAssignment {
        private final Expression addr;
        private final Expression value;
        private final Automaton aut;
        private final CodeBox c;
        private final CifCompilerContext ctxt;
        private final String state;
        private final Map<Expression, Integer> addrRsltNrMap;
        public int count = -1;

        public CoreAssignment(Expression addr, Expression value, Automaton aut, CodeBox c, CifCompilerContext ctxt, String state, AtomicInteger counter) {
            this.addr = addr;
            this.value = value;
            this.aut = aut;
            this.c = c;
            this.ctxt = ctxt;
            this.state = state;
            this.addrRsltNrMap = Maps.map();
            for (Expression varRef : CifAddressableUtils.getRefExprs((Expression)addr)) {
                this.addrRsltNrMap.put(varRef, counter.getAndIncrement());
            }
        }

        public void genPreCode() {
            Assert.check((this.count > 0 ? 1 : 0) != 0);
            if (this.count == 1) {
                return;
            }
            for (Map.Entry<Expression, Integer> entry : this.addrRsltNrMap.entrySet()) {
                Expression addrRef = entry.getKey();
                int rsltIdx = entry.getValue();
                this.c.add("%s rslt%d;", new Object[]{TypeCodeGenerator.gencodeType(addrRef.getType(), this.ctxt), rsltIdx});
            }
        }

        public void genPostCode() {
            Assert.check((this.count > 0 ? 1 : 0) != 0);
            if (this.count == 1) {
                return;
            }
            for (Map.Entry<Expression, Integer> entry : this.addrRsltNrMap.entrySet()) {
                Expression addrRef = entry.getKey();
                int rsltIdx = entry.getValue();
                this.c.add("%s = rslt%d;", new Object[]{this.gencodeAddrVarRef(addrRef), rsltIdx});
            }
        }

        public List<ExprCodeGeneratorResult> genCode() {
            this.c.add("try {");
            this.c.indent();
            List exprResults = Lists.list();
            if (this.addr instanceof DiscVariableExpression || this.addr instanceof ContVariableExpression) {
                ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(this.value, this.ctxt, "source");
                String rhsCode = result.toString();
                exprResults.add(result);
                this.gencodeAddrVarAsgn(this.addr, rhsCode);
                this.gencodeTypeRangeBoundCheck(this.addr, this.gencodeAddrVarRef(this.addr), this.value.getType(), this.addr.getType(), 0);
            } else {
                ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(this.value, this.ctxt, this.state);
                exprResults.add(result);
                this.c.add("{");
                this.c.indent();
                this.c.add("%s rhs = %s;", new Object[]{TypeCodeGenerator.gencodeType(this.value.getType(), this.ctxt), result});
                exprResults.addAll(this.gencodeComplex(this.addr, "rhs", this.value.getType()));
                this.c.dedent();
                this.c.add("}");
            }
            this.c.dedent();
            this.c.add("} catch (CifSimulatorException e) {");
            this.c.indent();
            this.c.add("throw new CifSimulatorException(\"Execution of assignment \\\"%s := %s\\\" failed.\", e, %s);", new Object[]{StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprToStr((Expression)this.addr), (int)1000)), StringEscapeUtils.escapeJava((String)Strings.truncate((String)CifTextUtils.exprToStr((Expression)this.value), (int)1000)), this.state});
            this.c.dedent();
            this.c.add("}");
            return exprResults;
        }

        private List<ExprCodeGeneratorResult> gencodeComplex(Expression addr, String rhsRefCode, CifType rhsType) {
            CifType nctype;
            if (addr instanceof TupleExpression) {
                TupleExpression taddr = (TupleExpression)addr;
                TupleType type = (TupleType)CifTypeUtils.normalizeType((CifType)taddr.getType());
                List exprResults = Lists.list();
                int i = 0;
                while (i < taddr.getFields().size()) {
                    Expression subAddr = (Expression)taddr.getFields().get(i);
                    CifType subType = ((Field)type.getFields().get(i)).getType();
                    String newRhs = rhsRefCode + "." + this.ctxt.getTupleTypeFieldFieldName(type, i);
                    exprResults.addAll(this.gencodeComplex(subAddr, newRhs, subType));
                    ++i;
                }
                return exprResults;
            }
            if (addr instanceof DiscVariableExpression || addr instanceof ContVariableExpression) {
                this.gencodeAddrVarAsgn(addr, rhsRefCode);
                this.gencodeTypeRangeBoundCheck(addr, this.gencodeAddrVarRef(addr), rhsType, addr.getType(), 0);
                return Lists.list();
            }
            this.c.add("{");
            this.c.indent();
            List projs = CifAddressableUtils.collectProjs((Expression)addr);
            List childTypes = Lists.listc((int)projs.size());
            for (ProjectionExpression proj : projs) {
                CifType nctype2 = CifTypeUtils.normalizeType((CifType)proj.getChild().getType());
                childTypes.add(nctype2);
            }
            List idxCodes = Lists.listc((int)projs.size());
            boolean anyIdxVars = false;
            List exprResults = Lists.list();
            int i = 0;
            while (i < projs.size()) {
                ProjectionExpression proj = (ProjectionExpression)projs.get(i);
                nctype = (CifType)childTypes.get(i);
                if (nctype instanceof ListType) {
                    ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(proj.getIndex(), this.ctxt, this.state);
                    this.c.add("int idx%d = %s;", new Object[]{i, result});
                    exprResults.add(result);
                    anyIdxVars = true;
                    idxCodes.add("idx" + i);
                } else if (nctype instanceof DictType) {
                    CifType keyType = ((DictType)nctype).getKeyType();
                    ExprCodeGeneratorResult result = ExprCodeGenerator.gencodeExpr(proj.getIndex(), this.ctxt, this.state);
                    this.c.add("%s key%d = %s;", new Object[]{TypeCodeGenerator.gencodeType(keyType, this.ctxt), i, result});
                    exprResults.add(result);
                    anyIdxVars = true;
                    idxCodes.add("key" + i);
                } else if (nctype instanceof TupleType) {
                    if (proj.getIndex() instanceof FieldExpression) {
                        Field field = ((FieldExpression)proj.getIndex()).getField();
                        idxCodes.add(this.ctxt.getTupleTypeFieldFieldName(field));
                    } else {
                        int idx;
                        try {
                            idx = (Integer)CifEvalUtils.eval((Expression)proj.getIndex(), (boolean)false);
                        }
                        catch (CifEvalException e) {
                            throw new RuntimeException(e);
                        }
                        TupleType tupleType = (TupleType)nctype;
                        idxCodes.add(this.ctxt.getTupleTypeFieldFieldName(tupleType, idx));
                    }
                } else {
                    String msg = "Unexpected addr proj child type: " + String.valueOf(nctype);
                    throw new RuntimeException(msg);
                }
                ++i;
            }
            if (anyIdxVars) {
                this.c.add();
            }
            Expression varRef = CifAddressableUtils.stripProjs((Expression)addr);
            this.c.add("%s part0 = %s;", new Object[]{TypeCodeGenerator.gencodeType(varRef.getType(), this.ctxt), this.gencodeAddrVarRef(varRef)});
            int i2 = 0;
            while (i2 < projs.size()) {
                ProjectionExpression proj = (ProjectionExpression)projs.get(i2);
                CifType nctype3 = (CifType)childTypes.get(i2);
                String idxCode = (String)idxCodes.get(i2);
                boolean last = i2 == projs.size() - 1;
                String rsltTypeCode = TypeCodeGenerator.gencodeType(proj.getType(), this.ctxt);
                if (nctype3 instanceof ListType) {
                    this.c.add("%s part%d = project(part%d, %s);", new Object[]{rsltTypeCode, i2 + 1, i2, idxCode});
                } else if (nctype3 instanceof DictType) {
                    if (!last) {
                        this.c.add("%s part%d = project(part%d, %s);", new Object[]{rsltTypeCode, i2 + 1, i2, idxCode});
                    }
                } else if (nctype3 instanceof TupleType) {
                    if (!last) {
                        this.c.add("%s part%d = part%d.%s;", new Object[]{rsltTypeCode, i2 + 1, i2, idxCode});
                    }
                } else {
                    String msg = "Unexpected addr proj child type: " + String.valueOf(nctype3);
                    throw new RuntimeException(msg);
                }
                ++i2;
            }
            this.c.add();
            i2 = projs.size() - 1;
            while (i2 >= 0) {
                String newValueCode;
                nctype = (CifType)childTypes.get(i2);
                String idxCode = (String)idxCodes.get(i2);
                String string = newValueCode = i2 == projs.size() - 1 ? rhsRefCode : "part" + (i2 + 1);
                if (nctype instanceof ListType) {
                    this.c.add("part%d = modify(part%d, %s, %s);", new Object[]{i2, i2, idxCode, newValueCode});
                } else if (nctype instanceof DictType) {
                    this.c.add("part%d = modify(part%d, %s, %s);", new Object[]{i2, i2, idxCode, newValueCode});
                } else if (nctype instanceof TupleType) {
                    this.c.add("part%d = part%d.copy();", new Object[]{i2, i2});
                    this.c.add("part%d.%s = %s;", new Object[]{i2, idxCode, newValueCode});
                } else {
                    String msg = "Unexpected addr proj child type: " + String.valueOf(nctype);
                    throw new RuntimeException(msg);
                }
                --i2;
            }
            this.gencodeAddrVarAsgn(varRef, "part0");
            this.gencodeTypeRangeBoundCheck(varRef, rhsRefCode, rhsType, ((ProjectionExpression)Lists.last((List)projs)).getType(), 0);
            this.c.dedent();
            this.c.add("}");
            return exprResults;
        }

        private void gencodeAddrVarAsgn(Expression addr, String rhsCode) {
            if (this.count == 1) {
                this.c.add("%s = %s;", new Object[]{this.gencodeAddrVarRef(addr), rhsCode});
            } else {
                int rsltIdx = this.addrRsltNrMap.get(addr);
                this.c.add("rslt%d = %s;", new Object[]{rsltIdx, rhsCode});
            }
        }

        private String gencodeAddrVarRef(Expression addr) {
            if (addr instanceof DiscVariableExpression) {
                DiscVariableExpression daddr = (DiscVariableExpression)addr;
                DiscVariable var = daddr.getVariable();
                if (this.aut != null) {
                    return Strings.fmt((String)"target.%s.%s", (Object[])new Object[]{this.ctxt.getAutSubStateFieldName(this.aut), this.ctxt.getDiscVarFieldName(var)});
                }
                EObject parent = var.eContainer();
                if (parent instanceof FunctionParameter) {
                    return this.ctxt.getFuncParamMethodParamName(var);
                }
                if (parent instanceof InternalFunction) {
                    return this.ctxt.getFuncLocalVarName(var);
                }
                String msg = "Unknown addr var in func: " + String.valueOf(var);
                throw new RuntimeException(msg);
            }
            if (addr instanceof ContVariableExpression) {
                ContVariableExpression caddr = (ContVariableExpression)addr;
                ContVariable var = caddr.getVariable();
                return Strings.fmt((String)"target.%s.%s", (Object[])new Object[]{this.ctxt.getAutSubStateFieldName(this.aut), this.ctxt.getContVarFieldName(var)});
            }
            throw new RuntimeException("Unknown addr var: " + String.valueOf(addr));
        }

        private void gencodeTypeRangeBoundCheck(Expression addr, String valueRefTxt, CifType valueType, CifType addrType, int level) {
            boolean contained = CifTypeUtils.checkTypeCompat((CifType)addrType, (CifType)valueType, (RangeCompat)RangeCompat.CONTAINED);
            if (contained) {
                return;
            }
            boolean overlap = CifTypeUtils.checkTypeCompat((CifType)addrType, (CifType)valueType, (RangeCompat)RangeCompat.OVERLAP);
            Assert.check((boolean)overlap);
            valueType = CifTypeUtils.normalizeType((CifType)valueType);
            addrType = CifTypeUtils.normalizeType((CifType)addrType);
            if (valueType instanceof IntType) {
                String name;
                Assert.check((boolean)(addrType instanceof IntType));
                IntType typeValue = (IntType)valueType;
                IntType typeAddr = (IntType)addrType;
                List guards = Lists.listc((int)2);
                if (CifTypeUtils.getLowerBound((IntType)typeValue) < CifTypeUtils.getLowerBound((IntType)typeAddr)) {
                    guards.add(Strings.fmt((String)"%s < %d", (Object[])new Object[]{valueRefTxt, typeAddr.getLower()}));
                }
                if (CifTypeUtils.getUpperBound((IntType)typeValue) > CifTypeUtils.getUpperBound((IntType)typeAddr)) {
                    guards.add(Strings.fmt((String)"%s > %d", (Object[])new Object[]{valueRefTxt, typeAddr.getUpper()}));
                }
                Assert.check((!guards.isEmpty() ? 1 : 0) != 0);
                String guard = String.join((CharSequence)" || ", guards);
                if (addr instanceof DiscVariableExpression) {
                    DiscVariableExpression vaddr = (DiscVariableExpression)addr;
                    name = vaddr.getVariable().getName();
                } else {
                    ContVariableExpression vaddr = (ContVariableExpression)addr;
                    name = vaddr.getVariable().getName();
                }
                this.c.add("if (%s) {", new Object[]{guard});
                this.c.indent();
                this.c.add("throw new CifSimulatorException(fmt(\"Variable \\\"%s\\\" is assigned value \\\"%%s\\\", which violates the integer type bounds of the type \\\"%s\\\" of that variable.\", runtimeToString(%s)));", new Object[]{name, CifTextUtils.typeToStr((CifType)addr.getType()), this.gencodeAddrVarRef(addr)});
                this.c.dedent();
                this.c.add("}");
            } else if (valueType instanceof ListType) {
                Assert.check((boolean)(addrType instanceof ListType));
                ListType typeValue = (ListType)valueType;
                ListType typeAddr = (ListType)addrType;
                List guards = Lists.listc((int)2);
                if (CifTypeUtils.getLowerBound((ListType)typeValue) < CifTypeUtils.getLowerBound((ListType)typeAddr)) {
                    guards.add(Strings.fmt((String)"%s.size() < %d", (Object[])new Object[]{valueRefTxt, typeAddr.getLower()}));
                }
                if (CifTypeUtils.getUpperBound((ListType)typeValue) > CifTypeUtils.getUpperBound((ListType)typeAddr)) {
                    guards.add(Strings.fmt((String)"%s.size() > %d", (Object[])new Object[]{valueRefTxt, typeAddr.getUpper()}));
                }
                if (!guards.isEmpty()) {
                    String name;
                    String guard = String.join((CharSequence)" || ", guards);
                    if (addr instanceof DiscVariableExpression) {
                        DiscVariableExpression vaddr = (DiscVariableExpression)addr;
                        name = vaddr.getVariable().getName();
                    } else {
                        ContVariableExpression vaddr = (ContVariableExpression)addr;
                        name = vaddr.getVariable().getName();
                    }
                    this.c.add("if (%s) {", new Object[]{guard});
                    this.c.indent();
                    this.c.add("throw new CifSimulatorException(fmt(\"Variable \\\"%s\\\" is assigned value \\\"%%s\\\", which violates the list type bounds of the type \\\"%s\\\" of that variable.\", runtimeToString(%s)));", new Object[]{name, CifTextUtils.typeToStr((CifType)addr.getType()), this.gencodeAddrVarRef(addr)});
                    this.c.dedent();
                    this.c.add("}");
                }
                this.c.add("for (%s elem%d: %s) {", new Object[]{TypeCodeGenerator.gencodeType(typeValue.getElementType(), this.ctxt), level, valueRefTxt});
                this.c.indent();
                this.gencodeTypeRangeBoundCheck(addr, "elem" + level, typeValue.getElementType(), typeAddr.getElementType(), level + 1);
                this.c.dedent();
                this.c.add("}");
            } else if (valueType instanceof SetType) {
                Assert.check((boolean)(addrType instanceof SetType));
                SetType typeValue = (SetType)valueType;
                SetType typeAddr = (SetType)addrType;
                this.c.add("for (%s elem%d: %s) {", new Object[]{TypeCodeGenerator.gencodeType(typeValue.getElementType(), this.ctxt), level, valueRefTxt});
                this.c.indent();
                this.gencodeTypeRangeBoundCheck(addr, "elem" + level, typeValue.getElementType(), typeAddr.getElementType(), level + 1);
                this.c.dedent();
                this.c.add("}");
            } else if (valueType instanceof DictType) {
                Assert.check((boolean)(addrType instanceof DictType));
                DictType typeValue = (DictType)valueType;
                DictType typeAddr = (DictType)addrType;
                this.c.add("for (Entry<%s, %s> elem%d: %s.entrySet()) {", new Object[]{TypeCodeGenerator.gencodeType(typeValue.getKeyType(), this.ctxt, true), TypeCodeGenerator.gencodeType(typeValue.getValueType(), this.ctxt, true), level, valueRefTxt});
                this.c.indent();
                this.gencodeTypeRangeBoundCheck(addr, "elem" + level + ".getKey()", typeValue.getKeyType(), typeAddr.getKeyType(), level + 1);
                this.gencodeTypeRangeBoundCheck(addr, "elem" + level + ".getValue()", typeValue.getValueType(), typeAddr.getValueType(), level + 1);
                this.c.dedent();
                this.c.add("}");
            } else if (valueType instanceof TupleType) {
                Assert.check((boolean)(addrType instanceof TupleType));
                TupleType typeValue = (TupleType)valueType;
                TupleType typeAddr = (TupleType)addrType;
                EList fieldsValue = typeValue.getFields();
                EList fieldsAddr = typeAddr.getFields();
                int i = 0;
                while (i < fieldsValue.size()) {
                    Field fieldValue = (Field)fieldsValue.get(i);
                    Field fieldAddr = (Field)fieldsAddr.get(i);
                    String newRefTxt = valueRefTxt + ".";
                    newRefTxt = newRefTxt + this.ctxt.getTupleTypeFieldFieldName(typeAddr, i);
                    this.gencodeTypeRangeBoundCheck(addr, newRefTxt, fieldValue.getType(), fieldAddr.getType(), level);
                    ++i;
                }
            }
        }
    }
}

