/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.simulator.compiler.CifCompilerContext;
import org.eclipse.escet.cif.simulator.compiler.JavaCodeFile;
import org.eclipse.escet.cif.simulator.compiler.TypeCodeGenerator;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class StateCodeGenerator {
    private StateCodeGenerator() {
    }

    public static void gencodeState(Specification spec, CifCompilerContext ctxt) {
        Declaration var;
        JavaCodeFile file = ctxt.addCodeFile("State");
        CodeBox h = file.header;
        h.add("/** Runtime state. */");
        h.add("public final class State extends RuntimeState {");
        CodeBox c = file.body;
        List<Declaration> vars = ctxt.getStateVars();
        c.add("private static String[] STATE_VAR_NAMES = {");
        c.indent();
        for (Declaration var2 : vars) {
            c.add("\"%s\",", new Object[]{CifTextUtils.getAbsName((PositionObject)var2)});
        }
        c.dedent();
        c.add("};");
        c.add();
        for (Automaton aut : ctxt.getAutomata()) {
            c.add("public State%s %s;", new Object[]{ctxt.getAutClassName(aut), ctxt.getAutSubStateFieldName(aut)});
        }
        c.add("public StateCont %s;", new Object[]{"s"});
        c.add("public StateInputVars %s;", new Object[]{"i"});
        c.add();
        c.add("// Private constructor, to force the use of create/copy.");
        c.add("private State(RuntimeSpec<?> spec) {");
        c.indent();
        c.add("super(spec);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static State create(RuntimeSpec<?> spec) {");
        c.indent();
        c.add("State rslt = new State(spec);");
        for (Automaton aut : ctxt.getAutomata()) {
            c.add("rslt.%s = new State%s();", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutClassName(aut)});
        }
        c.add("rslt.%s = new StateCont();", new Object[]{"s"});
        c.add("rslt.%s = new StateInputVars();", new Object[]{"i"});
        c.add("new StateInit().initState(spec, rslt);");
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("public static State copy(State state) {");
        c.indent();
        c.add("State rslt = new State(state.spec);");
        for (Automaton aut : ctxt.getAutomata()) {
            c.add("rslt.%s = state.%s;", new Object[]{ctxt.getAutSubStateFieldName(aut), ctxt.getAutSubStateFieldName(aut)});
        }
        c.add("rslt.%s = state.%s;", new Object[]{"s", "s"});
        c.add("rslt.%s = state.%s;", new Object[]{"i", "i"});
        c.add("return rslt;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public double getTime() {");
        c.indent();
        c.add("return %s.time;", new Object[]{"s"});
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String[] getStateVarNames() {");
        c.indent();
        c.add("return STATE_VAR_NAMES;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public Object getStateVarValue(int idx) {");
        c.indent();
        c.add("switch (idx) {");
        c.indent();
        int i = 0;
        while (i < vars.size()) {
            var = vars.get(i);
            if (var instanceof InputVariable) {
                c.add("case %d: return %s.%s;", new Object[]{i, "i", ctxt.getInputVarFieldName((InputVariable)var)});
            } else {
                EObject parent = var.eContainer();
                if (parent instanceof Automaton) {
                    String varField = var instanceof DiscVariable ? ctxt.getDiscVarFieldName((DiscVariable)var) : ctxt.getContVarFieldName((ContVariable)var);
                    Automaton aut = (Automaton)parent;
                    c.add("case %d: return %s.%s;", new Object[]{i, ctxt.getAutSubStateFieldName(aut), varField});
                } else {
                    c.add("case %d: return %s.%s;", new Object[]{i, "s", ctxt.getContVarFieldName((ContVariable)var)});
                }
            }
            ++i;
        }
        c.add("default: throw new RuntimeException(\"Unknown idx: \" + idx);");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public double getStateVarDerValue(int idx) {");
        c.indent();
        c.add("switch (idx) {");
        c.indent();
        i = 0;
        while (i < vars.size()) {
            var = vars.get(i);
            if (var instanceof ContVariable) {
                ContVariable cvar = (ContVariable)var;
                c.add("case %d: return Derivatives.%s(this);", new Object[]{i, ctxt.getDerivativeMethodName(cvar)});
            }
            ++i;
        }
        c.add("default: throw new RuntimeException(\"Unknown idx or not a continuous variable: \" + idx);");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String[] getAlgVarNames() {");
        c.indent();
        c.add("return AlgVars.ALG_VAR_NAMES;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public Object getAlgVarValue(int idx) {");
        c.indent();
        c.add("switch (idx) {");
        c.indent();
        List<AlgVariable> algVars = ctxt.getAlgVars();
        int i2 = 0;
        while (i2 < algVars.size()) {
            AlgVariable var3 = algVars.get(i2);
            c.add("case %d: return AlgVars.%s(this);", new Object[]{i2, ctxt.getAlgVarMethodName(var3)});
            ++i2;
        }
        c.add("default: throw new RuntimeException(\"Unknown idx: \" + idx);");
        c.dedent();
        c.add("}");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public String getAutCurLocName(int idx) {");
        c.indent();
        List<Automaton> automata = ctxt.getAutomata();
        if (!automata.isEmpty()) {
            c.add("int locIdx;");
            c.add("switch (idx) {");
            c.indent();
            int i3 = 0;
            while (i3 < automata.size()) {
                Automaton aut = automata.get(i3);
                c.add("case %d: locIdx = %s.%s; break;", new Object[]{i3, ctxt.getAutSubStateFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
                ++i3;
            }
            c.add("default:");
            c.indent();
        }
        c.add("throw new RuntimeException(\"Invalid aut idx: \" + idx);");
        if (!automata.isEmpty()) {
            c.dedent();
            c.dedent();
            c.add("}");
            c.add("return spec.automata.get(idx).getLocName(locIdx);");
        }
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public boolean checkInitialization() {");
        c.indent();
        c.add("if (!SPEC.evalInitPreds(this)) return false;");
        c.add("if (!SPEC.evalStateInvPreds(this, true)) return false;");
        c.add("return true;");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void calcTransitions(Double endTime, Double maxDelay) {");
        c.indent();
        c.add("SPEC.calcTransitions(this, endTime, maxDelay);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public void calcTimeTransition(Double endTime) {");
        c.indent();
        c.add("SPEC.calcTimeTransition(this, endTime, null);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public Transition<?> chooseTransition(RuntimeState state, List<Transition<?>> transitions, SimulationResult result) {");
        c.indent();
        c.add("@SuppressWarnings({\"rawtypes\", \"unchecked\"})");
        c.add("List<Transition<State>> transitions2 = (List)transitions;");
        c.add("return SPEC.input.chooseTransition((State)state, transitions2, result);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public ChosenTargetTime chooseTargetTime(double maxTargetTime) {");
        c.indent();
        c.add("return SPEC.input.chooseTargetTime(this, maxTargetTime);");
        c.dedent();
        c.add("}");
        c.add();
        c.add("@Override");
        c.add("public Double getNextMaxEndTime() {");
        c.indent();
        c.add("return SPEC.input.getNextMaxEndTime(this);");
        c.dedent();
        c.add("}");
    }

    public static void gencodeSubStates(Specification spec, CifCompilerContext ctxt) {
        for (Automaton aut : ctxt.getAutomata()) {
            StateCodeGenerator.gencodeSubState(aut, ctxt);
        }
        StateCodeGenerator.gencodeSubStateCont(spec, ctxt);
        StateCodeGenerator.gencodeSubStateInputVars(spec, ctxt);
    }

    private static void gencodeSubState(Automaton aut, CifCompilerContext ctxt) {
        DiscVariable var;
        String className = "State" + ctxt.getAutClassName(aut);
        JavaCodeFile file = ctxt.addCodeFile(className);
        String absName = CifTextUtils.getAbsName((PositionObject)aut);
        CodeBox h = file.header;
        h.add("/** Runtime sub-state for automaton \"%s\". */", new Object[]{absName});
        h.add("public final class %s {", new Object[]{className});
        CodeBox c = file.body;
        c.add("public %s %s;", new Object[]{"int", ctxt.getLocationPointerFieldName(aut)});
        for (Declaration decl : aut.getDeclarations()) {
            if (decl instanceof DiscVariable) {
                var = (DiscVariable)decl;
                c.add("public %s %s;", new Object[]{TypeCodeGenerator.gencodeType(var.getType(), ctxt), ctxt.getDiscVarFieldName(var)});
                continue;
            }
            if (decl instanceof InputVariable || !(decl instanceof ContVariable)) continue;
            var = (ContVariable)decl;
            c.add("public double %s;", new Object[]{ctxt.getContVarFieldName((ContVariable)var)});
        }
        c.add();
        c.add("public %s copy() {", new Object[]{className});
        c.indent();
        c.add("%s rslt = new %s();", new Object[]{className, className});
        c.add("rslt.%s = %s;", new Object[]{ctxt.getLocationPointerFieldName(aut), ctxt.getLocationPointerFieldName(aut)});
        for (Declaration decl : aut.getDeclarations()) {
            if (decl instanceof DiscVariable) {
                var = (DiscVariable)decl;
                c.add("rslt.%s = %s;", new Object[]{ctxt.getDiscVarFieldName(var), ctxt.getDiscVarFieldName(var)});
                continue;
            }
            if (decl instanceof InputVariable || !(decl instanceof ContVariable)) continue;
            var = (ContVariable)decl;
            c.add("rslt.%s = %s;", new Object[]{ctxt.getContVarFieldName((ContVariable)var), ctxt.getContVarFieldName((ContVariable)var)});
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }

    private static void gencodeSubStateCont(Specification spec, CifCompilerContext ctxt) {
        List variables = Lists.list();
        StateCodeGenerator.collectContVarsNotInAut((ComplexComponent)spec, variables);
        JavaCodeFile file = ctxt.addCodeFile("StateCont");
        CodeBox h = file.header;
        h.add("/**");
        h.add(" * Runtime sub-state for continuous variables declared outside the automata,");
        h.add(" * and variable 'time'.");
        h.add(" */");
        h.add("public final class StateCont {");
        CodeBox c = file.body;
        c.add("public double time;");
        for (ContVariable var : variables) {
            c.add("public double %s;", new Object[]{ctxt.getContVarFieldName(var)});
        }
        c.add();
        c.add("public StateCont copy() {");
        c.indent();
        c.add("StateCont rslt = new StateCont();");
        c.add("rslt.time = time;");
        for (ContVariable var : variables) {
            c.add("rslt.%s = %s;", new Object[]{ctxt.getContVarFieldName(var), ctxt.getContVarFieldName(var)});
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }

    private static void gencodeSubStateInputVars(Specification spec, CifCompilerContext ctxt) {
        List<InputVariable> variables = ctxt.getInputVariables();
        JavaCodeFile file = ctxt.addCodeFile("StateInputVars");
        CodeBox h = file.header;
        h.add("/** Runtime sub-state for input variables. */");
        h.add("public final class StateInputVars {");
        CodeBox c = file.body;
        for (InputVariable var : variables) {
            c.add("public %s %s;", new Object[]{TypeCodeGenerator.gencodeType(var.getType(), ctxt), ctxt.getInputVarFieldName(var)});
        }
        c.add();
        c.add("public StateInputVars copy() {");
        c.indent();
        c.add("StateInputVars rslt = new StateInputVars();");
        for (InputVariable var : variables) {
            c.add("rslt.%s = %s;", new Object[]{ctxt.getInputVarFieldName(var), ctxt.getInputVarFieldName(var)});
        }
        c.add("return rslt;");
        c.dedent();
        c.add("}");
    }

    private static void collectContVarsNotInAut(ComplexComponent comp, List<ContVariable> vars) {
        if (comp instanceof Automaton) {
            return;
        }
        for (Declaration decl : comp.getDeclarations()) {
            if (!(decl instanceof ContVariable)) continue;
            vars.add((ContVariable)decl);
        }
        for (Component child : ((Group)comp).getComponents()) {
            StateCodeGenerator.collectContVarsNotInAut((ComplexComponent)child, vars);
        }
    }
}

