/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.ElifUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.IfUpdate;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.expressions.ContVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class CifAddressableUtils {
    private CifAddressableUtils() {
    }

    public static List<Expression> getRefExprs(Expression addr) {
        if (addr instanceof TupleExpression) {
            List rslt = Lists.list();
            for (Expression elem : ((TupleExpression)addr).getFields()) {
                rslt.addAll(CifAddressableUtils.getRefExprs(elem));
            }
            return rslt;
        }
        if (addr instanceof ProjectionExpression) {
            while (addr instanceof ProjectionExpression) {
                addr = ((ProjectionExpression)addr).getChild();
            }
            return Lists.list((Object)addr);
        }
        return Lists.list((Object)addr);
    }

    public static Set<Declaration> getRefs(Expression addr) throws DuplVarAsgnException {
        List<Expression> refExprs = CifAddressableUtils.getRefExprs(addr);
        Set rslt = Sets.set();
        for (Expression refExpr : refExprs) {
            if (refExpr instanceof DiscVariableExpression) {
                rslt.add(((DiscVariableExpression)refExpr).getVariable());
                continue;
            }
            if (refExpr instanceof ContVariableExpression) {
                rslt.add(((ContVariableExpression)refExpr).getVariable());
                continue;
            }
            if (refExpr instanceof InputVariableExpression) {
                rslt.add(((InputVariableExpression)refExpr).getVariable());
                continue;
            }
            throw new RuntimeException("Unknown addressable: " + String.valueOf(addr));
        }
        if (refExprs.size() != rslt.size()) {
            throw new DuplVarAsgnException();
        }
        return rslt;
    }

    public static Expression stripProjs(Expression addr) {
        Expression rslt = addr;
        while (rslt instanceof ProjectionExpression) {
            rslt = ((ProjectionExpression)rslt).getChild();
        }
        return rslt;
    }

    public static List<ProjectionExpression> collectProjs(Expression addr) {
        Assert.check((!(addr instanceof TupleExpression) ? 1 : 0) != 0);
        List rslt = Lists.list();
        while (addr instanceof ProjectionExpression) {
            ProjectionExpression paddr = (ProjectionExpression)addr;
            rslt.add(paddr);
            addr = paddr.getChild();
        }
        rslt = Lists.reverse((List)rslt);
        return rslt;
    }

    public static void collectAddrVars(List<Update> updates, Set<Declaration> vars) {
        for (Update update : updates) {
            CifAddressableUtils.collectAddrVars(update, vars);
        }
    }

    public static void collectAddrVars(Update update, Set<Declaration> vars) {
        if (update instanceof IfUpdate) {
            IfUpdate ifUpd = (IfUpdate)update;
            CifAddressableUtils.collectAddrVars((List<Update>)ifUpd.getThens(), vars);
            for (ElifUpdate elifUpd : ifUpd.getElifs()) {
                CifAddressableUtils.collectAddrVars((List<Update>)elifUpd.getThens(), vars);
            }
            CifAddressableUtils.collectAddrVars((List<Update>)ifUpd.getElses(), vars);
        } else {
            Assignment asgn = (Assignment)update;
            CifAddressableUtils.collectAddrVars(asgn.getAddressable(), vars);
        }
    }

    public static void collectAddrVars(Expression addr, Set<Declaration> vars) {
        if (addr instanceof TupleExpression) {
            for (Expression elem : ((TupleExpression)addr).getFields()) {
                CifAddressableUtils.collectAddrVars(elem, vars);
            }
        } else if (addr instanceof ProjectionExpression) {
            while (addr instanceof ProjectionExpression) {
                addr = ((ProjectionExpression)addr).getChild();
            }
            CifAddressableUtils.collectAddrVars(addr, vars);
        } else if (addr instanceof DiscVariableExpression) {
            vars.add((Declaration)((DiscVariableExpression)addr).getVariable());
        } else if (addr instanceof ContVariableExpression) {
            vars.add((Declaration)((ContVariableExpression)addr).getVariable());
        } else if (addr instanceof InputVariableExpression) {
            vars.add((Declaration)((InputVariableExpression)addr).getVariable());
        } else {
            throw new RuntimeException("Unknown addr: " + String.valueOf(addr));
        }
    }

    public static void collectAddrVars(Automaton aut, Set<Declaration> vars) {
        for (Location loc : aut.getLocations()) {
            for (Edge edge : loc.getEdges()) {
                CifAddressableUtils.collectAddrVars((List<Update>)edge.getUpdates(), vars);
            }
        }
    }

    public static class DuplVarAsgnException
    extends Exception {
    }
}

