/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.AndExpression;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.commands.internal.HandlerServiceHandler;
import org.eclipse.e4.core.commands.internal.ICommandHelpService;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.expressions.WorkbenchWindowExpression;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.ISourceProviderService;

public class LegacyHandlerService
implements IHandlerService {
    private static final String[] SELECTION_VARIABLES = new String[]{"selection", "activeFocusControlId", "activeFocusControl", "activeMenuEditorInput", "activeMenu", "activeMenuSelection"};
    public static final String LEGACY_H_ID = "legacy::handler::";
    private static IHandlerActivation systemHandlerActivation;
    private IEclipseContext eclipseContext;
    private IEvaluationContext evalContext;
    private Expression defaultExpression = null;
    private final Collection<HandlerActivation> handlerActivations = new ArrayList<HandlerActivation>();
    private static Field contextFVariables;

    static {
        contextFVariables = null;
    }

    private static IHandlerActivation registerLegacyHandler(IEclipseContext context, String cmdId, IHandler handler, Expression activeWhen) {
        return LegacyHandlerService.registerLegacyHandler(context, cmdId, handler, activeWhen, null, null);
    }

    private static IHandlerActivation registerLegacyHandler(IEclipseContext context, String cmdId, IHandler handler, Expression activeWhen, String helpContextId, Collection<HandlerActivation> handlerActivations) {
        ECommandService cs = (ECommandService)context.get(ECommandService.class);
        Command command = cs.getCommand(cmdId);
        E4HandlerProxy handlerProxy = new E4HandlerProxy(command, handler);
        if (helpContextId != null) {
            LegacyHandlerService.setHelpContextId(handler, helpContextId, context);
        }
        HandlerActivation activation = new HandlerActivation(context, cmdId, handler, handlerProxy, activeWhen);
        LegacyHandlerService.addHandlerActivation(activation);
        EHandlerService hs = (EHandlerService)context.get(EHandlerService.class);
        hs.activateHandler(cmdId, (Object)new HandlerSelectionFunction(cmdId));
        if (handlerActivations != null) {
            handlerActivations.add(activation);
        }
        return activation;
    }

    static void addHandlerActivation(HandlerActivation eActivation) {
        ArrayList<HandlerActivation> handlerActivations = (ArrayList<HandlerActivation>)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        if (handlerActivations == null) {
            handlerActivations = new ArrayList<HandlerActivation>();
        } else {
            if (handlerActivations.contains(eActivation)) {
                return;
            }
            handlerActivations = new ArrayList(handlerActivations);
        }
        handlerActivations.add(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    static void removeHandlerActivation(HandlerActivation eActivation) {
        ArrayList handlerActivations = (ArrayList)eActivation.context.getLocal(LEGACY_H_ID + eActivation.getCommandId());
        handlerActivations = handlerActivations == null ? new ArrayList() : new ArrayList(handlerActivations);
        handlerActivations.remove(eActivation);
        eActivation.context.set(LEGACY_H_ID + eActivation.getCommandId(), handlerActivations);
    }

    public LegacyHandlerService(IEclipseContext context) {
        this.eclipseContext = context;
        this.evalContext = new ExpressionContext(this.eclipseContext);
        IWorkbenchWindow window = (IWorkbenchWindow)this.eclipseContext.get(IWorkbenchWindow.class);
        if (window != null) {
            this.defaultExpression = new WorkbenchWindowExpression(window);
        }
    }

    public LegacyHandlerService(IEclipseContext context, Expression defaultExpression) {
        this.eclipseContext = context;
        this.evalContext = new ExpressionContext(this.eclipseContext);
        this.defaultExpression = defaultExpression;
    }

    @Override
    public void addSourceProvider(ISourceProvider provider) {
    }

    @Override
    public void removeSourceProvider(ISourceProvider provider) {
    }

    private void clearActivations() {
        this.deactivateHandlers(this.handlerActivations);
        for (final IHandlerActivation iHandlerActivation : this.handlerActivations) {
            final IHandler handler = iHandlerActivation.getHandler();
            if (handler == null) continue;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    handler.dispose();
                }

                public void handleException(Throwable exception) {
                    WorkbenchPlugin.log("Failed to dispose handler for " + iHandlerActivation.getCommandId(), exception);
                }
            });
        }
        this.handlerActivations.clear();
    }

    @Override
    public void dispose() {
        this.clearActivations();
        this.defaultExpression = null;
        this.eclipseContext = null;
        this.evalContext = null;
    }

    @Override
    public IHandlerActivation activateHandler(IHandlerActivation activation) {
        if (activation == systemHandlerActivation) {
            return activation;
        }
        HandlerActivation handlerActivation = (HandlerActivation)activation;
        handlerActivation.participating = true;
        LegacyHandlerService.addHandlerActivation(handlerActivation);
        return activation;
    }

    @Override
    public IHandlerActivation activateHandler(String commandId, IHandler handler) {
        return this.activateHandler(commandId, handler, null, false);
    }

    @Override
    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    @Override
    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, boolean global) {
        Expression e;
        if (global || this.defaultExpression == null) {
            return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, handler, expression);
        }
        if (expression != null) {
            AndExpression andExpr = new AndExpression();
            andExpr.add(expression);
            andExpr.add(this.defaultExpression);
            e = andExpr;
        } else {
            e = this.defaultExpression;
        }
        return LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, handler, e);
    }

    @Override
    public IHandlerActivation activateHandler(String commandId, IHandler handler, Expression expression, int sourcePriorities) {
        return this.activateHandler(commandId, handler, expression, false);
    }

    @Override
    public ExecutionEvent createExecutionEvent(Command command, Event event) {
        EvaluationContext legacy = new EvaluationContext(this.evalContext, this.evalContext.getDefaultVariable());
        return new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, (Object)legacy);
    }

    @Override
    public ExecutionEvent createExecutionEvent(ParameterizedCommand command, Event event) {
        EvaluationContext legacy = new EvaluationContext(this.evalContext, this.evalContext.getDefaultVariable());
        return new ExecutionEvent(command.getCommand(), command.getParameterMap(), (Object)event, (Object)legacy);
    }

    @Override
    public void deactivateHandler(IHandlerActivation activation) {
        if (activation != null && activation != systemHandlerActivation) {
            HandlerActivation eActivation = (HandlerActivation)activation;
            eActivation.participating = false;
            LegacyHandlerService.removeHandlerActivation(eActivation);
        }
    }

    @Override
    public void deactivateHandlers(Collection activations) {
        for (Object activation : activations) {
            ((HandlerActivation)activation).participating = false;
        }
        for (Object element : activations) {
            this.deactivateHandler((IHandlerActivation)element);
        }
    }

    @Override
    public Object executeCommand(String commandId, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        ECommandService cs = (ECommandService)this.eclipseContext.get(ECommandService.class);
        Command command = cs.getCommand(commandId);
        return this.executeCommand(ParameterizedCommand.generateCommand((Command)command, null), event);
    }

    @Override
    public Object executeCommand(ParameterizedCommand command, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        EHandlerService hs = (EHandlerService)this.eclipseContext.get(EHandlerService.class);
        if (hs == null) {
            WorkbenchPlugin.log("IEclipseContext is " + String.valueOf(this.eclipseContext));
            WorkbenchPlugin.log("EHandlerService is null", new IllegalStateException("EHandlerService must not be null"));
            throw new ExecutionException("No handler service available");
        }
        IEclipseContext staticContext = EclipseContextFactory.create();
        if (event != null) {
            staticContext.set(Event.class, (Object)event);
        }
        try {
            Object rc = hs.executeHandler(command, staticContext);
            Object obj = staticContext.get("HandlerServiceImpl.exception");
            if (obj instanceof ExecutionException) {
                throw (ExecutionException)((Object)obj);
            }
            if (obj instanceof NotDefinedException) {
                throw (NotDefinedException)((Object)obj);
            }
            if (obj instanceof NotEnabledException) {
                throw (NotEnabledException)obj;
            }
            if (obj instanceof NotHandledException) {
                throw (NotHandledException)((Object)obj);
            }
            if (obj instanceof Exception) {
                WorkbenchPlugin.log((Exception)obj);
            }
            Object object = rc;
            return object;
        }
        catch (InjectionException e) {
            this.rethrow(e);
            throw e;
        }
        finally {
            staticContext.dispose();
        }
    }

    @Override
    public Object executeCommandInContext(ParameterizedCommand command, Event event, IEvaluationContext context) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IHandler handler = command.getCommand().getHandler();
        boolean enabled = handler.isEnabled();
        IEclipseContext staticContext = null;
        Object defaultVar = null;
        if (context instanceof ExpressionContext) {
            staticContext = ((ExpressionContext)context).eclipseContext.createChild();
        } else {
            staticContext = this.eclipseContext.getActiveLeaf().createChild("snapshotContext");
            if (event != null) {
                staticContext.set(Event.class, (Object)event);
            }
            staticContext.set(IEvaluationContext.class, (Object)context);
            defaultVar = context.getDefaultVariable();
            if (defaultVar != null && defaultVar != IEvaluationContext.UNDEFINED_VARIABLE) {
                staticContext.set("org.eclipse.ui.internal.services.EvaluationService.default_var", defaultVar);
            }
        }
        IEclipseContext lookupContext = staticContext;
        this.populateSnapshot(context, staticContext);
        EHandlerService hs = (EHandlerService)lookupContext.get(EHandlerService.class);
        try {
            Object rc = hs.executeHandler(command, staticContext);
            Object obj = staticContext.get("HandlerServiceImpl.exception");
            if (obj instanceof ExecutionException) {
                throw (ExecutionException)((Object)obj);
            }
            if (obj instanceof NotDefinedException) {
                throw (NotDefinedException)((Object)obj);
            }
            if (obj instanceof NotEnabledException) {
                throw (NotEnabledException)obj;
            }
            if (obj instanceof NotHandledException) {
                throw (NotHandledException)((Object)obj);
            }
            if (obj instanceof Exception) {
                WorkbenchPlugin.log((Exception)obj);
            }
            Object object = rc;
            return object;
        }
        catch (InjectionException e) {
            this.rethrow(e);
            throw e;
        }
        finally {
            if (handler.isEnabled() != enabled && handler instanceof HandlerServiceHandler) {
                ((HandlerServiceHandler)handler).overrideEnabled(enabled);
            }
            staticContext.dispose();
        }
    }

    private void populateSnapshot(IEvaluationContext context, IEclipseContext staticContext) {
        IEvaluationContext ctxPtr = context;
        while (ctxPtr != null && !(ctxPtr instanceof ExpressionContext)) {
            Map<?, ?> vars = this.getVariables(ctxPtr);
            if (vars != null) {
                for (Map.Entry<?, ?> entry : vars.entrySet()) {
                    if (staticContext.getLocal(entry.getKey().toString()) != null) continue;
                    staticContext.set(entry.getKey().toString(), entry.getValue());
                }
            }
            ctxPtr = ctxPtr.getParent();
        }
    }

    private Map<?, ?> getVariables(IEvaluationContext ctx) {
        Field vars = LegacyHandlerService.getContextVariablesField();
        if (vars != null) {
            try {
                return (Map)vars.get(ctx);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Field getContextVariablesField() {
        if (contextFVariables == null) {
            try {
                contextFVariables = EvaluationContext.class.getField("fVariables");
                contextFVariables.setAccessible(true);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        return contextFVariables;
    }

    private void rethrow(InjectionException e) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        Throwable cause = e.getCause();
        if (cause instanceof ExecutionException) {
            throw (ExecutionException)cause;
        }
        if (cause instanceof NotDefinedException) {
            throw (NotDefinedException)cause;
        }
        if (cause instanceof NotEnabledException) {
            throw (NotEnabledException)cause;
        }
        if (cause instanceof NotHandledException) {
            throw (NotHandledException)cause;
        }
    }

    @Override
    public IEvaluationContext createContextSnapshot(boolean includeSelection) {
        int n;
        IEvaluationContext tmpContext = this.getCurrentState();
        EvaluationContext context = new EvaluationContext(null, IEvaluationContext.UNDEFINED_VARIABLE);
        if (includeSelection) {
            String[] stringArray = SELECTION_VARIABLES;
            n = SELECTION_VARIABLES.length;
            int n2 = 0;
            while (n2 < n) {
                String variable = stringArray[n2];
                this.copyVariable((IEvaluationContext)context, tmpContext, variable);
                ++n2;
            }
        }
        ISourceProviderService sp = (ISourceProviderService)this.eclipseContext.get(ISourceProviderService.class);
        ISourceProvider[] iSourceProviderArray = sp.getSourceProviders();
        int n3 = iSourceProviderArray.length;
        n = 0;
        while (n < n3) {
            String[] names;
            ISourceProvider provider = iSourceProviderArray[n];
            String[] stringArray = names = provider.getProvidedSourceNames();
            int n4 = names.length;
            int n5 = 0;
            while (n5 < n4) {
                String name = stringArray[n5];
                if (!this.isSelectionVariable(name)) {
                    this.copyVariable((IEvaluationContext)context, tmpContext, name);
                }
                ++n5;
            }
            ++n;
        }
        return context;
    }

    private boolean isSelectionVariable(String name) {
        String[] stringArray = SELECTION_VARIABLES;
        int n = SELECTION_VARIABLES.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            if (variable.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void copyVariable(IEvaluationContext context, IEvaluationContext tmpContext, String var) {
        Object o = tmpContext.getVariable(var);
        if (o != null) {
            context.addVariable(var, o);
        }
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return new EvaluationContext(this.evalContext, this.evalContext.getDefaultVariable());
    }

    @Override
    public void readRegistry() {
        this.clearActivations();
        this.readDefaultHandlers();
        this.readHandlers();
    }

    /*
     * Unable to fully structure code
     */
    private void readHandlers() {
        registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class);
        extPoint = registry.getExtensionPoint("org.eclipse.ui.handlers");
        var7_4 = elements = extPoint.getConfigurationElements();
        var6_5 = elements.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block11: {
                block9: {
                    block12: {
                        configElement = var7_4[var5_6];
                        commandId = configElement.getAttribute("commandId");
                        if (commandId == null || commandId.isEmpty() || (defaultHandler = configElement.getAttribute("class")) == null && configElement.getChildren("class").length == 0) break block11;
                        activeWhen = null;
                        awChildren = configElement.getChildren("activeWhen");
                        if (awChildren.length <= 0) break block9;
                        subChildren = awChildren[0].getChildren();
                        if (subChildren.length == 1) break block12;
                        if (Policy.DEBUG_CMDS) {
                            Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), null);
                        }
                        break block11;
                    }
                    elementHandler = ElementHandler.getDefault();
                    converter = ExpressionConverter.getDefault();
                    try {
                        activeWhen = elementHandler.create(converter, subChildren[0]);
                    }
                    catch (CoreException e) {
                        if (!Policy.DEBUG_CMDS) break block9;
                        Activator.trace((String)"/trace/commands", (String)("Incorrect activeWhen element " + commandId), (Throwable)e);
                    }
                }
                enabledWhen = null;
                ewChildren = configElement.getChildren("enabledWhen");
                if (ewChildren.length <= 0) ** GOTO lbl44
                subChildren = ewChildren[0].getChildren();
                if (subChildren.length != 1) {
                    if (Policy.DEBUG_CMDS) {
                        Activator.trace((String)"/trace/commands", (String)("Incorrect enableWhen element " + commandId), null);
                    }
                } else {
                    block10: {
                        elementHandler = ElementHandler.getDefault();
                        converter = ExpressionConverter.getDefault();
                        try {
                            enabledWhen = elementHandler.create(converter, subChildren[0]);
                        }
                        catch (CoreException e) {
                            if (!Policy.DEBUG_CMDS) break block10;
                            Activator.trace((String)"/trace/commands", (String)("Incorrect enableWhen element " + commandId), (Throwable)e);
                        }
                    }
                    LegacyHandlerService.registerLegacyHandler(this.eclipseContext, commandId, (IHandler)new HandlerProxy(commandId, configElement, "class", enabledWhen, (IEvaluationService)this.eclipseContext.get(IEvaluationService.class)), activeWhen, configElement.getAttribute("helpContextId"), this.handlerActivations);
                }
            }
            ++var5_6;
        }
    }

    private void readDefaultHandlers() {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = (IExtensionRegistry)this.eclipseContext.get(IExtensionRegistry.class);
        IExtensionPoint extPoint = registry.getExtensionPoint("org.eclipse.ui.commands");
        IConfigurationElement[] iConfigurationElementArray = elements = extPoint.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultHandler;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String id = configElement.getAttribute("id");
            if (!(id == null || id.isEmpty() || (defaultHandler = configElement.getAttribute("defaultHandler")) == null && configElement.getChildren("defaultHandler").length == 0)) {
                LegacyHandlerService.registerLegacyHandler(this.eclipseContext, id, (IHandler)new HandlerProxy(id, configElement, "defaultHandler"), null, null, this.handlerActivations);
            }
            ++n2;
        }
    }

    @Override
    public void setHelpContextId(IHandler handler, String helpContextId) {
        LegacyHandlerService.setHelpContextId(handler, helpContextId, this.eclipseContext);
    }

    private static void setHelpContextId(IHandler handler, String helpContextId, IEclipseContext eclipseContext) {
        ICommandHelpService commandHelpService = (ICommandHelpService)eclipseContext.get(ICommandHelpService.class);
        commandHelpService.setHelpContextId(handler, helpContextId);
    }

    static class HandlerSelectionFunction
    extends ContextFunction {
        private final String commandId;

        public HandlerSelectionFunction(String commandId) {
            this.commandId = commandId;
        }

        public Object compute(IEclipseContext context, String contextKey) {
            LinkedHashSet activationSet = new LinkedHashSet();
            IEclipseContext current = context;
            while (current != null) {
                List handlerActivations = (List)current.getLocal(LegacyHandlerService.LEGACY_H_ID + this.commandId);
                if (handlerActivations != null) {
                    activationSet.addAll(handlerActivations);
                }
                current = current.getParent();
            }
            if (activationSet.isEmpty()) {
                return null;
            }
            HandlerActivation bestActivation = null;
            ExpressionContext legacyEvalContext = new ExpressionContext(context);
            HandlerActivation conflictBest = null;
            HandlerActivation conflictOther = null;
            for (HandlerActivation handlerActivation : activationSet) {
                if (!handlerActivation.participating || !handlerActivation.evaluate((IEvaluationContext)legacyEvalContext)) continue;
                if (bestActivation == null) {
                    bestActivation = handlerActivation;
                    continue;
                }
                int comparison = bestActivation.compareTo(handlerActivation);
                if (comparison < 0) {
                    bestActivation = handlerActivation;
                    continue;
                }
                if (comparison != 0) continue;
                conflictBest = bestActivation;
                conflictOther = handlerActivation;
            }
            if (bestActivation != null) {
                if (bestActivation == conflictBest) {
                    String fullMessage = "Conflicting handlers: {" + String.valueOf(conflictBest) + "} vs {" + String.valueOf(conflictOther) + "} in: " + String.valueOf(context);
                    String shortMessage = "Conflicting handlers for " + this.commandId + ": {" + String.valueOf(conflictBest.getHandler()) + "} vs {" + String.valueOf(conflictOther.getHandler()) + "} in: " + String.valueOf(context);
                    WorkbenchPlugin.log(shortMessage, new IllegalStateException(fullMessage));
                }
                return bestActivation.proxy;
            }
            return null;
        }
    }
}

