/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.java;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Locale;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;

public class CsvParser {
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char COMMA = ',';
    public static final char DQUOTE = '\"';
    private Reader reader = null;
    private int nextChar = -1;
    private int numFields = -1;

    public CsvParser(Reader reader) {
        if (reader != null) {
            this.setInput(reader);
        }
    }

    public void setInput(Reader reader) {
        this.reader = reader;
        this.nextChar = -1;
        this.numFields = -1;
    }

    public List<List<String>> parse() {
        List<String> line;
        List<List<String>> lines = Lists.list();
        while ((line = this.getLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    public List<String> getLine() {
        if (this.numFields >= 0) {
            boolean advanced = this.advanceChar('\r');
            advanced |= this.advanceChar('\n');
            if (this.isEof()) {
                return null;
            }
            if (!advanced) {
                char k = this.get();
                if (this.isPrintable(k)) {
                    throw new CsvParseError(Strings.fmt("Unexpected character '%c' (Unicode U+%s) found.", Character.valueOf(k), Integer.toHexString(k).toUpperCase(Locale.US)));
                }
                throw new CsvParseError(Strings.fmt("Unexpected character (Unicode U+%s) found.", Integer.toHexString(k).toUpperCase(Locale.US)));
            }
        }
        List<String> line = this.readLine();
        if (this.numFields < 0 || this.numFields == line.size()) {
            this.numFields = line.size();
            return line;
        }
        throw new CsvParseError(Strings.fmt("Incorrect number of fields (%d found, %d expected).", line.size(), this.numFields));
    }

    private List<String> readLine() {
        List<String> line = Lists.list();
        do {
            String s = this.readField();
            line.add(s);
        } while (this.advanceChar(','));
        return line;
    }

    private String readField() {
        if (this.isEof()) {
            return "";
        }
        char k = this.get();
        return k == '\"' ? this.getQuotedField() : this.getUnquotedField();
    }

    private String getQuotedField() {
        Assert.check(this.advanceChar('\"'));
        StringBuilder s = new StringBuilder();
        while (true) {
            if (this.isEof()) {
                throw new CsvParseError("Unexpected EOF while reading a quoted string.");
            }
            char k = this.get();
            if (this.isTextData(k) || k == ',' || k == '\r' || k == '\n') {
                s.append(k);
                this.advance();
                continue;
            }
            if (k != '\"') continue;
            this.advance();
            if (this.isEof()) {
                return s.toString();
            }
            if (!this.advanceChar('\"')) break;
            s.append('\"');
        }
        return s.toString();
    }

    private String getUnquotedField() {
        char k;
        StringBuilder s = new StringBuilder();
        while (!this.isEof() && this.isTextData(k = this.get())) {
            s.append(k);
            this.advance();
        }
        return s.toString();
    }

    private boolean isTextData(char k) {
        return k >= ' ' && k <= '~' && k != '\"' && k != ',';
    }

    private boolean isPrintable(char k) {
        return k >= ' ' && k <= '~';
    }

    private boolean advanceChar(char k) {
        if (!this.isEof() && this.get() == k) {
            this.advance();
            return true;
        }
        return false;
    }

    private char get() {
        Assert.check(!this.isEof());
        Assert.check(this.nextChar >= 0);
        return (char)this.nextChar;
    }

    private void advance() {
        Assert.check(!this.isEof());
        Assert.check(this.nextChar >= 0);
        this.nextChar = -1;
    }

    private boolean isEof() {
        if (this.nextChar >= 0) {
            return false;
        }
        if (this.reader == null) {
            return true;
        }
        try {
            this.nextChar = this.reader.read();
        }
        catch (IOException ex) {
            throw new CsvParseError("CSV read error.", ex);
        }
        if (this.nextChar < 0) {
            this.reader = null;
            return true;
        }
        return false;
    }

    public static class CsvParseError
    extends RuntimeException {
        public CsvParseError(String message) {
            this(message, null);
        }

        public CsvParseError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

