/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.annotations;

import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.typechecker.annotations.AnnotationProblemReporter;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.typechecker.SemanticProblemSeverity;

public class AnnotationProviderHelper {
    private AnnotationProviderHelper() {
    }

    public static boolean checkBoolLiteralArg(Annotation annotation, AnnotationArgument arg, AnnotationProblemReporter reporter) {
        if (!(arg.getValue() instanceof BoolExpression)) {
            reporter.reportProblem(annotation, "argument value must be a boolean literal.", arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkNonNegativeIntLiteralArg(Annotation annotation, AnnotationArgument arg, AnnotationProblemReporter reporter) {
        void intLiteral;
        Expression expression = arg.getValue();
        if (!(expression instanceof IntExpression)) {
            reporter.reportProblem(annotation, "argument value must be an integer literal.", arg.getValue().getPosition(), SemanticProblemSeverity.ERROR);
            return false;
        }
        IntExpression intExpression = (IntExpression)expression;
        IntExpression cfr_ignored_0 = (IntExpression)expression;
        Assert.check((intLiteral.getValue() >= 0 ? 1 : 0) != 0);
        return true;
    }
}

