/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker.postchk;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.ExprStructuralEqHashWrap;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.common.java.Maps;

public class UniqueStateInvariantsPostChecker {
    private final Map<ExprStructuralEqHashWrap, Invariant> stateInvariants = Maps.map();

    /*
     * WARNING - void declaration
     */
    public void check(ComplexComponent comp, CifPostCheckEnv env) {
        block3: {
            void aut;
            block2: {
                void group;
                this.check((List<Invariant>)comp.getInvariants(), this.stateInvariants, env);
                ComplexComponent complexComponent = comp;
                if (!(complexComponent instanceof Group)) break block2;
                Group group2 = (Group)complexComponent;
                Group cfr_ignored_0 = (Group)complexComponent;
                for (Component child : group.getComponents()) {
                    this.check((ComplexComponent)child, env);
                }
                break block3;
            }
            ComplexComponent complexComponent = comp;
            if (!(complexComponent instanceof Automaton)) break block3;
            Automaton child = (Automaton)complexComponent;
            Automaton cfr_ignored_1 = (Automaton)complexComponent;
            for (Location loc : aut.getLocations()) {
                if (loc.getInvariants().isEmpty()) continue;
                this.check((List<Invariant>)loc.getInvariants(), Maps.map(), env);
            }
        }
    }

    private void check(List<Invariant> invariants, Map<ExprStructuralEqHashWrap, Invariant> previousEncounteredInvariants, CifPostCheckEnv env) {
        block5: for (Invariant invariant : invariants) {
            switch (invariant.getInvKind()) {
                case EVENT_DISABLES: {
                    continue block5;
                }
                case EVENT_NEEDS: {
                    continue block5;
                }
                case STATE: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown invariant kind: " + String.valueOf(invariant.getInvKind()));
                }
            }
            ExprStructuralEqHashWrap wrappedExpr = new ExprStructuralEqHashWrap(invariant.getPredicate());
            Invariant duplicate = previousEncounteredInvariants.get(wrappedExpr);
            if (duplicate != null) {
                env.addProblem(ErrMsg.INV_DUPL_STATE, invariant.getPosition(), new String[0]);
                env.addProblem(ErrMsg.INV_DUPL_STATE, duplicate.getPosition(), new String[0]);
                continue;
            }
            previousEncounteredInvariants.put(wrappedExpr, invariant);
        }
    }
}

