/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.model;

import java.util.List;
import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.io.RuntimeValueToString;
import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeSpec;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;

public abstract class RuntimeState {
    public final RuntimeSpec<?> spec;

    public RuntimeState(RuntimeSpec<?> spec) {
        this.spec = spec;
    }

    public abstract double getTime();

    public String getTimeText() {
        return CifSimulatorMath.realToStr(this.getTime());
    }

    public int getAutCount() {
        return this.spec.automata.size();
    }

    public abstract String getAutCurLocName(int var1);

    public String[] getAutCurLocNames() {
        String[] rslt = new String[this.getAutCount()];
        int i = 0;
        while (i < rslt.length) {
            rslt[i] = this.getAutCurLocName(i);
            ++i;
        }
        return rslt;
    }

    public int getStateVarCount() {
        return this.getStateVarNames().length;
    }

    public String getStateVarName(int idx) {
        return this.getStateVarNames()[idx];
    }

    public abstract String[] getStateVarNames();

    public abstract Object getStateVarValue(int var1);

    public Object getStateVarValues() {
        Object[] rslt = new Object[this.getStateVarCount()];
        int i = 0;
        while (i < rslt.length) {
            rslt[i] = this.getStateVarValue(i);
            ++i;
        }
        return rslt;
    }

    public abstract double getStateVarDerValue(int var1);

    public int getAlgVarCount() {
        return this.getAlgVarNames().length;
    }

    public String getAlgVarName(int idx) {
        return this.getAlgVarNames()[idx];
    }

    public abstract String[] getAlgVarNames();

    public abstract Object getAlgVarValue(int var1);

    public Object[] getAlgVarValues() {
        Object[] rslt = new Object[this.getAlgVarCount()];
        int i = 0;
        while (i < rslt.length) {
            rslt[i] = this.getAlgVarValue(i);
            ++i;
        }
        return rslt;
    }

    public Object getVarValue(RuntimeStateObjectMeta objMeta) {
        switch (objMeta.type) {
            case AUTOMATON: {
                throw new IllegalArgumentException("objMeta not an automaton");
            }
            case TIME: {
                return this.getTime();
            }
            case DISCRETE: 
            case INPUT: 
            case CONTINUOUS: {
                return this.getStateVarValue(objMeta.idx);
            }
            case DERIVATIVE: {
                return this.getStateVarDerValue(objMeta.idx);
            }
            case ALGEBRAIC: {
                return this.getAlgVarValue(objMeta.idx);
            }
        }
        throw new RuntimeException("Unknown type: " + String.valueOf((Object)objMeta.type));
    }

    public String getStateObjValueText(RuntimeStateObjectMeta objMeta) {
        switch (objMeta.type) {
            case AUTOMATON: {
                return this.getAutCurLocName(objMeta.idx);
            }
            case TIME: {
                return this.getTimeText();
            }
            case DISCRETE: 
            case INPUT: 
            case CONTINUOUS: {
                return RuntimeValueToString.runtimeToString(this.getStateVarValue(objMeta.idx));
            }
            case DERIVATIVE: {
                return RuntimeValueToString.runtimeToString(this.getStateVarDerValue(objMeta.idx));
            }
            case ALGEBRAIC: {
                return RuntimeValueToString.runtimeToString(this.getAlgVarValue(objMeta.idx));
            }
        }
        throw new RuntimeException("Unknown type: " + String.valueOf((Object)objMeta.type));
    }

    public abstract boolean checkInitialization();

    public abstract void calcTransitions(Double var1, Double var2);

    public abstract void calcTimeTransition(Double var1);

    public abstract Transition<?> chooseTransition(RuntimeState var1, List<Transition<?>> var2, SimulationResult var3);

    public abstract ChosenTargetTime chooseTargetTime(double var1);

    public abstract Double getNextMaxEndTime();

    public String toString() {
        return this.toString(null, false, false);
    }

    public String toString(List<RuntimeStateObjectMeta> metas, boolean includeAlgVars, boolean includeDerivs) {
        return this.toString("\n", metas, includeAlgVars, includeDerivs);
    }

    public String toSingleLineString(List<RuntimeStateObjectMeta> metas, boolean includeAlgVars, boolean includeDerivs) {
        return this.toString(", ", metas, includeAlgVars, includeDerivs);
    }

    public String toString(String separator, List<RuntimeStateObjectMeta> metas, boolean includeAlgVars, boolean includeDerivs) {
        StringBuilder rslt = new StringBuilder();
        boolean first = true;
        if (metas == null) {
            metas = this.spec.stateObjectsMeta;
        }
        for (RuntimeStateObjectMeta meta : metas) {
            if (meta.type == StateObjectType.ALGEBRAIC && !includeAlgVars || meta.type == StateObjectType.DERIVATIVE && !includeDerivs) continue;
            if (first) {
                first = false;
            } else {
                rslt.append(separator);
            }
            rslt.append(meta.name);
            rslt.append("=");
            rslt.append(this.getStateObjValueText(meta));
        }
        return rslt.toString();
    }
}

