/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.io;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.eclipse.escet.common.dsm.ClusterInput;
import org.eclipse.escet.common.dsm.Label;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.CsvParser;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.java.output.BlackHoleOutputProvider;
import org.eclipse.escet.common.java.output.DebugNormalOutput;

public class ReadMatrix {
    private ReadMatrix() {
    }

    static ClusterInput convertToMatrix(List<List<String>> matrixLines, DebugNormalOutput debugOut) {
        int firstDataLine;
        int matRowCount = matrixLines.size();
        int matColcount = matrixLines.stream().map(row -> row.size()).max(Math::max).orElseGet(() -> 0);
        if (matRowCount > 1 && matRowCount == matColcount) {
            firstDataLine = 1;
        } else if (matRowCount >= 1 && matRowCount + 1 == matColcount) {
            firstDataLine = 0;
        } else {
            String msg = "Matrix data is not square, found %d rows and %d columns, excluding first label column.";
            throw new InputOutputException(Strings.fmt((String)msg, (Object[])new Object[]{matRowCount, matColcount - 1}));
        }
        int size = matRowCount - firstDataLine;
        BlockRealMatrix adjMat = new BlockRealMatrix(size, size);
        Label[] rowLabels = new Label[size];
        int row2 = 0;
        while (row2 < size) {
            List<String> line = matrixLines.get(firstDataLine + row2);
            rowLabels[row2] = line.size() > 0 ? new Label(line.get(0)) : new Label("");
            int col = 0;
            while (col < size) {
                double value;
                if (line.size() <= col + 1) break;
                String valueText = line.get(col + 1);
                if (valueText.isBlank()) {
                    value = 0.0;
                } else {
                    try {
                        value = Double.parseDouble(valueText);
                    }
                    catch (NumberFormatException ex) {
                        throw new InputOutputException(Strings.fmt((String)"Value \"%s\" is not numeric.", (Object[])new Object[]{valueText}));
                    }
                }
                if (value < 0.0) {
                    throw new InputOutputException(Strings.fmt((String)"Value \"%s\" is negative.", (Object[])new Object[]{valueText}));
                }
                if (Double.isNaN(value)) {
                    throw new InputOutputException(Strings.fmt((String)"Value \"%s\" is not a number.", (Object[])new Object[]{valueText}));
                }
                if (Double.isInfinite(value)) {
                    throw new InputOutputException(Strings.fmt((String)"Value \"%s\" is infinite.", (Object[])new Object[]{valueText}));
                }
                adjMat.setEntry(row2, col, value);
                ++col;
            }
            while (col < size) {
                adjMat.setEntry(row2, col, 0.0);
                ++col;
            }
            ++row2;
        }
        if (firstDataLine == 1) {
            List<String> firstLine = matrixLines.get(0);
            String topLeftCell = (String)Lists.first(firstLine);
            if (!topLeftCell.isEmpty()) {
                throw new InputOutputException(Strings.fmt((String)"The top-left cell of the matrix contains \"%s\" rather than being empty.", (Object[])new Object[]{topLeftCell}));
            }
            Label[] colLabels = (Label[])Lists.slice(firstLine, (Integer)1, null).stream().map(l -> new Label((String)l)).toArray(Label[]::new);
            Assert.areEqual((Object)rowLabels.length, (Object)size);
            Assert.areEqual((Object)colLabels.length, (Object)size);
            int i = 0;
            while (i < size) {
                if (!rowLabels[i].equals(colLabels[i])) {
                    throw new InputOutputException(Strings.fmt((String)"Row label \"%s\" is different from column label \"%s\".", (Object[])new Object[]{rowLabels[i], colLabels[i]}));
                }
                ++i;
            }
        }
        return new ClusterInput((RealMatrix)adjMat, rowLabels, debugOut != null ? debugOut : new BlackHoleOutputProvider().getDebugOutput());
    }

    static List<List<String>> readMatrixLines(BufferedReader reader) {
        CsvParser csvParser = new CsvParser((Reader)reader);
        List lines = csvParser.parse();
        Function<List, List> trimmer = line -> (List)line.stream().map(String::trim).collect(Lists.toList());
        return (List)lines.stream().map(line -> (List)trimmer.apply((List)line)).collect(Lists.toList());
    }

    public static ClusterInput readMatrixFile(String filepath, DebugNormalOutput debugOut) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filepath));){
                List<List<String>> matrixLines = ReadMatrix.readMatrixLines(reader);
                return ReadMatrix.convertToMatrix(matrixLines, debugOut);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CsvParser.CsvParseError ex) {
            throw new InputOutputException(Strings.fmt((String)"Failed to read matrix file \"%s\".", (Object[])new Object[]{filepath}), ex);
        }
    }
}

