/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.common.dsm.sequencing.GraphCycleFinder;
import org.eclipse.escet.common.dsm.sequencing.elements.CollectionElement;
import org.eclipse.escet.common.dsm.sequencing.elements.Element;
import org.eclipse.escet.common.dsm.sequencing.elements.SingularElement;
import org.eclipse.escet.common.dsm.sequencing.graph.Cycle;
import org.eclipse.escet.common.dsm.sequencing.graph.Edge;
import org.eclipse.escet.common.dsm.sequencing.graph.Graph;
import org.eclipse.escet.common.dsm.sequencing.graph.Vertex;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.BitSetIterator;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;

public class Sequencer {
    private Sequencer() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<Vertex> sequenceGraph(Graph g, List<BitSet> collections) {
        GraphCycleFinder cycleFinder = new GraphCycleFinder();
        Set foundCycles = cycleFinder.findSimpleCycles(g);
        Assert.notNull((Object)foundCycles);
        List<List<Cycle>> cycleCollections = Sequencer.makeCycleCollections(foundCycles);
        List elements = Lists.list();
        BitSet storedVertices = new BitSet();
        for (List<Cycle> collection : cycleCollections) {
            Sequencer.tearCycles(collection);
            CollectionElement collectionElement = Sequencer.makeCollectionElement(collection, g.vertices);
            collectionElement.setVertexIndices(storedVertices);
            elements.add(collectionElement);
        }
        int vertexIndex = 0;
        List<Vertex> graphVertices = g.vertices;
        for (Vertex vertex : graphVertices) {
            if (!storedVertices.get(vertexIndex)) {
                storedVertices.set(vertexIndex);
                BitSet inputs = new BitSet(graphVertices.size());
                for (Edge e : vertex.inputs) {
                    inputs.set(e.producingVertex);
                }
                BitSet outputs = new BitSet(graphVertices.size());
                for (Edge e : vertex.outputs) {
                    outputs.set(e.consumingVertex);
                }
                SingularElement element = new SingularElement(vertex, inputs, outputs);
                elements.add(element);
            }
            ++vertexIndex;
        }
        int numVertices = 0;
        BitSet vertices = new BitSet();
        for (Element elem : elements) {
            elem.setVertexIndices(vertices);
            numVertices += elem.getVertexCount();
        }
        Assert.check((numVertices == g.vertices.size() ? 1 : 0) != 0);
        Assert.check((numVertices == vertices.cardinality() ? 1 : 0) != 0);
        Element[] orderedElements = new Element[elements.size()];
        Sequencer.orderElements((Element[])elements.toArray(new Element[0]), (BitSet)vertices, (Element[])orderedElements);
        List result = Lists.listc((int)numVertices);
        Element[] elementArray = orderedElements;
        int n = orderedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Element element;
            Element elem = elementArray[n2];
            if (collections != null && (element = elem) instanceof CollectionElement) {
                void ce;
                CollectionElement cfr_ignored_0 = (CollectionElement)element;
                CollectionElement cfr_ignored_1 = (CollectionElement)element;
                BitSet verticesSet = new BitSet();
                collections.add(verticesSet);
                for (SingularElement element2 : ce.containedElements) {
                    verticesSet.set(element2.vertex.number);
                }
            }
            elem.appendVertices(result);
            ++n2;
        }
        return result;
    }

    static List<List<Cycle>> makeCycleCollections(Set<Cycle> cycles) {
        Map collectionMap = Maps.map();
        for (Cycle cycle : cycles) {
            Set cycleCollection = null;
            Iterator iterator = new BitSetIterator(cycle.vertices).iterator();
            while (iterator.hasNext()) {
                int cycleVertex = (Integer)iterator.next();
                Set existingCollection = (Set)collectionMap.get(cycleVertex);
                if (existingCollection == null || existingCollection == cycleCollection) continue;
                if (cycleCollection == null) {
                    cycleCollection = existingCollection;
                    continue;
                }
                if (cycleCollection.contains(existingCollection.iterator().next())) continue;
                if (existingCollection.size() < cycleCollection.size()) {
                    cycleCollection.addAll(existingCollection);
                    continue;
                }
                existingCollection.addAll(cycleCollection);
                cycleCollection = existingCollection;
            }
            if (cycleCollection == null) {
                cycleCollection = Sets.set();
            }
            cycleCollection.add(cycle);
            for (Cycle c : cycleCollection) {
                Iterator iterator2 = new BitSetIterator(c.vertices).iterator();
                while (iterator2.hasNext()) {
                    int cVertex = (Integer)iterator2.next();
                    collectionMap.put(cVertex, cycleCollection);
                }
            }
        }
        Set uniqueCollections = Sets.set();
        List result = Lists.list();
        for (Set collection : collectionMap.values()) {
            if (!uniqueCollections.add(collection)) continue;
            result.add(Lists.set2list((Set)collection));
        }
        return result;
    }

    static void tearCycles(List<Cycle> collection) {
        Map edgeCounts = Maps.map();
        int cycleNum = 0;
        for (Cycle cycle : collection) {
            for (Edge edge : cycle.edges) {
                Assert.check((!edge.teared ? 1 : 0) != 0);
                BitSet cyclesWithEdge = edgeCounts.computeIfAbsent(edge, e -> new BitSet(collection.size()));
                cyclesWithEdge.set(cycleNum);
            }
            ++cycleNum;
        }
        BitSet tearedCycles = new BitSet(collection.size());
        while (tearedCycles.cardinality() < collection.size()) {
            Edge bestEdge = null;
            BitSet edgeCycles = null;
            int bestEdgeCount = -1;
            Iterator iter = edgeCounts.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                BitSet cyclesWithEdge = (BitSet)entry.getValue();
                cyclesWithEdge.andNot(tearedCycles);
                int count = cyclesWithEdge.cardinality();
                if (count == 0) {
                    iter.remove();
                    continue;
                }
                if (count <= bestEdgeCount) continue;
                bestEdgeCount = count;
                bestEdge = (Edge)entry.getKey();
                edgeCycles = (BitSet)entry.getValue();
            }
            Assert.check((bestEdgeCount > 0 ? 1 : 0) != 0);
            bestEdge.teared = true;
            tearedCycles.or(edgeCycles);
        }
    }

    private static CollectionElement makeCollectionElement(List<Cycle> collection, List<Vertex> graphVertices) {
        BitSet containedVertices = new BitSet();
        for (Cycle cycle : collection) {
            containedVertices.or(cycle.vertices);
        }
        BitSet collectionInputs = new BitSet();
        BitSet collectionOutputs = new BitSet();
        Element[] containedElements = new SingularElement[containedVertices.cardinality()];
        int nextFreeContained = 0;
        Iterator iterator = new BitSetIterator(containedVertices).iterator();
        while (iterator.hasNext()) {
            int vertexIndex = (Integer)iterator.next();
            Vertex vertex = graphVertices.get(vertexIndex);
            BitSet nonTearedInputs = new BitSet();
            for (Edge e : vertex.inputs) {
                collectionInputs.set(e.producingVertex);
                if (e.teared) continue;
                nonTearedInputs.set(e.producingVertex);
            }
            BitSet nonTearedOutputs = new BitSet();
            for (Edge e : vertex.outputs) {
                collectionOutputs.set(e.consumingVertex);
                if (e.teared) continue;
                nonTearedOutputs.set(e.consumingVertex);
            }
            nonTearedInputs.and(containedVertices);
            nonTearedOutputs.and(containedVertices);
            containedElements[nextFreeContained] = new SingularElement(vertex, nonTearedInputs, nonTearedOutputs);
            ++nextFreeContained;
        }
        Element[] orderedElements = new SingularElement[containedElements.length];
        Sequencer.orderElements((Element[])containedElements, (BitSet)containedVertices, (Element[])orderedElements);
        collectionInputs.andNot(containedVertices);
        collectionOutputs.andNot(containedVertices);
        return new CollectionElement(Arrays.asList(orderedElements), collectionInputs, collectionOutputs);
    }

    private static <E extends Element> void orderElements(E[] elements, BitSet vertices, E[] destination) {
        Assert.check((elements.length == destination.length ? 1 : 0) != 0);
        int firstEmpty = 0;
        int lastEmpty = destination.length - 1;
        BitSet predecessors = BitSets.copy((BitSet)vertices);
        BitSet successors = BitSets.copy((BitSet)vertices);
        int lastElement = elements.length - 1;
        while (lastElement >= 0) {
            boolean progress = false;
            int elmIdx = 0;
            while (elmIdx <= lastElement) {
                if (!((Element)elements[elmIdx]).hasInputDeps(predecessors)) {
                    destination[firstEmpty] = elements[elmIdx];
                    ++firstEmpty;
                    ((Element)elements[elmIdx]).clearVertexIndices(predecessors);
                    progress = true;
                    if (elmIdx != lastElement) {
                        elements[elmIdx] = elements[lastElement];
                    }
                    elements[lastElement] = null;
                    --lastElement;
                    continue;
                }
                if (!((Element)elements[elmIdx]).hasOutputDeps(successors)) {
                    destination[lastEmpty] = elements[elmIdx];
                    --lastEmpty;
                    ((Element)elements[elmIdx]).clearVertexIndices(successors);
                    progress = true;
                    if (elmIdx != lastElement) {
                        elements[elmIdx] = elements[lastElement];
                    }
                    elements[lastElement] = null;
                    --lastElement;
                    continue;
                }
                ++elmIdx;
            }
            Assert.check((boolean)progress);
        }
        Assert.check((lastEmpty + 1 == firstEmpty ? 1 : 0) != 0);
    }
}

