/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.common.CifDocAnnotationFormatter;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotatedObject;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.conversion.PlcFunctionAppls;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.generators.ComponentDocData;
import org.eclipse.escet.cif.plcgen.generators.DocumentingSupport;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TextTopics;
import org.eclipse.escet.cif.plcgen.model.PlcModelUtils;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcGlobalVarList;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouInstance;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcResource;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcTask;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcBoolLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcIntLiteral;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcFuncBlockType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.targets.PlcBaseTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class PlcCodeStorage {
    private static final int AIM_COMMENT_LENGTH = 79;
    private static final int MAX_LOOPS_KILLED = 9999;
    private final PlcTarget target;
    private final PlcProject project;
    private final PlcResource resource;
    private final PlcTask task;
    private final PlcPou mainProgram;
    private PlcGlobalVarList globalConstants = null;
    private PlcGlobalVarList globalInputs = null;
    private PlcGlobalVarList globalOutputs = null;
    private PlcGlobalVarList globalTimerVars = null;
    private ExprGenerator exprGenerator = null;
    private PlcBasicVariable isProgressVariable = null;
    private final List<String> programHeaderTextLines;
    private Map<ComplexComponent, ComponentDocData> componentDatas = null;
    private List<PlcStatement> stateInitializationCode = null;
    private List<PlcStatement> updateContVarsRemainingTimeCode = null;
    private Integer maxUncontrollableLimit;
    private Integer maxControllableLimit;
    private List<PlcStatement> inputFuncCode = null;
    private List<PlcStatement> outputFuncCode = null;

    public PlcCodeStorage(PlcTarget target, PlcGenSettings settings) {
        this.target = target;
        this.maxUncontrollableLimit = this.limitMaxIter(settings.maxUncontrollableLimit, "uncontrollable", settings.warnOutput);
        this.maxControllableLimit = this.limitMaxIter(settings.maxControllableLimit, "controllable", settings.warnOutput);
        this.programHeaderTextLines = settings.programHeaderTextLines;
        this.project = new PlcProject(settings.projectName);
        PlcConfiguration config = new PlcConfiguration(settings.configurationName);
        this.project.configurations.add(config);
        this.resource = new PlcResource(settings.resourceName);
        config.resources.add(this.resource);
        this.task = new PlcTask(settings.taskName, settings.taskCycleTime, settings.taskPriority);
        this.resource.tasks.add(this.task);
        this.mainProgram = new PlcPou("MAIN", PlcPouType.PROGRAM, null);
        this.project.pous.add(this.mainProgram);
        this.task.pouInstances.add(new PlcPouInstance("MAIN", this.mainProgram));
    }

    private Integer limitMaxIter(Integer specifiedLimit, String eventKind, WarnOutput warnOutput) {
        if (specifiedLimit == null) {
            return specifiedLimit;
        }
        PlcElementaryType loopCountType = this.target.getStdIntegerType();
        int feasibleLimit = switch (loopCountType.bitSize) {
            case 32, 64 -> specifiedLimit;
            case 16 -> Math.min(specifiedLimit, Short.MAX_VALUE);
            default -> throw new AssertionError((Object)("Unexpected loopCount bit-size " + loopCountType.bitSize + " found."));
        };
        if (specifiedLimit != feasibleLimit) {
            warnOutput.line("Maximum iteration limit for %s events was reduced from %d to %d, as the PLC's integer type does not support larger values.", new Object[]{eventKind, specifiedLimit, feasibleLimit});
        }
        return feasibleLimit;
    }

    public ExprGenerator getExprGenerator() {
        if (this.exprGenerator == null) {
            this.exprGenerator = new ExprGenerator(this.target, this.target.getVarStorage().getCifDataProvider());
        }
        return this.exprGenerator;
    }

    public PlcBasicVariable getIsProgressVariable() {
        if (this.isProgressVariable == null) {
            this.isProgressVariable = this.getExprGenerator().getTempVariable("isProgress", PlcElementaryType.BOOL_TYPE);
        }
        return this.isProgressVariable;
    }

    public void addConstant(PlcDataVariable plcVar) {
        if (this.globalConstants == null) {
            this.globalConstants = new PlcGlobalVarList("CONSTANTS", PlcGlobalVarList.PlcVarListKind.CONSTANTS);
        }
        this.globalConstants.variables.add(plcVar);
    }

    public void addInputVariable(PlcDataVariable variable) {
        if (this.globalInputs == null) {
            this.globalInputs = new PlcGlobalVarList("INPUTS", PlcGlobalVarList.PlcVarListKind.INPUT_OUTPUT);
        }
        this.globalInputs.variables.add(variable);
    }

    public void addOutputVariable(PlcDataVariable variable) {
        if (this.globalOutputs == null) {
            this.globalOutputs = new PlcGlobalVarList("OUTPUTS", PlcGlobalVarList.PlcVarListKind.INPUT_OUTPUT);
        }
        this.globalOutputs.variables.add(variable);
    }

    public PlcDataVariable addStateVariable(String name, PlcType type) {
        return this.addStateVariable(name, type, null, null);
    }

    public PlcDataVariable addStateVariable(String name, PlcType type, String address, PlcExpression initValue) {
        String targetText = this.target.getUsageVariableText(PlcVariablePurpose.STATE_VAR, name);
        PlcDataVariable plcVar = new PlcDataVariable(targetText, name, type, address, initValue);
        this.mainProgram.localVars.add(plcVar);
        return plcVar;
    }

    public void addTempVariable(PlcDataVariable variable) {
        this.mainProgram.tempVars.add(variable);
    }

    public void addTimerVariable(PlcDataVariable variable) {
        if (this.globalTimerVars == null) {
            this.globalTimerVars = new PlcGlobalVarList("TIMERS", PlcGlobalVarList.PlcVarListKind.TIMERS);
        }
        Assert.check((boolean)(variable.type instanceof PlcFuncBlockType));
        this.globalTimerVars.variables.add(variable);
    }

    public void addDeclaredType(PlcDeclaredType declaredType) {
        this.project.declaredTypes.add(declaredType);
    }

    public void addStateInitialization(List<PlcStatement> stateInitializationCode) {
        Assert.check((this.stateInitializationCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(stateInitializationCode)) {
            this.stateInitializationCode = stateInitializationCode;
        }
    }

    public void storeUpdateContvarsRemainingTimeCode(List<PlcStatement> updateContVarsRemainingTimeCode) {
        this.updateContVarsRemainingTimeCode = updateContVarsRemainingTimeCode;
    }

    public void addInputFuncCode(List<PlcStatement> inputFuncCode) {
        Assert.check((this.inputFuncCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(inputFuncCode)) {
            this.inputFuncCode = inputFuncCode;
        }
    }

    public void addOutputFuncCode(List<PlcStatement> outputFuncCode) {
        Assert.check((this.outputFuncCode == null ? 1 : 0) != 0);
        if (PlcModelUtils.isNonEmptyCode(outputFuncCode)) {
            this.outputFuncCode = outputFuncCode;
        }
    }

    public void finishPlcProgram(PlcBaseTarget.EventTransitionsCode transitionsCode) {
        Assert.implies((this.updateContVarsRemainingTimeCode != null ? 1 : 0) != 0, (this.stateInitializationCode != null ? 1 : 0) != 0);
        ExprGenerator exprGen = this.getExprGenerator();
        ModelTextGenerator textGenerator = this.target.getModelTextGenerator();
        NameGenerator nameGen = this.target.getNameGenerator();
        PlcDataVariable firstRun = null;
        if (this.stateInitializationCode != null) {
            String name = nameGen.generateGlobalName("firstRun", false);
            firstRun = this.addStateVariable(name, PlcElementaryType.BOOL_TYPE, null, new PlcBoolLiteral(true));
        }
        PlcDataVariable loopCount = null;
        PlcDataVariable loopsKilled = null;
        if (this.maxUncontrollableLimit != null || this.maxControllableLimit != null) {
            String name = nameGen.generateGlobalName("loopsKilled", false);
            loopsKilled = this.addStateVariable(name, PlcElementaryType.INT_TYPE);
            Assert.check((boolean)true);
            PlcElementaryType loopCountType = this.target.getStdIntegerType();
            loopCount = exprGen.makeLocalVariable("loopCount", loopCountType);
            this.addTempVariable(loopCount);
        }
        this.addGlobalVariableTable(this.globalConstants);
        this.addGlobalVariableTable(this.globalInputs);
        this.addGlobalVariableTable(this.globalOutputs);
        this.addGlobalVariableTable(this.globalTimerVars);
        boolean isProperPlcBody = false;
        CodeBox box = this.mainProgram.body;
        this.addProgramHeader(box);
        box.add();
        box.add(this.generateComponentDocumentation());
        if (this.inputFuncCode != null) {
            box.add();
            this.generateCommentHeader("Read PLC inputs.", '-', box);
            textGenerator.toText(this.inputFuncCode, box, this.mainProgram.name, false);
            boolean bl = isProperPlcBody = isProperPlcBody || this.hasProperPlcStatement(this.inputFuncCode);
        }
        if (this.stateInitializationCode != null) {
            String headerText = this.updateContVarsRemainingTimeCode == null ? "Initialize state." : "Initialize state or update continuous variables.";
            box.add();
            this.generateCommentHeader(headerText, '-', box);
            box.add("IF %s THEN", new Object[]{firstRun.targetText});
            box.indent();
            box.add("%s := FALSE;", new Object[]{firstRun.targetText});
            if (loopsKilled != null) {
                box.add("%s := 0;", new Object[]{loopsKilled.targetText});
            }
            box.add();
            textGenerator.toText(this.stateInitializationCode, box, this.mainProgram.name, false);
            box.dedent();
            if (this.updateContVarsRemainingTimeCode != null) {
                box.add("ELSE");
                box.indent();
                textGenerator.toText(this.updateContVarsRemainingTimeCode, box, this.mainProgram.name, false);
                box.dedent();
            }
            box.add("END_IF;");
            isProperPlcBody = true;
        }
        this.project.pous.addAll(transitionsCode.eventFunctions());
        this.generateEventTransitionsCode(transitionsCode.unconTransCode(), this.maxUncontrollableLimit, "uncontrollable", loopCount, loopsKilled, box);
        isProperPlcBody = isProperPlcBody || this.hasProperPlcStatement(transitionsCode.unconTransCode());
        this.generateEventTransitionsCode(transitionsCode.conTransCode(), this.maxControllableLimit, "controllable", loopCount, loopsKilled, box);
        boolean bl = isProperPlcBody = isProperPlcBody || this.hasProperPlcStatement(transitionsCode.conTransCode());
        if (this.outputFuncCode != null) {
            box.add();
            this.generateCommentHeader("Write PLC outputs.", '-', box);
            textGenerator.toText(this.outputFuncCode, box, this.mainProgram.name, false);
            boolean bl2 = isProperPlcBody = isProperPlcBody || this.hasProperPlcStatement(this.outputFuncCode);
        }
        if (!isProperPlcBody) {
            box.add("(* Nothing to do. *) ;");
        }
        exprGen.releaseTempVariable(this.isProgressVariable);
        this.mainProgram.tempVars.addAll(exprGen.getCreatedTempVariables());
    }

    private void generateEventTransitionsCode(List<PlcStatement> eventTransitionsIterationCode, Integer maxIter, String eventKind, PlcBasicVariable loopCount, PlcBasicVariable loopsKilled, CodeBox box) {
        if (eventTransitionsIterationCode.isEmpty()) {
            return;
        }
        ModelTextGenerator textGenerator = this.target.getModelTextGenerator();
        PlcFunctionAppls funcAppls = new PlcFunctionAppls(this.target);
        box.add();
        this.generateCommentHeader("Process " + eventKind + " events.", '-', box);
        PlcBasicVariable progressVar = this.getIsProgressVariable();
        box.add("%s := TRUE;", new Object[]{progressVar.targetText});
        if (maxIter == null) {
            box.add("(* Perform events until none can be done anymore. *)");
            box.add("WHILE %s DO", new Object[]{progressVar.targetText});
            box.indent();
        } else {
            Assert.notNull((Object)loopCount);
            PlcVarExpression progressCond = new PlcVarExpression(progressVar, new PlcVarExpression.PlcProjection[0]);
            PlcFuncAppl maxIterCond = funcAppls.lessThanFuncAppl(new PlcVarExpression(loopCount, new PlcVarExpression.PlcProjection[0]), this.target.makeStdInteger(maxIter));
            PlcFuncAppl whileCond = funcAppls.andFuncAppl(progressCond, maxIterCond);
            box.add("(* Perform events until none can be done anymore. *)");
            box.add("(* Track the number of iterations and abort if there are too many. *)");
            box.add("%s := 0;", new Object[]{loopCount.targetText});
            box.add("WHILE %s DO", new Object[]{textGenerator.toString(whileCond)});
            box.indent();
            box.add("%s := %s + 1;", new Object[]{loopCount.targetText, loopCount.targetText});
        }
        box.add("%s := FALSE;", new Object[]{progressVar.targetText});
        box.add();
        textGenerator.toText(eventTransitionsIterationCode, box, this.mainProgram.name, false);
        box.dedent();
        box.add("END_WHILE;");
        if (maxIter != null && loopsKilled != null) {
            Assert.notNull((Object)loopCount);
            PlcFuncAppl reachedMaxLoopCond = funcAppls.greaterEqualFuncAppl(new PlcVarExpression(loopCount, new PlcVarExpression.PlcProjection[0]), this.target.makeStdInteger(maxIter));
            PlcVarExpression progressInLastIterCond = new PlcVarExpression(progressVar, new PlcVarExpression.PlcProjection[0]);
            PlcFuncAppl fullCond = funcAppls.andFuncAppl(reachedMaxLoopCond, progressInLastIterCond);
            PlcFuncAppl incKilled = funcAppls.addFuncAppl(new PlcVarExpression(loopsKilled, new PlcVarExpression.PlcProjection[0]), new PlcIntLiteral(1, loopsKilled.type));
            PlcFuncAppl limitedIncrementKilled = funcAppls.minFuncAppl(incKilled, new PlcIntLiteral(9999, loopsKilled.type));
            box.add("(* Register the first %d aborted loops. *)", new Object[]{9999});
            box.add("IF %s THEN", new Object[]{textGenerator.toString(fullCond)});
            box.indent();
            box.add("%s := %s;", new Object[]{loopsKilled.targetText, textGenerator.toString(limitedIncrementKilled)});
            box.dedent();
            box.add("END_IF;");
        }
    }

    private void generateCommentHeader(String text, char dashChar, CodeBox box) {
        char[] pre = new char[]{'(', '*', ' ', dashChar, dashChar, dashChar, ' '};
        char[] post = new char[]{dashChar, dashChar, dashChar, ' ', '*', ')'};
        char[] afterText = new char[]{' '};
        int layoutLength = pre.length + afterText.length + post.length;
        int length = Math.max(79, layoutLength + text.length());
        char[] line = new char[length];
        Arrays.fill(line, dashChar);
        System.arraycopy(pre, 0, line, 0, pre.length);
        System.arraycopy(text.toCharArray(), 0, line, pre.length, text.length());
        System.arraycopy(afterText, 0, line, pre.length + text.length(), afterText.length);
        System.arraycopy(post, 0, line, line.length - post.length, post.length);
        box.add(new String(line));
    }

    private void addGlobalVariableTable(PlcGlobalVarList varTable) {
        if (varTable != null) {
            this.resource.globalVarLists.add(varTable);
        }
    }

    private void addProgramHeader(CodeBox box) {
        boolean first = true;
        for (String line : this.programHeaderTextLines) {
            String prefix = first ? "(*" : " *";
            first = false;
            if (line.isEmpty()) {
                box.add(prefix);
                continue;
            }
            box.add(prefix + " " + line);
        }
        if (!first) {
            box.add(" *)");
        }
    }

    public void addComponentDatas(Map<ComplexComponent, ComponentDocData> componentDatas) {
        this.componentDatas = componentDatas;
    }

    public void setAutomatonEdgeVariableName(Automaton aut, String edgeVariableName) {
        ComponentDocData compData = this.componentDatas.computeIfAbsent((ComplexComponent)aut, c -> new ComponentDocData((ComplexComponent)c));
        compData.edgeVariableName = edgeVariableName;
    }

    private List<String> generateComponentDocumentation() {
        CifDocAnnotationFormatter autDocFormatter = new CifDocAnnotationFormatter(null, null, " * ", List.of(" *"), null);
        CifDocAnnotationFormatter subDocFormatter = new CifDocAnnotationFormatter(null, null, " *   ", List.of(" *"), null);
        TextTopics topics = new TextTopics(" *");
        List compDatas = Lists.listc((int)this.componentDatas.size());
        compDatas.addAll(this.componentDatas.values());
        Collections.sort(compDatas, Comparator.comparing(cd -> cd.getComponentName()));
        topics.add("(*------------------------------------------------------");
        topics.add(" * Model overview:");
        boolean allComponentsEmpty = true;
        for (ComponentDocData compData : compDatas) {
            if (compData.isEmpty()) continue;
            allComponentsEmpty = false;
            compData.sortData();
            topics.ensureEmptyAtEnd();
            topics.add(" * ----");
            topics.add(" * %s:", Strings.makeInitialUppercase((String)DocumentingSupport.getDescription((PositionObject)compData.component)));
            topics.addAll(autDocFormatter.formatDocs((AnnotatedObject)compData.component));
            topics.ensureEmptyAtEnd();
            if (compData.isEmptyVariables()) {
                topics.add(" * - No variables in this component.");
            } else {
                for (Declaration var : compData.variables) {
                    topics.add(" * - %s.", Strings.makeInitialUppercase((String)DocumentingSupport.getDescription((PositionObject)var)));
                    topics.addAll(subDocFormatter.formatDocs((AnnotatedObject)var));
                }
                if (compData.edgeVariableName != null) {
                    topics.ensureEmptyAtEnd();
                    topics.add(" * - PLC edge selection variable \"%s\".", compData.edgeVariableName);
                }
            }
            if (!(compData.component instanceof Automaton)) continue;
            topics.ensureEmptyAtEnd();
            if (compData.uncontrollableEvents.isEmpty()) {
                topics.add(" * - No use of uncontrollable events.");
            } else {
                for (Event evt : compData.uncontrollableEvents) {
                    topics.add(" * - %s.", Strings.makeInitialUppercase((String)DocumentingSupport.getDescription((PositionObject)evt)));
                    topics.addAll(subDocFormatter.formatDocs((AnnotatedObject)evt));
                }
            }
            topics.ensureEmptyAtEnd();
            if (compData.controllableEvents.isEmpty()) {
                topics.add(" * - No use of controllable events.");
                continue;
            }
            for (Event evt : compData.controllableEvents) {
                topics.add(" * - %s.", Strings.makeInitialUppercase((String)DocumentingSupport.getDescription((PositionObject)evt)));
                topics.addAll(subDocFormatter.formatDocs((AnnotatedObject)evt));
            }
        }
        if (allComponentsEmpty) {
            topics.ensureEmptyAtEnd();
            topics.add(" * No groups or automata to report.");
        }
        topics.dropEmptyAtEnd();
        topics.add(" *------------------------------------------------------ *)");
        return topics.getLines();
    }

    private boolean hasProperPlcStatement(List<PlcStatement> statements) {
        if (statements == null) {
            return false;
        }
        for (PlcStatement stat : statements) {
            if (!stat.isProperPlcStatement()) continue;
            return true;
        }
        return false;
    }

    public void writeOutput() {
        this.target.writeOutput(this.project);
    }
}

