/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.targets;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.types.BoolType;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.EnumType;
import org.eclipse.escet.cif.metamodel.cif.types.IntType;
import org.eclipse.escet.cif.metamodel.cif.types.RealType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.conversion.ModelTextGenerator;
import org.eclipse.escet.cif.plcgen.conversion.expressions.ExprGenerator;
import org.eclipse.escet.cif.plcgen.generators.CifEventTransition;
import org.eclipse.escet.cif.plcgen.generators.CifProcessor;
import org.eclipse.escet.cif.plcgen.generators.ContinuousVariablesGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultContinuousVariablesGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultNameGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultTypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.DefaultVariableStorage;
import org.eclipse.escet.cif.plcgen.generators.InputOutputGenerator;
import org.eclipse.escet.cif.plcgen.generators.NameGenerator;
import org.eclipse.escet.cif.plcgen.generators.PlcCodeStorage;
import org.eclipse.escet.cif.plcgen.generators.PlcVariablePurpose;
import org.eclipse.escet.cif.plcgen.generators.TransitionGenerator;
import org.eclipse.escet.cif.plcgen.generators.TypeGenerator;
import org.eclipse.escet.cif.plcgen.generators.VariableStorage;
import org.eclipse.escet.cif.plcgen.generators.io.IoAddress;
import org.eclipse.escet.cif.plcgen.generators.io.IoDirection;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcBasicVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDataVariable;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPouType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcExpression;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcFuncAppl;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcNamedValue;
import org.eclipse.escet.cif.plcgen.model.expressions.PlcVarExpression;
import org.eclipse.escet.cif.plcgen.model.functions.PlcBasicFuncDescription;
import org.eclipse.escet.cif.plcgen.model.functions.PlcFuncOperation;
import org.eclipse.escet.cif.plcgen.model.functions.PlcPouDescription;
import org.eclipse.escet.cif.plcgen.model.statements.PlcAssignmentStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcCommentLine;
import org.eclipse.escet.cif.plcgen.model.statements.PlcReturnStatement;
import org.eclipse.escet.cif.plcgen.model.statements.PlcStatement;
import org.eclipse.escet.cif.plcgen.model.types.PlcElementaryType;
import org.eclipse.escet.cif.plcgen.model.types.PlcType;
import org.eclipse.escet.cif.plcgen.options.ConvertEnums;
import org.eclipse.escet.cif.plcgen.options.EventTransitionForm;
import org.eclipse.escet.cif.plcgen.options.PlcNumberBits;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.targets.PlcTargetType;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public abstract class PlcBaseTarget
extends PlcTarget {
    public static final int CIF_INTEGER_SIZE = 32;
    public static final int CIF_REAL_SIZE = 64;
    public final PlcTargetType targetType;
    protected final String tonFuncBlockCallName;
    private PlcNumberBits intTypeSize;
    private PlcNumberBits realTypeSize;
    private final ConvertEnums autoEnumConversion;
    private ConvertEnums selectedEnumConversion;
    private EventTransitionForm transitionForm;
    private PathPair outputPaths;
    private WarnOutput warnOutput;
    private final ModelTextGenerator modelTextGenerator = new ModelTextGenerator(this);
    protected CifProcessor cifProcessor;
    protected TransitionGenerator transitionGenerator;
    private ContinuousVariablesGenerator continuousVariablesGenerator;
    protected InputOutputGenerator ioGenerator;
    protected VariableStorage varStorage;
    protected TypeGenerator typeGenerator;
    protected PlcCodeStorage codeStorage;
    protected NameGenerator nameGenerator;
    protected final Set<String> disallowedNames;

    public PlcBaseTarget(PlcTargetType targetType, ConvertEnums autoEnumConversion) {
        this(targetType, autoEnumConversion, "");
    }

    public PlcBaseTarget(PlcTargetType targetType, ConvertEnums autoEnumConversion, String tonFuncBlockCallName) {
        this.targetType = targetType;
        this.autoEnumConversion = autoEnumConversion;
        this.tonFuncBlockCallName = tonFuncBlockCallName;
        this.disallowedNames = Collections.unmodifiableSet(this.getDisallowedNames());
        Assert.check((autoEnumConversion != ConvertEnums.AUTO ? 1 : 0) != 0);
    }

    protected Set<String> getDisallowedNames() {
        Set names = Sets.set();
        names.addAll(List.of("action", "array", "at", "by", "case", "configuration", "constant", "do", "else", "elsif", "end_action", "end_case", "end_configuration", "end_for", "end_function", "end_function_block", "end_if", "end_program", "end_repeat", "end_resource", "end_retain", "end_step", "end_struct", "end_transition", "end_type", "end_var", "end_while", "exit", "false", "f_edge", "for", "from", "function", "function_block", "if", "initial_step", "of", "on", "program", "read_only", "read_write", "r_edge", "repeat", "resource", "retain", "return", "step", "struct", "task", "then", "to", "transition", "true", "type", "until", "var", "var_access", "var_config", "var_external", "var_global", "var_in_out", "var_input", "var_output", "var_temp", "while", "with"));
        names.addAll(List.of("abs", "acos", "add", "and", "asin", "atan", "cos", "div", "eq", "exp", "expt", "ge", "gt", "le", "ln", "log", "lt", "max", "min", "mod", "mul", "ne", "not", "or", "sel", "sin", "sqrt", "sub", "tan", "xor"));
        names.addAll(List.of("rs", "sr", "ton", "tof", "tp", "f_trig", "r_trig", "ctu", "ctu_dint", "ctu_lint", "ctu_udint", "ctu_ulint", "ctd", "ctd_dint", "ctd_lint", "ctd_udint", "ctd_ulint", "ctud", "ctud_dint", "ctud_lint", "ctud_udint", "ctud_ulint"));
        List<String> typeKeywords = List.of("bool", "sint", "int", "dint", "lint", "usint", "uint", "ulint", "udint", "real", "lreal", "time", "date", "time_of_day", "tod", "date_and_time", "dt", "string", "byte", "word", "dword", "lword", "wstring");
        names.addAll(typeKeywords);
        names.addAll(List.of("any", "and_derived", "any_elementary", "any_magnitude", "any_num", "any_real", "any_int", "any_bit", "any_string", "any_date"));
        int i = 0;
        while (i < typeKeywords.size()) {
            int j = 0;
            while (j < typeKeywords.size()) {
                if (i != j) {
                    names.add(typeKeywords.get(i) + "_to_" + typeKeywords.get(j));
                }
                ++j;
            }
            ++i;
        }
        return names;
    }

    public void setup(PlcGenSettings settings) {
        this.intTypeSize = settings.intTypeSize;
        this.realTypeSize = settings.realTypeSize;
        this.outputPaths = settings.outputPaths;
        this.warnOutput = settings.warnOutput;
        this.selectedEnumConversion = settings.enumConversion == ConvertEnums.AUTO ? this.autoEnumConversion : settings.enumConversion;
        this.transitionForm = settings.transitionForm;
        if (settings.intTypeSize.getTypeSize(32) < 32) {
            this.warnOutput.line("Configured integer type size is less than the CIF integer type size. Some values in the program may be truncated.");
        } else if (this.getMaxIntegerTypeSize() < 32) {
            this.warnOutput.line("Maximum integer type size supported by the PLC is less than the CIF integer type size. Some values in the program may be truncated.");
        }
        if (settings.realTypeSize.getTypeSize(64) < 64) {
            this.warnOutput.line("Configured real type size is less than the CIF real type size. Some values in the program may be truncated.");
        } else if (this.getMaxRealTypeSize() < 64) {
            this.warnOutput.line("Maximum real type size supported by the PLC is less than the CIF real type size. Some values in the program may be truncated.");
        }
    }

    public void generate(PlcGenSettings settings, Specification inputSpec) {
        this.setup(settings);
        this.nameGenerator = new DefaultNameGenerator(this, settings);
        this.codeStorage = new PlcCodeStorage(this, settings);
        this.typeGenerator = new DefaultTypeGenerator(this, settings);
        this.varStorage = new DefaultVariableStorage(this);
        this.cifProcessor = new CifProcessor(this, inputSpec, settings);
        this.transitionGenerator = new DefaultTransitionGenerator(this);
        this.ioGenerator = new InputOutputGenerator(this, settings);
        this.continuousVariablesGenerator = new DefaultContinuousVariablesGenerator(this);
        this.nameGenerator.addDisallowedNames(this.ioGenerator.getCustomIoNames());
        CifProcessor.CifProcessorResults processorResults = this.cifProcessor.process();
        if (settings.termination.isRequested()) {
            return;
        }
        for (DiscVariable discVar : processorResults.discVariables()) {
            this.varStorage.addStateVariable((Declaration)discVar, discVar.getType());
        }
        for (InputVariable inpVar : processorResults.inputVariables()) {
            this.varStorage.addStateVariable((Declaration)inpVar, inpVar.getType());
        }
        for (EnumDecl enumDecl : processorResults.enumDecls()) {
            this.typeGenerator.convertEnumDecl(enumDecl);
        }
        for (ContVariable contVar : processorResults.contVariables()) {
            this.varStorage.addStateVariable((Declaration)contVar, (CifType)CifConstructors.newRealType());
            this.continuousVariablesGenerator.addVariable(contVar);
        }
        for (Constant constant : processorResults.constants()) {
            this.varStorage.addConstant(constant);
        }
        this.codeStorage.addComponentDatas(processorResults.componentDatas());
        if (settings.termination.isRequested()) {
            return;
        }
        this.continuousVariablesGenerator.process();
        if (settings.termination.isRequested()) {
            return;
        }
        this.ioGenerator.process(processorResults.cifObjectFinder());
        if (settings.termination.isRequested()) {
            return;
        }
        this.varStorage.process();
        if (settings.termination.isRequested()) {
            return;
        }
        List<CifEventTransition> allCifEventTransitions = processorResults.cifEventTransitions();
        EventTransitionsCode eventTransCode = this.generateTransCode(allCifEventTransitions);
        if (settings.termination.isRequested()) {
            return;
        }
        this.codeStorage.finishPlcProgram(eventTransCode);
        if (settings.termination.isRequested()) {
            return;
        }
        this.codeStorage.writeOutput();
    }

    private EventTransitionsCode generateTransCode(List<CifEventTransition> allCifEventTransitions) {
        this.transitionGenerator.setup(allCifEventTransitions);
        List<CifEventTransition> unconSeq = allCifEventTransitions.stream().filter(cet -> cet.event.getControllable() == false).toList();
        List<CifEventTransition> conSeq = allCifEventTransitions.stream().filter(cet -> cet.event.getControllable()).toList();
        PlcBasicVariable mainProgressVar = this.codeStorage.getIsProgressVariable();
        if (this.transitionForm == EventTransitionForm.CODE_IN_MAIN) {
            ExprGenerator exprGen = this.codeStorage.getExprGenerator();
            List<List<PlcStatement>> transCode = this.transitionGenerator.generate(List.of(unconSeq, conSeq), exprGen, mainProgressVar);
            return new EventTransitionsCode(transCode.get(0), transCode.get(1), List.of());
        }
        Assert.areEqual((Object)((Object)this.transitionForm), (Object)((Object)EventTransitionForm.CODE_IN_FUNCTION));
        List pous = Lists.listc((int)(unconSeq.size() + conSeq.size()));
        List<PlcStatement> unconCallSequence = this.convertEventTransitions(unconSeq, mainProgressVar, pous);
        List<PlcStatement> conCallSequence = this.convertEventTransitions(conSeq, mainProgressVar, pous);
        return new EventTransitionsCode(unconCallSequence, conCallSequence, pous);
    }

    private List<PlcStatement> convertEventTransitions(List<CifEventTransition> eventTransitions, PlcBasicVariable mainProgressVar, List<PlcPou> pous) {
        List stats = Lists.listc((int)eventTransitions.size());
        for (CifEventTransition eventTrans : eventTransitions) {
            PlcPou pou = this.makeEventPou(eventTrans, mainProgressVar.varName);
            pous.add(pou);
            PlcPouDescription funcDesc = new PlcPouDescription(pou);
            PlcNamedValue argument = new PlcNamedValue(mainProgressVar.varName, new PlcVarExpression(mainProgressVar, new PlcVarExpression.PlcProjection[0]));
            PlcFuncAppl rhs = new PlcFuncAppl(funcDesc, List.of(argument));
            PlcAssignmentStatement assignment = new PlcAssignmentStatement(mainProgressVar, (PlcExpression)rhs);
            stats.add(assignment);
        }
        return stats;
    }

    private PlcPou makeEventPou(CifEventTransition cifEventTrans, String paramName) {
        String funcName = this.nameGenerator.generateGlobalNames(Set.of("tryEvent_"), (PositionObject)cifEventTrans.event);
        PlcPou pou = new PlcPou("tryEvent_" + funcName, PlcPouType.FUNCTION, PlcElementaryType.BOOL_TYPE);
        PlcDataVariable funcIsProgressParam = new PlcDataVariable(paramName, PlcElementaryType.BOOL_TYPE);
        pou.inputVars.add(funcIsProgressParam);
        List stats = Lists.list();
        ExprGenerator pouExprGen = new ExprGenerator(this, this.varStorage.getCifDataProvider());
        PlcDataVariable funcIsProgressVar = pouExprGen.makeLocalVariable("funcIsProgress", PlcElementaryType.BOOL_TYPE);
        pou.tempVars.add(funcIsProgressVar);
        PlcVarExpression copyRhs = new PlcVarExpression((PlcBasicVariable)funcIsProgressParam, new PlcVarExpression.PlcProjection[0]);
        PlcAssignmentStatement copyAssignment = new PlcAssignmentStatement(funcIsProgressVar, (PlcExpression)copyRhs);
        stats.add(copyAssignment);
        List<List<CifEventTransition>> eventSeqs = List.of(List.of(cifEventTrans));
        stats.addAll((Collection)this.transitionGenerator.generate(eventSeqs, pouExprGen, funcIsProgressVar).get(0));
        pou.tempVars.addAll(pouExprGen.getCreatedTempVariables());
        stats.add(new PlcCommentLine(null));
        stats.add(new PlcCommentLine("Return event execution progress."));
        stats.add(new PlcReturnStatement(new PlcVarExpression((PlcBasicVariable)funcIsProgressVar, new PlcVarExpression.PlcProjection[0])));
        this.modelTextGenerator.toText(stats, pou.body, pou.name, true);
        return pou;
    }

    protected abstract Writer getPlcCodeWriter();

    @Override
    public PlcTargetType getTargetType() {
        return this.targetType;
    }

    @Override
    public ModelTextGenerator getModelTextGenerator() {
        Assert.notNull((Object)this.modelTextGenerator);
        return this.modelTextGenerator;
    }

    @Override
    public CifProcessor getCifProcessor() {
        Assert.notNull((Object)this.cifProcessor);
        return this.cifProcessor;
    }

    @Override
    public TransitionGenerator getTransitionGenerator() {
        Assert.notNull((Object)this.transitionGenerator);
        return this.transitionGenerator;
    }

    @Override
    public ContinuousVariablesGenerator getContinuousVariablesGenerator() {
        Assert.notNull((Object)this.continuousVariablesGenerator);
        return this.continuousVariablesGenerator;
    }

    @Override
    public VariableStorage getVarStorage() {
        Assert.notNull((Object)this.varStorage);
        return this.varStorage;
    }

    @Override
    public TypeGenerator getTypeGenerator() {
        Assert.notNull((Object)this.typeGenerator);
        return this.typeGenerator;
    }

    @Override
    public PlcCodeStorage getCodeStorage() {
        Assert.notNull((Object)this.codeStorage);
        return this.codeStorage;
    }

    @Override
    public NameGenerator getNameGenerator() {
        Assert.notNull((Object)this.nameGenerator);
        return this.nameGenerator;
    }

    @Override
    public boolean isAllowedName(String name) {
        return !this.disallowedNames.contains(name);
    }

    @Override
    public ConvertEnums getActualEnumerationsConversion() {
        return this.selectedEnumConversion;
    }

    @Override
    public String getUsageVariableText(PlcVariablePurpose purpose, String varName) {
        return varName;
    }

    @Override
    public String getTonFuncBlockCallName() {
        return this.tonFuncBlockCallName;
    }

    protected static boolean commonSupportedConstants(Constant constant) {
        CifType tp = CifTypeUtils.unwrapType((CifType)constant.getType());
        return tp instanceof BoolType || tp instanceof IntType || tp instanceof RealType || tp instanceof EnumType;
    }

    @Override
    public EnumSet<PlcBasicFuncDescription.PlcFuncNotation> getSupportedFuncNotations(PlcFuncOperation funcOper, int numArgs) {
        return PlcBasicFuncDescription.PlcFuncNotation.ALL;
    }

    @Override
    public int getExprPriority(PlcBasicFuncDescription.ExprBinding exprBinding) {
        return switch (exprBinding) {
            case PlcBasicFuncDescription.ExprBinding.UNARY_NEGATE, PlcBasicFuncDescription.ExprBinding.UNARY_NOT -> 1;
            case PlcBasicFuncDescription.ExprBinding.BINARY_MUL, PlcBasicFuncDescription.ExprBinding.BINARY_DIV, PlcBasicFuncDescription.ExprBinding.BINARY_MOD -> 3;
            case PlcBasicFuncDescription.ExprBinding.BINARY_SUB, PlcBasicFuncDescription.ExprBinding.BINARY_ADD -> 4;
            case PlcBasicFuncDescription.ExprBinding.BINARY_LESS_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_LESS_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_EQUAL -> 5;
            case PlcBasicFuncDescription.ExprBinding.BINARY_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_UNEQUAL -> 6;
            case PlcBasicFuncDescription.ExprBinding.BINARY_AND -> 7;
            case PlcBasicFuncDescription.ExprBinding.BINARY_XOR -> 8;
            case PlcBasicFuncDescription.ExprBinding.BINARY_OR -> 9;
            case PlcBasicFuncDescription.ExprBinding.NO_PRIORITY -> Integer.MAX_VALUE;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public PlcBasicFuncDescription.ExprAssociativity getExprAssociativity(PlcBasicFuncDescription.ExprBinding exprBinding) {
        return switch (exprBinding) {
            case PlcBasicFuncDescription.ExprBinding.UNARY_NEGATE, PlcBasicFuncDescription.ExprBinding.UNARY_NOT -> PlcBasicFuncDescription.ExprAssociativity.RIGHT;
            case PlcBasicFuncDescription.ExprBinding.BINARY_MUL, PlcBasicFuncDescription.ExprBinding.BINARY_DIV, PlcBasicFuncDescription.ExprBinding.BINARY_MOD, PlcBasicFuncDescription.ExprBinding.BINARY_SUB, PlcBasicFuncDescription.ExprBinding.BINARY_ADD -> PlcBasicFuncDescription.ExprAssociativity.LEFT;
            case PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_GREATER_EQUAL -> PlcBasicFuncDescription.ExprAssociativity.ALWAYS;
            case PlcBasicFuncDescription.ExprBinding.BINARY_LESS_THAN, PlcBasicFuncDescription.ExprBinding.BINARY_LESS_EQUAL -> PlcBasicFuncDescription.ExprAssociativity.ALWAYS;
            case PlcBasicFuncDescription.ExprBinding.BINARY_EQUAL, PlcBasicFuncDescription.ExprBinding.BINARY_UNEQUAL -> PlcBasicFuncDescription.ExprAssociativity.ALWAYS;
            case PlcBasicFuncDescription.ExprBinding.BINARY_AND, PlcBasicFuncDescription.ExprBinding.BINARY_XOR, PlcBasicFuncDescription.ExprBinding.BINARY_OR -> PlcBasicFuncDescription.ExprAssociativity.LEFT;
            case PlcBasicFuncDescription.ExprBinding.NO_PRIORITY -> PlcBasicFuncDescription.ExprAssociativity.NONE;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public int getMaxIntegerTypeSize() {
        return ((PlcElementaryType)Lists.last(this.getSupportedIntegerTypes())).bitSize;
    }

    @Override
    public PlcElementaryType getStdIntegerType() {
        int generatorBestIntSize = Math.min(32, this.getMaxIntegerTypeSize());
        int userSpecifiedIntSize = this.intTypeSize.getTypeSize(generatorBestIntSize);
        return PlcElementaryType.getTypeByRequiredBits(userSpecifiedIntSize, PlcElementaryType.INTEGER_TYPES_ALL);
    }

    @Override
    public int getMaxRealTypeSize() {
        return ((PlcElementaryType)Lists.last(this.getSupportedRealTypes())).bitSize;
    }

    @Override
    public PlcElementaryType getStdRealType() {
        int generatorBestRealSize = Math.min(64, this.getMaxRealTypeSize());
        int userSpecifiedRealSize = this.realTypeSize.getTypeSize(generatorBestRealSize);
        return PlcElementaryType.getTypeByRequiredBits(userSpecifiedRealSize, PlcElementaryType.REAL_TYPES_ALL);
    }

    @Override
    public void verifyIoTableEntry(IoAddress parsedAddress, PlcType plcTableType, IoDirection directionFromCif, String ioName, String tableLinePositionText) {
        String typeText;
        int maxAvailableBits;
        if (PlcElementaryType.isIntType(plcTableType)) {
            maxAvailableBits = this.getMaxIntegerTypeSize();
            typeText = "integer";
        } else if (PlcElementaryType.isRealType(plcTableType)) {
            maxAvailableBits = this.getMaxRealTypeSize();
            typeText = "real";
        } else if (plcTableType.equals(PlcElementaryType.BOOL_TYPE)) {
            maxAvailableBits = 1;
            typeText = "boolean";
        } else {
            throw new AssertionError((Object)("Unexpected PLC type \"" + String.valueOf(plcTableType) + "\" found."));
        }
        if (parsedAddress.size() > maxAvailableBits) {
            this.warnOutput.line("Size of I/O address \"%s\" (of %d bits) exceeds the size of the largest supported %s type (of %d bits).", new Object[]{parsedAddress.getAddress(), parsedAddress.size(), typeText, maxAvailableBits});
        }
        if (ioName != null && !this.checkIoVariableName(ioName)) {
            String msg = Strings.fmt((String)"I/O variable name \"%s\" %s is not a valid name for the selected target.", (Object[])new Object[]{ioName, tableLinePositionText});
            throw new InvalidInputException(msg);
        }
    }

    @Override
    public boolean checkIoVariableName(String name) {
        Assert.notNull((Object)name);
        Pattern p = Pattern.compile("[A-Za-z][A-Za-z0-9_]*");
        Matcher m = p.matcher(name);
        if (!m.matches()) {
            return false;
        }
        return !name.startsWith("_") && !name.endsWith("_") && !name.contains("__");
    }

    @Override
    public void writeOutput(PlcProject project) {
        Writer writer = this.getPlcCodeWriter();
        writer.write(project, this.outputPaths);
    }

    public record EventTransitionsCode(List<PlcStatement> unconTransCode, List<PlcStatement> conTransCode, List<PlcPou> eventFunctions) {
    }
}

