/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.writers;

import org.eclipse.escet.cif.plcgen.model.declarations.PlcConfiguration;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcDeclaredType;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcPou;
import org.eclipse.escet.cif.plcgen.model.declarations.PlcProject;
import org.eclipse.escet.cif.plcgen.model.types.PlcStructType;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.cif.plcgen.writers.Writer;
import org.eclipse.escet.common.box.Box;
import org.eclipse.escet.common.java.PathPair;

public class AbbWriter
extends Writer {
    public AbbWriter(PlcTarget target) {
        super(target);
    }

    @Override
    public void write(PlcProject project, PathPair outputPaths) {
        this.ensureDirectory(outputPaths);
        for (PlcConfiguration config : project.configurations) {
            this.write(config, outputPaths);
        }
        for (PlcPou pou : project.pous) {
            this.write(pou, outputPaths);
        }
        for (PlcDeclaredType declaredType : project.declaredTypes) {
            this.writeDeclaredType(declaredType, outputPaths);
        }
    }

    private void write(PlcConfiguration config, PathPair outPaths) {
        String fileName = config.name + ".plccfg";
        Box code = this.toBox(config);
        this.writeFile(code, outPaths, fileName);
    }

    private void write(PlcPou pou, PathPair outPaths) {
        String ext = pou.retType == null ? ".plcprog" : ".plcfunc";
        String fileName = pou.name + ext;
        Box code = this.toBox(pou);
        this.writeFile(code, outPaths, fileName);
    }

    /*
     * WARNING - void declaration
     */
    private void writeDeclaredType(PlcDeclaredType declaredType, PathPair outPaths) {
        String typeName;
        PlcDeclaredType plcDeclaredType = declaredType;
        if (plcDeclaredType instanceof PlcStructType) {
            void structType;
            PlcStructType plcStructType = (PlcStructType)plcDeclaredType;
            PlcStructType cfr_ignored_0 = (PlcStructType)plcDeclaredType;
            typeName = structType.typeName;
        } else {
            PlcDeclaredType plcDeclaredType2 = declaredType;
            if (plcDeclaredType2 instanceof PlcStructType) {
                void enumType;
                PlcStructType plcStructType = (PlcStructType)plcDeclaredType2;
                PlcStructType cfr_ignored_1 = (PlcStructType)plcDeclaredType2;
                typeName = enumType.typeName;
            } else {
                throw new AssertionError((Object)("Unexpected declared type found: \"" + String.valueOf(declaredType) + "\"."));
            }
        }
        String fileName = typeName + ".plctype";
        Box code = this.toTypeDeclBox(declaredType);
        this.writeFile(code, outPaths, fileName);
    }
}

