/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.PlatformUtils;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class AppEclipseApplication
implements IApplication {
    public Object start(IApplicationContext context) throws Exception {
        Constructor<?> appConstructor;
        Class<?> appClass;
        Class<?> cls;
        boolean stateOk;
        Map args = context.getArguments();
        String[] appArgs = (String[])args.get("application.args");
        if (appArgs == null || appArgs.length < 2) {
            throw new ApplicationException("Invalid command line arguments. Expected: <plugin_name> <class_name> [application_arguments]");
        }
        String bundleName = appArgs[0];
        String className = appArgs[1];
        String[] cmdLineArgs = Arrays.copyOfRange(appArgs, 2, appArgs.length);
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            String msg = Strings.fmt((String)"OSGi bundle \"%s\" not found.", (Object[])new Object[]{bundleName});
            throw new ApplicationException(msg);
        }
        int state = bundle.getState();
        boolean bl = stateOk = state == 4 || state == 8 || state == 32;
        if (!stateOk) {
            String msg = Strings.fmt((String)"OSGi bundle \"%s\" is not in state RESOLVED, STARTING or ACTIVE, but in state %s.", (Object[])new Object[]{bundleName, PlatformUtils.getStateName(bundle)});
            throw new ApplicationException(msg);
        }
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            String msg = Strings.fmt((String)"Failed to obtain bundle wiring from OSGi bundle \"%s\".", (Object[])new Object[]{bundleName});
            throw new ApplicationException(msg);
        }
        ClassLoader classLoader = bundleWiring.getClassLoader();
        if (classLoader == null) {
            String msg = Strings.fmt((String)"Failed to class loader from OSGi bundle \"%s\".", (Object[])new Object[]{bundleName});
            throw new ApplicationException(msg);
        }
        try {
            cls = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            String msg = Strings.fmt((String)"Failed to load/find class \"%s\" for OSGi bundle \"%s\".", (Object[])new Object[]{className, bundleName});
            throw new ApplicationException(msg, (Throwable)ex);
        }
        try {
            Class<?> tmpClass;
            appClass = tmpClass = cls;
        }
        catch (ClassCastException ex) {
            String msg = Strings.fmt((String)"Class \"%s\" is not an application framework application class.", (Object[])new Object[]{className});
            throw new ApplicationException(msg, (Throwable)ex);
        }
        try {
            appConstructor = appClass.getConstructor(new Class[0]);
        }
        catch (SecurityException ex) {
            String msg = Strings.fmt((String)"Failed to obtain constructor for class \"%s\" due to security settings.", (Object[])new Object[]{appClass.getName()});
            throw new RuntimeException(msg, ex);
        }
        catch (NoSuchMethodException ex) {
            String msg = Strings.fmt((String)"Application class \"%s\" is missing a parameterless constructor.", (Object[])new Object[]{appClass.getName()});
            throw new RuntimeException(msg, ex);
        }
        Application app = (Application)appConstructor.newInstance(new Object[0]);
        System.setProperty("eclipse.exitdata", "");
        return app.run(cmdLineArgs, false);
    }

    public void stop() {
    }
}

