/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.tooldef.common.ToolDefTypeUtils;
import org.eclipse.escet.tooldef.metamodel.java.ToolDefConstructors;
import org.eclipse.escet.tooldef.metamodel.tooldef.TypeParam;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.BoolType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.DoubleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.IntType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ListType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.LongType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.MapType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ObjectType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.SetType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.StringType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.ToolDefType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TupleType;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.TypeParamRef;
import org.eclipse.escet.tooldef.metamodel.tooldef.types.UnresolvedType;
import org.eclipse.escet.tooldef.typechecker.TypeConstraints;

public class TypeMatcher {
    private TypeMatcher() {
    }

    public static boolean computeSubType(ToolDefType t1, ToolDefType t2, TypeConstraints constraints) {
        Assert.check((!(t1 instanceof UnresolvedType) ? 1 : 0) != 0);
        Assert.check((!(t2 instanceof UnresolvedType) ? 1 : 0) != 0);
        t1 = ToolDefTypeUtils.normalizeType((ToolDefType)t1);
        t2 = ToolDefTypeUtils.normalizeType((ToolDefType)t2);
        if (t2 instanceof TypeParamRef) {
            ToolDefType constraint;
            TypeParam typeParam2 = ((TypeParamRef)t2).getType();
            if (t1 instanceof TypeParamRef) {
                TypeParam typeParam1 = ((TypeParamRef)t1).getType();
                Assert.check((typeParam1 != typeParam2 ? 1 : 0) != 0);
            }
            constraint = (constraint = (ToolDefType)constraints.get(typeParam2)) == null ? t1 : ToolDefTypeUtils.mergeTypes((ToolDefType)constraint, (ToolDefType)t1);
            constraints.put(typeParam2, constraint);
            return true;
        }
        if (t1 instanceof TypeParamRef) {
            return t2 instanceof ObjectType && t2.isNullable();
        }
        if (t1.isNullable() && !t2.isNullable()) {
            return false;
        }
        if (t2 instanceof ObjectType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof IntType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof IntType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof LongType) {
            return true;
        }
        if (t1 instanceof LongType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof DoubleType && t2 instanceof DoubleType) {
            return true;
        }
        if (t1 instanceof BoolType && t2 instanceof BoolType) {
            return true;
        }
        if (t1 instanceof StringType && t2 instanceof StringType) {
            return true;
        }
        if (t1 instanceof ListType && t2 instanceof ListType) {
            ListType lt1 = (ListType)t1;
            ListType lt2 = (ListType)t2;
            return TypeMatcher.computeSubType(lt1.getElemType(), lt2.getElemType(), constraints);
        }
        if (t1 instanceof SetType && t2 instanceof SetType) {
            SetType st1 = (SetType)t1;
            SetType st2 = (SetType)t2;
            return TypeMatcher.computeSubType(st1.getElemType(), st2.getElemType(), constraints);
        }
        if (t1 instanceof MapType && t2 instanceof MapType) {
            MapType mt1 = (MapType)t1;
            MapType mt2 = (MapType)t2;
            return TypeMatcher.computeSubType(mt1.getKeyType(), mt2.getKeyType(), constraints) && TypeMatcher.computeSubType(mt1.getValueType(), mt2.getValueType(), constraints);
        }
        if (t1 instanceof TupleType && t2 instanceof TupleType) {
            EList fields1 = ((TupleType)t1).getFields();
            EList fields2 = ((TupleType)t2).getFields();
            if (fields1.size() != fields2.size()) {
                return false;
            }
            int i = 0;
            while (i < fields1.size()) {
                if (!TypeMatcher.computeSubType((ToolDefType)fields1.get(i), (ToolDefType)fields2.get(i), constraints)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static ToolDefType substitute(ToolDefType type, TypeConstraints constraints, boolean substMissing) {
        if ((type = ToolDefTypeUtils.normalizeType((ToolDefType)type)) instanceof BoolType) {
            return type;
        }
        if (type instanceof IntType) {
            return type;
        }
        if (type instanceof LongType) {
            return type;
        }
        if (type instanceof DoubleType) {
            return type;
        }
        if (type instanceof StringType) {
            return type;
        }
        if (type instanceof ObjectType) {
            return type;
        }
        if (type instanceof TupleType) {
            TupleType ttype = (TupleType)type;
            EList origFieldTypes = ttype.getFields();
            List newFieldTypes = Lists.listc((int)origFieldTypes.size());
            for (ToolDefType origFieldType : origFieldTypes) {
                newFieldTypes.add(TypeMatcher.substitute(origFieldType, constraints, substMissing));
            }
            if (origFieldTypes.equals(newFieldTypes)) {
                return type;
            }
            return ToolDefConstructors.newTupleType((List)newFieldTypes, (Boolean)type.isNullable(), null);
        }
        if (type instanceof ListType) {
            ToolDefType newElemType;
            ListType ltype = (ListType)type;
            ToolDefType origElemType = ltype.getElemType();
            if (origElemType == (newElemType = TypeMatcher.substitute(origElemType, constraints, substMissing))) {
                return type;
            }
            return ToolDefConstructors.newListType((ToolDefType)newElemType, (Boolean)ltype.isNullable(), null);
        }
        if (type instanceof SetType) {
            ToolDefType newElemType;
            SetType stype = (SetType)type;
            ToolDefType origElemType = stype.getElemType();
            if (origElemType == (newElemType = TypeMatcher.substitute(origElemType, constraints, substMissing))) {
                return type;
            }
            return ToolDefConstructors.newSetType((ToolDefType)newElemType, (Boolean)stype.isNullable(), null);
        }
        if (type instanceof MapType) {
            MapType mtype = (MapType)type;
            ToolDefType origKeyType = mtype.getKeyType();
            ToolDefType newKeyType = TypeMatcher.substitute(origKeyType, constraints, substMissing);
            ToolDefType origValueType = mtype.getValueType();
            ToolDefType newValueType = TypeMatcher.substitute(origValueType, constraints, substMissing);
            if (origKeyType == newKeyType && origValueType == newValueType) {
                return type;
            }
            return ToolDefConstructors.newMapType((ToolDefType)newKeyType, (Boolean)type.isNullable(), null, (ToolDefType)newValueType);
        }
        if (type instanceof TypeParamRef) {
            TypeParam typeParam = ((TypeParamRef)type).getType();
            ToolDefType rslt = (ToolDefType)constraints.get(typeParam);
            if (rslt == null) {
                return substMissing ? ToolDefConstructors.newObjectType((Boolean)true, null) : type;
            }
            return (ToolDefType)EMFHelper.deepclone((EObject)rslt);
        }
        throw new RuntimeException("Unknown/unsupported type: " + String.valueOf(type));
    }
}

