/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDVarSet;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.bdd.conversion.CifBddBitVector;
import org.eclipse.escet.cif.bdd.spec.CifBddDiscVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeApplyDirection;
import org.eclipse.escet.cif.bdd.spec.CifBddEdgeKind;
import org.eclipse.escet.cif.bdd.spec.CifBddInputVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddLocPtrVariable;
import org.eclipse.escet.cif.bdd.spec.CifBddSpec;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifBddEdge {
    public final CifBddSpec cifBddSpec;
    public List<Edge> edges;
    public Event event;
    public BDD origGuard;
    public BDD guard;
    public List<List<Assignment>> assignments;
    public final Set<CifBddVariable> assignedVariables = Sets.set();
    public BDD update;
    public BDD updateGuard;
    public BDDVarSet updateGuardSupport;
    public BDD error;

    public CifBddEdge(CifBddSpec cifBddSpec) {
        this.cifBddSpec = cifBddSpec;
    }

    public CifBddEdgeKind getEdgeKind() {
        if (this.event.getControllable().booleanValue()) {
            return CifBddEdgeKind.CONTROLLABLE;
        }
        if (this.edges.contains(null)) {
            return CifBddEdgeKind.INPUT_VARIABLE;
        }
        return CifBddEdgeKind.UNCONTROLLABLE;
    }

    public void initApply() {
        Assert.check((this.update != null ? 1 : 0) != 0);
        Assert.check((this.updateGuard == null ? 1 : 0) != 0);
        this.updateGuard = this.update.and(this.guard);
        this.update.free();
        this.update = null;
        Assert.check((this.updateGuardSupport == null ? 1 : 0) != 0);
        this.updateGuardSupport = this.getSupportFor(this.updateGuard);
    }

    private BDDVarSet getSupportFor(BDD relation) {
        return this.assignedVariables.stream().map(v -> v.domain.set().union(v.domainNew.set())).reduce(relation.support(), BDDVarSet::unionWith);
    }

    public void reinitApply() {
        Assert.check((this.update == null ? 1 : 0) != 0);
        Assert.check((this.updateGuard != null ? 1 : 0) != 0);
        BDD updateGuardNew = this.updateGuard.and(this.guard);
        this.updateGuard.free();
        this.updateGuard = updateGuardNew;
        Assert.check((this.updateGuardSupport != null ? 1 : 0) != 0);
        this.updateGuardSupport.free();
        this.updateGuardSupport = this.getSupportFor(this.updateGuard);
    }

    public void cleanupApply() {
        Assert.check((this.update == null ? 1 : 0) != 0);
        this.updateGuard = BddUtils.free(this.updateGuard);
        this.updateGuardSupport = BddUtils.free(this.updateGuardSupport);
    }

    public void freeBDDs() {
        this.origGuard = BddUtils.free(this.origGuard);
        this.guard = BddUtils.free(this.guard);
        this.update = BddUtils.free(this.update);
        this.updateGuard = BddUtils.free(this.updateGuard);
        this.updateGuardSupport = BddUtils.free(this.updateGuardSupport);
        this.error = BddUtils.free(this.error);
    }

    public BDD apply(BDD pred, CifBddEdgeApplyDirection direction, BDD restriction) {
        BDD rslt = switch (direction) {
            case CifBddEdgeApplyDirection.FORWARD -> {
                if (restriction == null) {
                    yield this.updateGuard.relnext(pred, this.updateGuardSupport);
                }
                yield this.updateGuard.relnextIntersection(pred, restriction, this.updateGuardSupport);
            }
            case CifBddEdgeApplyDirection.BACKWARD -> {
                if (restriction == null) {
                    yield this.updateGuard.relprev(pred, this.updateGuardSupport);
                }
                yield this.updateGuard.relprevIntersection(pred, restriction, this.updateGuardSupport);
            }
            default -> throw new IncompatibleClassChangeError();
        };
        pred.free();
        return rslt;
    }

    public String toString() {
        return this.toString("Edge: ");
    }

    public String toString(String prefix) {
        return this.toString(prefix, false);
    }

    public String toString(String prefix, boolean includeOnlyOrigGuard) {
        StringBuilder txt = new StringBuilder();
        txt.append(prefix);
        txt.append(Strings.fmt((String)"(event: %s)", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)this.event)}));
        String guardsTxt = BddUtils.bddToStr(this.origGuard, this.cifBddSpec);
        if (!includeOnlyOrigGuard && !this.origGuard.equals((Object)this.guard)) {
            guardsTxt = Strings.fmt((String)"%s -> %s", (Object[])new Object[]{guardsTxt, BddUtils.bddToStr(this.guard, this.cifBddSpec)});
        }
        txt.append(Strings.fmt((String)" (guard: %s)", (Object[])new Object[]{guardsTxt}));
        if (this.assignments.stream().anyMatch(as -> !as.isEmpty())) {
            txt.append(" (assignments: ");
            int i = 0;
            while (i < this.assignments.size()) {
                List<Assignment> edgeAssignments;
                if (i > 0) {
                    txt.append(" / ");
                }
                if ((edgeAssignments = this.assignments.get(i)).isEmpty()) {
                    txt.append("none");
                } else {
                    int j = 0;
                    while (j < edgeAssignments.size()) {
                        if (j > 0) {
                            txt.append(", ");
                        }
                        Assignment asgn = edgeAssignments.get(j);
                        txt.append(this.assignmentToString(asgn));
                        ++j;
                    }
                }
                ++i;
            }
            txt.append(")");
        }
        return txt.toString();
    }

    private String assignmentToString(Assignment asgn) {
        Expression addr = asgn.getAddressable();
        Declaration addrVar = (Declaration)CifScopeUtils.getRefObjFromRef((Expression)addr);
        Expression rhs = asgn.getValue();
        CifBddVariable[] cifBddVariableArray = this.cifBddSpec.variables;
        int n = this.cifBddSpec.variables.length;
        int n2 = 0;
        while (n2 < n) {
            CifBddVariable var = cifBddVariableArray[n2];
            if (var instanceof CifBddDiscVariable) {
                CifBddDiscVariable cifBddDiscVar = (CifBddDiscVariable)var;
                if (cifBddDiscVar.var == addrVar) {
                    return Strings.fmt((String)"%s := %s", (Object[])new Object[]{cifBddDiscVar.name, CifTextUtils.exprToStr((Expression)rhs)});
                }
            } else if (var instanceof CifBddLocPtrVariable) {
                CifBddLocPtrVariable cifBddLpVar = (CifBddLocPtrVariable)var;
                if (cifBddLpVar.var == addrVar) {
                    int locIdx = ((IntExpression)rhs).getValue();
                    Location loc = (Location)cifBddLpVar.aut.getLocations().get(locIdx);
                    return Strings.fmt((String)"%s := %s", (Object[])new Object[]{cifBddLpVar.name, CifTextUtils.getAbsName((PositionObject)loc)});
                }
            } else if (var instanceof CifBddInputVariable) {
                CifBddInputVariable cifBddInputVar = (CifBddInputVariable)var;
                if (cifBddInputVar.var == addrVar) {
                    return Strings.fmt((String)"%s+ != %s", (Object[])new Object[]{cifBddInputVar.name, cifBddInputVar.name});
                }
            } else {
                String msg = "Unexpected CIF/BDD variable for addressable: " + String.valueOf(var);
                throw new RuntimeException(msg);
            }
            ++n2;
        }
        throw new RuntimeException("No CIF/BDD variable found for addressable: " + String.valueOf(addrVar));
    }

    public static CifBddEdge mergeEdges(CifBddEdge edge1, CifBddEdge edge2) {
        Assert.areEqual((Object)edge1.cifBddSpec, (Object)edge2.cifBddSpec);
        Assert.areEqual((Object)edge1.event, (Object)edge2.event);
        Assert.check((!edge1.edges.contains(null) ? 1 : 0) != 0);
        Assert.check((!edge2.edges.contains(null) ? 1 : 0) != 0);
        CifBddEdge mergedEdge = new CifBddEdge(edge1.cifBddSpec);
        mergedEdge.event = edge1.event;
        mergedEdge.edges = Lists.concat(edge1.edges, edge2.edges);
        mergedEdge.assignments = Lists.concat(edge1.assignments, edge2.assignments);
        CifBddEdge.addUnchangedVariablePredicates(edge1, edge2);
        CifBddEdge.addUnchangedVariablePredicates(edge2, edge1);
        BDD update1 = edge1.guard.id().andWith(edge1.update);
        BDD update2 = edge2.guard.id().andWith(edge2.update);
        mergedEdge.update = update1.orWith(update2);
        mergedEdge.assignedVariables.addAll(edge1.assignedVariables);
        mergedEdge.assignedVariables.addAll(edge2.assignedVariables);
        edge1.assignedVariables.clear();
        edge2.assignedVariables.clear();
        BDD error1 = edge1.origGuard.id().andWith(edge1.error);
        BDD error2 = edge2.origGuard.id().andWith(edge2.error);
        mergedEdge.error = error1.orWith(error2);
        mergedEdge.origGuard = edge1.origGuard.orWith(edge2.origGuard);
        mergedEdge.guard = edge1.guard.orWith(edge2.guard);
        return mergedEdge;
    }

    private static void addUnchangedVariablePredicates(CifBddEdge edge1, CifBddEdge edge2) {
        List predicates = Lists.list();
        for (CifBddVariable variable : Sets.difference(edge2.assignedVariables, edge1.assignedVariables)) {
            CifBddBitVector vectorOld = CifBddBitVector.createDomain(variable.domain);
            CifBddBitVector vectorNew = CifBddBitVector.createDomain(variable.domainNew);
            predicates.add(vectorOld.equalTo(vectorNew));
            vectorOld.free();
            vectorNew.free();
        }
        if (!predicates.isEmpty()) {
            edge1.update = edge1.update.andWith((BDD)predicates.stream().reduce(BDD::andWith).get());
        }
    }
}

