/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.spec;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import com.github.javabdd.BDDPairing;
import com.github.javabdd.BDDVarSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.bdd.settings.CifBddSettings;
import org.eclipse.escet.cif.bdd.spec.CifBddEdge;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.utils.BddUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;

public class CifBddSpec {
    public final CifBddSettings settings;
    public BDDFactory factory;
    public Set<Event> alphabet;
    public Set<Event> controllables;
    public Set<Event> inputVarEvents;
    public CifBddVariable[] variables;
    public List<CifBddEdge> edges;
    public List<CifBddEdge> orderedEdgesBackward;
    public List<CifBddEdge> orderedEdgesForward;
    public Map<Event, List<CifBddEdge>> eventEdges;
    public List<BitSet> worksetDependenciesBackward;
    public List<BitSet> worksetDependenciesForward;
    public List<BDD> initialsVars;
    public List<BDD> initialsComps;
    public List<BDD> initialsLocs;
    public BDD initialVars;
    public BDD initialComps;
    public BDD initialLocs;
    public BDD initial;
    public BDD initialPlantInv;
    public BDD initialInv;
    public List<BDD> markedsComps;
    public List<BDD> markedsLocs;
    public BDD markedComps;
    public BDD markedLocs;
    public BDD marked;
    public BDD markedPlantInv;
    public BDD markedInv;
    public List<BDD> plantInvsComps;
    public List<BDD> plantInvsLocs;
    public BDD plantInvComps;
    public BDD plantInvLocs;
    public BDD plantInv;
    public List<BDD> reqInvsComps;
    public List<BDD> reqInvsLocs;
    public BDD reqInvComps;
    public BDD reqInvLocs;
    public BDD reqInv;
    public Map<Event, BDD> stateEvtExclsReqAuts;
    public Map<Event, BDD> stateEvtExclsReqInvs;
    public Map<Event, List<BDD>> stateEvtExclReqLists;
    public Map<Event, BDD> stateEvtExclReqs;
    public Map<Event, List<BDD>> stateEvtExclPlantLists;
    public Map<Event, BDD> stateEvtExclPlants;
    public BDDPairing oldToNewVarsPairing;
    public BDDPairing newToOldVarsPairing;
    public BDDVarSet varSetOld;
    public BDDVarSet varSetNew;

    public CifBddSpec(CifBddSettings settings) {
        this.settings = settings;
    }

    public void freeIntermediateBDDs(boolean freeReqsInvsCompsAndLocs) {
        this.plantInvsComps = BddUtils.free(this.plantInvsComps);
        this.plantInvsLocs = BddUtils.free(this.plantInvsLocs);
        this.plantInvComps = BddUtils.free(this.plantInvComps);
        this.plantInvLocs = BddUtils.free(this.plantInvLocs);
        if (freeReqsInvsCompsAndLocs) {
            this.reqInvsComps = BddUtils.free(this.reqInvsComps);
            this.reqInvsLocs = BddUtils.free(this.reqInvsLocs);
        }
        this.reqInvComps = BddUtils.free(this.reqInvComps);
        this.reqInvLocs = BddUtils.free(this.reqInvLocs);
        this.initialsVars = BddUtils.free(this.initialsVars);
        this.initialsComps = BddUtils.free(this.initialsComps);
        this.initialsLocs = BddUtils.free(this.initialsLocs);
        this.initialVars = BddUtils.free(this.initialVars);
        this.initialComps = BddUtils.free(this.initialComps);
        this.initialLocs = BddUtils.free(this.initialLocs);
        this.initialInv = BddUtils.free(this.initialInv);
        this.markedsComps = BddUtils.free(this.markedsComps);
        this.markedsLocs = BddUtils.free(this.markedsLocs);
        this.markedComps = BddUtils.free(this.markedComps);
        this.markedLocs = BddUtils.free(this.markedLocs);
        this.markedPlantInv = BddUtils.free(this.markedPlantInv);
        this.markedInv = BddUtils.free(this.markedInv);
        this.stateEvtExclPlantLists = BddUtils.free(this.stateEvtExclPlantLists, e -> (Collection)e.getValue());
        this.stateEvtExclReqLists = BddUtils.free(this.stateEvtExclReqLists, e -> (Collection)e.getValue());
    }

    public void freeAllBDDs() {
        this.freeIntermediateBDDs(true);
        this.initial = BddUtils.free(this.initial);
        this.initialPlantInv = BddUtils.free(this.initialPlantInv);
        this.marked = BddUtils.free(this.marked);
        this.plantInv = BddUtils.free(this.plantInv);
        this.reqInv = BddUtils.free(this.reqInv);
        this.stateEvtExclsReqAuts = BddUtils.free(this.stateEvtExclsReqAuts, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclsReqInvs = BddUtils.free(this.stateEvtExclsReqInvs, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclReqs = BddUtils.free(this.stateEvtExclReqs, e -> Collections.singleton((BDD)e.getValue()));
        this.stateEvtExclPlants = BddUtils.free(this.stateEvtExclPlants, e -> Collections.singleton((BDD)e.getValue()));
        this.varSetOld = BddUtils.free(this.varSetOld);
        this.varSetNew = BddUtils.free(this.varSetNew);
        for (CifBddEdge edge : this.edges) {
            edge.freeBDDs();
        }
        this.factory.done();
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.getEdgesText());
    }

    public List<String> getEdgesText() {
        return this.getEdgesText(false);
    }

    public List<String> getEdgesText(boolean includeOnlyOrigGuard) {
        return this.edges.stream().map(e -> e.toString("Edge: ", includeOnlyOrigGuard)).toList();
    }
}

